/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Thu Oct  3 02:41:21 2002 by Jeff Dalton
 * Copyright: (c) 2001, AIAI, University of Edinburgh
 */

package ix.kaos;

// KAoS imports
import edu.uwf.kaos.coabsgrid.KAoSAgentRegistrationHelper;
import edu.uwf.kaos.coabsgrid.KAoSAgentRep;
import com.globalinfotek.coabsgrid.entry.CoABSAgentDescription;
import net.jini.core.entry.Entry;

// Grid imports
//import com.globalinfotek.coabsgrid.AgentRegistrationHelper;
import com.globalinfotek.coabsgrid.MessageListener;
import com.globalinfotek.coabsgrid.Message;
import com.globalinfotek.coabsgrid.BasicMessage;
import com.globalinfotek.coabsgrid.AgentRep;
import com.globalinfotek.coabsgrid.entry.AgentRepUIDescriptor;

import java.io.IOException;

import ix.grid.OldGridCommunicationStrategy;

import ix.util.*;

/**
 * A class that encapsulates the KAoS knowledge needed for
 * sending and receiving our messages.
 *
 * It uses KAoSAgentRegistrationHelper(String name)
 */
public class OldKaosCommunicationStrategy
             extends OldGridCommunicationStrategy {

    public OldKaosCommunicationStrategy() {
    }

    /**
     * Register as an agent and set up for receiving messages.
     */
    public void setupServer(Object destination, 
			    IPC.MessageListener listener) {

	ipcName = (String)destination; // our name for registering as agent
	ipcListener = listener;

        Debug.noteln("Registering KAoS agent", ipcName);
        try {
            reg = new KAoSAgentRegistrationHelper(ipcName);
            reg.addMessageListener(this);

            CoABSAgentDescription desc = new CoABSAgentDescription(ipcName);

	    // Set things visible in the CoABS Grid Manager
	    String host = System.getProperty
		("com.globalinfotek.coabsgrid.class.server.machine");
	    String port = System.getProperty
		("com.globalinfotek.coabsgrid.class.server.port");
	    Debug.noteln("Grid class.server is " + host + ":" + port);

	    desc.displayIconURL = "http://" + host + ":" + port + 
		"/ix/resources/images/ip2-logo.gif";
	    desc.documentationURL = "http://www.aiai.ed.ac.uk/project/ix/";
	    desc.architecture = "I-X";
	    desc.description = "I-X Process Panel for "
		+ Util.getUserName() + " at "
		+ getLocalHostName() + " using KAoS";
	    desc.organization = "AIAI, University of Edinburgh";

            Entry[] attributes_ = new Entry[1];
            attributes_[0] = desc;
   
            reg.addAdvertisedCapabilities(attributes_);
            reg.registerAgent();
        }
        catch (IOException e) {
	    setupFailure(e);
        }
        catch (ClassNotFoundException cnfe) {
            setupFailure(cnfe);
        }
	catch (Throwable t) {
	    setupFailure(t);
	}
    }

}
