/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Wed Oct  2 23:36:40 2002 by Jeff Dalton
 * Copyright: (c) 2001, AIAI, University of Edinburgh
 */

package ix.grid;

// Grid imports
import com.globalinfotek.coabsgrid.AgentRegistrationHelper;
import com.globalinfotek.coabsgrid.MessageListener;
import com.globalinfotek.coabsgrid.Message;
import com.globalinfotek.coabsgrid.BasicMessage;
import com.globalinfotek.coabsgrid.AgentRep;
// import com.globalinfotek.coabsgrid.entry.AgentRepUIDescriptor;

import com.globalinfotek.coabsgrid.entry.CoABSAgentDescription;

import java.io.IOException;
import java.io.StringReader;

import javax.swing.*;

import ix.util.xml.XML;

import ix.util.*;

/**
 * A class that encapsulates the Grid knowledge needed for
 * sending and receiving our Grid messages.
 */
public class OldGridCommunicationStrategy 
implements IPC.CommunicationStrategy, MessageListener {

    public String ipcName = "ipcName unknown";

    public IPC.MessageListener ipcListener = null;

    public AgentRegistrationHelper reg;


    public OldGridCommunicationStrategy() {
    }


    /**
     * Sends an object such as an Issue or Report to a named Grid agent
     * by converting it to XML and calling the <code>sendText</code> method.
     */
    public void sendObject(Object destination, Object contents) {
	String toName = (String)destination;
	sendText(toName, XML.objectToXMLString(contents));
    }

    /**
     * Sends a string to a named Grid agent.
     */
    public void sendText(String toName, String contents) {

	// Look up the agent we're sending to.
	AgentRep toRep = reg.getDirectory().getAgentRepByName(toName);
	if (toRep == null) {
	    Debug.noteln("Cannot find grid agent", toName);
	    throw new IPC.IPCException
		("Cannot find grid agent " + toName);
	}

	// Construct a message.  We could leave the first 3 new BasicMessage
	// parameters null like this:
	//
	// BasicMessage message = new BasicMessage(null, null, null, contents);
	//
	// But instead we will fill some in.  The constructor is
	//
	// BasicMessage(java.lang.String receiver,
	//              ServiceRep sender,
	//              java.lang.String acl,
	//              java.lang.String rawText)
	//
	BasicMessage message = 
	    new BasicMessage(toName,
			     reg.getGridAgent().getAgentRep(),
			     null,
			     contents);
	// Would reg.getAgentRep() also work as the 2nd arg? /\/

	// Now send
	try {
	    toRep.addMessage(message);
	}
	catch (java.rmi.RemoteException e) {
	    Debug.noteException(e);
	    throw new IPC.IPCException
		("Problem sending to " + toName + ": " + e);
	}
    }

    /**
     * Register as an agent and set up for receiving messages.
     */
    public void setupServer(Object destination, 
			    IPC.MessageListener listener) {
	ipcName = (String)destination;   // our name for registering as agent
	ipcListener = listener;
	try {
	    reg = new AgentRegistrationHelper(ipcName);

	    // Set things visible in the CoABS Grid Manager
	    String host = System.getProperty
		("com.globalinfotek.coabsgrid.class.server.machine");
	    String port = System.getProperty
		("com.globalinfotek.coabsgrid.class.server.port");
	    Debug.noteln("Grid class.server is " + host + ":" + port);

	    CoABSAgentDescription desc = reg.getCoABSAgentDescription();
	    desc.displayIconURL = "http://" + host + ":" + port + 
		"/ix/resources/images/ip2-logo.gif";
	    desc.documentationURL = "http://www.aiai.ed.ac.uk/project/ix/";
	    desc.architecture = "I-X";
	    desc.description = "I-X Process Panel for "
		+ Util.getUserName() + " at "
		+ getLocalHostName();
	    desc.organization = "AIAI, University of Edinburgh";

	    reg.addMessageListener(this);
	    reg.registerAgent();
	}
	catch (IOException e) {
	    setupFailure(e);
	}
	catch (Throwable t) {
	    setupFailure(t);
	}
    }

    protected void setupFailure(Throwable thrown) {
	displayFailure("setting up IPC server", thrown);
    }

    protected String getLocalHostName() {
	// /\/: Should be a Util.getLocalHostName(String default).
	String name = "unknown";
	try { name = Util.getHostName(); }
	catch (Throwable t) {
	    Debug.noteException(t);
	}
	return name;
    }


    /**
     * Called when a new Grid message has been added to our message queue.
     */
    public synchronized void messageAdded(Message message) {
	try {
	    do_messageAdded(message);
	}
	catch (Throwable t) {
	    displayFailure("processing message", t);
	}
    }

    protected void do_messageAdded(Message message) {
	// Note that we might get some registration messages
	// that we can ignore.
	Debug.noteln("Grid message:", message);
	String text = message.getRawText();
	if (text != null && text.startsWith("<")) {
	    // Looks like XML ...
	    Debug.noteln("Received XML via Grid", text);
	    try {
		Object contents = XML.objectFromXML(text);
		Debug.noteln("Object from XML", contents);
		ipcListener
		    .messageReceived(new IPC.BasicInputMessage(contents));
	    }
	    catch (Throwable t) {
		displayFailure("parsing message", t);
	    }
	}
	else {
	    Debug.noteln("Ignoring message", message);
	}
	reg.removeMessage(message);
    }

    protected void displayFailure(final String when, Throwable thrown) {
	Debug.noteln("Exception while " + when);
	Debug.noteException(thrown);
	final Object[] message =
	    new Object[] {
	        "Problem while " + when,
		Strings.foldLongLine(thrown.toString())};
	SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                JOptionPane.showMessageDialog(
                    null,
		    message,
		    "Error while " + when,
		    JOptionPane.ERROR_MESSAGE);
            }
        });
    }

}
