:: I-X Austin Tate 4-Sep-2002
@echo off
:: First required parameter is panel name
:: second required parameter is KAoS domain name(s) - for multiple domains
::    put the domain names separated by commas in double string quotes.
:: third required parameter is KAoS domain manager name
:: fourth optionally overrides method name (e.g. for UNSGO panel)
:: optionally give an extra application parameters for app_params
::     (e.g. to start the name server "-run-name-server")

if "%1"=="" goto NO_PARAM
:: do not check for empty second parameters since it can be defined
:: by a string and will fail on syntax
:: REMOVED 4-Sep-2002     if "%2"=="" goto NO_PARAM
:: REMOVED 4-Sep-2002     if "%3"=="" goto NO_PARAM
set panel_name=%1
set domain_name=%2
set domain_manager_name=%3
set method_name=ix.ip2.Ip2
:: alternative for custom code is set method_name=coax.Ip2Example
if not "%4"=="" set method_name=%4

title %panel_name% Command Console
:: Call and necessary classpath is built up in the run-ix-app.bat script
:: and is based on
:: java -classpath=app_path;added_path;
::      added_java_params %java_params%
::      app_class_name added_app_params %app_params%
:: set current directory to application base
cd ..\..
set app_base=.
set app_path=.\java
set ipc=kaos
set app_params=-ipc=%ipc% -load config\coax-%panel_name%.props %5 %6 %7 %8 %9
set ix_base=..\..

:: Set up required java_params
:: The following properties are used by KAoS to boot JAS-defined naming,
:: directory and transport services used by agent's KAoSRegistrationHelper

call %ix_base%\comms\kaos\scripts\win\kaos-setvars.bat
call %kaos_base%\Scripts\win\domain.bat %domain_name%
call %kaos_base%\Scripts\win\domainManager.bat %domain_manager_name%
call %kaos_base%\Scripts\win\set-kaos-vars.bat
call %kaos_base%\Scripts\win\grid\set-kaos-grid-vars.bat %GRID_SERVICE_ID_DIRECTORY%

:: ****** Specify name of Guard for this agent
set GUARD_NAME=-Dguard.name=IX-%panel_name%-AgentGuard

set java_params=%GUARD_NAME% %BOOT_FILE% %SERVICE_ID_FILE_PATH% %DM_NAME% %D_NAME% 

%ix_base%\scripts\win\run-ix-app.bat %method_name%
goto END

:NO_PARAM
echo kaos-run-ix-app.bat requires panel name as a parameter
pause

:END
