/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Mon Feb 25 16:32:59 2002 by Jeff Dalton
 * Copyright: (c) 2002, AIAI, University of Edinburgh
 */

package coax;

import javax.swing.*;

import ix.itest.*;
import ix.icore.*;
import ix.util.*;

public class ItestUN extends Itest {

    public ItestUN() {
	super("United Nations Secretary General's Office Special Representative to Binni");
    }

    /**
     * Main program.
     */
    public static void main(String[] argv) {

        Util.printGreeting("UNSGO Special Representative to Binni");

        new ItestUN().mainStartup(argv);

    }

    /**
     * Command-line argument processing used by all versions of I-TEST.
     *
     * @see ix.icore.IXAgent#processCommandLineArguments()
     */
    protected void processCommandLineArguments() {
        super.processCommandLineArguments();
    }

    /**
     * Constructs a panel containing a nice, UN-related picture.
     */
    public JPanel makeLogoPanel() {
        JPanel imagePanel = new JPanel();
        ImageIcon icon = new ImageIcon("images/un-sec-gen-office.jpg");
        imagePanel.add(new JLabel(icon));
        return imagePanel;
    }

}


