;;; CoAX Binni Process Models
;;; Author: Jeff Dalton and Austin Tate
;;; Updated: 7-Oct-2002
;;; Copyright: (c) 2001-2, AIAI, University of Edinburgh


;;; SOP to interconnect two panels in a given relationship

(refinement sop_interconnect_panels_superior
               (interconnect ?p1 as superior to ?p2)
  (nodes
    (1 (connect ?p1 superior))
    (2 (connect ?p2 subordinate)))
  (orderings
    ))

(refinement sop_interconnect_panels_subordinate
               (interconnect ?p1 as subordinate to ?p2)
  (nodes
    (1 (connect ?p1 subordinate))
    (2 (connect ?p2 superior)))
  (orderings
    ))

(refinement sop_interconnect_panels_peer
               (interconnect ?p1 as peer to ?p2)
  (nodes
    (1 (connect ?p1 peer))
    (2 (connect ?p2 peer)))
  (orderings
    ))

(refinement sop_interconnect_panels_contact
               (interconnect ?p1 as contact to ?p2)
  (nodes
    (1 (connect ?p1 contact))
    (2 (connect ?p2 contact)))
  (orderings
    ))

(refinement sop_connect_panel
               (connect ?panel ?rel)
  (nodes
    (1 (open-tool I-Space))
    (2 (add ?panel ?rel))
    (3 (commit)))
  (orderings
    (1 2) (2 3)))

;;; Schemas to handle reposition requests

(refinement sop_reposition_shipping
               (reposition shipping)
  (nodes
    (1 (move-ships safety))
    (2 (move-ships defence))
    (3 (move-ships ASW)))
  (orderings
    ))

;;; Schemas to handle coordinate (plans) functions

(refinement sop_coordinate_with_url (coordinate ?type ?time ?ship ?details ?plan-url)
  (nodes
    (1 (coordinate_plans ?plan-url)))
  (orderings
    ))

(refinement sop_coordinate_no_url (coordinate &rest ?any-arguments)
  (nodes
    (1 (coordinate_plans)))
  (orderings
    ))

;;; Schemas to handle assign functions

(refinement sop_assign (assign ?type ?time ?vehicle ?level ?agent)
  (nodes
    (1 (assess assignment))
    (2 (make assignment))
    (3 (check assignment)))
  (orderings
    (1 2) (2 3)))

(refinement sop_assign_1 (assign ?a)
  (nodes
    (1 (assess assignment))
    (2 (make assignment))
    (3 (check assignment)))
  (orderings
    (1 2) (2 3)))

;;; Could add others for assign for 0 to X parameters

;;; Schemas to handle help

;;; help <vehicle-type> <vehicle-id> <emergency-type> <severity> <lat> <long>
;;; could have many different types of responses filtered by vehicle type, etc

;;; monitor-medical-situation <vehicle-type> <vehicle-name>
;;;           casualties <current-criticality> <lat> <long>

;;; Steve Wark, DSTO, suggested a message/activity format of
;;; (update-casualties <time> <casualties>)
;;;     where <time> is scenario time (eg. 1811)
;;;     <casualties> is list of casualties in format
;;;                   ((<severity> <number> <before>)+ )
;;;           <severity> is 'T1', 'T2', 'T3', 'T4'
;;;           <number>   is number of patients of this type
;;;           <before>   is elapsed time (minutes) before medevac is required.
;;; then med evac agents can trigger on the change in <before> or <severity>.
;;; Example message (update-casualties 1811 ((T1 1 120) (T2 3 360) (T3 6 720)))

(refinement sop_help_casualties_moderate
               (help ?type ?id casualties moderate ?lat ?long)
  (nodes
    (1 (assess-situation casualties))
    (2 (monitor-medical-situation ?type ?id casualties moderate ?lat ?long)))
  (orderings
    (1 2)))

(refinement sop_help_casualties_critical
               (help ?type ?id casualties ?severity ?lat ?long)
  (nodes
    (1 (assess-situation casualties))
    (2 (handle-medical-situation ?type ?id casualties critical ?lat ?long))
    (3 (notify-next-of-kin ?type ?id casualties critical ?lat ?long)))
  (orderings
    (1 2) (1 3)))

(refinement sop_notify_next_of_kin
               (notify-next-of-kin ?type ?id casualties ?severity ?lat ?long)
  (nodes
    (1 (note Country-HQ ?type ?id casualties critical ?lat ?long))
    (2 (note Others     ?type ?id casualties critical ?lat ?long)))
  (orderings
    ))

(refinement sop_help_damage
               (help ?type ?id damage ?severity ?lat ?long)
  (nodes
    (1 (assess damage situation))
    (2 (assign-helper ?type ?id damage ?severity ?lat ?long)))
  (orderings
    (1 2)))

;;; SOPs for help for other length arguments

(refinement sop_help (help &rest ?any-arguments)
  (nodes
    (1 (assess-situation ?any-arguments))
    (2 (monitor-situation ?any-arguments)))
  (orderings
    (1 2)))

;;; Schemas for demonstrations

(refinement sop_do
               (do ?this)
  (nodes
    (1 (do ?this part-1))
    (2 (do ?this part-2)))
  (orderings
    (1 2)))

(refinement sop_consider
               (consider ?this)
  (nodes
    (1 (do ?this part-1))
    (2 (do ?this part-2))
    (3 (do ?this part-3)))
  (orderings
    ))

;;; End







