;;; CoAX Binni Process Models
;;; Author: Jeff Dalton and Austin Tate
;;; Updated: 2-Oct-2002
;;; Copyright: (c) 2001-2, AIAI, University of Edinburgh

(refinement separate_forces_using_firestorm 
               (separate ?alpha and ?beta forces)
  (nodes
    (1 (consider COAs))
    (2 (select firestorm mission))
    (3 (authorise firestorm mission go))
    (4 (report firestorm mission complete)))
  (orderings
    (1 2 3 4)))

;;; SOP to interconnect two panels in a given relationship

(refinement sop_interconnect_panels_superior
               (interconnect ?p1 as superior to ?p2)
  (nodes
    (1 (connect ?p1 superior))
    (2 (connect ?p2 subordinate)))
  (orderings
    ))

(refinement sop_interconnect_panels_subordinate
               (interconnect ?p1 as subordinate to ?p2)
  (nodes
    (1 (connect ?p1 subordinate))
    (2 (connect ?p2 superior)))
  (orderings
    ))

(refinement sop_interconnect_panels_peer
               (interconnect ?p1 as peer to ?p2)
  (nodes
    (1 (connect ?p1 peer))
    (2 (connect ?p2 peer)))
  (orderings
    ))

(refinement sop_interconnect_panels_contact
               (interconnect ?p1 as contact to ?p2)
  (nodes
    (1 (connect ?p1 contact))
    (2 (connect ?p2 contact)))
  (orderings
    ))

(refinement sop_connect_panel
               (connect ?panel ?rel)
  (nodes
    (1 (open-tool I-Space))
    (2 (add ?panel ?rel))
    (3 (commit)))
  (orderings
    (1 2) (2 3)))

;;; Schemas to handle help

;;; help <vehicle-type> <vehicle-id> <emergency-type> <severity> <lat> <long>
;;; could have many different types of responses filtered by vehicle type, etc

;;; monitor-medical-situation <vehicle-type> <vehicle-name>
;;;           casualties <current-criticality> <lat> <long>

;;; Steve Wark, DSTO, suggested a message/activity format of
;;; (update-casualties <time> <casualties>)
;;;     where <time> is scenario time (eg. 1811)
;;;     <casualties> is list of casualties in format
;;;                   ((<severity> <number> <before>)+ )
;;;           <severity> is 'T1', 'T2', 'T3', 'T4'
;;;           <number>   is number of patients of this type
;;;           <before>   is elapsed time (minutes) before medevac is required.
;;; then med evac agents can trigger on the change in <before> or <severity>.
;;; Example message (update-casualties 1811 ((T1 1 120) (T2 3 360) (T3 6 720)))

(refinement sop_help_casualties_moderate
               (help ?type ?id casualties moderate ?lat ?long)
  (nodes
    (1 (assess-situation casualties))
    (2 (monitor-medical-situation ?type ?id casualties moderate ?lat ?long)))
  (orderings
    (1 2)))

(refinement sop_help_casualties_critical
               (help ?type ?id casualties ?severity ?lat ?long)
  (nodes
    (1 (assess-situation casualties))
    (2 (handle-medical-situation ?type ?id casualties critical ?lat ?long))
    (3 (notify-next-of-kin ?type ?id casualties critical ?lat ?long)))
  (orderings
    (1 2) (1 3)))

(refinement sop_notify_next_of_kin
               (notify-next-of-kin ?type ?id casualties ?severity ?lat ?long)
  (nodes
    (1 (note Country-HQ ?type ?id casualties critical ?lat ?long))
    (2 (note Others     ?type ?id casualties critical ?lat ?long)))
  (orderings
    ))

(refinement sop_help_damage
               (help ?type ?id damage ?severity ?lat ?long)
  (nodes
    (1 (assess damage situation))
    (2 (assign-helper ?type ?id damage ?severity ?lat ?long)))
  (orderings
    (1 2)))

;;; SOPs for help for other length arguments

(refinement sop_help (help &rest ?any-arguments)
  (nodes
    (1 (assess-situation ?any-arguments))
    (2 (monitor-situation ?any-arguments)))
  (orderings
    (1 2)))

;;; Schemas for considering entities in regions

;;; laki_safari_park overlaps firestorm area in NE
;;; sw_region overlaps firestorm area in SW
;;; Could define other spatial relationships.

(refinement impact_on_firestorm_area_laki (consider ?arg laki_safari_park)
   (nodes
     (1 (avoid ?arg firestorm_area))
   )
   (orderings)
)

(refinement impact_on_firestorm_area_sw (consider ?arg sw_region)
   (nodes
     (1 (avoid ?arg firestorm_area))
   )
   (orderings)
)

(refinement no_impact_on_firestorm_area (consider ?arg ?location)
   (nodes
     (1 (deconflict_plans ))
   )
   (orderings)
)

;;; End of original domain model

;;; CoAX process description
;;; Author: Jeff Dalton <J.Dalton@ed.ac.uk>
;;; Created: June 2000
;;; Updated: Sun Jul  1 18:33:19 2001 by Jeff Dalton
;;; Copyright: (c) 2000, AIAI, University of Edinburgh


(refinement sop-conduct-coalition-mission (conduct coalition_mission)
  (nodes
    (1 (monitor C2 process))
    (2 (task refinement))
    (3 (initial planning))
    (4 (ongoing operations))
    (5 (intelligence updates)))
  (orderings
    (3 4)))


;;;(define-product (Joint Operational Estimate))
;;;(define-product (Air Estimate))
;;;(define-product (CFC Campaign Plan))
;;;(define-product (CFACC Air Operations Plan))


;;; Initial Planning

(refinement sop-initial-planning (initial planning)
  (nodes
    (1 (develop joint operational estimate))
    (2 (develop air estimate))
    (3 (produce CFC campaign plan))
    (4 (produce CFACC air operations plan)))
  (orderings
    ((1 2) (3 4))))


(refinement sop-develop-joint-operational-estimate (develop joint operational estimate)
  (nodes
    (1 (transmit mission to CFACC [message S1M1a]))
    (2 (transmit CFC mission directive to CFACC [message S1M2a]))
    (3 (consider joint operational COAs))
    (4 (transmit CFC intent to CFACC [message S1M3a]))
    (5 (request CFACC draft estimate [message S1M4a])))
  (orderings
    (1 2 3 4 5))
;;;  (effects
;;;    (at start
;;;      (status (Joint Operational Estimate)) = :draft)
;;;    (at finish
;;;      (status (Joint Operational Estimate)) = :complete))
)

(refinement sop-transmit-mission-to--jfacc (transmit mission to CFACC [message S1M1a]))
(refinement sop-transmit-jtfc-mission-directive-to-jfacc (transmit CFC mission directive to CFACC [message S1M2a]))
(refinement sop-consider-joint-operational-coas (consider joint operational COAs))
(refinement sop-transmit-jtfcs-intent-to-jfac (transmit CFC intent to CFACC [message S1M3a]))
(refinement sop-request-jfacc-draft-estimate (request CFACC draft estimate [message S1M4a]))


(refinement sop-develop-air-estimate (develop air estimate)
  (nodes
    (1 (confirm receipt of S1M1a [message S1M1b]))
    (2 (confirm receipt of S1M2a [message S1M2b]))
    (3 (confirm receipt of S1M3a [message S1M3b]))
    (4 (request intelligence report [message I1a]))
    (5 (assemble information and intelligence))
    (6 (consider Air COAs))
    (7 (provide CFACC draft estimate [message S1M4b]))
  )
  ;;; (orderings
  ;;;   (1 2 3 4 5 6 7))
;;;  (effects
;;;    (at start
;;;      (status (Air Estimate)) = :draft)
;;;    (at finish
;;;      (status (Air Estimate)) = :complete)
;;;  )
)

(refinement sop-confirm-receipt-of-s1m1a (confirm receipt of S1M1a [message S1M1b]))
(refinement sop-confirm-receipt-of-s1m2b (confirm receipt of S1M2a [message S1M2b]))
(refinement sop-confirm-receipt-of-s1m3b (confirm receipt of S1M3a [message S1M3b]))
(refinement sop-request-intelligence-report-i1a (request intelligence report [message I1a]))
(refinement sop-assemble-intelligence-and-intelligence (assemble information and intelligence))
(refinement sop-consider-air-coas (consider Air COAs))
(refinement sop-provide-jfacc-draft-estimate-s1m4b (provide CFACC draft estimate [message S1M4b]))

(refinement sop-produce-jtfc-campaign-plan (produce CFC campaign plan)
  (nodes
    (1 (request information on availability of assets [message S2M1a]))
    (2 (request for apportionment recommendation [message S2M2a]))
    (3 (consider possible campaign COAs))
    (4 (produce joint campaign plan)))
  (orderings
    (1 2 3 4))
;;;  (effects
;;;    (at start
;;;      (status (CFC Campaign Plan)) = :draft)
;;;    (at finish
;;;      (status (CFC Campaign Plan)) = :complete)
;;;  )
)

(refinement sop-request-information-on-availability-of-assets-s1m1a (request information on availability of assets [message S2M1a]))
(refinement sop-requet-for-apportionment-recommendation-s2m2a (request for apportionment recommendation [message S2M2a]))
(refinement sop-consider-possible-campaign-coas (consider possible campaign COAs))
(refinement sop-produce-joint-campaign-plan (produce joint campaign plan))


(refinement sop-produce-jfacc-air-operations-plan (produce CFACC air operations plan)
  (nodes
    (1 (provide information on availability of assets [message S2M1b]))
    (2 (provide apportionment recommendation [message S2M2b]))
    (3 (consider possible operations COAs))
    (4 (produce air operations plan)))
  (orderings
    ; was (1 2 3 4)
    ((1 2 3) 4))
;;;  (effects
;;;    (at start
;;;      (status (CFACC Air Operations Plan)) = :draft)
;;;    (at finish
;;;      (status (CFACC Air Operations Plan)) = :complete))
)

(refinement sop-provide-information-on-availability-of-available-assets-s2m1b (provide information on availability of assets [message S2M1b]))
(refinement sop-provide-apportionment-recommendation-s2m2b (provide apportionment recommendation [message S2M2b]))
(refinement sop-consider-possible-opeations-coas (consider possible operations COAs))
(refinement sop-produce-air-operations-plan (produce air operations plan))


;;; Ongoing operations

(refinement sop-ongoing-operations (ongoing operations))


;;; Intelligence updates

(refinement sop-intelligence-updates (intelligence updates)
  (nodes
    (1 (continuous intelligence updates))
    (2 (wait for rfi))
    (3 (gather intelligence))
    (4 (collate intelligence))
    (5 (fuse intelligence))
    (6 (provide intelligence [message I1b])))
  (orderings
    (2 3 4 5 6)
;;;    (6 2)
  )
)

(refinement sop-continuous-intelligence-updates (continuous intelligence updates))
(refinement sop-wait-for-rfi (wait for rfi)
;;;  (properties
;;;    (loop-entry true))
)

(refinement sop-gather-intelligence (gather intelligence))
(refinement sop-collate-intellligence (collate intelligence))
(refinement sop-fuse-intelligence (fuse intelligence))
(refinement sop-provide-intelligence-i1b (provide intelligence [message I1b]))

;;; Schemas for demonstrations

(refinement sop_do
               (do ?this)
  (nodes
    (1 (do ?this part-1))
    (2 (do ?this part-2)))
  (orderings
    (1 2)))

(refinement sop_consider
               (consider ?this)
  (nodes
    (1 (do ?this part-1))
    (2 (do ?this part-2))
    (3 (do ?this part-3)))
  (orderings
    ))

;;; End



