/*
 * Decompiled with CFR 0.152.
 */
package ix.util.xml;

import ix.iface.util.CatchingActionListener;
import ix.util.Debug;
import ix.util.Fn;
import ix.util.Seq;
import ix.util.Strings;
import ix.util.Util;
import ix.util.lisp.LList;
import ix.util.xml.DashSyntaxXMLTranslator;
import ix.util.xml.Syntax;
import ix.util.xml.XMLTranslator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;

public class XMLTreeEditPanel
extends JPanel
implements ActionListener,
TreeSelectionListener {
    protected Document document;
    protected TNodeFactory nodeFactory = new TNodeFactory();
    protected TNodeParser nodeParser = new TNodeParser();
    protected TemplateSyntax syntax = new TemplateSyntax();
    protected EditorTree docTree;
    protected DefaultTreeModel docModel;
    protected EditorTree templateTree;
    protected EditorTree mostRecentlySelectedTree;
    protected EditingTextArea editText;
    protected JButton submitButton;
    static /* synthetic */ Class class$ix$icore$Activity;
    static /* synthetic */ Class class$ix$icore$Issue;
    static /* synthetic */ Class class$ix$icore$Report;
    static /* synthetic */ Class class$ix$icore$domain$Domain;
    static /* synthetic */ Class class$ix$icore$domain$PatternAssignment;
    static /* synthetic */ Class class$ix$ip2$test$TestItem;

    public XMLTreeEditPanel() {
        super(new BorderLayout());
        TNode tNode = new TNode("root");
        tNode.setShouldBeExpanded(true);
        this.docModel = new DefaultTreeModel(tNode);
        this.docTree = new EditorTree("document tree", this.docModel);
        this.docTree.setEditable(true);
        this.docTree.getSelectionModel().setSelectionMode(1);
        this.docTree.setShowsRootHandles(true);
        this.docTree.addTreeSelectionListener(this);
        this.docTree.addMouseListener(new TreeMouseListener());
        this.templateTree = this.makeTemplateTree();
        this.addTemplatesFor(new Class[]{class$ix$icore$Activity == null ? (class$ix$icore$Activity = XMLTreeEditPanel.class$("ix.icore.Activity")) : class$ix$icore$Activity, class$ix$icore$Issue == null ? (class$ix$icore$Issue = XMLTreeEditPanel.class$("ix.icore.Issue")) : class$ix$icore$Issue, class$ix$icore$Report == null ? (class$ix$icore$Report = XMLTreeEditPanel.class$("ix.icore.Report")) : class$ix$icore$Report, class$ix$icore$domain$Domain == null ? (class$ix$icore$domain$Domain = XMLTreeEditPanel.class$("ix.icore.domain.Domain")) : class$ix$icore$domain$Domain, class$ix$icore$domain$PatternAssignment == null ? (class$ix$icore$domain$PatternAssignment = XMLTreeEditPanel.class$("ix.icore.domain.PatternAssignment")) : class$ix$icore$domain$PatternAssignment, class$ix$ip2$test$TestItem == null ? (class$ix$ip2$test$TestItem = XMLTreeEditPanel.class$("ix.ip2.test.TestItem")) : class$ix$ip2$test$TestItem});
        this.addTemplate(this.syntax.makeMapEntryNode());
        this.editText = new EditingTextArea(2, 30);
        this.editText.setEditable(false);
        this.submitButton = this.makeButton("Submit Text");
        this.submitButton.setEnabled(false);
        JScrollPane jScrollPane = new JScrollPane(this.docTree);
        jScrollPane.setBorder(BorderFactory.createTitledBorder("Document"));
        JScrollPane jScrollPane2 = new JScrollPane(this.templateTree);
        jScrollPane2.setBorder(BorderFactory.createTitledBorder("Templates"));
        JScrollPane jScrollPane3 = new JScrollPane(this.editText);
        jScrollPane3.setBorder(BorderFactory.createTitledBorder("Text"));
        JSplitPane jSplitPane = new JSplitPane(1, jScrollPane, jScrollPane2);
        jSplitPane.setDividerSize(3);
        jSplitPane.setResizeWeight(0.8);
        JSplitPane jSplitPane2 = new JSplitPane(0, jSplitPane, jScrollPane3);
        jSplitPane2.setDividerSize(3);
        jSplitPane2.setResizeWeight(0.9);
        this.add((Component)jSplitPane2, "Center");
        this.add((Component)this.makeButtonPanel(), "South");
    }

    protected void reset() {
        this.setDocRoot(new TNode("root"));
        this.editText.clear();
    }

    protected void setDocRoot(TNode tNode) {
        this.docModel.setRoot(tNode);
        tNode.setShouldBeExpanded(true);
    }

    public void editDocument(Document document) {
        this.document = document;
        this.setDocRoot(this.nodeFactory.nodeFrom(document));
    }

    public Document getDocument() {
        this.document = this.nodeParser.documentFrom((TNode)this.docModel.getRoot());
        return this.document;
    }

    public void editObject(Object object) {
        this.editDocument(this.syntax.xmlt().objectToDocument(object));
    }

    public Object getObject() {
        Document document = this.getDocument();
        try {
            return this.syntax.xmlt().objectFromDocument(document);
        }
        catch (Exception exception) {
            Debug.noteException(exception);
            Element element = this.syntax.xmlt().getLastConvertedElement();
            if (element != null) {
                Debug.noteln("Bad elt", element);
                TNode tNode = this.nodeParser.getNodeForElement(element);
                if (tNode != null) {
                    TreePath treePath = tNode.getTreePath();
                    Debug.noteln("Bad node's path", treePath);
                    this.docTree.scrollPathToVisible(treePath);
                    this.docTree.setSelectionPath(treePath);
                }
            }
            throw new InvalidNode(exception.toString());
        }
    }

    public void addTemplatesFor(Class[] classArray) {
        this.addTemplatesFor(Seq.toLList(Seq.elements(classArray)));
    }

    public void addTemplatesFor(List list) {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.templateTree.getModel();
        TNode tNode = (TNode)defaultTreeModel.getRoot();
        List list2 = this.syntax.makeTemplateNodes(list);
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            TNode tNode2 = (TNode)iterator.next();
            tNode.add(tNode2);
        }
        defaultTreeModel.nodeStructureChanged(tNode);
    }

    public void addTemplate(TNode tNode) {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.templateTree.getModel();
        TNode tNode2 = (TNode)defaultTreeModel.getRoot();
        tNode2.add(tNode);
        defaultTreeModel.nodeStructureChanged(tNode2);
    }

    protected EditorTree makeTemplateTree() {
        TNode tNode = new TNode("Templates");
        tNode.setShouldBeExpanded(true);
        EditorTree editorTree = new EditorTree("template tree", tNode);
        editorTree.setEditable(false);
        editorTree.getSelectionModel().setSelectionMode(1);
        editorTree.setShowsRootHandles(true);
        editorTree.addTreeSelectionListener(this);
        editorTree.addMouseListener(new TreeMouseListener());
        return editorTree;
    }

    protected JPanel makeButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(this.makeButton("Add Child"));
        jPanel.add(this.makeButton("Copy Subtree"));
        jPanel.add(this.makeButton("Cut Subtree"));
        jPanel.add(this.submitButton);
        jPanel.add(Box.createHorizontalGlue());
        return jPanel;
    }

    protected JButton makeButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(CatchingActionListener.listener(this));
        return jButton;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        Debug.noteln("XMLTreeEditPanel action:", string);
        if (string.equals("Add Child")) {
            this.addChild();
        } else if (string.equals("Copy Subtree")) {
            this.copySubtree();
        } else if (string.equals("Cut Subtree")) {
            this.cutSubtree();
        } else if (string.equals("Submit Text")) {
            this.editText.submit();
        } else {
            Debug.noteln("Nothing to do for", string);
        }
    }

    public void addChild() {
        TNode tNode = (TNode)this.docTree.getLastSelectedPathComponent();
        if (tNode == null) {
            this.complain("No selected node in document");
        } else {
            TNode tNode2 = new TNode("blank");
            this.docModel.insertNodeInto(tNode2, tNode, tNode.getChildCount());
            this.docTree.scrollPathToVisible(tNode2.getTreePath());
        }
    }

    public void copySubtree() {
        TNode tNode = (TNode)this.docTree.getLastSelectedPathComponent();
        if (tNode == null) {
            this.complain("No selected node in document");
        } else {
            new CutFrame(tNode.copySubtree(), "Copy");
        }
    }

    public void cutSubtree() {
        TNode tNode = (TNode)this.docTree.getLastSelectedPathComponent();
        if (tNode == null) {
            this.complain("No selected node in document");
        } else {
            TNode tNode2 = (TNode)tNode.getParent();
            if (tNode2 != null) {
                this.docModel.removeNodeFromParent(tNode);
                new CutFrame(tNode, "Cut");
            } else {
                this.complain("The root cannot be cut; try File: Reset");
            }
        }
    }

    protected void complain(Object object) {
        JOptionPane.showMessageDialog(this, object, "Error", 0);
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        EditorTree editorTree = (EditorTree)treeSelectionEvent.getSource();
        TNode tNode = (TNode)editorTree.getLastSelectedPathComponent();
        if (tNode == null) {
            return;
        }
        Debug.noteln(editorTree.getName() + " selection", tNode.getTreePath());
        if (this.mostRecentlySelectedTree != null && this.mostRecentlySelectedTree != editorTree) {
            Debug.noteln("Changing selected tree");
            this.mostRecentlySelectedTree.getSelectionModel().clearSelection();
        }
        this.mostRecentlySelectedTree = editorTree;
        TNode tNode2 = (TNode)tNode.getParent();
        if (tNode2 != null && this.nodeParser.isAtomicValue(tNode2)) {
            this.editText.display(tNode2);
        } else {
            this.editText.clear();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class CutFrame
    extends JFrame
    implements ActionListener {
        EditorTree subtree;
        TNode subtreeNode;
        EditorTree destinationTree;
        DefaultTreeModel destinationModel;
        Container contentPane = this.getContentPane();

        CutFrame(TNode tNode, String string) {
            super(string);
            this.subtreeNode = tNode;
            this.subtree = new EditorTree(string + " tree", tNode);
            this.subtree.setEditable(false);
            this.subtree.setSelectionModel(null);
            this.subtree.setShowsRootHandles(true);
            this.subtree.fixExpansions();
            JScrollPane jScrollPane = new JScrollPane(this.subtree);
            jScrollPane.setBorder(BorderFactory.createTitledBorder("Subtree"));
            this.contentPane.add((Component)jScrollPane, "Center");
            JPanel jPanel = this.makeButtonPanel();
            jPanel.setBorder(BorderFactory.createTitledBorder("Insert ..."));
            this.contentPane.add((Component)jPanel, "South");
            ((Component)this).setSize(400, 300);
            ((Component)this).setVisible(true);
        }

        JPanel makeButtonPanel() {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 0));
            jPanel.add(Box.createHorizontalGlue());
            jPanel.add(this.makeButton("As"));
            jPanel.add(this.makeButton("Before"));
            jPanel.add(this.makeButton("After"));
            jPanel.add(this.makeButton("Child"));
            jPanel.add(this.makeButton("Discard"));
            jPanel.add(Box.createHorizontalGlue());
            return jPanel;
        }

        JButton makeButton(String string) {
            JButton jButton = new JButton(string);
            jButton.addActionListener(CatchingActionListener.listener(this));
            return jButton;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            Debug.noteln("XMLTreeEditPanel action:", string);
            if (string.equals("Discard")) {
                this.subtreeNode = null;
                this.finished();
                return;
            }
            this.destinationTree = XMLTreeEditPanel.this.mostRecentlySelectedTree;
            if (this.destinationTree == null) {
                XMLTreeEditPanel.this.complain("No selected destination");
                return;
            }
            this.destinationModel = (DefaultTreeModel)this.destinationTree.getModel();
            TNode tNode = (TNode)this.destinationTree.getLastSelectedPathComponent();
            if (tNode == null) {
                XMLTreeEditPanel.this.complain("No selected node");
                return;
            }
            if (string.equals("As")) {
                this.insertAs(tNode);
            }
            if (string.equals("Before")) {
                this.insertBefore(tNode);
            } else if (string.equals("After")) {
                this.insertAfter(tNode);
            } else if (string.equals("Child")) {
                this.insertUnder(tNode);
            } else {
                Debug.noteln("Nothing to do for", string);
            }
        }

        void insertAs(TNode tNode) {
            TNode tNode2 = (TNode)tNode.getParent();
            if (tNode2 == null) {
                this.destinationModel.setRoot(this.subtreeNode);
            } else {
                int n = this.destinationModel.getIndexOfChild(tNode2, tNode);
                this.destinationModel.removeNodeFromParent(tNode);
                this.destinationModel.insertNodeInto(this.subtreeNode, tNode2, n);
            }
            this.finished();
        }

        void insertBefore(TNode tNode) {
            TNode tNode2 = (TNode)tNode.getParent();
            if (tNode2 == null) {
                XMLTreeEditPanel.this.complain("Cannot insert before root");
            } else {
                this.destinationModel.insertNodeInto(this.subtreeNode, tNode2, this.destinationModel.getIndexOfChild(tNode2, tNode));
                this.finished();
            }
        }

        void insertAfter(TNode tNode) {
            TNode tNode2 = (TNode)tNode.getParent();
            if (tNode2 == null) {
                XMLTreeEditPanel.this.complain("Cannot insert at same level as root");
            } else {
                this.destinationModel.insertNodeInto(this.subtreeNode, tNode2, this.destinationModel.getIndexOfChild(tNode2, tNode) + 1);
                this.finished();
            }
        }

        void insertUnder(TNode tNode) {
            this.destinationModel.insertNodeInto(this.subtreeNode, tNode, 0);
            this.finished();
        }

        void finished() {
            if (this.subtreeNode != null) {
                this.destinationTree.fixExpansions();
                this.destinationTree.scrollPathToVisible(this.subtreeNode.getTreePath());
            }
            this.dispose();
        }
    }

    class EditingTextArea
    extends JTextArea {
        TNode editingNode;
        TNode valueNode;
        Element editingElt;

        EditingTextArea(int n, int n2) {
            super(n, n2);
        }

        void display(TNode tNode) {
            this.editingNode = tNode;
            this.editingElt = XMLTreeEditPanel.this.nodeParser.valueElementFrom(tNode);
            this.setText(this.editingElt.getText());
            this.setEditable(true);
            XMLTreeEditPanel.this.submitButton.setEnabled(true);
        }

        void clear() {
            if (this.editingNode != null) {
                this.editingNode = null;
                this.editingElt = null;
                this.setText("");
                this.setEditable(false);
                XMLTreeEditPanel.this.submitButton.setEnabled(false);
            }
        }

        void submit() {
            this.editingElt.setText(this.getText());
            XMLTreeEditPanel.this.nodeParser.setAtomicValue(this.editingNode, this.editingElt.getText());
            ((DefaultTreeModel)XMLTreeEditPanel.this.mostRecentlySelectedTree.getModel()).nodeStructureChanged(this.editingNode);
            this.clear();
        }
    }

    class RecordingExpansionListener
    implements TreeExpansionListener {
        JTree tree;
        boolean active = true;

        RecordingExpansionListener(JTree jTree) {
            this.tree = jTree;
        }

        public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
            if (this.active) {
                Debug.noteln("Tree expanding", treeExpansionEvent.getPath());
                this.theNode(treeExpansionEvent).setShouldBeExpanded(true);
            }
        }

        public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            if (this.active) {
                Debug.noteln("Tree collapsing", treeExpansionEvent.getPath());
                this.theNode(treeExpansionEvent).setShouldBeExpanded(false);
            }
        }

        TNode theNode(TreeExpansionEvent treeExpansionEvent) {
            Debug.assert(treeExpansionEvent.getSource() == this.tree);
            return (TNode)treeExpansionEvent.getPath().getLastPathComponent();
        }
    }

    class EditorTree
    extends JTree {
        RecordingExpansionListener expansionListener;

        EditorTree(String string, TreeNode treeNode) {
            this(string, new DefaultTreeModel(treeNode));
        }

        EditorTree(String string, TreeModel treeModel) {
            super(treeModel);
            this.expansionListener = new RecordingExpansionListener(this);
            this.setName(string);
            this.addTreeExpansionListener(this.expansionListener);
            this.putClientProperty("JTree.lineStyle", "Angled");
        }

        void fixExpansions() {
            this.fixExpansions((TNode)this.getModel().getRoot());
        }

        void fixExpansions(TNode tNode) {
            try {
                this.expansionListener.active = false;
                this.fixExpansionsRec(tNode);
                Object var3_2 = null;
                this.expansionListener.active = true;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.expansionListener.active = true;
                throw throwable;
            }
        }

        private void fixExpansionsRec(TNode tNode) {
            Enumeration<TreeNode> enumeration = tNode.children();
            while (enumeration.hasMoreElements()) {
                this.fixExpansionsRec((TNode)enumeration.nextElement());
            }
            TreePath treePath = tNode.getTreePath();
            if (tNode.shouldBeExpanded()) {
                this.expandPath(treePath);
            } else {
                this.collapsePath(treePath);
            }
        }
    }

    class NodePopupMenu
    extends JPopupMenu
    implements ActionListener {
        EditorTree tree;
        DefaultTreeModel model;
        TNode node;

        NodePopupMenu(EditorTree editorTree, TNode tNode) {
            this.tree = editorTree;
            this.model = (DefaultTreeModel)editorTree.getModel();
            this.node = tNode;
            if (XMLTreeEditPanel.this.nodeParser.isAttribute(tNode)) {
                this.addValueMenuItemIfKnown();
            }
            this.add(this.makeMenuItem("Fully Expand"));
            this.add(this.makeMenuItem("Fully Collapse"));
            this.add(this.makeMenuItem("Add Child"));
            this.add(this.makeMenuItem("Copy Subtree"));
            this.add(this.makeMenuItem("Cut Subtree"));
            if (XMLTreeEditPanel.this.nodeParser.isAttributesList(tNode)) {
                this.add(this.makeMenuItem("Delete Valueless Attributes"));
            } else if (tNode.getChildCount() > 0) {
                this.add(this.makeMenuItem("Delete Closed Subnodes"));
            }
        }

        JMenuItem makeMenuItem(String string) {
            JMenuItem jMenuItem = new JMenuItem(string);
            jMenuItem.addActionListener(CatchingActionListener.listener(this));
            return jMenuItem;
        }

        void addValueMenuItemIfKnown() {
            List list;
            TNode tNode = XMLTreeEditPanel.this.nodeParser.getAttributeContainingObjectNode(this.node);
            String string = (String)tNode.getUserObject();
            Class clazz = XMLTreeEditPanel.this.syntax.classForXmlName(string);
            String string2 = XMLTreeEditPanel.this.nodeParser.getAttributeName(this.node);
            Class clazz2 = XMLTreeEditPanel.this.syntax.getFieldClass(clazz, XMLTreeEditPanel.this.syntax.xmlt().internalFieldName(string2));
            if (clazz2 != null && (list = XMLTreeEditPanel.this.syntax.getEnumerationValues(clazz2)) != null) {
                JMenu jMenu = this.makeValueMenu(list);
                this.add(jMenu);
            }
        }

        JMenu makeValueMenu(List list) {
            JMenu jMenu = new JMenu("Set Value");
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                JMenuItem jMenuItem = this.makeMenuItem(e.toString());
                jMenuItem.setActionCommand("setValue");
                jMenu.add(jMenuItem);
            }
            return jMenu;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            Debug.noteln("Item popup command", string);
            if (string.equals("Fully Expand")) {
                this.fullyExpand();
            } else if (string.equals("Fully Collapse")) {
                this.fullyCollapse();
            } else if (string.equals("Add Child")) {
                this.addChild();
            } else if (string.equals("Copy Subtree")) {
                this.copySubtree();
            } else if (string.equals("Cut Subtree")) {
                this.cutSubtree();
            } else if (string.equals("setValue")) {
                JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                String string2 = jMenuItem.getText();
                this.setValue(string2);
            } else if (string.equals("Delete Valueless Attributes")) {
                this.deleteValuelessAttributes();
            } else if (string.equals("Delete Closed Subnodes")) {
                this.deleteClosedSubnodes();
            } else {
                Debug.noteln("Nothing to do for", string);
            }
        }

        void fullyExpand() {
            this.node.setSubtreeShouldBeExpanded(true);
            this.tree.fixExpansions();
        }

        void fullyCollapse() {
            this.node.setSubtreeShouldBeExpanded(false);
            this.tree.fixExpansions();
        }

        void addChild() {
            TNode tNode = new TNode("blank");
            this.model.insertNodeInto(tNode, this.node, this.node.getChildCount());
            this.tree.scrollPathToVisible(tNode.getTreePath());
        }

        void copySubtree() {
            new CutFrame(this.node.copySubtree(), "Copy");
        }

        void cutSubtree() {
            TNode tNode = (TNode)this.node.getParent();
            if (tNode != null) {
                if (this.tree == XMLTreeEditPanel.this.templateTree && !Util.dialogConfirms(XMLTreeEditPanel.this, "Are you sure you want to cut a template?")) {
                    return;
                }
            } else {
                throw new InvalidCommand("A root cannot be cut");
            }
            this.model.removeNodeFromParent(this.node);
            new CutFrame(this.node, "Cut");
        }

        void setValue(String string) {
            String string2 = (String)this.node.getUserObject();
            String string3 = Strings.beforeFirst("=", string2);
            this.node.setUserObject(string3 + "=" + string);
            this.model.nodeChanged(this.node);
        }

        void deleteValuelessAttributes() {
            LList lList = Seq.toLList(this.node.children());
            Iterator iterator = lList.iterator();
            while (iterator.hasNext()) {
                TNode tNode = (TNode)iterator.next();
                if (!XMLTreeEditPanel.this.nodeParser.getAttributeValue(tNode).trim().equals("")) continue;
                this.model.removeNodeFromParent(tNode);
            }
        }

        void deleteClosedSubnodes() {
            LList lList = Seq.toLList(this.node.children());
            Iterator iterator = lList.iterator();
            while (iterator.hasNext()) {
                TNode tNode = (TNode)iterator.next();
                if (tNode.shouldBeExpanded()) continue;
                this.model.removeNodeFromParent(tNode);
            }
        }
    }

    class TreeMouseListener
    extends MouseAdapter {
        TreeMouseListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            EditorTree editorTree = (EditorTree)mouseEvent.getSource();
            int n = editorTree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
            TreePath treePath = editorTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (n == -1) {
                return;
            }
            if (!SwingUtilities.isRightMouseButton(mouseEvent)) {
                return;
            }
            Debug.noteln("Right click in " + editorTree.getName(), treePath);
            TNode tNode = (TNode)treePath.getLastPathComponent();
            NodePopupMenu nodePopupMenu = new NodePopupMenu(editorTree, tNode);
            nodePopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    class TemplateSyntax
    extends Syntax {
        static /* synthetic */ Class class$java$util$List;
        static /* synthetic */ Class class$java$util$Set;
        static /* synthetic */ Class class$java$util$Map;

        TemplateSyntax() {
            super(new DashSyntaxXMLTranslator());
        }

        List makeTemplateNodes(List list) {
            Serializable serializable;
            LinkedList linkedList = new LinkedList();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                serializable = (Class)iterator.next();
                this.walkRelevantClasses((Class)serializable, (List)linkedList);
            }
            serializable = new LinkedList();
            Iterator iterator2 = linkedList.iterator();
            while (iterator2.hasNext()) {
                Class clazz = (Class)iterator2.next();
                TNode tNode = this.templateFrom(clazz);
                if (tNode == null) continue;
                serializable.add(tNode);
            }
            return serializable;
        }

        TNode templateFrom(Class clazz) {
            Syntax.ClassDescr classDescr = new Syntax.ClassDescr(clazz);
            if (classDescr.isStruct()) {
                return this.structTemplateFrom(clazz);
            }
            return null;
        }

        TNode structTemplateFrom(Class clazz) {
            String string = this.xmlNameForClass(clazz);
            List list = this.getFields(clazz);
            List list2 = this.attributeFields(list);
            List list3 = this.elementFields(list);
            Debug.assert(list.size() == list2.size() + list3.size());
            TNode tNode = new TNode(string);
            if (list2.isEmpty()) {
                if (list3.isEmpty()) {
                    return null;
                }
            } else {
                tNode.add(this.makeAttributesNode(list2));
            }
            Iterator iterator = list3.iterator();
            while (iterator.hasNext()) {
                Syntax.FieldDescr fieldDescr = (Syntax.FieldDescr)iterator.next();
                tNode.add(this.makeFieldNode(fieldDescr));
            }
            return tNode;
        }

        TNode makeAttributesNode(List list) {
            TNode tNode = new TNode("attributes");
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Syntax.FieldDescr fieldDescr = (Syntax.FieldDescr)iterator.next();
                String string = fieldDescr.getElementName();
                tNode.add(new TNode(string + "="));
            }
            return tNode;
        }

        TNode makeFieldNode(Syntax.FieldDescr fieldDescr) {
            TNode tNode = new TNode(fieldDescr.getElementName());
            if (fieldDescr.type.isList()) {
                String string = this.xmlNameForClass(class$java$util$List == null ? (class$java$util$List = TemplateSyntax.class$("java.util.List")) : class$java$util$List);
                TNode tNode2 = new TNode(string);
                tNode2.add(new TNode(string + "-element..."));
                tNode.add(tNode2);
            } else if (fieldDescr.type.isSet()) {
                String string = this.xmlNameForClass(class$java$util$Set == null ? (class$java$util$Set = TemplateSyntax.class$("java.util.Set")) : class$java$util$Set);
                TNode tNode3 = new TNode(string);
                tNode3.add(new TNode(string + "-element..."));
                tNode.add(tNode3);
            } else if (fieldDescr.type.isMap()) {
                String string = this.xmlNameForClass(class$java$util$Map == null ? (class$java$util$Map = TemplateSyntax.class$("java.util.Map")) : class$java$util$Map);
                TNode tNode4 = new TNode(string);
                tNode4.add(this.makeMapEntryNode());
                tNode.add(tNode4);
            } else {
                String string = this.xmlNameForClass(fieldDescr.type.theClass);
                TNode tNode5 = new TNode(string);
                tNode5.add(new TNode(string + "-value"));
                tNode.add(tNode5);
            }
            return tNode;
        }

        TNode makeMapEntryNode() {
            String string = this.xmlt.externalName("MapEntry");
            TNode tNode = new TNode(string);
            tNode.add(new TNode("key"));
            tNode.add(new TNode("value"));
            return tNode;
        }

        XMLTranslator xmlt() {
            return this.xmlt;
        }

        String xmlNameForClass(Class clazz) {
            return this.xmlt.externalNameForClass(clazz);
        }

        Class classForXmlName(String string) {
            return this.xmlt.classForExternalName(string);
        }

        Class getFieldClass(Class clazz, String string) {
            List list = this.getFields(clazz);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Syntax.FieldDescr fieldDescr = (Syntax.FieldDescr)iterator.next();
                if (!fieldDescr.name.equals(string)) continue;
                return fieldDescr.type.theClass;
            }
            return null;
        }

        List getEnumerationValues(Class clazz) {
            if (new Syntax.ClassDescr(clazz).isEnumeration()) {
                return (List)Fn.applyStatic(clazz, "values", new Object[0]);
            }
            return null;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    class InvalidNode
    extends RuntimeException {
        InvalidNode(String string) {
            super(string);
        }
    }

    class TNodeParser {
        Map elementToNodeMap = new HashMap();

        TNodeParser() {
        }

        Document documentFrom(TNode tNode) {
            this.elementToNodeMap.clear();
            Element element = this.elementFrom(tNode);
            return new Document(element);
        }

        Element elementFrom(TNode tNode) {
            if (this.isAttributesList(tNode)) {
                throw this.syntaxError(tNode, "Misplaced attributes");
            }
            Element element = this.isAtomicValue(tNode) ? this.valueElementFrom(tNode) : this.structElementFrom(tNode);
            this.elementToNodeMap.put(element, tNode);
            return element;
        }

        TNode getNodeForElement(Element element) {
            return (TNode)this.elementToNodeMap.get(element);
        }

        protected Element valueElementFrom(TNode tNode) {
            String string = (String)tNode.getUserObject();
            TNode tNode2 = (TNode)tNode.getChildAt(0);
            String string2 = (String)tNode2.getUserObject();
            Element element = new Element(string);
            element.setText(string2);
            return element;
        }

        protected Element structElementFrom(TNode tNode) {
            String string = (String)tNode.getUserObject();
            Enumeration<TreeNode> enumeration = tNode.children();
            Element element = new Element(string);
            if (this.hasAttributes(tNode)) {
                this.addAttributes(element, tNode);
                enumeration.nextElement();
            }
            while (enumeration.hasMoreElements()) {
                TNode tNode2 = (TNode)enumeration.nextElement();
                element.addContent(this.elementFrom(tNode2));
            }
            return element;
        }

        protected void addAttributes(Element element, TNode tNode) {
            TNode tNode2 = (TNode)tNode.getChildAt(0);
            Enumeration<TreeNode> enumeration = tNode2.children();
            while (enumeration.hasMoreElements()) {
                TNode tNode3 = (TNode)enumeration.nextElement();
                this.addAttribute(element, tNode3);
            }
        }

        protected void addAttribute(Element element, TNode tNode) {
            String[] stringArray = this.parseAttribute(tNode);
            element.setAttribute(stringArray[0], stringArray[1]);
        }

        String[] parseAttribute(TNode tNode) {
            if (!this.isAttribute(tNode)) {
                throw this.syntaxError(tNode, "Invalid attribute");
            }
            String string = (String)tNode.getUserObject();
            String[] stringArray = Strings.breakAtFirst("=", string);
            if (tNode.getChildCount() != 0 || stringArray[0].equals("")) {
                throw this.syntaxError(tNode, "Invalid attribute");
            }
            return stringArray;
        }

        boolean hasAttributes(TNode tNode) {
            return tNode.getChildCount() >= 1 && this.isAttributesList((TNode)tNode.getChildAt(0));
        }

        boolean isAttributesList(TNode tNode) {
            return tNode.getUserObject().equals("attributes");
        }

        boolean isAttribute(TNode tNode) {
            TNode tNode2 = (TNode)tNode.getParent();
            return tNode2 != null && this.isAttributesList(tNode2) && tNode.getChildCount() == 0;
        }

        String getAttributeName(TNode tNode) {
            String[] stringArray = this.parseAttribute(tNode);
            return stringArray[0];
        }

        String getAttributeValue(TNode tNode) {
            String[] stringArray = this.parseAttribute(tNode);
            return stringArray[1];
        }

        TNode getAttributeContainingObjectNode(TNode tNode) {
            Debug.assert(this.isAttribute(tNode));
            TNode tNode2 = (TNode)tNode.getParent().getParent();
            if (tNode2 == null) {
                throw this.syntaxError(tNode, "Attribute outside object");
            }
            return tNode2;
        }

        boolean isAtomicValue(TNode tNode) {
            return tNode.getChildCount() == 1 && !this.isAttributesList(tNode) && !this.isAttributesList((TNode)tNode.getChildAt(0)) && tNode.getChildAt(0).getChildCount() == 0;
        }

        void setAtomicValue(TNode tNode, Object object) {
            Debug.assert(this.isAtomicValue(tNode));
            TNode tNode2 = (TNode)tNode.getChildAt(0);
            tNode2.setUserObject(object);
        }

        InvalidNode syntaxError(TNode tNode, String string) {
            TreePath treePath = tNode.getTreePath();
            XMLTreeEditPanel.this.docTree.scrollPathToVisible(treePath);
            XMLTreeEditPanel.this.docTree.setSelectionPath(treePath);
            return new InvalidNode(string);
        }
    }

    class TNodeFactory {
        TNodeFactory() {
        }

        TNode nodeFrom(Document document) {
            return this.nodeFrom(document.getRootElement());
        }

        TNode nodeFrom(Element element) {
            TNode tNode = new TNode(element.getName());
            if (element.getAttributes().isEmpty()) {
                if (element.getChildren().isEmpty()) {
                    tNode.add(new TNode(element.getText()));
                    return tNode;
                }
            } else {
                tNode.add(this.makeAttributesNode(element));
            }
            Iterator iterator = element.getChildren().iterator();
            while (iterator.hasNext()) {
                Element element2 = (Element)iterator.next();
                tNode.add(this.nodeFrom(element2));
            }
            return tNode;
        }

        TNode makeAttributesNode(Element element) {
            TNode tNode = new TNode("attributes");
            Iterator iterator = element.getAttributes().iterator();
            while (iterator.hasNext()) {
                Attribute attribute = (Attribute)iterator.next();
                String string = attribute.getName();
                String string2 = attribute.getValue();
                tNode.add(new TNode(string + "=" + string2));
            }
            return tNode;
        }
    }

    class TNode
    extends DefaultMutableTreeNode {
        boolean shouldBeExpanded = false;

        TNode(Object object) {
            super(object);
        }

        boolean shouldBeExpanded() {
            return this.shouldBeExpanded;
        }

        void setShouldBeExpanded(boolean bl) {
            this.shouldBeExpanded = bl;
        }

        void setSubtreeShouldBeExpanded(boolean bl) {
            Enumeration<TreeNode> enumeration = this.preorderEnumeration();
            while (enumeration.hasMoreElements()) {
                TNode tNode = (TNode)enumeration.nextElement();
                tNode.setShouldBeExpanded(bl);
            }
        }

        public TreePath getTreePath() {
            return new TreePath(this.getPath());
        }

        public void setUserObject(Object object) {
            Debug.noteln("Setting user object to", object);
            super.setUserObject(object);
        }

        public TNode copySubtree() {
            TNode tNode = new TNode(this.getUserObject());
            tNode.shouldBeExpanded = this.shouldBeExpanded;
            Enumeration<TreeNode> enumeration = this.children();
            while (enumeration.hasMoreElements()) {
                TNode tNode2 = (TNode)enumeration.nextElement();
                tNode.add(tNode2.copySubtree());
            }
            return tNode;
        }
    }

    class InvalidCommand
    extends RuntimeException {
        InvalidCommand(String string) {
            super(string);
        }
    }
}

