/*
 * Decompiled with CFR 0.152.
 */
package ix.util.xml;

import ix.icore.IXAgent;
import ix.iface.util.CatchingActionListener;
import ix.iface.util.IconImage;
import ix.util.Debug;
import ix.util.Util;
import ix.util.xml.XMLLoader;
import ix.util.xml.XMLSaver;
import ix.util.xml.XMLTreeEditPanel;
import ix.util.xml.XMLTreeEditor;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import org.jdom.Document;

public class XMLTreeEditFrame
extends JFrame
implements ActionListener {
    protected IXAgent agent;
    protected Container contentPane = this.getContentPane();
    protected XMLTreeEditPanel editPanel;

    XMLTreeEditFrame(IXAgent iXAgent, String string) {
        super(string);
        this.agent = iXAgent;
        ((Frame)this).setIconImage(IconImage.getIconImage(this));
        this.setJMenuBar(this.makeMenuBar());
        this.editPanel = new XMLTreeEditPanel();
        this.contentPane.add((Component)this.editPanel, "Center");
        ((Component)this).setSize(500, 600);
    }

    protected boolean isStandalone() {
        return this.agent instanceof XMLTreeEditor;
    }

    protected JMenuBar makeMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenuBar.add(jMenu);
        if (this.isStandalone()) {
            jMenu.add(this.makeMenuItem("Load From ..."));
            jMenu.add(this.makeMenuItem("Save As ..."));
            jMenu.add(this.makeMenuItem("Reset"));
            jMenu.add(this.makeMenuItem("Exit"));
        } else {
            jMenu.add(this.makeMenuItem("Reset"));
            jMenu.add(this.makeMenuItem("Close"));
        }
        JMenu jMenu2 = new JMenu("Edit");
        jMenuBar.add(jMenu2);
        jMenu2.add(this.makeMenuItem("Check As Document"));
        jMenu2.add(this.makeMenuItem("Check As Object"));
        return jMenuBar;
    }

    protected JMenuItem makeMenuItem(String string) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.addActionListener(CatchingActionListener.listener(this));
        return jMenuItem;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        Debug.noteln("XMLTreeEditFrame action:", string);
        if (string.equals("Load From ...")) {
            this.loadFrom();
        } else if (string.equals("Save As ...")) {
            this.saveAs();
        } else if (string.equals("Reset")) {
            this.reset();
        } else if (string.equals("Close")) {
            ((Component)this).setVisible(false);
        } else if (string.equals("Exit")) {
            this.exitIfUserConfirms();
        } else if (string.equals("Check As Document")) {
            this.editPanel.getDocument();
        } else if (string.equals("Check As Object")) {
            this.editPanel.getObject();
        } else {
            Debug.noteln("Nothing to do for", string);
        }
    }

    protected void reset() {
        this.editPanel.reset();
    }

    public void exitIfUserConfirms() {
        if (Util.dialogConfirms(null, "Are you sure you want to exit?")) {
            System.exit(0);
        }
    }

    protected void loadFrom() {
        Document document = new XMLLoader(this).loadDocument();
        if (document != null) {
            this.editPanel.editDocument(document);
        }
    }

    protected void saveAs() {
        Document document = this.editPanel.getDocument();
        new XMLSaver(this).saveDocument(document);
    }
}

