/*
 * Decompiled with CFR 0.152.
 */
package ix.util.xml;

import ix.ichat.ChatMessage;
import ix.icore.Issue;
import ix.icore.Priority;
import ix.icore.Status;
import ix.icore.domain.NodeSpec;
import ix.util.ClassFinder;
import ix.util.Debug;
import ix.util.FieldWalker;
import ix.util.Function1;
import ix.util.Function2;
import ix.util.Name;
import ix.util.SemiPrimitive;
import ix.util.lisp.LList;
import ix.util.lisp.LListCollector;
import ix.util.lisp.Lisp;
import ix.util.xml.XML;
import ix.util.xml.XMLException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;

public class XMLTranslator {
    protected ClassFinder classFinder = new ClassFinder();
    protected XMLOutputter outputter = XML.makePrettyXMLOutputter();
    protected Function1 prefilter = null;
    protected Function1 postfilter = null;
    protected Map walkerCache = new HashMap();
    protected String implAttribute = this.externalFieldName("implClass");
    protected boolean omitImplAttributes = false;
    protected Element lastConvertedElement = null;
    protected Class defaultListClass = class$java$util$LinkedList == null ? (class$java$util$LinkedList = XMLTranslator.class$("java.util.LinkedList")) : class$java$util$LinkedList;
    protected Class defaultSetClass = class$java$util$HashSet == null ? (class$java$util$HashSet = XMLTranslator.class$("java.util.HashSet")) : class$java$util$HashSet;
    protected Class defaultMapClass = class$java$util$HashMap == null ? (class$java$util$HashMap = XMLTranslator.class$("java.util.HashMap")) : class$java$util$HashMap;
    protected static XMLTranslator standardTranslator = new XMLTranslator();
    static /* synthetic */ Class class$java$util$LinkedList;
    static /* synthetic */ Class class$java$util$HashSet;
    static /* synthetic */ Class class$java$util$HashMap;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$ix$util$SemiPrimitive;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Set;
    static /* synthetic */ Class class$ix$util$lisp$LList;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Void;

    public XMLTranslator() {
        this.addImport("ix.icore.*");
        this.addImport("ix.icore.domain.*");
        this.addImport("ix.icore.process.state.*");
        this.addImport("ix.ichat.ChatMessage");
        this.addImport("ix.ip2.test.*");
        this.addImport("ix.util.Name");
        this.addImport("ix.util.lisp.*");
        this.addImport("ix.test.xml.*");
    }

    public ClassFinder getClassFinder() {
        return this.classFinder;
    }

    public XMLOutputter getOutputter() {
        return this.outputter;
    }

    public void setPrefilter(Function1 function1) {
        this.prefilter = function1;
    }

    public void setPostfilter(Function1 function1) {
        this.postfilter = function1;
    }

    public void setOmitImplAttributes(boolean bl) {
        this.omitImplAttributes = bl;
    }

    public void addImport(String string) {
        this.classFinder.addImport(string);
    }

    public Class classForExternalName(String string) {
        return this.classFinder.classForName(this.internalName(string));
    }

    public String externalNameForClass(Class clazz) {
        return this.externalName(this.classFinder.nameForClass(clazz));
    }

    public String internalFieldName(String string) {
        return this.internalName(string);
    }

    public String externalFieldName(String string) {
        return this.externalName(string);
    }

    public String internalName(String string) {
        return string;
    }

    public String externalName(String string) {
        return string;
    }

    public String objectToXMLString(Object object) {
        Document document = this.objectToDocument(object);
        StringWriter stringWriter = new StringWriter();
        try {
            this.outputter.output(document, (Writer)stringWriter);
        }
        catch (IOException iOException) {
            Debug.noteException(iOException);
            throw new XMLException("Can't convert " + object + " to string because " + iOException);
        }
        stringWriter.flush();
        return stringWriter.toString();
    }

    public Document objectToDocument(Object object) {
        return new Document(this.objectToElement(object));
    }

    public Element objectToElement(Object object) {
        if (this.prefilter != null) {
            object = this.prefilter.funcall(object);
        }
        if (object == null) {
            return new Element("null");
        }
        if (object instanceof SemiPrimitive) {
            return this.primitiveObjectToElement(object);
        }
        if (object instanceof Number) {
            return this.primitiveObjectToElement(object);
        }
        if (object instanceof String) {
            return this.stringToElement(object);
        }
        if (object instanceof Boolean) {
            return this.primitiveObjectToElement(object);
        }
        if (object instanceof List) {
            return this.listToElement(object);
        }
        if (object instanceof Set) {
            return this.setToElement(object);
        }
        if (object instanceof Map) {
            return this.mapToElement(object);
        }
        return this.structToElement(object);
    }

    public Element primitiveObjectToElement(Object object) {
        Class<?> clazz = object.getClass();
        String string = this.externalNameForClass(clazz);
        Element element = new Element(string);
        element.setText(object.toString());
        return element;
    }

    public Element stringToElement(Object object) {
        return this.primitiveObjectToElement(object);
    }

    public Element listToElement(Object object) {
        return this.collectionToElement(class$java$util$List == null ? (class$java$util$List = XMLTranslator.class$("java.util.List")) : class$java$util$List, (List)object);
    }

    public Element setToElement(Object object) {
        return this.collectionToElement(class$java$util$Map == null ? (class$java$util$Map = XMLTranslator.class$("java.util.Map")) : class$java$util$Map, (Set)object);
    }

    public Element collectionToElement(Class clazz, Collection collection) {
        Class<?> clazz2 = collection.getClass();
        String string = this.externalNameForClass(clazz2);
        String string2 = this.externalNameForClass(clazz);
        Element element = new Element(string2);
        if (!this.omitImplAttributes) {
            element.setAttribute(this.implAttribute, string);
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            element.addContent(this.objectToElement(e));
        }
        return element;
    }

    public Element mapToElement(Object object) {
        Map map = (Map)object;
        Class<?> clazz = map.getClass();
        String string = this.externalNameForClass(clazz);
        String string2 = this.externalNameForClass(class$java$util$Map == null ? (class$java$util$Map = XMLTranslator.class$("java.util.Map")) : class$java$util$Map);
        Element element = new Element(string2);
        if (!this.omitImplAttributes) {
            element.setAttribute(this.implAttribute, string);
        }
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Element element2 = new Element(this.externalName("MapEntry"));
            Element element3 = new Element("key");
            Element element4 = new Element("value");
            element.addContent(element2);
            element2.addContent(element3);
            element2.addContent(element4);
            element3.addContent(this.objectToElement(entry.getKey()));
            element4.addContent(this.objectToElement(entry.getValue()));
        }
        return element;
    }

    public Element structToElement(Object object) {
        Class<?> clazz = object.getClass();
        FieldWalker fieldWalker = this.ensureFieldWalker(clazz);
        String string = this.externalNameForClass(clazz);
        Element element = new Element(string);
        fieldWalker.walkFields(object, element);
        return element;
    }

    protected FieldWalker ensureFieldWalker(Class clazz) {
        FieldWalker fieldWalker = (FieldWalker)this.walkerCache.get(clazz);
        if (fieldWalker == null) {
            fieldWalker = new WalkerForXML(clazz);
            this.walkerCache.put(clazz, fieldWalker);
        }
        return fieldWalker;
    }

    public static boolean isAttributeClass(Class clazz) {
        return clazz.isPrimitive() || (class$ix$util$SemiPrimitive == null ? (class$ix$util$SemiPrimitive = XMLTranslator.class$("ix.util.SemiPrimitive")) : class$ix$util$SemiPrimitive).isAssignableFrom(clazz) || (class$java$lang$Number == null ? (class$java$lang$Number = XMLTranslator.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(clazz) || (class$java$lang$Boolean == null ? (class$java$lang$Boolean = XMLTranslator.class$("java.lang.Boolean")) : class$java$lang$Boolean).isAssignableFrom(clazz);
    }

    public Object objectFromXML(String string) {
        Document document = XML.parseXML(string);
        return this.objectFromDocument(document);
    }

    public Object objectFromDocument(Document document) {
        Object object = this.objectFromElement(document.getRootElement());
        this.lastConvertedElement = null;
        return object;
    }

    public Element getLastConvertedElement() {
        return this.lastConvertedElement;
    }

    public Object objectFromElement(Element element) {
        this.lastConvertedElement = element;
        String string = element.getName();
        if (string.equals("null")) {
            return null;
        }
        Class clazz = this.classForExternalName(string);
        if (clazz == null) {
            throw new XMLException("Can't find class " + string);
        }
        return this.objectFromElement(clazz, element);
    }

    protected Object objectFromElement(Class clazz, Element element) {
        this.lastConvertedElement = element;
        Object object = (class$ix$util$SemiPrimitive == null ? (class$ix$util$SemiPrimitive = XMLTranslator.class$("ix.util.SemiPrimitive")) : class$ix$util$SemiPrimitive).isAssignableFrom(clazz) ? this.primitiveObjectFromElement(clazz, element) : ((class$java$lang$Number == null ? (class$java$lang$Number = XMLTranslator.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(clazz) ? this.primitiveObjectFromElement(clazz, element) : ((class$java$lang$String == null ? (class$java$lang$String = XMLTranslator.class$("java.lang.String")) : class$java$lang$String).isAssignableFrom(clazz) ? this.stringFromElement(clazz, element) : ((class$java$lang$Boolean == null ? (class$java$lang$Boolean = XMLTranslator.class$("java.lang.Boolean")) : class$java$lang$Boolean).isAssignableFrom(clazz) ? this.primitiveObjectFromElement(clazz, element) : ((class$java$util$List == null ? (class$java$util$List = XMLTranslator.class$("java.util.List")) : class$java$util$List).isAssignableFrom(clazz) ? this.listFromElement(clazz, element) : ((class$java$util$Set == null ? (class$java$util$Set = XMLTranslator.class$("java.util.Set")) : class$java$util$Set).isAssignableFrom(clazz) ? this.setFromElement(clazz, element) : ((class$java$util$Map == null ? (class$java$util$Map = XMLTranslator.class$("java.util.Map")) : class$java$util$Map).isAssignableFrom(clazz) ? this.mapFromElement(clazz, element) : this.structFromElement(clazz, element)))))));
        if (this.postfilter != null) {
            object = this.postfilter.funcall(object);
        }
        return object;
    }

    public Object primitiveObjectFromElement(Class clazz, Element element) {
        return this.primitiveObjectFromString(clazz, element.getText());
    }

    public Object primitiveObjectFromString(Class clazz, String string) {
        try {
            Method method = clazz.getMethod("valueOf", class$java$lang$String == null ? (class$java$lang$String = XMLTranslator.class$("java.lang.String")) : class$java$lang$String);
            return method.invoke(null, string);
        }
        catch (InvocationTargetException invocationTargetException) {
            Debug.noteException(invocationTargetException);
            throw new XMLException("Can't convert to " + clazz + " because " + invocationTargetException.getTargetException());
        }
        catch (Exception exception) {
            Debug.noteException(exception);
            throw new XMLException("Can't convert to " + clazz + " because " + exception);
        }
    }

    public String stringFromElement(Class clazz, Element element) {
        return element.getText();
    }

    public List listFromElement(Class clazz, Element element) {
        return (List)this.collectionFromElement(clazz, this.defaultListClass, element);
    }

    public Set setFromElement(Class clazz, Element element) {
        return (Set)this.collectionFromElement(clazz, this.defaultSetClass, element);
    }

    public Collection collectionFromElement(Class clazz, Class clazz2, Element element) {
        Object object;
        Class clazz3;
        if ((class$ix$util$lisp$LList == null ? (class$ix$util$lisp$LList = XMLTranslator.class$("ix.util.lisp.LList")) : class$ix$util$lisp$LList).isAssignableFrom(clazz3 = clazz.isInterface() ? this.getImplClass(element, clazz2) : clazz)) {
            return this.makeLListFromElement(element);
        }
        LinkedList<Object> linkedList = new LinkedList<Object>();
        Iterator iterator = element.getChildren().iterator();
        while (iterator.hasNext()) {
            object = (Element)iterator.next();
            Object object2 = this.objectFromElement((Element)object);
            linkedList.add(object2);
        }
        if (linkedList.getClass() == clazz3) {
            return linkedList;
        }
        try {
            object = clazz3.getConstructor(class$java$util$Collection == null ? (class$java$util$Collection = XMLTranslator.class$("java.util.Collection")) : class$java$util$Collection);
            return (Collection)((Constructor)object).newInstance(linkedList);
        }
        catch (Exception exception) {
            Debug.noteException(exception);
            throw new XMLException("Could not create " + clazz3 + " collection because " + exception);
        }
    }

    public LList makeLListFromElement(Element element) {
        LListCollector lListCollector = new LListCollector();
        Iterator iterator = element.getChildren().iterator();
        while (iterator.hasNext()) {
            Element element2 = (Element)iterator.next();
            String string = element2.getName();
            if (string.equals("null")) {
                lListCollector.add((Object)null);
                continue;
            }
            Class clazz = this.classForExternalName(string);
            Object object = clazz == (class$java$util$List == null ? XMLTranslator.class$("java.util.List") : class$java$util$List) && element2.getAttributeValue(this.implAttribute) == null ? this.makeLListFromElement(element2) : this.objectFromElement(element2);
            lListCollector.add(object);
        }
        return lListCollector.contents();
    }

    public Class getImplClass(Element element, Class clazz) {
        Class clazz2;
        String string = element.getAttributeValue(this.implAttribute);
        Class clazz3 = clazz2 = string == null ? clazz : this.classForExternalName(string);
        if (clazz2 == null) {
            throw new XMLException("Cannot find implementation class " + string);
        }
        return clazz2;
    }

    public Map mapFromElement(Class clazz, Element element) {
        Class clazz2 = clazz.isInterface() ? this.getImplClass(element, this.defaultMapClass) : clazz;
        Map map = (Map)this.makeInstance(clazz2);
        String string = this.externalName("MapEntry");
        Iterator iterator = element.getChildren().iterator();
        while (iterator.hasNext()) {
            Element element2 = (Element)iterator.next();
            this.requireEltType(string, element2);
            this.requireEltSize(2, element2);
            List list = element2.getChildren();
            Element element3 = (Element)list.get(0);
            Element element4 = (Element)list.get(1);
            this.requireEltType("key", element3);
            this.requireEltType("value", element4);
            this.requireEltSize(1, element3);
            this.requireEltSize(1, element4);
            Element element5 = (Element)element3.getChildren().get(0);
            Element element6 = (Element)element4.getChildren().get(0);
            Object object = this.objectFromElement(element5);
            Object object2 = this.objectFromElement(element6);
            map.put(object, object2);
        }
        return map;
    }

    protected void requireEltType(String string, Element element) {
        if (!element.getName().equals(string)) {
            throw new XMLException("Expecting " + string + " element but found " + element.getName());
        }
    }

    protected void requireEltSize(int n, Element element) {
        int n2 = element.getChildren().size();
        if (n2 != n) {
            throw new XMLException("Expecting " + n + " children but found " + n2 + " in " + element);
        }
    }

    public Object structFromElement(Class clazz, Element element) {
        String string;
        Class clazz2;
        FieldWalker.FieldInfo fieldInfo;
        String string2;
        String string3;
        Attribute attribute;
        Object object = this.makeInstance(clazz);
        FieldWalker fieldWalker = this.ensureFieldWalker(clazz);
        Iterator iterator = element.getAttributes().iterator();
        while (iterator.hasNext()) {
            attribute = (Attribute)iterator.next();
            string3 = this.internalFieldName(attribute.getName());
            string2 = attribute.getValue();
            fieldInfo = fieldWalker.getFieldInfo(string3);
            if (fieldInfo == null) {
                throw new XMLException("No field for attribute " + attribute.getName());
            }
            try {
                clazz2 = fieldInfo.type.isPrimitive() ? XMLTranslator.wrapperClass(fieldInfo.type) : fieldInfo.type;
                string = clazz2 == (class$java$lang$String == null ? XMLTranslator.class$("java.lang.String") : class$java$lang$String) ? string2 : this.primitiveObjectFromString(clazz2, string2);
                fieldInfo.setValue(object, string);
            }
            catch (Exception exception) {
                Debug.noteException(exception);
                throw new XMLException("Cannot set field " + string3 + " because " + exception);
            }
        }
        attribute = element.getChildren().iterator();
        while (attribute.hasNext()) {
            Class clazz3;
            string3 = (Element)attribute.next();
            this.requireEltSize(1, (Element)string3);
            string2 = this.internalFieldName(string3.getName());
            fieldInfo = fieldWalker.getFieldInfo(string2);
            clazz2 = (Element)string3.getChildren().get(0);
            string = clazz2.getName();
            Object object2 = !string.equals("null") && (clazz3 = this.classForExternalName(string)) != null && clazz3.isInterface() && clazz2.getAttributeValue(this.implAttribute) == null && !fieldInfo.type.isInterface() ? this.objectFromElement(fieldInfo.type, (Element)clazz2) : this.objectFromElement((Element)clazz2);
            try {
                fieldWalker.setField(object, string2, object2);
            }
            catch (Exception exception) {
                Debug.noteException(exception);
                throw new XMLException("Cannot set field " + string2 + " because " + exception);
            }
        }
        return object;
    }

    public static final Class wrapperClass(Class clazz) {
        if (clazz == Byte.TYPE) {
            return class$java$lang$Byte == null ? (class$java$lang$Byte = XMLTranslator.class$("java.lang.Byte")) : class$java$lang$Byte;
        }
        if (clazz == Character.TYPE) {
            return class$java$lang$Character == null ? (class$java$lang$Character = XMLTranslator.class$("java.lang.Character")) : class$java$lang$Character;
        }
        if (clazz == Short.TYPE) {
            return class$java$lang$Short == null ? (class$java$lang$Short = XMLTranslator.class$("java.lang.Short")) : class$java$lang$Short;
        }
        if (clazz == Integer.TYPE) {
            return class$java$lang$Integer == null ? (class$java$lang$Integer = XMLTranslator.class$("java.lang.Integer")) : class$java$lang$Integer;
        }
        if (clazz == Long.TYPE) {
            return class$java$lang$Long == null ? (class$java$lang$Long = XMLTranslator.class$("java.lang.Long")) : class$java$lang$Long;
        }
        if (clazz == Float.TYPE) {
            return class$java$lang$Float == null ? (class$java$lang$Float = XMLTranslator.class$("java.lang.Float")) : class$java$lang$Float;
        }
        if (clazz == Double.TYPE) {
            return class$java$lang$Double == null ? (class$java$lang$Double = XMLTranslator.class$("java.lang.Double")) : class$java$lang$Double;
        }
        if (clazz == Boolean.TYPE) {
            return class$java$lang$Boolean == null ? (class$java$lang$Boolean = XMLTranslator.class$("java.lang.Boolean")) : class$java$lang$Boolean;
        }
        if (clazz == Void.TYPE) {
            return class$java$lang$Void == null ? (class$java$lang$Void = XMLTranslator.class$("java.lang.Void")) : class$java$lang$Void;
        }
        throw new IllegalArgumentException(clazz + " is not a primitive class");
    }

    public Object makeInstance(Class clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception exception) {
            Debug.noteException(exception);
            throw new XMLException("Cannot make 0-arg instance of " + clazz + " because " + exception);
        }
    }

    protected static String standardXML(Object object) {
        return standardTranslator.objectToXMLString(object);
    }

    protected static void test(XMLTranslator xMLTranslator, Object object) {
        XMLTranslator.test(xMLTranslator, object, null);
    }

    protected static void test(XMLTranslator xMLTranslator, Object object, Function2 function2) {
        try {
            Debug.noteln("Object:", object);
            Debug.noteln("Class:", object.getClass());
            String string = xMLTranslator.objectToXMLString(object);
            Debug.noteln("XML:", string);
            Object object2 = xMLTranslator.objectFromXML(string);
            Debug.noteln("Back to:", object2);
            Debug.noteln("Class:", object2.getClass());
            Debug.noteln("obj.equals(back)? " + object.equals(object2));
            Debug.noteln("back.equals(obj)? " + object2.equals(object));
            Debug.noteln("Standard XML:", XMLTranslator.standardXML(object2));
            if (function2 != null) {
                function2.funcall(object, object2);
            }
        }
        catch (Exception exception) {
            Debug.noteException(exception);
        }
        Debug.noteln("- - - - - - - - - - - - - - - - - - - -");
    }

    public static void main(String[] stringArray) {
        XMLTranslator.do_main(new XMLTranslator());
    }

    public static void do_main(XMLTranslator xMLTranslator) {
        Debug.noteln("----- With implClass attributes");
        XMLTranslator.test(xMLTranslator, new Long(123L));
        XMLTranslator.test(xMLTranslator, Lisp.NIL);
        Debug.noteln("----- Without implClass attributes");
        xMLTranslator.setOmitImplAttributes(true);
        XMLTranslator.test(xMLTranslator, new Long(123L));
        XMLTranslator.test(xMLTranslator, Lisp.NIL);
        XMLTranslator.test(xMLTranslator, Lisp.readFromString("(10 11 12)"));
        XMLTranslator.test(xMLTranslator, new LinkedList((LList)Lisp.readFromString("(10 11 12)")));
        Issue issue = new Issue("Note this");
        issue.setPriority(Priority.HIGH);
        issue.setRef(Name.valueOf("ref-1"));
        issue.setSenderId(Name.valueOf("no one"));
        XMLTranslator.test(xMLTranslator, issue);
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add("a");
        linkedList.add("b");
        linkedList.add("c");
        XMLTranslator.test(xMLTranslator, linkedList);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("a", "a-val");
        hashMap.put("b", "b-val");
        XMLTranslator.test(xMLTranslator, hashMap);
        XMLTranslator.test(xMLTranslator, "String with <boo f=\"x\">embedded XML &c</boo>");
        issue.setSenderId(Name.valueOf("probably \"no one\""));
        XMLTranslator.test(xMLTranslator, issue, new Function2(){

            public Object funcall(Object object, Object object2) {
                Debug.noteln("Decoded senderId =", ((Issue)object2).getSenderId());
                return null;
            }
        });
        XMLTranslator.test(xMLTranslator, Status.COMPLETE);
        XMLTranslator.test(xMLTranslator, new ChatMessage("Hello", "sender-1"));
        XMLTranslator.test(xMLTranslator, Lisp.readFromString("(a nil b)"));
        XMLTranslator.test(xMLTranslator, new NodeSpec("node-1", (LList)Lisp.NIL));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected final class WalkerForXML
    extends FieldWalker {
        public WalkerForXML(Class clazz) {
            super(clazz);
        }

        public void visitField(Object object, FieldWalker.FieldInfo fieldInfo, Object object2) {
            Element element = (Element)object2;
            String string = XMLTranslator.this.externalFieldName(fieldInfo.name);
            try {
                Object object3 = fieldInfo.getValue(object);
                if (XMLTranslator.isAttributeClass(fieldInfo.type)) {
                    if (object3 != null) {
                        element.setAttribute(string, object3.toString());
                    }
                } else if (object3 != null) {
                    Element element2 = new Element(string);
                    element.addContent(element2);
                    element2.addContent(XMLTranslator.this.objectToElement(object3));
                }
            }
            catch (Exception exception) {
                Debug.noteException(exception);
                throw new XMLException("Cannot get value of field " + fieldInfo.name + " of class " + object.getClass().getName() + " because " + exception);
            }
        }
    }
}

