/*
 * Decompiled with CFR 0.152.
 */
package ix.util.xml;

import ix.iface.domain.DomainParser;
import ix.util.Debug;
import ix.util.Strings;
import ix.util.xml.XML;
import ix.util.xml.XMLFileFilter;
import ix.util.xml.XMLTranslator;
import java.awt.Component;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.jdom.Document;
import org.jdom.output.XMLOutputter;

public class XMLSaver {
    protected File libDir = DomainParser.getLibraryDirectory();
    protected XMLTranslator xmlt = XML.defaultTranslator;
    protected Component frame;

    public XMLSaver(Component component) {
        this.frame = component;
    }

    public XMLTranslator getXMLTranslator() {
        return this.xmlt;
    }

    public void setXMLTranslator(XMLTranslator xMLTranslator) {
        this.xmlt = xMLTranslator;
    }

    public void saveObject(Object object) {
        this.saveDocument(this.getDocument(object));
    }

    public Document getDocument(Object object) {
        return this.xmlt.objectToDocument(object);
    }

    public void saveDocument(Document document) {
        File file;
        do {
            if ((file = this.chooseFileToWrite(this.frame, this.libDir)) == null) {
                return;
            }
            if (!file.exists()) continue;
            switch (JOptionPane.showConfirmDialog(this.frame, "Overwrite " + Strings.quote(file.getPath()), "Confirm", 0)) {
                case 0: {
                    break;
                }
                case 1: {
                    return;
                }
            }
        } while (!this.writeTo(file, document));
    }

    public boolean writeTo(File file, Document document) {
        Debug.noteln("XMLSaver writing to", file);
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            XMLOutputter xMLOutputter = new XMLOutputter("  ", true);
            xMLOutputter.setLineSeparator(System.getProperty("line.separator"));
            xMLOutputter.setTextNormalize(false);
            xMLOutputter.output(document, (OutputStream)bufferedOutputStream);
            ((OutputStream)bufferedOutputStream).flush();
            return true;
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this.frame, new Object[]{"Problem saving " + Strings.quote(file.getPath()), iOException.getMessage()}, "Trouble saving to file", 0);
            return false;
        }
    }

    public File chooseFileToWrite(Component component, File file) {
        JFileChooser jFileChooser = new JFileChooser(file);
        jFileChooser.setFileFilter(new XMLFileFilter());
        int n = jFileChooser.showSaveDialog(component);
        if (n == 0) {
            return jFileChooser.getSelectedFile();
        }
        return null;
    }
}

