/*
 * Decompiled with CFR 0.152.
 */
package ix.util.xml;

import ix.iface.domain.DomainParser;
import ix.iface.domain.LTF_Parser;
import ix.util.Debug;
import ix.util.Strings;
import ix.util.xml.XML;
import ix.util.xml.XMLFileFilter;
import ix.util.xml.XMLTranslator;
import java.awt.Component;
import java.io.File;
import java.io.FileNotFoundException;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.jdom.Document;
import org.jdom.input.SAXBuilder;

public class XMLLoader {
    protected File libDir = DomainParser.getLibraryDirectory();
    protected XMLTranslator xmlt = XML.defaultTranslator;
    protected Component frame;

    public XMLLoader(Component component) {
        this.frame = component;
    }

    public XMLTranslator getXMLTranslator() {
        return this.xmlt;
    }

    public void setXMLTranslator(XMLTranslator xMLTranslator) {
        this.xmlt = xMLTranslator;
    }

    public Object loadObject() {
        Document document;
        while ((document = this.loadDocument()) != null) {
            try {
                return this.xmlt.objectFromDocument(document);
            }
            catch (Throwable throwable) {
                Debug.noteException(throwable);
                JOptionPane.showMessageDialog(this.frame, new Object[]{"Problem converting to an object.", throwable.getMessage()}, "Exception", 0);
                continue;
            }
            break;
        }
        return null;
    }

    public Document loadDocument() {
        File file;
        Document document;
        do {
            if ((file = XMLLoader.chooseFileToRead(this.frame, this.libDir)) != null) continue;
            return null;
        } while ((document = this.readFrom(file)) == null);
        return document;
    }

    public Document readFrom(File file) {
        Debug.noteln("XMLLoader reading from", file);
        try {
            String string = file.getName();
            if (string.endsWith(".lsp")) {
                return this.readLTF(file);
            }
            if (!string.endsWith(".xml")) {
                throw new IllegalArgumentException("Don't know how to read " + file);
            }
            SAXBuilder sAXBuilder = new SAXBuilder(XML.SAXDriverClass);
            Document document = sAXBuilder.build(file);
            return document;
        }
        catch (Exception exception) {
            Debug.noteException(exception);
            JOptionPane.showMessageDialog(this.frame, new Object[]{"Problem reading " + Strings.quote(file.getPath()), exception.getMessage()}, "Exception", 0);
            return null;
        }
    }

    public Document readLTF(File file) throws FileNotFoundException {
        return XML.objectToDocument(new LTF_Parser(file).readDomain());
    }

    public static File chooseFileToRead(Component component, File file) {
        JFileChooser jFileChooser = new JFileChooser(file);
        jFileChooser.setFileFilter(new XMLFileFilter());
        int n = jFileChooser.showOpenDialog(component);
        if (n == 0) {
            return jFileChooser.getSelectedFile();
        }
        return null;
    }
}

