/*
 * Decompiled with CFR 0.152.
 */
package ix.util.xml;

import ix.util.Debug;
import ix.util.Strings;
import ix.util.Util;
import ix.util.xml.ConversionXMLTranslator;
import ix.util.xml.XMLException;
import ix.util.xml.XMLTranslator;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public class XML {
    public static XMLTranslator defaultTranslator = new ConversionXMLTranslator();
    static String SAXDriverClass;
    public static XMLOutputter prettyXMLOutputter;

    private XML() {
    }

    public static Object objectFromXML(String string) {
        return defaultTranslator.objectFromXML(string);
    }

    public static Object objectFromFile(File file) {
        try {
            SAXBuilder sAXBuilder = new SAXBuilder(SAXDriverClass);
            Document document = sAXBuilder.build(file);
            return XML.objectFromDocument(document);
        }
        catch (Exception exception) {
            Debug.noteln("While parsing", exception);
            exception.fillInStackTrace();
            throw new XMLException("Problem with file " + file + ": " + exception);
        }
    }

    public static Object objectFromDocument(Document document) {
        return defaultTranslator.objectFromDocument(document);
    }

    public static Object objectFromElement(Element element) {
        return defaultTranslator.objectFromElement(element);
    }

    public static Document parseXML(String string) {
        StringReader stringReader = new StringReader(string);
        try {
            SAXBuilder sAXBuilder = new SAXBuilder(SAXDriverClass);
            Document document = sAXBuilder.build((Reader)stringReader);
            return document;
        }
        catch (Exception exception) {
            Debug.noteln("While parsing", exception);
            throw new XMLException("Can't parse because " + exception);
        }
    }

    public static String objectToXMLString(Object object) {
        return defaultTranslator.objectToXMLString(object);
    }

    public static Document objectToDocument(Object object) {
        return defaultTranslator.objectToDocument(object);
    }

    public static XMLOutputter makePrettyXMLOutputter() {
        XMLOutputter xMLOutputter = new XMLOutputter("  ", true);
        xMLOutputter.setTextNormalize(false);
        return xMLOutputter;
    }

    public static String encodeText(String string) {
        return XML.encodeForXML(string, false);
    }

    public static String decodeText(String string) {
        return XML.decodeForXML(string);
    }

    public static String encodeAttribute(String string) {
        return XML.encodeForXML(string, true);
    }

    public static String decodeAttribute(String string) {
        return XML.decodeForXML(string);
    }

    private static String encodeForXML(String string, boolean bl) {
        String string2 = bl ? "&<>\"" : "&<>";
        int n = Strings.indexOfAny(string2, string);
        if (n < 0) {
            return string;
        }
        int n2 = 0;
        while (n >= 0) {
            n2 += XML.charEncoding(string.charAt(n)).length() - 1;
            n = Strings.indexOfAny(string2, n + 1, string);
        }
        int n3 = string.length();
        StringBuffer stringBuffer = new StringBuffer(n3 + n2);
        int n4 = 0;
        while (n4 < n3) {
            char c = string.charAt(n4);
            if (string2.indexOf(c) >= 0) {
                stringBuffer.append(XML.charEncoding(c));
            } else {
                stringBuffer.append(c);
            }
            ++n4;
        }
        Debug.assert(stringBuffer.length() == n3 + n2);
        return stringBuffer.toString();
    }

    private static String charEncoding(char c) {
        switch ("&<>\"".indexOf(c)) {
            case 0: {
                return "&amp;";
            }
            case 1: {
                return "&lt;";
            }
            case 2: {
                return "&gt;";
            }
            case 3: {
                return "&quot;";
            }
        }
        throw new RuntimeException("No encoding for " + String.valueOf(c));
    }

    private static String decodeForXML(String string) {
        if (string.indexOf(38) < 0) {
            return string;
        }
        int n = 0;
        int n2 = string.length();
        StringBuffer stringBuffer = new StringBuffer(n2);
        while (n < n2) {
            String string2;
            char c;
            char c2 = string.charAt(n);
            if (c2 != '&') {
                stringBuffer.append(c2);
                ++n;
                continue;
            }
            char c3 = string.charAt(n + 1);
            if (c3 == 'a') {
                c = '&';
                string2 = "&amp;";
            } else if (c3 == 'l') {
                c = '<';
                string2 = "&lt;";
            } else if (c3 == 'g') {
                c = '>';
                string2 = "&gt;";
            } else if (c3 == 'q') {
                c = '\"';
                string2 = "&quot;";
            } else {
                throw new RuntimeException("Cannot decode " + string);
            }
            Debug.assert(string.charAt(n + string2.length() - 1) == ';');
            stringBuffer.append(c);
            n += string2.length();
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        String string;
        while (!(string = Util.askLine("Text:")).equals("bye")) {
            String string2 = XML.encodeAttribute(string);
            Debug.noteln("Encode:", string2);
            Debug.noteln("Decode:", XML.decodeAttribute(string2));
        }
        return;
    }

    static {
        defaultTranslator.setOmitImplAttributes(true);
        SAXDriverClass = "org.apache.xerces.parsers.SAXParser";
        prettyXMLOutputter = XML.makePrettyXMLOutputter();
    }
}

