/*
 * Decompiled with CFR 0.152.
 */
package ix.util.xml;

import ix.util.Collect;
import ix.util.Debug;
import ix.util.FieldWalker;
import ix.util.Fn;
import ix.util.Predicate1;
import ix.util.Strings;
import ix.util.TwoKeyHashMap;
import ix.util.Util;
import ix.util.xml.DashSyntaxXMLTranslator;
import ix.util.xml.JavaSyntaxXMLTranslator;
import ix.util.xml.XML;
import ix.util.xml.XMLTranslator;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.output.XMLOutputter;

public class Syntax {
    protected XMLTranslator xmlt;
    protected XMLOutputter outputter = XML.makePrettyXMLOutputter();
    protected Map walkerCache = new HashMap();
    protected Map classToFieldsCache = new HashMap();
    protected TwoKeyHashMap fieldCaseMap = new TwoKeyHashMap();
    protected Set hiddenFields = new HashSet();
    protected Predicate1 isFieldAttribute;
    static /* synthetic */ Class class$ix$icore$domain$Refinement;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$ix$icore$domain$NodeSpec;
    static /* synthetic */ Class class$ix$icore$process$state$Plan;
    static /* synthetic */ Class class$ix$icore$domain$PatternAssignment;
    static /* synthetic */ Class class$java$util$Set;
    static /* synthetic */ Class class$java$util$Map;

    public Syntax(XMLTranslator xMLTranslator) {
        this.setFieldCase(class$ix$icore$domain$Refinement == null ? (class$ix$icore$domain$Refinement = Syntax.class$("ix.icore.domain.Refinement")) : class$ix$icore$domain$Refinement, "nodes", new ClassDescr(class$java$util$List == null ? (class$java$util$List = Syntax.class$("java.util.List")) : class$java$util$List, class$ix$icore$domain$NodeSpec == null ? (class$ix$icore$domain$NodeSpec = Syntax.class$("ix.icore.domain.NodeSpec")) : class$ix$icore$domain$NodeSpec));
        this.setFieldCase(class$ix$icore$process$state$Plan == null ? (class$ix$icore$process$state$Plan = Syntax.class$("ix.icore.process.state.Plan")) : class$ix$icore$process$state$Plan, "worldState", new ClassDescr(class$java$util$List == null ? (class$java$util$List = Syntax.class$("java.util.List")) : class$java$util$List, class$ix$icore$domain$PatternAssignment == null ? (class$ix$icore$domain$PatternAssignment = Syntax.class$("ix.icore.domain.PatternAssignment")) : class$ix$icore$domain$PatternAssignment));
        this.isFieldAttribute = new Predicate1(){

            public boolean trueOf(Object object) {
                FieldDescr fieldDescr = (FieldDescr)object;
                return XMLTranslator.isAttributeClass(fieldDescr.type.theClass);
            }
        };
        this.xmlt = xMLTranslator;
    }

    public void describeClass(String string, PrintStream printStream) {
        Class clazz = this.xmlt.classForExternalName(string);
        if (clazz == null) {
            clazz = this.xmlt.getClassFinder().classForName(string);
        }
        if (clazz == null) {
            printStream.println("Can't find class named " + string);
            return;
        }
        printStream.println("Syntax for " + string + " and related classes:");
        printStream.println("");
        List list = this.relevantClasses(clazz);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Class clazz2 = (Class)iterator.next();
            this.printSyntax(clazz2, printStream);
            printStream.println("");
        }
    }

    protected void printSyntax(Class clazz, PrintStream printStream) {
        ClassDescr classDescr = new ClassDescr(clazz);
        String string = classDescr.getSyntaxNTName();
        printStream.print(string + " ::=");
        if (classDescr.isStruct()) {
            this.printStructSyntax(clazz, printStream);
        } else if (classDescr.isEnumeration()) {
            this.printEnumerationSyntax(clazz, printStream);
        }
    }

    protected void printStructSyntax(Class clazz, PrintStream printStream) {
        FieldDescr fieldDescr;
        Iterator iterator;
        String string = this.xmlt.externalNameForClass(clazz);
        List list = this.getFields(clazz);
        List list2 = this.attributeFields(list);
        List list3 = this.elementFields(list);
        Debug.assert(list.size() == list2.size() + list3.size());
        printStream.println("");
        printStream.print("   <" + string);
        if (!list2.isEmpty()) {
            iterator = list2.iterator();
            while (iterator.hasNext()) {
                fieldDescr = (FieldDescr)iterator.next();
                String string2 = fieldDescr.getElementName();
                String string3 = fieldDescr.type.getSyntaxNTName();
                printStream.println("");
                printStream.print("         " + string2 + "=" + Strings.quote(string3));
            }
        }
        printStream.println(">");
        iterator = list3.iterator();
        while (iterator.hasNext()) {
            fieldDescr = (FieldDescr)iterator.next();
            printStream.println("      " + this.fieldSyntax(fieldDescr));
        }
        printStream.println("   </" + string + ">");
    }

    protected String fieldSyntax(FieldDescr fieldDescr) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = fieldDescr.type.getSyntaxNTName();
        stringBuffer.append("<" + fieldDescr.getElementName() + ">");
        if (fieldDescr.type.isList()) {
            String string2 = this.xmlt.externalNameForClass(class$java$util$List == null ? (class$java$util$List = Syntax.class$("java.util.List")) : class$java$util$List);
            stringBuffer.append("<").append(string2).append(">").append(this.eltTypeSyntax(fieldDescr.type)).append("</").append(string2).append(">");
        } else if (fieldDescr.type.isSet()) {
            String string3 = this.xmlt.externalNameForClass(class$java$util$Set == null ? (class$java$util$Set = Syntax.class$("java.util.Set")) : class$java$util$Set);
            stringBuffer.append("<").append(string3).append(">").append(this.eltTypeSyntax(fieldDescr.type)).append("</").append(string3).append(">");
        } else if (fieldDescr.type.isMap()) {
            String string4 = this.xmlt.externalNameForClass(class$java$util$Map == null ? (class$java$util$Map = Syntax.class$("java.util.Map")) : class$java$util$Map);
            stringBuffer.append("<").append(string4).append(">").append("...").append("</").append(string4).append(">");
        } else {
            stringBuffer.append(string);
        }
        stringBuffer.append("</" + fieldDescr.getElementName() + ">");
        return stringBuffer.toString();
    }

    protected String eltTypeSyntax(ClassDescr classDescr) {
        String string = classDescr.eltType == null ? "" : classDescr.eltType.getSyntaxNTName();
        return string + "...";
    }

    protected List attributeFields(List list) {
        return (List)Collect.filter(list, this.isFieldAttribute);
    }

    protected List elementFields(List list) {
        return (List)Collect.filter(list, Fn.negate(this.isFieldAttribute));
    }

    protected void OLDprintStructSyntax(Class clazz, PrintStream printStream) {
        List list = this.getFields(clazz);
        printStream.println("");
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            FieldDescr fieldDescr = (FieldDescr)iterator.next();
            printStream.println("   " + fieldDescr.type + " " + fieldDescr.name);
        }
    }

    protected void printEnumerationSyntax(Class clazz, PrintStream printStream) {
        List list = (List)Fn.applyStatic(clazz, "values", new Object[0]);
        int n = 1;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = n == 1 ? " " : " | ";
            printStream.print(string);
            printStream.print(iterator.next().toString());
            ++n;
        }
        printStream.println("");
    }

    protected List relevantClasses(Class clazz) {
        LinkedList linkedList = new LinkedList();
        this.walkRelevantClasses(clazz, linkedList);
        return linkedList;
    }

    protected void walkRelevantClasses(Class clazz, List list) {
        if (clazz == null || list.contains(clazz)) {
            return;
        }
        list.add(clazz);
        ClassDescr classDescr = new ClassDescr(clazz);
        if (classDescr.isStruct()) {
            Iterator iterator = this.getFields(clazz).iterator();
            while (iterator.hasNext()) {
                FieldDescr fieldDescr = (FieldDescr)iterator.next();
                this.walkRelevantClasses(fieldDescr.type, list);
            }
        }
    }

    protected void walkRelevantClasses(ClassDescr classDescr, List list) {
        if (classDescr == null) {
            return;
        }
        if (classDescr.isEnumeration() || classDescr.isStruct()) {
            this.walkRelevantClasses(classDescr.theClass, list);
        } else if (classDescr.isCollection()) {
            this.walkRelevantClasses(classDescr.eltType, list);
        } else if (classDescr.isMap()) {
            this.walkRelevantClasses(classDescr.keyType, list);
            this.walkRelevantClasses(classDescr.valType, list);
        }
    }

    public ClassDescr getFieldCase(Class clazz, String string) {
        return (ClassDescr)this.fieldCaseMap.get(clazz, string);
    }

    public void setFieldCase(Class clazz, String string, ClassDescr classDescr) {
        this.fieldCaseMap.put(clazz, string, classDescr);
    }

    protected List getFields(Class clazz) {
        List list = (List)this.classToFieldsCache.get(clazz);
        if (list == null) {
            list = this.computeFields(clazz);
            this.classToFieldsCache.put(clazz, list);
        }
        return list;
    }

    protected List computeFields(Class clazz) {
        LinkedList<FieldDescr> linkedList = new LinkedList<FieldDescr>();
        Iterator iterator = this.getFieldInfo(clazz).iterator();
        while (iterator.hasNext()) {
            FieldWalker.FieldInfo fieldInfo = (FieldWalker.FieldInfo)iterator.next();
            if (this.hiddenFields.contains(fieldInfo.name)) continue;
            linkedList.add(new FieldDescr(fieldInfo.name, this.getFieldClassDescr(fieldInfo.type, fieldInfo.name, clazz)));
        }
        return linkedList;
    }

    protected ClassDescr getFieldClassDescr(Class clazz, String string, Class clazz2) {
        ClassDescr classDescr = (ClassDescr)this.fieldCaseMap.get(clazz2, string);
        if (classDescr != null) {
            return classDescr;
        }
        classDescr = new ClassDescr(clazz);
        if (classDescr.isList() && string.length() >= 2) {
            String string2 = Strings.capitalize(string.substring(0, string.length() - 1));
            Class clazz3 = this.xmlt.getClassFinder().classForName(string2);
            if (clazz3 != null) {
                classDescr.eltType = new ClassDescr(clazz3);
            }
        }
        return classDescr;
    }

    protected List getFieldInfo(Class clazz) {
        FieldWalker fieldWalker = this.ensureFieldWalker(clazz);
        return fieldWalker.getFieldInfo();
    }

    protected FieldWalker ensureFieldWalker(Class clazz) {
        FieldWalker fieldWalker = (FieldWalker)this.walkerCache.get(clazz);
        if (fieldWalker == null) {
            fieldWalker = new FieldWalker(clazz);
            this.walkerCache.put(clazz, fieldWalker);
        }
        return fieldWalker;
    }

    public static void main(String[] stringArray) {
        Syntax syntax;
        Syntax syntax2 = syntax = stringArray.length > 0 && stringArray[0].equals("java") ? new Syntax(new JavaSyntaxXMLTranslator()) : new Syntax(new DashSyntaxXMLTranslator());
        String string;
        while (!(string = Util.askLine("Class name:")).equals("bye")) {
            syntax.describeClass(string, System.out);
            System.out.println("");
        }
        return;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class FieldDescr {
        String name;
        ClassDescr type;

        FieldDescr(String string, ClassDescr classDescr) {
            this.name = string;
            this.type = classDescr;
        }

        String getElementName() {
            return Syntax.this.xmlt.externalFieldName(this.name);
        }
    }

    protected class ClassDescr {
        Class theClass;
        ClassDescr eltType;
        ClassDescr keyType;
        ClassDescr valType;
        static /* synthetic */ Class class$java$lang$String;
        static /* synthetic */ Class class$java$lang$Number;
        static /* synthetic */ Class class$ix$util$SemiPrimitive;
        static /* synthetic */ Class class$ix$util$EnumeratedValue;
        static /* synthetic */ Class class$java$util$Collection;
        static /* synthetic */ Class class$java$util$List;
        static /* synthetic */ Class class$java$util$Set;
        static /* synthetic */ Class class$java$util$Map;

        ClassDescr(Class clazz) {
            this.theClass = clazz;
        }

        ClassDescr(Class clazz, Class clazz2) {
            this.theClass = clazz;
            this.eltType = new ClassDescr(clazz2);
        }

        ClassDescr(Class clazz, Class clazz2, Class clazz3) {
            this.theClass = clazz;
            this.keyType = new ClassDescr(clazz2);
            this.valType = new ClassDescr(clazz3);
        }

        String getElementName() {
            return Syntax.this.xmlt.externalNameForClass(this.theClass);
        }

        String getSyntaxNTName() {
            return this.getElementName().toUpperCase();
        }

        boolean isInterface() {
            return this.theClass.isInterface();
        }

        boolean isPrimitive() {
            return this.theClass.isPrimitive() || this.theClass == (class$java$lang$String == null ? (class$java$lang$String = ClassDescr.class$("java.lang.String")) : class$java$lang$String) || (class$java$lang$Number == null ? (class$java$lang$Number = ClassDescr.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(this.theClass) || (class$ix$util$SemiPrimitive == null ? (class$ix$util$SemiPrimitive = ClassDescr.class$("ix.util.SemiPrimitive")) : class$ix$util$SemiPrimitive).isAssignableFrom(this.theClass);
        }

        boolean isEnumeration() {
            return (class$ix$util$EnumeratedValue == null ? (class$ix$util$EnumeratedValue = ClassDescr.class$("ix.util.EnumeratedValue")) : class$ix$util$EnumeratedValue).isAssignableFrom(this.theClass);
        }

        boolean isCollection() {
            return (class$java$util$Collection == null ? (class$java$util$Collection = ClassDescr.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(this.theClass);
        }

        boolean isList() {
            return (class$java$util$List == null ? (class$java$util$List = ClassDescr.class$("java.util.List")) : class$java$util$List).isAssignableFrom(this.theClass);
        }

        boolean isSet() {
            return (class$java$util$Set == null ? (class$java$util$Set = ClassDescr.class$("java.util.Set")) : class$java$util$Set).isAssignableFrom(this.theClass);
        }

        boolean isMap() {
            return (class$java$util$Map == null ? (class$java$util$Map = ClassDescr.class$("java.util.Map")) : class$java$util$Map).isAssignableFrom(this.theClass);
        }

        boolean isStruct() {
            return !this.isInterface() && !this.isPrimitive() && !this.isCollection() && !this.isMap();
        }

        public String toString() {
            String string = Syntax.this.xmlt.externalNameForClass(this.theClass);
            if (this.isCollection()) {
                if (this.eltType == null) {
                    return string;
                }
                Class clazz = this.eltType.theClass;
                String string2 = Syntax.this.xmlt.externalNameForClass(clazz);
                return string + " [List of " + string2 + "]";
            }
            if (this.isMap()) {
                return string;
            }
            return string;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

