/*
 * Decompiled with CFR 0.152.
 */
package ix.util.match;

import ix.util.Debug;
import ix.util.lisp.Cons;
import ix.util.lisp.ItemVar;
import ix.util.lisp.LList;
import ix.util.lisp.Lisp;
import ix.util.lisp.Symbol;
import ix.util.match.MatchEnv;

public final class SimpleMatcher {
    public static final MatchEnv emptyEnv = new MatchEnv(){

        public Object put(Object object, Object object2) {
            Debug.assert(false, "emptyEnv can't be modified");
            return null;
        }
    };
    public static final Symbol REST = Symbol.intern("&rest");

    public static final MatchEnv mustMatch(Object object, Object object2) {
        return SimpleMatcher.mustMatch(object, object2, null);
    }

    public static final MatchEnv mustMatch(Object object, Object object2, MatchEnv matchEnv) {
        MatchEnv matchEnv2 = SimpleMatcher.match(object, object2, matchEnv);
        Debug.assert(matchEnv2 != null, "Failed to match", object);
        return matchEnv2;
    }

    public static final MatchEnv match(Object object, Object object2) {
        return SimpleMatcher.match(object, object2, null);
    }

    public static final MatchEnv match(Object object, Object object2, MatchEnv matchEnv) {
        if (object instanceof ItemVar) {
            Object v;
            if (matchEnv == null) {
                matchEnv = new MatchEnv();
            }
            if ((v = matchEnv.get(object)) == null) {
                matchEnv.put(object, object2);
                return matchEnv;
            }
            return v.equals(object2) ? matchEnv : null;
        }
        if (object == object2) {
            return SimpleMatcher.success(matchEnv);
        }
        if (object instanceof Cons && ((Cons)object).car() == REST) {
            return SimpleMatcher.matchRest(object, object2, matchEnv);
        }
        if (object instanceof Number) {
            return SimpleMatcher.when(object.equals(object2), matchEnv);
        }
        if (object.getClass() != object2.getClass()) {
            return null;
        }
        if (object instanceof Symbol) {
            return null;
        }
        if (object instanceof String) {
            return SimpleMatcher.when(((String)object).equals((String)object2), matchEnv);
        }
        if (object instanceof Cons) {
            Cons cons = (Cons)object;
            Cons cons2 = (Cons)object2;
            MatchEnv matchEnv2 = SimpleMatcher.match(cons.car(), cons2.car(), matchEnv);
            if (matchEnv2 == null) {
                return null;
            }
            if (matchEnv2 == emptyEnv) {
                return SimpleMatcher.match(cons.cdr(), cons2.cdr(), null);
            }
            return SimpleMatcher.when(SimpleMatcher.match(cons.cdr(), cons2.cdr(), matchEnv2) != null, matchEnv2);
        }
        return null;
    }

    private static final MatchEnv matchRest(Object object, Object object2, MatchEnv matchEnv) {
        if (!(object2 instanceof LList)) {
            return null;
        }
        Cons cons = (Cons)object;
        Object object3 = cons.cdr().car();
        if (object3 == Lisp.NIL) {
            return SimpleMatcher.success(matchEnv);
        }
        Debug.assert(object3 instanceof ItemVar, "(&rest ?var ...)");
        Debug.assert(cons.cdr().cdr() == Lisp.NIL, "(&rest ?var)");
        if (matchEnv == null) {
            matchEnv = new MatchEnv();
        }
        matchEnv.put(object3, object2);
        return matchEnv;
    }

    private static final MatchEnv when(boolean bl, MatchEnv matchEnv) {
        if (bl) {
            return SimpleMatcher.success(matchEnv);
        }
        return null;
    }

    private static final MatchEnv success(MatchEnv matchEnv) {
        if (matchEnv == null) {
            return emptyEnv;
        }
        return matchEnv;
    }
}

