/*
 * Decompiled with CFR 0.152.
 */
package ix.util.match;

import ix.icore.Variable;
import ix.util.Debug;
import ix.util.lisp.Cons;
import ix.util.lisp.ItemVar;
import ix.util.lisp.LList;
import ix.util.lisp.Lisp;
import ix.util.lisp.Symbol;
import ix.util.match.MatchEnv;

public final class Matcher {
    public static final MatchEnv emptyEnv = new MatchEnv(){

        public Object put(Object object, Object object2) {
            Debug.assert(false, "emptyEnv can't be modified");
            return null;
        }
    };
    public static final Symbol REST = Symbol.intern("&rest");

    public static final MatchEnv mustMatch(Object object, Object object2) {
        return Matcher.mustMatch(object, object2, null);
    }

    public static final MatchEnv mustMatch(Object object, Object object2, MatchEnv matchEnv) {
        MatchEnv matchEnv2 = Matcher.match(object, object2, matchEnv);
        Debug.assert(matchEnv2 != null, "Failed to match", object);
        return matchEnv2;
    }

    public static final MatchEnv match(Object object, Object object2) {
        return Matcher.match(object, object2, null);
    }

    public static final MatchEnv match(Object object, Object object2, MatchEnv matchEnv) {
        Object object3;
        Debug.assert(!(object2 instanceof ItemVar), "Match data has " + object2);
        if (object instanceof Variable && (object3 = Matcher.deref((Variable)object, matchEnv)) != null) {
            object = object3;
        }
        if (object2 instanceof Variable && (object3 = Matcher.deref((Variable)object2, matchEnv)) != null) {
            object2 = object3;
        }
        if (object == object2) {
            return Matcher.success(matchEnv);
        }
        if (object instanceof ItemVar) {
            if (matchEnv == null) {
                matchEnv = new MatchEnv();
            }
            if ((object3 = matchEnv.get(object)) == null) {
                matchEnv.checkedPut(object, object2);
                return matchEnv;
            }
            if (object3 instanceof Variable) {
                Object object4 = Matcher.deref((Variable)object3, matchEnv);
                if (object4 != null) {
                    object3 = object4;
                } else {
                    if (object2 instanceof Variable) {
                        Debug.noteln("Asked to unify value " + object3 + " and " + object2);
                        return Matcher.success(matchEnv);
                    }
                    matchEnv.checkedPut(object, object2);
                    matchEnv.checkedPut(object3, object2);
                    return matchEnv;
                }
            }
            return object3.equals(object2) ? matchEnv : null;
        }
        if (object instanceof Variable) {
            if (object2 instanceof Variable) {
                Debug.noteln("Asked to unify " + object + " and " + object2);
                return Matcher.success(matchEnv);
            }
            if (matchEnv == null) {
                matchEnv = new MatchEnv();
            }
            matchEnv.checkedPut(object, object2);
            return matchEnv;
        }
        if (object2 instanceof Variable) {
            if (matchEnv == null) {
                matchEnv = new MatchEnv();
            }
            matchEnv.checkedPut(object2, object);
            return matchEnv;
        }
        if (object instanceof Cons && ((Cons)object).car() == REST) {
            return Matcher.matchRest(object, object2, matchEnv);
        }
        if (object instanceof Number) {
            return Matcher.when(object.equals(object2), matchEnv);
        }
        if (object.getClass() != object2.getClass()) {
            return null;
        }
        if (object instanceof Symbol) {
            return null;
        }
        if (object instanceof String) {
            return Matcher.when(((String)object).equals((String)object2), matchEnv);
        }
        if (object instanceof Cons) {
            object3 = (Cons)object;
            Cons cons = (Cons)object2;
            MatchEnv matchEnv2 = Matcher.match(((Cons)object3).car(), cons.car(), matchEnv);
            if (matchEnv2 == null) {
                return null;
            }
            if (matchEnv2 == emptyEnv) {
                return Matcher.match(((Cons)object3).cdr(), cons.cdr(), null);
            }
            return Matcher.when(Matcher.match(((Cons)object3).cdr(), cons.cdr(), matchEnv2) != null, matchEnv2);
        }
        return null;
    }

    public static final Object deref(Variable variable, MatchEnv matchEnv) {
        Object object = variable.getValue();
        if (object != null) {
            Debug.assert(matchEnv == null || matchEnv.get(variable) == null);
            return object;
        }
        return matchEnv == null ? variable : matchEnv.get(variable);
    }

    private static final MatchEnv matchRest(Object object, Object object2, MatchEnv matchEnv) {
        if (!(object2 instanceof LList)) {
            return null;
        }
        Cons cons = (Cons)object;
        Object object3 = cons.cdr().car();
        if (object3 == Lisp.NIL) {
            return Matcher.success(matchEnv);
        }
        Debug.assert(object3 instanceof ItemVar, "(&rest ?var ...)");
        Debug.assert(cons.cdr().cdr() == Lisp.NIL, "(&rest ?var)");
        if (matchEnv == null) {
            matchEnv = new MatchEnv();
        }
        matchEnv.checkedPut(object3, object2);
        return matchEnv;
    }

    private static final MatchEnv when(boolean bl, MatchEnv matchEnv) {
        if (bl) {
            return Matcher.success(matchEnv);
        }
        return null;
    }

    private static final MatchEnv success(MatchEnv matchEnv) {
        if (matchEnv == null) {
            return emptyEnv;
        }
        return matchEnv;
    }
}

