/*
 * Decompiled with CFR 0.152.
 */
package ix.util.lisp;

import ix.util.Debug;
import ix.util.SemiPrimitive;
import ix.util.lisp.ItemVar;
import ix.util.lisp.Keyword;
import ix.util.lisp.LispObject;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Hashtable;

public class Symbol
implements LispObject,
SemiPrimitive,
Comparable,
Serializable {
    protected static Hashtable obTable = new Hashtable();
    public String name;

    protected Symbol(String string) {
        this.name = string;
        Debug.assert(obTable.get(string) == null);
        obTable.put(string, this);
    }

    public static Symbol intern(String string) {
        Symbol symbol = (Symbol)obTable.get(string);
        if (symbol != null) {
            return symbol;
        }
        if (string.length() == 0) {
            return new Symbol(string);
        }
        switch (string.charAt(0)) {
            case ':': {
                return new Keyword(string);
            }
            case '?': {
                return new ItemVar(string);
            }
        }
        return new Symbol(string);
    }

    public int compareTo(Object object) {
        if (object instanceof Symbol) {
            return this.name.compareTo(((Symbol)object).name);
        }
        throw new ClassCastException("Cannot compare symbol " + this + " to " + object);
    }

    protected Object readResolve() throws ObjectStreamException {
        return Symbol.intern(this.name);
    }

    public String toString() {
        return this.name;
    }

    public static Symbol valueOf(String string) {
        return Symbol.intern(string);
    }
}

