/*
 * Decompiled with CFR 0.152.
 */
package ix.util.lisp;

import ix.util.Debug;
import ix.util.lisp.Cons;
import ix.util.lisp.LList;
import ix.util.lisp.Lisp;
import ix.util.lisp.LispReadException;
import ix.util.lisp.LispStreamTokenizer;
import ix.util.lisp.LispTokenizer;
import ix.util.lisp.Symbol;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringBufferInputStream;

public class LispReader {
    protected LispTokenizer tk;
    private static final Object CLOSE = new Object();

    public LispReader(LispTokenizer lispTokenizer) {
        this.tk = lispTokenizer;
    }

    public LispReader(InputStream inputStream) {
        this.tk = new LispStreamTokenizer(inputStream);
    }

    public LispReader(Reader reader) {
        this.tk = new LispStreamTokenizer(reader);
    }

    public LispReader(String string) {
        this.tk = new LispStreamTokenizer(new StringBufferInputStream(string));
    }

    public Object safeRead(Object object) {
        try {
            return this.readObject();
        }
        catch (RuntimeException runtimeException) {
            Debug.noteException(runtimeException);
            return object;
        }
    }

    public Object safeRead() {
        return this.safeRead(Lisp.NIL);
    }

    public Object readObject() {
        Object object = this.reader();
        if (object == CLOSE) {
            throw new LispReadException("Extra close paren");
        }
        return object;
    }

    protected Object reader() {
        int n;
        try {
            n = this.tk.nextToken();
        }
        catch (IOException iOException) {
            Debug.noteException(iOException);
            throw new LispReadException("Tokenizer error");
        }
        Debug.assert(n != 10, "EOL token returned");
        if (n == -1) {
            return Lisp.EOF;
        }
        if (n == -3) {
            String string = this.tk.sval;
            char c = string.charAt(0);
            if (Character.isDigit(c) || c == '-' || c == '+') {
                return this.tryAsNumber(string);
            }
            if (string.equals("nil")) {
                return Lisp.NIL;
            }
            return Symbol.intern(string);
        }
        if (n == -2) {
            return new Double(this.tk.nval);
        }
        if (n == 40) {
            return this.listreader();
        }
        if (n == 41) {
            return CLOSE;
        }
        if (n == 34) {
            return this.tk.sval;
        }
        return Symbol.intern(String.valueOf((char)n));
    }

    protected Object tryAsNumber(String string) {
        try {
            return Long.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return Double.valueOf(string);
            }
            catch (NumberFormatException numberFormatException2) {
                return Symbol.intern(string);
            }
        }
    }

    protected LList listreader() {
        Object object;
        Cons cons;
        Cons cons2 = cons = new Cons(Lisp.NIL, Lisp.NIL);
        while ((object = this.reader()) != CLOSE && object != Lisp.EOF) {
            cons2.cdr = new Cons(object, Lisp.NIL);
            cons2 = (Cons)cons2.cdr;
        }
        if (object == Lisp.EOF) {
            throw new LispReadException("Missing close paren.");
        }
        return cons.cdr;
    }
}

