/*
 * Decompiled with CFR 0.152.
 */
package ix.util.lisp;

import ix.util.Strings;
import ix.util.lisp.Cons;
import ix.util.lisp.LList;
import ix.util.lisp.LListCollector;
import ix.util.lisp.LispReadException;
import ix.util.lisp.LispReader;
import ix.util.lisp.Null;
import ix.util.lisp.Symbol;

public class Lisp {
    public static final Null NIL = new Null();
    public static final Object EOF = new Object();

    private Lisp() {
    }

    public static final Cons cons(Object object, LList lList) {
        return new Cons(object, lList);
    }

    public static final Null list() {
        return NIL;
    }

    public static final Cons list(Object object) {
        return new Cons(object, NIL);
    }

    public static final Cons list(Object object, Object object2) {
        return new Cons(object, new Cons(object2, NIL));
    }

    public static final Cons list(Object object, Object object2, Object object3) {
        return new Cons(object, new Cons(object2, new Cons(object3, NIL)));
    }

    public static final Cons list(Object object, Object object2, Object object3, Object object4) {
        return new Cons(object, new Cons(object2, new Cons(object3, new Cons(object4, NIL))));
    }

    public static final Cons list(Object object, Object object2, Object object3, Object object4, Object object5) {
        return new Cons(object, new Cons(object2, new Cons(object3, new Cons(object4, new Cons(object5, NIL)))));
    }

    public static final boolean equal(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object instanceof Cons) {
            return object2 instanceof Cons ? Lisp.equal(((Cons)object).car, ((Cons)object2).car) && Lisp.equal(((Cons)object).cdr, ((Cons)object2).cdr) : false;
        }
        if (object instanceof String) {
            return object2 instanceof String ? object.equals(object2) : false;
        }
        if (object instanceof Number) {
            return object2 instanceof Number ? object.equals(object2) : false;
        }
        return false;
    }

    public static Object readFromString(String string) {
        LispReader lispReader = new LispReader(string);
        try {
            Object object = lispReader.readObject();
            if (lispReader.readObject() != EOF) {
                throw new LispReadException(string.trim().startsWith("(") ? "Extra close paren" : "More than one object");
            }
            return object;
        }
        catch (LispReadException lispReadException) {
            throw new LispReadException(lispReadException.getMessage() + " in string " + Strings.quote(string));
        }
    }

    public static LList elementsFromString(String string) {
        LListCollector lListCollector = new LListCollector();
        LispReader lispReader = new LispReader(string);
        try {
            while (true) {
                Object object;
                if ((object = lispReader.readObject()) == EOF) {
                    return lListCollector.contents();
                }
                lListCollector.add(object);
            }
        }
        catch (LispReadException lispReadException) {
            throw new LispReadException(lispReadException.getMessage() + " in string " + Strings.quote(string));
        }
    }

    public static String printToString(Object object) {
        if (object == null) {
            return "#<null>";
        }
        if (object instanceof Number) {
            return object.toString();
        }
        if (object instanceof String) {
            return "\"" + object + "\"";
        }
        if (object instanceof Symbol) {
            return object.toString();
        }
        if (object instanceof Null) {
            return "nil";
        }
        if (object instanceof Cons) {
            LList lList = (Cons)object;
            String string = "(" + Lisp.printToString(((LList)lList).car());
            while (((LList)lList).cdr() instanceof Cons) {
                string = string + " " + Lisp.printToString(((LList)lList).cdr().car());
                lList = ((LList)lList).cdr();
            }
            return string + ")";
        }
        return object.toString();
    }

    public static String elementsToString(LList lList) {
        if (lList.isEmpty()) {
            return "";
        }
        String string = Lisp.printToString(lList);
        return string.substring(1, string.length() - 1);
    }
}

