/*
 * Decompiled with CFR 0.152.
 */
package ix.util.lisp;

import ix.util.Collector;
import ix.util.Debug;
import ix.util.Function1;
import ix.util.Predicate2;
import ix.util.lisp.Cons;
import ix.util.lisp.LList;
import ix.util.lisp.LListListIterator;
import ix.util.lisp.Lisp;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSequentialList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.ListIterator;

public class LListCollector
extends AbstractSequentialList
implements Collector,
Serializable {
    transient Cons head;
    Cons tail;

    public LListCollector() {
        this.tail = this.head = new Cons(Lisp.NIL, Lisp.NIL);
    }

    public LListCollector(Collection collection) {
        this.tail = this.head = new Cons(Lisp.NIL, Lisp.NIL);
        this.addAll(collection);
    }

    public ListIterator listIterator(int n) {
        return new LListCollectorListIterator(n);
    }

    public int size() {
        return this.length();
    }

    public boolean add(Object object) {
        this.addElement(object);
        return true;
    }

    public void clear() {
        this.setContents(Lisp.NIL);
    }

    public int lastIndexOf(Object object) {
        return this.contents().lastIndexOf(object);
    }

    public void addElement(Object object) {
        this.tail.cdr = new Cons(object, Lisp.NIL);
        this.tail = (Cons)this.tail.cdr;
    }

    public void deleteElement(Object object) {
        this.setContents(this.head.cdr.delete(object));
    }

    public void pushElement(Object object) {
        this.head.cdr = new Cons(object, this.head.cdr);
        if (this.tail == this.head) {
            this.tail = (Cons)this.tail.cdr;
        }
    }

    public Object popElement() {
        Debug.assert(this.head.cdr instanceof Cons, "popElement() when empty");
        Object object = this.head.cdr.car();
        if (this.tail == this.head.cdr) {
            Debug.assert(this.tail.cdr == Lisp.NIL, "bogus tail");
            this.tail = this.head;
        }
        this.head.cdr = ((Cons)this.head.cdr).cdr;
        return object;
    }

    public void insertElement(Object object, Predicate2 predicate2) {
        this.setContents(this.head.cdr.insert(object, predicate2));
    }

    public Enumeration elements() {
        return this.head.cdr.elements();
    }

    public LList contents() {
        return this.head.cdr;
    }

    public Object result() {
        return this.head.cdr;
    }

    public void setContents(LList lList) {
        this.head.cdr = lList;
        this.tail = this.head;
        if (lList instanceof Cons) {
            this.tail = this.tail.lastCons();
        }
    }

    public boolean isEmpty() {
        return this.tail == this.head;
    }

    public int length() {
        return this.head.cdr.length();
    }

    public void concLList(LList lList) {
        this.tail.cdr = lList;
        if (lList instanceof Cons) {
            this.tail = this.tail.lastCons();
        }
    }

    public void appendLList(LList lList) {
        this.concLList((LList)lList.clone());
    }

    public void pushLList(LList lList) {
        this.setContents(lList.append(this.head.cdr));
    }

    public Function1 elementAdder() {
        return new adderFunction(){

            public Object funcall(Object object) {
                LListCollector.this.addElement(object);
                return null;
            }
        };
    }

    public Function1 elementPusher() {
        return new adderFunction(){

            public Object funcall(Object object) {
                LListCollector.this.pushElement(object);
                return null;
            }
        };
    }

    public Function1 llistAppender() {
        return new adderFunction(){

            public Object funcall(Object object) {
                LListCollector.this.appendLList((LList)object);
                return null;
            }
        };
    }

    public Function1 llistConcer() {
        return new adderFunction(){

            public Object funcall(Object object) {
                LListCollector.this.concLList((LList)object);
                return null;
            }
        };
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.length());
        if (this.head != this.tail) {
            Cons cons = (Cons)this.head.cdr;
            while (cons.cdr != Lisp.NIL) {
                objectOutputStream.writeObject(cons.car);
                cons = (Cons)cons.cdr;
            }
            Debug.assert(cons instanceof Cons);
            objectOutputStream.writeObject(cons);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        if (n == 0) {
            this.head = this.tail;
        } else {
            Cons cons;
            Cons cons2 = this.head = new Cons(Lisp.NIL, Lisp.NIL);
            int n2 = 0;
            while (n2 < n - 1) {
                cons = new Cons(objectInputStream.readObject(), Lisp.NIL);
                cons2.cdr = cons;
                cons2 = cons;
                ++n2;
            }
            cons = (Cons)objectInputStream.readObject();
            Debug.assert(cons == this.tail);
            cons2.cdr = cons;
        }
    }

    class LListCollectorListIterator
    extends LListListIterator {
        public LListCollectorListIterator(int n) {
            super(LListCollector.this.contents(), n);
        }

        public void set(Object object) {
            if (this.setPoint == null) {
                throw new IllegalStateException("set without next or previous, or after remove or add called");
            }
            this.setPoint.setCar(object);
        }

        public void remove() {
            boolean bl;
            if (this.setPoint == null) {
                throw new IllegalStateException("remove without next or previous, or after add");
            }
            Debug.assert(!LListCollector.this.isEmpty());
            Debug.assert(this.setPoint instanceof Cons);
            boolean bl2 = bl = this.setPoint == this.at;
            if (!bl) {
                Debug.assert(this.at == this.setPoint.cdr());
            }
            if (this.setPoint == LListCollector.this.head.cdr) {
                Debug.assert(!bl && this.index == 1 || bl && this.index == 0);
                LListCollector.this.popElement();
                this.at = this.list = LListCollector.this.head.cdr;
            } else if (this.setPoint == LListCollector.this.tail) {
                Debug.assert(this.setPoint.cdr == Lisp.NIL);
                Cons cons = LListListIterator.theCdrBefore(this.setPoint, LListCollector.this.head.cdr);
                Debug.assert(cons.cdr == this.setPoint);
                cons.setCdr(Lisp.NIL);
                LListCollector.this.tail = cons;
                this.at = Lisp.NIL;
                Debug.assert(!LListCollector.this.isEmpty());
            } else {
                Cons cons = (Cons)this.setPoint.cdr;
                this.setPoint.setCar(cons.car);
                this.setPoint.setCdr(cons.cdr);
                if (LListCollector.this.tail == cons) {
                    LListCollector.this.tail = this.setPoint;
                }
                if (this.at == cons) {
                    Debug.assert(!bl);
                    this.at = this.setPoint;
                }
                Debug.assert(!LListCollector.this.isEmpty());
            }
            Debug.assert(this.list == LListCollector.this.head.cdr);
            if (!bl) {
                --this.index;
            }
            Debug.assert(this.list.drop(this.index) == this.at);
            this.setPoint = null;
        }

        public void add(Object object) {
            if (LListCollector.this.head == LListCollector.this.tail) {
                Debug.assert(this.index == 0);
                Debug.assert(LListCollector.this.head.cdr == Lisp.NIL);
                LListCollector.this.addElement(object);
                this.list = LListCollector.this.head.cdr;
                this.at = this.list.cdr();
            } else if (this.at == Lisp.NIL) {
                LListCollector.this.addElement(object);
                this.at = this.at.cdr();
            } else if (this.at == LListCollector.this.head.cdr) {
                Debug.assert(this.index == 0);
                LListCollector.this.pushElement(object);
                this.list = LListCollector.this.head.cdr;
                this.at = this.list.cdr();
            } else {
                Debug.assert(this.at instanceof Cons);
                Object object2 = this.at.car();
                Cons cons = (Cons)this.at;
                cons.setCar(object);
                cons.setCdr(new Cons(object2, cons.cdr()));
                this.at = cons.cdr();
            }
            Debug.assert(this.list == LListCollector.this.head.cdr);
            this.setPoint = null;
            ++this.index;
        }
    }

    protected static interface adderFunction
    extends Function1 {
    }
}

