/*
 * Decompiled with CFR 0.152.
 */
package ix.util.lisp;

import ix.util.Function1;
import ix.util.Predicate2;
import ix.util.Seq;
import ix.util.lisp.Cons;
import ix.util.lisp.LListCollector;
import ix.util.lisp.LListIterator;
import ix.util.lisp.LListListIterator;
import ix.util.lisp.Lisp;
import ix.util.lisp.LispObject;
import java.io.Serializable;
import java.util.AbstractSequentialList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.ListIterator;

public abstract class LList
extends AbstractSequentialList
implements LispObject,
Serializable {
    public static LList newLList(Collection collection) {
        if (collection.isEmpty()) {
            return Lisp.NIL;
        }
        return new Cons(collection);
    }

    public ListIterator listIterator(int n) {
        return new LListListIterator(this, n);
    }

    public int size() {
        return this.length();
    }

    public Iterator iterator() {
        return new LListIterator(this);
    }

    public boolean isEmpty() {
        return this == Lisp.NIL;
    }

    public Object get(int n) {
        return this.elementAt(n);
    }

    public int lastIndexOf(Object object) {
        int n = -1;
        int n2 = -1;
        LList lList = this;
        while (lList != Lisp.NIL) {
            ++n;
            Object object2 = lList.car();
            if (object2 == object || object.equals(object2)) {
                n2 = n;
            }
            lList = lList.cdr();
        }
        return n2;
    }

    public abstract boolean isNull();

    public abstract Object car();

    public abstract LList cdr();

    public abstract int length();

    public abstract Object elementAt(int var1);

    public abstract Enumeration elements();

    public abstract boolean equal(LList var1);

    public abstract boolean find(Object var1);

    public abstract LList append(LList var1);

    public Object clone() {
        return Lisp.NIL;
    }

    public LList reverse() {
        LList lList = Lisp.NIL;
        LList lList2 = this;
        while (lList2 != Lisp.NIL) {
            lList = new Cons(lList2.car(), lList);
            lList2 = lList2.cdr();
        }
        return lList;
    }

    public Object get(Object object) {
        LList lList = this;
        while (lList != Lisp.NIL) {
            if (lList.car() == object) {
                return lList.cdr().car();
            }
            lList = lList.cdr().cdr();
        }
        return null;
    }

    public Cons lastCons() {
        Cons cons = (Cons)this;
        while (cons.cdr() != Lisp.NIL) {
            cons = (Cons)cons.cdr();
        }
        return cons;
    }

    public LList take(int n) {
        if (n <= 0 || this.isNull()) {
            return Lisp.NIL;
        }
        return new Cons(this.car(), this.cdr().take(n - 1));
    }

    public LList drop(int n) {
        LList lList = this;
        int n2 = 0;
        while (n2 < n) {
            lList = lList.cdr();
            ++n2;
        }
        return lList;
    }

    public LList without(Object object) {
        if (this.isNull()) {
            return this;
        }
        if (this.car() == object) {
            return this.cdr();
        }
        return new Cons(this.car(), this.cdr().without(object));
    }

    public LList delete(Object object) {
        if (this.isNull()) {
            return this;
        }
        if (this.car() == object) {
            return this.cdr();
        }
        LList lList = this;
        LList lList2 = this.cdr();
        while (lList2 != Lisp.NIL) {
            if (lList2.car() == object) {
                ((Cons)lList).setCdr(lList2.cdr());
                break;
            }
            lList = lList2;
            lList2 = lList2.cdr();
        }
        return this;
    }

    public LList insert(Object object, Predicate2 predicate2) {
        if (this.isNull()) {
            return new Cons(object, Lisp.NIL);
        }
        if (predicate2.trueOf(object, this.car())) {
            return new Cons(object, this);
        }
        return new Cons(this.car(), this.cdr().insert(object, predicate2));
    }

    public LList replaceAll(final Object object, final Object object2) {
        return this.mapcar(new Function1(){

            public Object funcall(Object object3) {
                return object3 == object ? object2 : object3;
            }
        });
    }

    public LList mapc(Function1 function1) {
        LList lList = this;
        while (!lList.isNull()) {
            function1.funcall(lList.car());
            lList = lList.cdr();
        }
        return this;
    }

    public LList mapcar(Function1 function1) {
        if (this.isNull()) {
            return Lisp.NIL;
        }
        return new Cons(function1.funcall(this.car()), this.cdr().mapcar(function1));
    }

    public LList flatmap(Function1 function1) {
        if (this.isNull()) {
            return Lisp.NIL;
        }
        return ((LList)function1.funcall(this.car())).append(this.cdr().flatmap(function1));
    }

    public void walkTree(Function1 function1) {
        LList lList = this;
        while (!lList.isNull()) {
            Object object = lList.car();
            if (object instanceof LList) {
                ((LList)object).walkTree(function1);
            } else {
                function1.funcall(object);
            }
            lList = lList.cdr();
        }
    }

    public LList intersect(LList lList) {
        LListCollector lListCollector = new LListCollector();
        LList lList2 = this;
        while (!lList2.isNull()) {
            Object object = lList2.car();
            if (lList.find(object)) {
                lListCollector.addElement(object);
            }
            lList2 = lList2.cdr();
        }
        return lListCollector.contents();
    }

    public LList permute() {
        return Seq.toLList(Seq.shuffleVector(Seq.toVector(this.elements())).elements());
    }
}

