/*
 * Decompiled with CFR 0.152.
 */
package ix.util.lisp;

import ix.util.Debug;
import ix.util.lisp.ConsEnumeration;
import ix.util.lisp.LList;
import ix.util.lisp.Lisp;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;

public class Cons
extends LList
implements Cloneable {
    Object car;
    LList cdr;

    public Cons(Object object, LList lList) {
        this.car = object;
        this.cdr = lList;
    }

    public Cons(Collection collection) {
        this(null, Lisp.NIL);
        Iterator iterator = collection.iterator();
        if (!iterator.hasNext()) {
            throw new IllegalArgumentException("Trying to add an empty collection to a Cons");
        }
        this.writeIn(this, collection.iterator());
    }

    protected Cons newInstance(Object object, LList lList) {
        return new Cons(object, lList);
    }

    public boolean addAll(Collection collection) {
        Iterator iterator = collection.iterator();
        if (!iterator.hasNext()) {
            return false;
        }
        Cons cons = this.lastCons();
        Cons cons2 = this.newInstance(null, Lisp.NIL);
        cons.setCdr(cons2);
        this.writeIn(cons2, iterator);
        return true;
    }

    private void writeIn(Cons cons, Iterator iterator) {
        Debug.assert(cons.car() == null);
        cons.setCar(iterator.next());
        while (iterator.hasNext()) {
            cons.setCdr(this.newInstance(iterator.next(), Lisp.NIL));
            cons = (Cons)cons.cdr();
        }
    }

    public boolean isNull() {
        return false;
    }

    public Object car() {
        return this.car;
    }

    public LList cdr() {
        return this.cdr;
    }

    public void setCar(Object object) {
        this.car = object;
    }

    public void setCdr(Object object) {
        this.cdr = (LList)object;
    }

    public int length() {
        int n = 1;
        Cons cons = this;
        while (cons.cdr != Lisp.NIL) {
            cons = (Cons)cons.cdr;
            ++n;
        }
        return n;
    }

    public Object elementAt(int n) {
        int n2 = 0;
        LList lList = this;
        while (lList != Lisp.NIL) {
            if (n2++ == n) {
                return lList.car;
            }
            lList = lList.cdr;
        }
        return Lisp.NIL;
    }

    public Enumeration elements() {
        return new ConsEnumeration(this);
    }

    public boolean equal(LList lList) {
        return Lisp.equal(this, lList);
    }

    public boolean find(Object object) {
        LList lList = this;
        while (lList != Lisp.NIL) {
            if (lList.car == object) {
                return true;
            }
            lList = lList.cdr;
        }
        return false;
    }

    public LList append(LList lList) {
        return new Cons(this.car, this.cdr.append(lList));
    }

    public Object clone() {
        return this.append(Lisp.NIL);
    }

    public boolean equals(Object object) {
        return Lisp.equal(this, object);
    }

    public String toString() {
        return Lisp.printToString(this);
    }
}

