/*
 * Decompiled with CFR 0.152.
 */
package ix.util.context;

import ix.util.Debug;
import ix.util.context.ContextHolder;
import ix.util.context.ContextHoldingStrategy;
import ix.util.context.ContextLink;
import ix.util.context.GlobalHoldingStrategy;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public final class Context {
    static long count = 0L;
    static HashMap numberToContextTable = new HashMap();
    public static final Context rootContext = new Context();
    static ContextHoldingStrategy contextHoldingStrategy = new GlobalHoldingStrategy();
    final long number;
    final Context parent;
    final List children = new ArrayList();
    static /* synthetic */ Class class$ix$util$context$Context;

    public Context() {
        this(null);
    }

    public Context(Context context) {
        Class clazz = class$ix$util$context$Context == null ? (class$ix$util$context$Context = Context.class$("ix.util.context.Context")) : class$ix$util$context$Context;
        synchronized (clazz) {
            this.number = count++;
            this.parent = context == null && rootContext != null ? rootContext : context;
            if (this.parent != null) {
                this.parent.children.add(this);
            }
            numberToContextTable.put(new Long(this.number), new WeakReference<Context>(this));
            Debug.assert(Context.getContext(this.number) == this);
        }
    }

    public long getNumber() {
        return this.number;
    }

    public Context getParent() {
        return this.parent;
    }

    public List getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public void discard() {
        Class clazz = class$ix$util$context$Context == null ? (class$ix$util$context$Context = Context.class$("ix.util.context.Context")) : class$ix$util$context$Context;
        synchronized (clazz) {
            if (this.parent != null) {
                this.parent.children.remove(this);
            }
            Context.discardSubtree(this);
        }
    }

    private static void discardSubtree(Context context) {
        Object object;
        Iterator iterator = context.children.iterator();
        while (iterator.hasNext()) {
            object = (Context)iterator.next();
            Context.discardSubtree((Context)object);
        }
        context.children.clear();
        object = new Long(context.number);
        WeakReference weakReference = (WeakReference)numberToContextTable.get(object);
        weakReference.clear();
        numberToContextTable.remove(object);
        Debug.assert(Context.getContext(context.number) == null);
    }

    public String toString() {
        return "#<Context " + this.number + ">";
    }

    public static Context getContext(long l) {
        WeakReference weakReference = (WeakReference)numberToContextTable.get(new Long(l));
        return weakReference == null ? null : (Context)weakReference.get();
    }

    public static ContextHoldingStrategy getContextHoldingStrategy() {
        return contextHoldingStrategy;
    }

    public static void setContextHoldingStrategy(ContextHoldingStrategy contextHoldingStrategy) {
        Context.contextHoldingStrategy = contextHoldingStrategy;
    }

    public static ContextHolder getContextHolder() {
        return contextHoldingStrategy.getContextHolder();
    }

    public static Object getInContext(ContextLink contextLink, Context context) {
        Context context2 = context;
        while (context2 != null) {
            long l = context2.number;
            while (contextLink != null && contextLink.contextNumber > l) {
                contextLink = contextLink.next;
            }
            if (contextLink == null) {
                throw new Error("Couldn't find value in " + context);
            }
            if (contextLink.contextNumber == l) {
                return contextLink.value;
            }
            context2 = context2.parent;
        }
        throw new Error("No value in " + context);
    }

    public static void setInContext(ContextLink contextLink, Context context, Object object) {
        Context context2 = context;
        long l = context2.number;
        ContextLink contextLink2 = contextLink;
        while (true) {
            if (contextLink2.contextNumber == l) {
                contextLink2.value = object;
                return;
            }
            if (contextLink2.contextNumber < l) {
                contextLink2.next = new ContextLink(contextLink2.contextNumber, contextLink2.value, contextLink2.next);
                contextLink2.contextNumber = l;
                contextLink2.value = object;
                return;
            }
            if (contextLink2.next == null) {
                contextLink2.next = new ContextLink(context2, object, null);
                return;
            }
            contextLink2 = contextLink2.next;
        }
    }

    public static void inContext(ContextHolder contextHolder, Context context, Runnable runnable) {
        Context context2 = contextHolder.getContext();
        try {
            contextHolder.setContext(context);
            runnable.run();
            Object var5_4 = null;
            contextHolder.setContext(context2);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            contextHolder.setContext(context2);
            throw throwable;
        }
    }

    public static void pushContext(ContextHolder contextHolder) {
        contextHolder.setContext(new Context(contextHolder.getContext()));
    }

    public static Context popContext(ContextHolder contextHolder) {
        Context context = contextHolder.getContext();
        if (context == null) {
            throw new Error("Trying to pop null context");
        }
        if (context.parent == null) {
            throw new Error("Trying to pop to null context");
        }
        contextHolder.setContext(context.parent);
        return context;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

