/*
 * Decompiled with CFR 0.152.
 */
package ix.util;

import ix.Release;
import ix.util.Debug;
import ix.util.Fn;
import ix.util.ObjectCopier;
import ix.util.Parameters;
import ix.util.RethrownException;
import ix.util.Strings;
import java.awt.Component;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class Util {
    private static NameGenerator defaultNameGenerator = new NameGenerator();
    private static ObjectCopier defaultObjectCopier = new ObjectCopier();
    static /* synthetic */ Class class$ix$util$Util;

    public static void printGreeting(String string) {
        System.out.println(string + ", I-X version " + Release.version + ", " + Release.date);
        System.out.println("");
    }

    public static void displayMessage(final Component component, final Object object) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JOptionPane.showMessageDialog(component, object, "Message", 1);
            }
        });
    }

    public static void displayAndWait(final Component component, final Object object) {
        Runnable runnable = new Runnable(){

            public void run() {
                JOptionPane.showMessageDialog(component, object, "Message", 1);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void swingAndWait(Runnable runnable) {
        try {
            SwingUtilities.invokeAndWait(runnable);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RethrownException(invocationTargetException);
        }
        catch (InterruptedException interruptedException) {
            throw new RethrownException(interruptedException);
        }
    }

    public static void notImplemented(Component component, String string) {
        JOptionPane.showMessageDialog(component, string + " is not yet supported.");
    }

    public static boolean dialogConfirms(Component component, String string) {
        switch (JOptionPane.showConfirmDialog(component, string, "Confirm", 0)) {
            case 0: {
                return true;
            }
            case 1: {
                return false;
            }
        }
        throw new Error("Confirm dialog failed to return YES or NO");
    }

    public static ImageIcon resourceImageIcon(String string) {
        String string2 = string.indexOf(47) > -1 ? string : "resources/images/" + string;
        URL uRL = (class$ix$util$Util == null ? (class$ix$util$Util = Util.class$("ix.util.Util")) : class$ix$util$Util).getClassLoader().getResource(string2);
        if (uRL != null) {
            Debug.noteln("Making ImageIcon from", uRL);
            return new ImageIcon(uRL);
        }
        throw new RuntimeException("Can't find image resource named " + Strings.quote(string));
    }

    public static ImageIcon resourceImageIconFromFile(String string) {
        String string2 = System.getProperty("ix.base", ".");
        File file = new File(string2, "resources");
        File file2 = new File(file, "images");
        File file3 = new File(file2, string);
        Debug.noteln("Making ImageIcon from", file3);
        try {
            return new ImageIcon(file3.toURL());
        }
        catch (MalformedURLException malformedURLException) {
            Debug.noteException(malformedURLException);
            throw new RuntimeException("Can't handle image filename " + string);
        }
    }

    public static String getUserName() {
        return System.getProperty("user.name");
    }

    public static String getHostName() throws UnknownHostException {
        return Parameters.haveParameter("host") ? Parameters.getParameter("host") : InetAddress.getLocalHost().getHostName();
    }

    public static String quote(String string) {
        return "\"" + string + "\"";
    }

    public static String generateName(String string) {
        return defaultNameGenerator.nextName(string);
    }

    public static Object copy(Object object) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        return defaultObjectCopier.copy(object);
    }

    public static Object copy(Object object, Class clazz) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        return defaultObjectCopier.copy(object, clazz);
    }

    public static Object makeInstance(Class clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception exception) {
            Debug.noteException(exception);
            throw new Error("Cannot make 0-arg instance of " + clazz + " because " + exception);
        }
    }

    public static Object clone(Object object) {
        return Fn.apply(object, "clone", new Object[0]);
    }

    public static void printLines(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            System.out.println(stringArray[n]);
            ++n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String askLine(String string) {
        System.out.print(string + " ");
        System.out.flush();
        try {
            while (true) {
                if (System.in.available() != 0) {
                    return Util.readLine(System.in);
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        catch (IOException iOException) {
            Debug.noteException(iOException);
            return "";
        }
    }

    public static String readLine(InputStream inputStream) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(80);
        while (true) {
            int n;
            try {
                n = inputStream.read();
            }
            catch (IOException iOException) {
                Debug.warn("IOException reading line from " + inputStream);
                break;
            }
            if (n == 10 || n == -1) break;
            if (n == 13) continue;
            byteArrayOutputStream.write(n);
        }
        return byteArrayOutputStream.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class NameGenerator {
        protected Map counters = new HashMap();

        public String nextName(String string) {
            Long l = (Long)this.counters.get(string);
            if (l == null) {
                l = new Long(0L);
                this.counters.put(string, l);
            }
            long l2 = l;
            this.counters.put(string, new Long(l2 + 1L));
            return string + "-" + l2;
        }
    }
}

