/*
 * Decompiled with CFR 0.152.
 */
package ix.util;

import ix.util.JavaNameWordIterator;
import ix.util.lisp.LListCollector;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public final class Strings {
    private Strings() {
    }

    public static int indexOfAny(String string, String string2) {
        return Strings.indexOfAny(string, 0, string2);
    }

    public static int indexOfAny(String string, int n, String string2) {
        int n2 = n;
        int n3 = string2.length();
        while (n2 < n3) {
            int n4 = string.indexOf(string2.charAt(n2));
            if (n4 != -1) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public static String[] breakAtFirst(String string, String string2) {
        int n = string2.indexOf(string);
        if (n == -1) {
            return new String[]{string2, ""};
        }
        return new String[]{string2.substring(0, n), string2.substring(n + string.length())};
    }

    public static String[] breakAtLast(String string, String string2) {
        int n = string2.lastIndexOf(string);
        if (n == -1) {
            return new String[]{string2, ""};
        }
        return new String[]{string2.substring(0, n), string2.substring(n + string.length())};
    }

    public static List breakAt(String string, String string2) {
        LListCollector lListCollector = new LListCollector();
        while (!string2.equals("")) {
            String[] stringArray = Strings.breakAtFirst(string, string2);
            lListCollector.add(stringArray[0]);
            string2 = stringArray[1];
        }
        return lListCollector.contents();
    }

    public static String joinWith(String string, List list) {
        CharSequence charSequence;
        int n = string.length();
        int n2 = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            charSequence = (String)iterator.next();
            n2 += ((String)charSequence).length();
            if (!iterator.hasNext()) continue;
            n2 += n;
        }
        charSequence = new StringBuffer(n2);
        Iterator iterator2 = list.iterator();
        while (iterator2.hasNext()) {
            String string2 = (String)iterator2.next();
            ((StringBuffer)charSequence).append(string2);
            if (!iterator2.hasNext()) continue;
            ((StringBuffer)charSequence).append(string);
        }
        return ((StringBuffer)charSequence).toString();
    }

    public static String beforeFirst(String string, String string2) {
        int n = string2.indexOf(string);
        return n == -1 ? string2 : string2.substring(0, n);
    }

    public static String afterLast(String string, String string2) {
        int n = string2.lastIndexOf(string);
        return n == -1 ? string2 : string2.substring(n + string.length());
    }

    public static String firstLine(String string) {
        return Strings.beforeFirst("\n", string);
    }

    public static List breakIntoLines(String string) {
        return Strings.breakAt("\n", string);
    }

    public static String foldLongLine(String string) {
        List list = Strings.breakAt(" ", string);
        String string2 = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer();
        int n = 75;
        int n2 = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            if (n2 + string3.length() > n) {
                stringBuffer.append(string2);
                n2 = 0;
            }
            stringBuffer.append(string3).append(" ");
            n2 += string3.length();
        }
        return stringBuffer.toString();
    }

    public static String replace(String string, String string2, String string3) {
        int n = string3.indexOf(string);
        if (n < 0) {
            return string3;
        }
        StringBuffer stringBuffer = new StringBuffer(string3.length());
        int n2 = string.length();
        int n3 = 0;
        while (n >= 0) {
            stringBuffer.append(string3.substring(n3, n)).append(string2);
            n3 = n + n2;
            n = string3.indexOf(string, n3);
        }
        stringBuffer.append(string3.substring(n3));
        return stringBuffer.toString();
    }

    public static String quote(String string) {
        return "\"" + string + "\"";
    }

    public static String capitalize(String string) {
        return string.substring(0, 1).toUpperCase() + string.substring(1);
    }

    public static String uncapitalize(String string) {
        return string.substring(0, 1).toLowerCase() + string.substring(1);
    }

    public static String repeat(int n, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(string);
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String dashNameToJavaName(String string) {
        List list = Strings.breakAt("-", string);
        StringBuffer stringBuffer = new StringBuffer(string.length());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            stringBuffer.append(Strings.capitalize(string2));
        }
        return stringBuffer.toString();
    }

    public static String dashNameToFullJavaName(String string) {
        if (string.indexOf(".") == -1) {
            return Strings.dashNameToJavaName(string);
        }
        List list = Strings.breakAt(".", string);
        ListIterator<String> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            String string2 = (String)listIterator.next();
            listIterator.set(Strings.dashNameToJavaName(string2));
        }
        return Strings.joinWith(".", list);
    }

    public static String javaNameToDashName(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        JavaNameWordIterator javaNameWordIterator = new JavaNameWordIterator(string);
        while (javaNameWordIterator.hasNext()) {
            String string2 = (String)javaNameWordIterator.next();
            if (string2.length() > 1 && Character.isUpperCase(string2.charAt(0)) && Character.isUpperCase(string2.charAt(1))) {
                stringBuffer.append(string2);
            } else {
                stringBuffer.append(string2.toLowerCase());
            }
            if (!javaNameWordIterator.hasNext()) continue;
            stringBuffer.append("-");
        }
        return stringBuffer.toString();
    }

    public static String fullJavaNameToDashName(String string) {
        if (string.indexOf(".") == -1) {
            return Strings.javaNameToDashName(string);
        }
        List list = Strings.breakAt(".", string);
        ListIterator<String> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            String string2 = (String)listIterator.next();
            listIterator.set(Strings.javaNameToDashName(string2));
        }
        return Strings.joinWith(".", list);
    }
}

