/*
 * Decompiled with CFR 0.152.
 */
package ix.util;

import ix.util.Debug;
import ix.util.Seq;
import ix.util.Strings;
import java.awt.Dimension;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Vector;

public abstract class Parameters {
    private static AccessRecordingProperties parameters = new AccessRecordingProperties();

    public static void setParameter(String string, String string2) {
        if (Debug.on) {
            Debug.noteln("Setting parameter \"" + string + "\" = " + "\"" + string2 + "\"");
        }
        ((Hashtable)parameters).put(string, string2);
    }

    public static Properties getParameters() {
        return parameters;
    }

    public static String getParameter(String string) {
        return parameters.getProperty(string);
    }

    public static String getParameter(String string, String string2) {
        return parameters.getProperty(string, string2);
    }

    public static boolean haveParameter(String string) {
        return parameters.getProperty(string) != null;
    }

    public static int getInt(String string) {
        String string2 = parameters.getProperty(string);
        if (string2 == null) {
            throw Parameters.bogusParameter("int", string, "null");
        }
        try {
            return Integer.decode(string2);
        }
        catch (NumberFormatException numberFormatException) {
            Debug.noteException(numberFormatException);
            throw Parameters.bogusParameter("int", string, string2);
        }
    }

    public static int getInt(String string, int n) {
        if (Parameters.haveParameter(string)) {
            return Parameters.getInt(string);
        }
        return n;
    }

    public static int getInt(String string, int n, int n2) {
        String string2 = parameters.getProperty(string);
        if (string2 == null) {
            return n2;
        }
        try {
            return Integer.parseInt(string2, n);
        }
        catch (NumberFormatException numberFormatException) {
            Debug.noteException(numberFormatException);
            throw Parameters.bogusParameter("int", string, string2);
        }
    }

    public static boolean getBoolean(String string) {
        return Parameters.getBoolean(string, false);
    }

    public static boolean getBoolean(String string, boolean bl) {
        String string2 = parameters.getProperty(string);
        if (string2 == null) {
            return bl;
        }
        if (string2.equals("")) {
            return true;
        }
        if (string2.equals("true")) {
            return true;
        }
        if (string2.equals("false")) {
            return false;
        }
        throw Parameters.bogusParameter("boolean", string, string2);
    }

    public static Dimension getDimension(String string) {
        String string2 = parameters.getProperty(string);
        if (string2 == null) {
            return null;
        }
        String[] stringArray = Strings.breakAtFirst("x", string2);
        try {
            int n = Integer.parseInt(stringArray[0]);
            int n2 = Integer.parseInt(stringArray[1]);
            return new Dimension(n, n2);
        }
        catch (Exception exception) {
            Debug.noteException(exception);
            throw Parameters.bogusParameter("Dimension", string, string2);
        }
    }

    public static List getList(String string) {
        return Parameters.getList(string, Collections.EMPTY_LIST);
    }

    public static List getList(String string, List list) {
        String string2 = parameters.getProperty(string);
        if (string2 == null) {
            return list;
        }
        return Strings.breakAt(",", string2);
    }

    private static RuntimeException bogusParameter(String string, String string2, String string3) {
        return new RuntimeException("Parameter \"" + string2 + "\" " + "has a non-" + string + " value: " + string3);
    }

    public static void checkParameterUse() {
        if (!Parameters.allParametersWereUsed()) {
            Vector<String> vector = new Vector<String>();
            Enumeration<?> enumeration = parameters.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (parameters.accessedProperty(string)) continue;
                vector.addElement(string);
            }
            Debug.assert(!vector.isEmpty());
            Debug.noteln("");
            Debug.noteln("Warning: The following parameters have not yet been used:");
            Debug.noteElements(vector.elements(), "   ");
            Debug.noteln("");
        }
    }

    public static boolean allParametersWereUsed() {
        Enumeration<?> enumeration = parameters.propertyNames();
        while (enumeration.hasMoreElements()) {
            if (parameters.accessedProperty((String)enumeration.nextElement())) continue;
            return false;
        }
        return true;
    }

    public static void processCommandLineArguments(String[] stringArray) {
        Enumeration enumeration = Seq.elements(stringArray);
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String[] stringArray2 = Strings.breakAtFirst("=", string);
            String string2 = stringArray2[0];
            String string3 = stringArray2[1];
            if (!string2.startsWith("-")) {
                Parameters.complain(string2, "does not start with \"-\"");
            } else {
                string2 = string2.substring(1);
            }
            if (string2.startsWith("n") && (string2.equals("not") || string2.equals("no"))) {
                if (!string3.equals("")) {
                    Parameters.complain(string, "has " + string2 + " with =");
                    continue;
                }
                if (enumeration.hasMoreElements()) {
                    string2 = (String)enumeration.nextElement();
                    Parameters.setParameter(string2, "false");
                    continue;
                }
                Parameters.complain(string2, "was not followed by a parameter name");
                continue;
            }
            if (string2.equals("load")) {
                if (!string3.equals("")) {
                    Parameters.complain(string, "has " + string2 + " with =");
                    continue;
                }
                if (enumeration.hasMoreElements()) {
                    Parameters.loadParameters((String)enumeration.nextElement());
                    continue;
                }
                Parameters.complain(string2, "was not followed by a file name");
                continue;
            }
            Parameters.setParameter(string2, string3);
        }
    }

    private static void complain(String string, String string2) {
        Debug.warn("Parameter \"" + string + "\" " + string2);
    }

    public static void loadParameters(String string) {
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(string));
        }
        catch (IOException iOException) {
            Debug.noteException(iOException);
            return;
        }
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            Parameters.setParameter(string2, (String)((Hashtable)properties).get(string2));
        }
    }

    static class AccessRecordingProperties
    extends Properties {
        Hashtable accessTable = new Hashtable();

        public String getProperty(String string) {
            this.accessTable.put(string, Boolean.TRUE);
            return super.getProperty(string);
        }

        public String getProperty(String string, String string2) {
            this.accessTable.put(string, Boolean.TRUE);
            return super.getProperty(string, string2);
        }

        public boolean accessedProperty(String string) {
            return this.accessTable.get(string) != null;
        }
    }
}

