/*
 * Decompiled with CFR 0.152.
 */
package ix.util;

import ix.icore.Sendable;
import ix.util.CatchingThread;
import ix.util.Debug;
import ix.util.Name;
import ix.util.Parameters;
import ix.util.Strings;
import ix.util.TextAreaFrame;
import ix.util.Util;
import ix.util.lisp.Lisp;
import ix.util.xml.XML;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.HashMap;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class IPC {
    static CommunicationStrategy defaultCommunicationStrategy = new SimpleIXCommunicationStrategy(){};

    private IPC() {
    }

    public static void setDefaultCommunicationStrategy(CommunicationStrategy communicationStrategy) {
        Debug.noteln("Setting default communication strategy to", communicationStrategy);
        defaultCommunicationStrategy = communicationStrategy;
    }

    public static void setDefaultCommunicationStrategy(String string) {
        IPC.setDefaultCommunicationStrategy(IPC.getCommunicationStrategy(string));
    }

    public static CommunicationStrategy getCommunicationStrategy(String string) {
        if (string.equals("") || string.equals("simple")) {
            return new SimpleIXCommunicationStrategy();
        }
        if (string.equals("xml")) {
            return new SimpleIXXMLCommunicationStrategy();
        }
        Class clazz = IPC.findClassForName(string);
        if (clazz != null || (clazz = IPC.findClassForName("ix." + string + "." + Strings.capitalize(string) + "CommunicationStrategy")) != null) {
            try {
                return (CommunicationStrategy)clazz.newInstance();
            }
            catch (Exception exception) {
                Debug.noteException(exception);
                throw new IllegalArgumentException("Can't make communication strategy from " + string + " because " + exception);
            }
        }
        throw new IllegalArgumentException("Can't find communication strategy class specified by " + Util.quote(string));
    }

    private static Class findClassForName(String string) {
        Debug.noteln("Looking for class", string);
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public static void sendObject(Object object, Object object2) {
        defaultCommunicationStrategy.sendObject(object, object2);
    }

    public static void setupServer(Object object, MessageListener messageListener) {
        defaultCommunicationStrategy.setupServer(object, messageListener);
    }

    public static class BrokenConnectionException
    extends IPCException {
        BrokenConnectionException(Connection connection, Throwable throwable) {
            super("Broken connection", throwable);
            this.reason = throwable;
        }
    }

    public static class IPCException
    extends RuntimeException {
        Throwable reason;

        public IPCException() {
        }

        public IPCException(String string) {
            super(string);
        }

        public IPCException(Throwable throwable) {
            super("Caused by " + throwable);
            this.reason = throwable;
        }

        public IPCException(String string, Throwable throwable) {
            super(string + " caused by " + throwable);
            this.reason = throwable;
        }

        public Throwable getReason() {
            return this.reason;
        }
    }

    public static class ServiceAddress
    implements Serializable {
        public String host;
        public int port;

        public ServiceAddress(String string, int n) {
            this.host = string;
            this.port = n;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public String toString() {
            return "addr[" + this.host + ":" + this.port + "]";
        }
    }

    public static class ObjectStreamNameServer
    extends CatchingThread {
        ObjectStreamCommunicationStrategy strategy;
        ServiceAddress addr;
        DestinationTable nameTable = new BasicDestinationTable();
        TextAreaFrame textFrame;
        ServerSocket servSock;

        public ObjectStreamNameServer(ObjectStreamCommunicationStrategy objectStreamCommunicationStrategy, ServiceAddress serviceAddress) {
            this.strategy = objectStreamCommunicationStrategy;
            this.addr = serviceAddress;
            this.textFrame = new TextAreaFrame("I-X Name-Server at " + serviceAddress.host + ":" + serviceAddress.port);
            try {
                this.servSock = new ServerSocket(serviceAddress.port);
            }
            catch (IOException iOException) {
                Debug.noteException(iOException);
                iOException.fillInStackTrace();
                throw new IPCException("Problem setting up name-server ServerSocket at " + serviceAddress, iOException);
            }
        }

        public void innerRun() {
            Debug.noteln("I-X Name-server running at", this.addr);
            try {
                while (true) {
                    Socket socket = this.servSock.accept();
                    Debug.noteln("Client connection", socket);
                    this.serveClientOn(new ObjectStreamConnection(socket));
                }
            }
            catch (IOException iOException) {
                Debug.noteException(iOException);
                iOException.fillInStackTrace();
                throw new IPCException("Problem in name-server at " + this.addr, iOException);
            }
        }

        protected void serveClientOn(ObjectStreamConnection objectStreamConnection) {
            new CatchingThread(this, objectStreamConnection){
                private final /* synthetic */ ObjectStreamConnection val$connection;
                private final /* synthetic */ ObjectStreamNameServer this$0;
                {
                    this.this$0 = objectStreamNameServer;
                    this.val$connection = objectStreamConnection;
                }

                public void innerRun() {
                    this.this$0.clientServiceLoop(this.val$connection);
                }
            }.start();
        }

        protected void clientServiceLoop(ObjectStreamConnection objectStreamConnection) {
            try {
                while (true) {
                    Object object = objectStreamConnection.receive();
                    this.handleMessage(objectStreamConnection, object);
                }
            }
            catch (BrokenConnectionException brokenConnectionException) {
                objectStreamConnection.close();
                Debug.noteln("Name-server lost connection to", objectStreamConnection.getDestination());
                this.transcript("Lost connection to " + objectStreamConnection.getDestination());
                return;
            }
        }

        protected synchronized void handleMessage(ObjectStreamConnection objectStreamConnection, Object object) {
            Debug.noteln("Name-server received", object);
            if (object instanceof String) {
                ServiceAddress serviceAddress = (ServiceAddress)this.nameTable.get(object);
                if (serviceAddress != null) {
                    objectStreamConnection.send(serviceAddress);
                } else {
                    objectStreamConnection.send("unknown");
                }
            } else if (object instanceof List) {
                List list = (List)object;
                if (list.get(0).equals("register") && list.get(1) instanceof String && list.get(2) instanceof ServiceAddress) {
                    this.recordRegistration(objectStreamConnection, (String)list.get(1), (ServiceAddress)list.get(2));
                    objectStreamConnection.send("ok");
                } else {
                    Debug.noteln("Ilegal name-server request", object);
                }
            } else {
                Debug.noteln("Ilegal name-server request", object);
            }
        }

        protected void recordRegistration(ObjectStreamConnection objectStreamConnection, String string, ServiceAddress serviceAddress) {
            objectStreamConnection.setDestination(string);
            this.nameTable.put(string, serviceAddress);
            this.transcript("Registering " + string + " at " + serviceAddress);
        }

        protected void transcript(String string) {
            SwingUtilities.invokeLater(new Runnable(this, string){
                private final /* synthetic */ String val$line;
                private final /* synthetic */ ObjectStreamNameServer this$0;
                {
                    this.this$0 = objectStreamNameServer;
                    this.val$line = string;
                }

                public void run() {
                    this.this$0.textFrame.appendLine(this.val$line);
                }
            });
        }
    }

    public static class ObjectStreamConnection
    implements Connection {
        Object destination;
        Socket sock;
        ObjectInputStream in;
        ObjectOutputStream out;

        public ObjectStreamConnection(Socket socket) {
            this("unknown agent", socket);
        }

        public ObjectStreamConnection(Object object, Socket socket) {
            this.destination = object;
            this.sock = socket;
        }

        public Object getDestination() {
            return this.destination;
        }

        public void setDestination(Object object) {
            this.destination = object;
        }

        public Socket getSocket() {
            return this.sock;
        }

        public void close() {
            try {
                this.sock.close();
            }
            catch (IOException iOException) {
                Debug.noteException(iOException);
                iOException.fillInStackTrace();
                throw new IPCException("Problem closing connection", iOException);
            }
        }

        public synchronized void send(Object object) {
            Debug.noteln("Sending to socket", this.sock);
            try {
                if (this.out == null) {
                    this.out = new ObjectOutputStream(this.sock.getOutputStream());
                }
                this.out.writeObject(object);
                this.out.flush();
                this.out.reset();
            }
            catch (IOException iOException) {
                Debug.noteException(iOException);
                iOException.fillInStackTrace();
                throw new IPCException("Problem sending to connection to " + this.destination, iOException);
            }
        }

        public Object receive() {
            try {
                if (this.in == null) {
                    this.in = new ObjectInputStream(this.sock.getInputStream());
                }
                Object object = this.in.readObject();
                Debug.noteln("Received " + object.getClass().getName() + " from socket", this.sock);
                return object;
            }
            catch (ClassNotFoundException classNotFoundException) {
                Debug.noteException(classNotFoundException);
                classNotFoundException.fillInStackTrace();
                throw new IPCException("Problem receiving from connection to " + this.destination, classNotFoundException);
            }
            catch (EOFException eOFException) {
                Debug.noteException(eOFException);
                eOFException.fillInStackTrace();
                throw new BrokenConnectionException(this, (Throwable)eOFException);
            }
            catch (SocketException socketException) {
                Debug.noteException(socketException);
                socketException.fillInStackTrace();
                throw new BrokenConnectionException(this, (Throwable)socketException);
            }
            catch (IOException iOException) {
                Debug.noteException(iOException);
                iOException.fillInStackTrace();
                throw new IPCException("Problem receiving from connection to " + this.destination, iOException);
            }
        }
    }

    public static class ObjectStreamServer
    extends CatchingThread {
        ObjectStreamCommunicationStrategy strategy;
        Object destination;
        MessageListener listener;
        ServiceAddress addr;
        ServerSocket servSock;

        public ObjectStreamServer(ObjectStreamCommunicationStrategy objectStreamCommunicationStrategy, Object object, MessageListener messageListener) {
            this.strategy = objectStreamCommunicationStrategy;
            this.destination = object;
            this.listener = messageListener;
            this.addr = (ServiceAddress)objectStreamCommunicationStrategy.destinationTable.get(object);
        }

        public void innerRun() {
            Debug.noteln("Server running for", this.destination);
            try {
                if (this.addr == null) {
                    int n = Parameters.getInt("port", 0);
                    this.servSock = new ServerSocket(n);
                    String string = Util.getHostName();
                    this.addr = new ServiceAddress(string, this.servSock.getLocalPort());
                } else {
                    this.servSock = new ServerSocket(this.addr.getPort());
                }
                if (this.strategy.destinationTable.get("name-server") != null) {
                    this.registerWithNameServer();
                }
                while (true) {
                    Socket socket = this.servSock.accept();
                    Debug.noteln("Client connection", socket);
                    this.receiveFrom(new ObjectStreamConnection(socket));
                }
            }
            catch (IOException iOException) {
                Debug.noteException(iOException);
                iOException.fillInStackTrace();
                throw new IPCException("Problem in server for " + this.destination, iOException);
            }
        }

        protected void registerWithNameServer() {
            Debug.noteln("Registering " + this.destination + " as " + this.addr.host + ":" + this.addr.port);
            do {
                try {
                    Object object = this.strategy.sendRequest("name-server", Lisp.list("register", this.destination, this.addr));
                    if (object.equals("ok")) {
                        return;
                    }
                }
                catch (IPCException iPCException) {
                    Debug.noteException(iPCException, false);
                }
            } while (this.shouldWaitForNameServer());
        }

        protected boolean shouldWaitForNameServer() {
            try {
                return this.askAboutWaiting();
            }
            catch (Exception exception) {
                Debug.noteException(exception, false);
                return true;
            }
        }

        private boolean askAboutWaiting() throws InterruptedException, InvocationTargetException {
            Object object = this.strategy.destinationTable.get("name-server");
            boolean[] blArray = new boolean[]{true};
            SwingUtilities.invokeAndWait(new Runnable(this, object, blArray){
                private final /* synthetic */ Object val$server_addr;
                private final /* synthetic */ boolean[] val$result;
                private final /* synthetic */ ObjectStreamServer this$0;
                {
                    this.this$0 = objectStreamServer;
                    this.val$server_addr = object;
                    this.val$result = blArray;
                }

                public void run() {
                    Object[] objectArray = new Object[]{"Could not register " + this.this$0.destination + " with name-server at " + this.val$server_addr, "Do you want to try again?"};
                    switch (JOptionPane.showConfirmDialog(null, objectArray, "Confirm", 0)) {
                        case 0: {
                            this.val$result[0] = true;
                            break;
                        }
                        case 1: {
                            this.val$result[0] = false;
                        }
                    }
                }
            });
            return blArray[0];
        }

        protected void receiveFrom(ObjectStreamConnection objectStreamConnection) {
            new CatchingThread(this, objectStreamConnection){
                private final /* synthetic */ ObjectStreamConnection val$connection;
                private final /* synthetic */ ObjectStreamServer this$0;
                {
                    this.this$0 = objectStreamServer;
                    this.val$connection = objectStreamConnection;
                }

                public void innerRun() {
                    Debug.noteln(this.this$0.destination + " receiver running ...");
                    this.this$0.receiveLoop(this.val$connection);
                }
            }.start();
        }

        protected void receiveLoop(ObjectStreamConnection objectStreamConnection) {
            try {
                while (true) {
                    Debug.noteln(this.destination + " waiting to receive ...");
                    Object object = this.strategy.postDecode(objectStreamConnection.receive());
                    Debug.noteln(this.destination + " received", object);
                    if (object instanceof Sendable) {
                        Name name = ((Sendable)object).getSenderId();
                        Debug.noteln("Sender was", name);
                        objectStreamConnection.setDestination(name);
                    }
                    this.listener.messageReceived(new BasicInputMessage(object));
                }
            }
            catch (BrokenConnectionException brokenConnectionException) {
                objectStreamConnection.close();
                Debug.noteln(this.destination + " lost connection to " + objectStreamConnection.getDestination());
                return;
            }
        }
    }

    public static class ObjectStreamCommunicationStrategy
    implements SocketlikeCommunicationStrategy {
        DestinationTable destinationTable = new BasicDestinationTable();
        HashMap connectionTable = new HashMap();
        Object serverDestination = null;
        public static String defaultNameServerAddress = "localhost:5555";

        public void setDestinationData(Object object, Object object2) {
            ServiceAddress serviceAddress = (ServiceAddress)object2;
            this.destinationTable.put(object, serviceAddress);
        }

        public Object getDestinationData(Object object) {
            Object object2 = this.destinationTable.get(object);
            if (object2 == null && !object.equals("name-server") && this.destinationTable.get("name-server") != null) {
                object2 = this.askNameServer(object);
            }
            if (object2 == null) {
                throw new IPCException("Unknown IPC destination " + object);
            }
            return object2;
        }

        public Object askNameServer(Object object) {
            Debug.assert(this.destinationTable.get("name-server") != null, "No name server addr");
            Object object2 = this.sendRequest("name-server", object);
            if (object2.equals("unknown")) {
                throw new IPCException("Name server doesn't know about " + object);
            }
            Debug.assert(object2 instanceof ServiceAddress, "Bogus addr for " + object, object2);
            return object2;
        }

        public void setDestinationTable(DestinationTable destinationTable) {
            this.destinationTable = destinationTable;
        }

        public Connection connectTo(Object object) {
            ServiceAddress serviceAddress = (ServiceAddress)this.getDestinationData(object);
            Debug.noteln("Connecting to " + object + " on " + serviceAddress.getHost() + " port " + serviceAddress.getPort());
            Debug.assert(this.connectionTable.get(object) == null, "connecting twice");
            try {
                Socket socket = new Socket(serviceAddress.getHost(), serviceAddress.getPort());
                ObjectStreamConnection objectStreamConnection = new ObjectStreamConnection(object, socket);
                this.connectionTable.put(object, objectStreamConnection);
                return objectStreamConnection;
            }
            catch (IOException iOException) {
                Debug.noteException(iOException, false);
                iOException.fillInStackTrace();
                throw new IPCException("Can't connect to " + object, iOException);
            }
        }

        public boolean haveConnection(Object object) {
            return this.connectionTable.get(object) != null;
        }

        public Connection getConnection(Object object) {
            Connection connection = (Connection)this.connectionTable.get(object);
            if (connection == null) {
                connection = this.connectTo(object);
            }
            return connection;
        }

        public Object preEncode(Object object) {
            return object;
        }

        public Object postDecode(Object object) {
            return object;
        }

        public void sendObject(Object object, Object object2) {
            boolean bl = this.haveConnection(object);
            try {
                Connection connection = this.getConnection(object);
                connection.send(this.preEncode(object2));
            }
            catch (IPCException iPCException) {
                this.discardAnyConnection(object);
                if (bl) {
                    Debug.noteln("Can't send because", iPCException);
                    Debug.noteln("Will attempt one resend to", object);
                    Util.displayAndWait(null, new Object[]{"Broken connection to " + object, "Will try resending once with a new connection."});
                    this.getConnection(object);
                    this.sendObject(object, object2);
                }
                throw iPCException;
            }
        }

        public Object sendRequest(Object object, Object object2) {
            try {
                Debug.noteln("Sending request to " + object, object2);
                Connection connection = this.getConnection(object);
                connection.send(object2);
                Object object3 = connection.receive();
                Debug.noteln("Received reply from " + object, object3);
                return object3;
            }
            catch (IPCException iPCException) {
                this.discardAnyConnection(object);
                iPCException.fillInStackTrace();
                throw iPCException;
            }
        }

        public void discardAnyConnection(Object object) {
            Connection connection = (Connection)this.connectionTable.get(object);
            if (connection != null) {
                Debug.noteln("Discarding connection to", object);
                connection.close();
                this.connectionTable.remove(object);
            } else {
                Debug.noteln("No connection to " + object + " to discard.");
            }
        }

        public void setupServer(Object object, MessageListener messageListener) {
            this.serverDestination = object;
            this.setupNameServerAddress();
            if (Parameters.haveParameter("run-name-server")) {
                this.setupNameServer();
            }
            ObjectStreamServer objectStreamServer = new ObjectStreamServer(this, object, messageListener);
            objectStreamServer.start();
        }

        protected void setupNameServerAddress() {
            if (Parameters.getParameter("name-server", "unspecified").equals("false")) {
                return;
            }
            if (this.destinationTable.get("name-server") != null && !Parameters.haveParameter("name-server")) {
                return;
            }
            String string = Parameters.getParameter("name-server", defaultNameServerAddress);
            String[] stringArray = Strings.breakAtFirst(":", string);
            String string2 = stringArray[0];
            Long l = (Long)Lisp.readFromString(stringArray[1]);
            Debug.noteln("Setting name-server addr " + string2 + ":" + l);
            this.setDestinationData("name-server", new ServiceAddress(string2, l.intValue()));
        }

        protected void setupNameServer() {
            ServiceAddress serviceAddress = (ServiceAddress)this.destinationTable.get("name-server");
            Debug.assert(serviceAddress != null, "Can't run name server, address unknown");
            new ObjectStreamNameServer(this, serviceAddress).start();
        }
    }

    public static class XMLObjectStreamCommunicationStrategy
    extends ObjectStreamCommunicationStrategy {
        public Object preEncode(Object object) {
            return XML.objectToXMLString(object);
        }

        public Object postDecode(Object object) {
            return XML.objectFromXML((String)object);
        }

        protected Object objectFromXMLMessage(InputMessage inputMessage) {
            String string = (String)inputMessage.getContents();
            return XML.objectFromXML(string);
        }
    }

    public static class SimpleIXXMLCommunicationStrategy
    extends XMLObjectStreamCommunicationStrategy {
        public SimpleIXXMLCommunicationStrategy() {
            this.destinationTable = new SimpleIXDestinationTable();
        }
    }

    public static class SimpleIXCommunicationStrategy
    extends ObjectStreamCommunicationStrategy {
        public SimpleIXCommunicationStrategy() {
            this.destinationTable = new SimpleIXDestinationTable();
        }
    }

    public static class SimpleIXDestinationTable
    extends BasicDestinationTable {
        public SimpleIXDestinationTable() {
            this.put("IDEEL", new ServiceAddress("localhost", 5040));
            this.put("ILEED", new ServiceAddress("localhost", 5050));
            this.put("ITEST", new ServiceAddress("localhost", 5060));
        }
    }

    public static class BasicDestinationTable
    extends HashMap
    implements DestinationTable {
    }

    public static interface DestinationTable {
        public Object get(Object var1);

        public Object put(Object var1, Object var2);
    }

    public static interface Connection {
        public Object getDestination();

        public void send(Object var1);

        public Object receive();

        public void close();
    }

    public static interface SocketlikeCommunicationStrategy
    extends CommunicationStrategy {
        public Object getDestinationData(Object var1);

        public void setDestinationData(Object var1, Object var2);

        public Connection connectTo(Object var1);

        public Connection getConnection(Object var1);
    }

    public static interface MessageListener {
        public void messageReceived(InputMessage var1);
    }

    public static class BasicInputMessage
    implements InputMessage {
        protected Object contents;

        public BasicInputMessage(Object object) {
            this.contents = object;
        }

        public Object getContents() {
            return this.contents;
        }
    }

    public static interface InputMessage {
        public Object getContents();
    }

    public static interface CommunicationStrategy {
        public void sendObject(Object var1, Object var2);

        public void setupServer(Object var1, MessageListener var2);
    }
}

