/*
 * Decompiled with CFR 0.152.
 */
package ix.util;

import ix.util.ClassFinder;
import ix.util.Debug;
import ix.util.Strings;
import ix.util.Util;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class FieldWalker {
    protected Class objClass;
    protected List fields;
    protected Map index;

    public FieldWalker(Class clazz) {
        this.objClass = clazz;
        this.fields = new LinkedList();
        this.index = new HashMap();
        this.collectFieldInfo();
    }

    public List getFieldInfo() {
        return this.fields;
    }

    public FieldInfo getFieldInfo(String string) {
        return (FieldInfo)this.index.get(string);
    }

    public void walkFields(Object object, Object object2) {
        Debug.assert(this.objClass.isInstance(object));
        Iterator iterator = this.fields.iterator();
        while (iterator.hasNext()) {
            FieldInfo fieldInfo = (FieldInfo)iterator.next();
            this.visitField(object, fieldInfo, object2);
        }
    }

    public void visitField(Object object, FieldInfo fieldInfo, Object object2) {
    }

    public void setField(Object object, String string, Object object2) throws NoSuchFieldException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Debug.assert(this.objClass.isInstance(object));
        FieldInfo fieldInfo = (FieldInfo)this.index.get(string);
        if (fieldInfo == null) {
            throw new NoSuchFieldException("FieldWalker does not recognize field " + Util.quote(string) + " in " + this.objClass);
        }
        fieldInfo.setValue(object, object2);
    }

    public void describeClass() {
        this.describeClass(System.out);
    }

    public void describeClass(PrintStream printStream) {
        printStream.println(this.objClass + " has " + (this.fields.isEmpty() ? "no fields" : "fields:"));
        Iterator iterator = this.fields.iterator();
        while (iterator.hasNext()) {
            FieldInfo fieldInfo = (FieldInfo)iterator.next();
            printStream.println(fieldInfo.type.getName() + " " + fieldInfo.name);
            printStream.println("   getter: " + fieldInfo.getter);
            printStream.println("   setter: " + fieldInfo.setter);
        }
    }

    protected void collectFieldInfo() {
        Object object;
        Object object2;
        List list = (List)this.collectFieldNames(this.objClass, new LinkedList());
        Method[] methodArray = this.objClass.getMethods();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            object2 = new FieldInfo(string);
            this.fields.add(object2);
            this.index.put(string, object2);
        }
        int n = 0;
        while (n < methodArray.length) {
            Class<?>[] classArray;
            FieldInfo fieldInfo;
            String string;
            object2 = methodArray[n];
            object = ((Method)object2).getName();
            if (FieldWalker.isGetName((String)object)) {
                string = this.fieldNameFromGetName((String)object);
                fieldInfo = (FieldInfo)this.index.get(string);
                if (fieldInfo != null && (classArray = ((Method)object2).getParameterTypes()).length == 0) {
                    fieldInfo.processGetMethod((Method)object2);
                }
            } else if (FieldWalker.isSetName((String)object) && (fieldInfo = (FieldInfo)this.index.get(string = this.fieldNameFromSetName((String)object))) != null) {
                classArray = ((Method)object2).getParameterTypes();
                Class<?> clazz = ((Method)object2).getReturnType();
                if (classArray.length == 1) {
                    fieldInfo.processSetMethod((Method)object2);
                }
            }
            ++n;
        }
        object2 = this.fields.listIterator();
        while (object2.hasNext()) {
            object = (FieldInfo)object2.next();
            if (((FieldInfo)object).getter == null || ((FieldInfo)object).setter == null) {
                object2.remove();
                continue;
            }
            ((FieldInfo)object).determineType();
        }
    }

    public static final boolean isGetName(String string) {
        return string.length() > 3 && string.startsWith("get");
    }

    public static final boolean isSetName(String string) {
        return string.length() > 3 && string.startsWith("set");
    }

    public String fieldNameFromGetName(String string) {
        return Strings.uncapitalize(string.substring(3));
    }

    public String fieldNameFromSetName(String string) {
        return Strings.uncapitalize(string.substring(3));
    }

    protected Collection collectFieldNames(Class clazz, Collection collection) {
        Class clazz2 = clazz.getSuperclass();
        if (clazz2 != null) {
            this.collectFieldNames(clazz2, collection);
        }
        Class<?>[] classArray = clazz.getInterfaces();
        int n = 0;
        while (n < classArray.length) {
            this.collectFieldNames(classArray[n], collection);
            ++n;
        }
        Field[] fieldArray = clazz.getDeclaredFields();
        int n2 = 0;
        while (n2 < fieldArray.length) {
            String string = fieldArray[n2].getName();
            if (!collection.contains(string)) {
                collection.add(string);
            }
            ++n2;
        }
        return collection;
    }

    public static void main(String[] stringArray) {
        ClassFinder classFinder = new ClassFinder();
        String string;
        while (!(string = Util.askLine("Class name:")).equals("bye")) {
            Class clazz = classFinder.classForName(string);
            System.out.println(clazz);
            if (clazz == null) continue;
            FieldWalker fieldWalker = new FieldWalker(clazz);
            fieldWalker.describeClass(System.out);
            System.out.println("");
        }
        return;
    }

    public static class FieldInfo {
        public String name;
        public Class type;
        public Method getter;
        public Method setter;

        public FieldInfo(String string) {
            this.name = string;
        }

        public Object getValue(Object object) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            return this.getter.invoke(object, new Object[0]);
        }

        public void setValue(Object object, Object object2) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            this.setter.invoke(object, object2);
        }

        protected void processGetMethod(Method method) {
            this.getter = this.getter == null ? method : this.moreSpecificMethod(method, this.getter);
        }

        protected void processSetMethod(Method method) {
            this.setter = this.setter == null ? method : this.moreSpecificMethod(method, this.setter);
        }

        protected Method moreSpecificMethod(Method method, Method method2) {
            Class<?> clazz;
            Class<?> clazz2 = method.getDeclaringClass();
            if (clazz2.isAssignableFrom(clazz = method2.getDeclaringClass())) {
                return method2;
            }
            return method;
        }

        protected void determineType() {
            Class<?> clazz;
            Class<?> clazz2 = this.getter.getReturnType();
            if (clazz2 != (clazz = this.setter.getParameterTypes()[0])) {
                throw new RuntimeException("Methods " + this.getter + " and " + this.setter + " do not agree on field type");
            }
            this.type = clazz2;
        }
    }
}

