/*
 * Decompiled with CFR 0.152.
 */
package ix.util;

import ix.util.AssertionFailure;
import ix.util.Strings;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class Debug {
    public static boolean on = true;
    public static PrintStream out = System.out;

    private Debug() {
    }

    public static void note(String string) {
        if (on) {
            Debug.printNote(string);
        }
    }

    public static void noteln(String string) {
        if (on) {
            Debug.printlnNote(string);
        }
    }

    public static void noteln(String string, Object object) {
        if (on) {
            Debug.printlnNote(string + " " + object);
        }
    }

    public static void noteln(String string, int n) {
        if (on) {
            Debug.printlnNote(string + " " + n);
        }
    }

    private static synchronized void printNote(String string) {
        out.print(string);
        out.flush();
    }

    private static synchronized void printlnNote(String string) {
        out.println(string);
    }

    public static synchronized void setNoteStream(PrintStream printStream) {
        out = printStream;
    }

    public static synchronized void setNoteFile(String string) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            out = new PrintStream(fileOutputStream, true);
        }
        catch (IOException iOException) {
            Debug.warn("Failed to setNoteFile to \"" + string + "\"\n" + "because " + iOException + "\n" + "so switching to System.out.");
            out = System.out;
        }
    }

    public static synchronized void noteException(Throwable throwable) {
        Debug.noteException(throwable, true);
    }

    public static synchronized void noteException(Throwable throwable, boolean bl) {
        if (on) {
            Debug.noteln("\nException:", throwable);
            if (bl) {
                throwable.printStackTrace(out);
            }
            Debug.noteln("");
        }
        if (!on || out != System.out) {
            System.err.println("\nException: " + throwable);
            if (bl) {
                throwable.printStackTrace(System.err);
            }
            System.err.println("");
        }
    }

    public static String describeException(Throwable throwable) {
        String string = Strings.afterLast(".", throwable.getClass().getName()) + ": ";
        if (throwable instanceof InvocationTargetException) {
            InvocationTargetException invocationTargetException = (InvocationTargetException)throwable;
            if (invocationTargetException.getMessage() != null) {
                return string + throwable.getMessage() + " - " + Debug.describeException(invocationTargetException.getTargetException());
            }
            return Debug.describeException(invocationTargetException.getTargetException());
        }
        return string + throwable.getMessage();
    }

    public static void warn(String string) {
        System.err.println("\nWarning: " + string + "\n");
        Thread.dumpStack();
        System.err.println("");
    }

    public static void error(String string) {
        System.err.println("\nWarning: " + string + "\n");
        throw new RuntimeException(string);
    }

    public static synchronized void noteEnumeration(Enumeration enumeration) {
        Debug.note("[");
        int n = 0;
        while (enumeration.hasMoreElements()) {
            Debug.note(n + ": " + enumeration.nextElement() + "\n ");
            ++n;
        }
        Debug.noteln("]");
    }

    public static synchronized void noteEnumerationClasses(Enumeration enumeration) {
        Debug.note("[");
        int n = 0;
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            Debug.note(n + " " + e.getClass() + ": " + e + "\n ");
            ++n;
        }
        Debug.noteln("]");
    }

    public static synchronized void noteElements(Enumeration enumeration, String string) {
        while (enumeration.hasMoreElements()) {
            Debug.noteln(string, enumeration.nextElement());
        }
    }

    public static void assert(boolean bl) {
        if (!bl) {
            Debug.noteln("Assertion failed.");
            throw new AssertionFailure();
        }
    }

    public static void assert(boolean bl, String string) {
        if (!bl) {
            Debug.noteln("Assertion failed:", string);
            throw new AssertionFailure(string);
        }
    }

    public static void assert(boolean bl, String string, Object object) {
        if (!bl) {
            String string2 = string + " " + object;
            Debug.noteln("Assertion failed:", string2);
            throw new AssertionFailure(string2);
        }
    }
}

