/*
 * Decompiled with CFR 0.152.
 */
package ix.util;

import ix.util.Debug;
import ix.util.Function1;
import ix.util.match.MatchCase;
import ix.util.match.MatchTable;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;

public class CommandLoop
implements Runnable {
    MatchTable commandTable;
    String prompt = "Command:";
    String exit = "bye";
    BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
    PrintStream out = System.out;

    public CommandLoop(MatchTable matchTable) {
        this.commandTable = matchTable;
    }

    public CommandLoop(final Function1 function1) {
        this.commandTable = new MatchTable();
        this.commandTable.addCase(new MatchCase(){

            public Object tryMatch(Object object) {
                return object;
            }

            public Object ifSelected(Object object, Object object2) {
                return function1.funcall(object);
            }
        });
    }

    public void setPrompt(String string) {
        this.prompt = string;
    }

    public void setExitCommand(String string) {
        this.exit = string;
    }

    public void run() {
        this.out.println("Type \"" + this.exit + "\" to exit.\n");
        while (true) {
            try {
                String string;
                while (!(string = this.ask(this.prompt)).equals(this.exit)) {
                    this.out.println(this.commandTable.match(string));
                    this.out.println("");
                }
            }
            catch (Exception exception) {
                Debug.noteException(exception);
                continue;
            }
            break;
        }
        System.out.println("\nBye!\n");
    }

    protected String ask(String string) throws IOException {
        this.out.print(string + " ");
        this.out.flush();
        return this.in.readLine();
    }
}

