/*
 * Decompiled with CFR 0.152.
 */
package ix.util;

import ix.util.Debug;
import ix.util.Strings;
import ix.util.Util;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ClassFinder {
    protected List imports = new LinkedList();
    protected Map nameToClass = new HashMap();
    protected Map classToName = new HashMap();
    protected Map nameToClassCache = new HashMap();
    protected Map classToNameCache = new HashMap();

    public ClassFinder() {
        this.addInitialNames();
        this.addInitialImports();
    }

    protected void addInitialNames() {
        this.addName("byte", Byte.TYPE);
        this.addName("char", Character.TYPE);
        this.addName("short", Short.TYPE);
        this.addName("int", Integer.TYPE);
        this.addName("long", Long.TYPE);
        this.addName("float", Float.TYPE);
        this.addName("double", Double.TYPE);
        this.addName("boolean", Boolean.TYPE);
        this.addName("void", Void.TYPE);
    }

    protected void addInitialImports() {
        this.addImport("java.lang.*");
        this.addImport("java.util.*");
    }

    public void addImport(String string) {
        this.imports.add(new Import(string));
        this.nameToClassCache.clear();
        this.classToNameCache.clear();
    }

    public void addName(String string, Class clazz) {
        this.nameToClass.put(string, clazz);
        this.classToName.put(clazz, string);
        this.nameToClassCache.clear();
        this.classToNameCache.clear();
    }

    public Class classForName(String string) {
        Class clazz = (Class)this.nameToClassCache.get(string);
        if (clazz != null) {
            return clazz;
        }
        if (clazz == null) {
            clazz = (Class)this.nameToClass.get(string);
        }
        if (clazz == null) {
            clazz = ClassFinder.tryClassForName(string);
        }
        if (clazz == null) {
            clazz = this.findImportClass(string);
        }
        if (clazz != null) {
            this.nameToClassCache.put(string, clazz);
        }
        return clazz;
    }

    protected Class findImportClass(String string) {
        Class clazz = null;
        Import import_ = null;
        Iterator iterator = this.imports.iterator();
        while (iterator.hasNext()) {
            Import import_2 = (Import)iterator.next();
            Class clazz2 = import_2.tryName(string);
            if (clazz2 == null) continue;
            if (clazz == null) {
                clazz = clazz2;
                import_ = import_2;
                continue;
            }
            throw new RuntimeException("Ambiguous name " + Util.quote(string) + " imported via both " + import_ + " and " + import_2);
        }
        return clazz;
    }

    public static Class tryClassForName(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public String nameForClass(Class clazz) {
        String string = (String)this.classToNameCache.get(clazz);
        if (string != null) {
            return string;
        }
        string = (String)this.classToName.get(clazz);
        if (string != null) {
            Debug.assert(this.nameToClass.get(string) == clazz);
            this.classToNameCache.put(clazz, string);
            return string;
        }
        String string2 = clazz.getName();
        if (string2.startsWith("[")) {
            throw new RuntimeException("Can't handle array class" + string2);
        }
        String string3 = Strings.afterLast(".", string2);
        string = this.classForName(string3) == clazz ? string3 : string2;
        this.classToNameCache.put(clazz, string);
        return string;
    }

    public static void main(String[] stringArray) {
        ClassFinder classFinder = new ClassFinder();
        String string;
        while (!(string = Util.askLine("Class name:")).equals("bye")) {
            Class clazz = classFinder.classForName(string);
            System.out.println(clazz);
            if (clazz == null) continue;
            System.out.println("Best name is " + Util.quote(classFinder.nameForClass(clazz)));
        }
        return;
    }

    protected static class Import {
        boolean star;
        String name;
        String prefix;

        public Import(String string) {
            this.name = string;
            this.star = string.endsWith("*");
            if (this.star) {
                this.prefix = string.substring(0, string.length() - 1);
                Debug.assert(this.prefix.endsWith("."), "invalid import", string);
            } else {
                this.prefix = string;
            }
        }

        public Class tryName(String string) {
            if (this.star) {
                return ClassFinder.tryClassForName(this.prefix + string);
            }
            if (this.prefix.equals(string)) {
                return ClassFinder.tryClassForName(this.prefix);
            }
            if (this.prefix.endsWith("." + string)) {
                return ClassFinder.tryClassForName(this.prefix);
            }
            return null;
        }

        public String toString() {
            return "import[" + this.name + "]";
        }
    }
}

