/*
 * Decompiled with CFR 0.152.
 */
package ix.util;

import ix.util.Debug;
import ix.util.Strings;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class CatchingThread
extends Thread {
    Runnable innerRunnable;

    public CatchingThread() {
    }

    public CatchingThread(Runnable runnable) {
        this.innerRunnable = runnable;
    }

    public void run() {
        try {
            this.innerRun();
        }
        catch (Throwable throwable) {
            Debug.noteException(throwable);
            this.handleException(throwable);
        }
    }

    public void innerRun() {
        if (this.innerRunnable != null) {
            this.innerRunnable.run();
        }
    }

    protected void handleException(final Throwable throwable) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CatchingThread.this.reportException(throwable);
            }
        });
    }

    protected void reportException(Throwable throwable) {
        String string = Strings.foldLongLine(Debug.describeException(throwable));
        JOptionPane.showMessageDialog(null, new Object[]{string}, "Exception", 0);
    }
}

