/*
 * Decompiled with CFR 0.152.
 */
package ix.iview.util;

import ix.Release;
import ix.icore.TaskItem;
import ix.icore.domain.Constraint;
import ix.icore.domain.Named;
import ix.icore.domain.NodeEndRef;
import ix.icore.domain.NodeSpec;
import ix.icore.domain.Ordering;
import ix.icore.domain.PatternAssignment;
import ix.icore.domain.Refinement;
import ix.iview.IDERelease;
import ix.iview.domain.UIObject;
import ix.util.Name;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import javax.swing.JOptionPane;

public class IVUtil {
    public static String ideReleaseToString() {
        return IDERelease.name + " version " + IDERelease.version + ", " + IDERelease.date;
    }

    public static String releaseToString() {
        return "I-X version " + Release.version + ", " + Release.date;
    }

    public static void printIDEReleaseGreeting() {
        System.out.println(IVUtil.ideReleaseToString());
        System.out.println("");
    }

    public static String namedListToDisplay(Collection collection) {
        String string = "";
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            string = string + ((Named)iterator.next()).getName() + " ";
        }
        return string;
    }

    public static Collection sortNamedCollection(Collection collection) {
        Object object;
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            object = (Named)iterator.next();
            if (object == null) continue;
            String string = object.getName();
            if (string == null || string.equals("")) {
                arrayList.add(object);
                continue;
            }
            treeMap.put(string, object);
        }
        object = new ArrayList(treeMap.values());
        object.addAll(arrayList);
        return object;
    }

    public static List sortNodeCollection(Collection collection) {
        Serializable serializable;
        TreeMap<String, Serializable> treeMap = new TreeMap<String, Serializable>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            serializable = (NodeSpec)iterator.next();
            if (serializable == null) continue;
            Name name = ((NodeSpec)serializable).getId();
            treeMap.put(name.toString(), serializable);
        }
        serializable = new ArrayList(treeMap.values());
        return serializable;
    }

    public static List sortConstraintCollection(Collection collection) {
        Cloneable cloneable;
        TreeMap<String, Cloneable> treeMap = new TreeMap<String, Cloneable>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            cloneable = (Constraint)iterator.next();
            if (cloneable == null) continue;
            String string = ((Constraint)cloneable).toString();
            treeMap.put(string, cloneable);
        }
        cloneable = new ArrayList(treeMap.values());
        return cloneable;
    }

    public static List sortTICollection(Collection collection) {
        Cloneable cloneable;
        TreeMap<String, Cloneable> treeMap = new TreeMap<String, Cloneable>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            cloneable = (TaskItem)iterator.next();
            if (cloneable == null) continue;
            Name name = ((TaskItem)cloneable).getId();
            treeMap.put(name.toString(), cloneable);
        }
        cloneable = new ArrayList(treeMap.values());
        return cloneable;
    }

    public static boolean checkCopyObject(String string, UIObject uIObject, String string2) {
        Object[] objectArray;
        String[] stringArray;
        int n;
        if (uIObject == null || uIObject.isEmpty()) {
            return false;
        }
        String string3 = uIObject.getName();
        return string3 != null && !string3.equals("") && !string3.equals("undefined") && !string3.equals("Undefined") && uIObject.nameHasChanged(string2) && (n = JOptionPane.showOptionDialog(null, stringArray = new String[]{"You have changed the name of the " + string + ".", "Do you want to overwrite the original", "or define a new one?"}, "Confirm", -1, 3, null, objectArray = new Object[]{"Overwrite", "New"}, objectArray[0])) == 1;
    }

    public static List filterForConditions(List list) {
        ArrayList<Constraint> arrayList = new ArrayList<Constraint>();
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                try {
                    Constraint constraint = (Constraint)iterator.next();
                    if (!constraint.getType().equals(Refinement.S_WORLD_STATE) || !constraint.getRelation().equals(Refinement.S_CONDITION) && !constraint.getRelation().equals(Refinement.S_EFFECT)) continue;
                    arrayList.add(constraint);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return arrayList;
    }

    public static List filterOutConditions(List list) {
        ArrayList<Constraint> arrayList = new ArrayList<Constraint>();
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                try {
                    Constraint constraint = (Constraint)iterator.next();
                    if (constraint.getType().equals(Refinement.S_WORLD_STATE) && (constraint.getRelation().equals(Refinement.S_CONDITION) || constraint.getRelation().equals(Refinement.S_EFFECT))) continue;
                    arrayList.add(constraint);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return arrayList;
    }

    public static String printNodes(Collection collection) {
        String string = "";
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            string = string + ", " + IVUtil.printNode((NodeSpec)iterator.next());
        }
        return string;
    }

    public static String printOrderings(Collection collection) {
        String string = "";
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            string = string + ", " + IVUtil.printOrdering((Ordering)iterator.next());
        }
        return string;
    }

    public static String printNode(NodeSpec nodeSpec) {
        return nodeSpec.getPattern().toString();
    }

    public static String printOrdering(Ordering ordering) {
        if (ordering == null) {
            return "";
        }
        NodeEndRef nodeEndRef = ordering.getFrom();
        NodeEndRef nodeEndRef2 = ordering.getTo();
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        if (nodeEndRef != null && nodeEndRef.getNode() != null) {
            string = nodeEndRef.getNode().toString();
        }
        if (nodeEndRef != null && nodeEndRef.getEnd() != null) {
            string2 = nodeEndRef.getEnd().toString();
        }
        if (nodeEndRef2 != null && nodeEndRef2.getNode() != null) {
            string3 = nodeEndRef2.getNode().toString();
        }
        if (nodeEndRef2 != null && nodeEndRef2.getEnd() != null) {
            string4 = nodeEndRef2.getEnd().toString();
        }
        return string + "-" + string2 + " -> " + string3 + "-" + string4;
    }

    public static String printCondition(Constraint constraint) {
        if (constraint == null) {
            return "";
        }
        String string = "E: ";
        if (constraint.getRelation() == Refinement.S_CONDITION) {
            string = "C: ";
        }
        String string2 = IVUtil.printConstraintParameters(constraint);
        return string + string2;
    }

    public static String printConstraint(Constraint constraint) {
        if (constraint == null) {
            return "";
        }
        String string = constraint.getType().toString();
        String string2 = constraint.getRelation().toString();
        String string3 = IVUtil.printConstraintParameters(constraint);
        return string + " - " + string2 + ": " + string3;
    }

    public static String printConstraintParameters(Constraint constraint) {
        List list = constraint.getParameters();
        String string = "";
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            try {
                PatternAssignment patternAssignment = (PatternAssignment)iterator.next();
                string = string + patternAssignment.getPattern() + " = " + patternAssignment.getValue().toString() + " ";
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string.trim();
    }
}

