/*
 * Decompiled with CFR 0.152.
 */
package ix.iview.igraph;

import ix.icore.domain.Named;
import ix.icore.domain.NodeSpec;
import ix.iview.domain.UIRefinement;
import ix.util.Debug;
import ix.util.lisp.LListCollector;
import java.awt.Point;
import java.util.Enumeration;
import java.util.Iterator;
import lt.monarch.graph.GraphView;
import lt.monarch.graph.view.NodeView;

public class IGraph
implements Named {
    public Class nodeViewType = class$lt$monarch$graph$view$NodeView == null ? (class$lt$monarch$graph$view$NodeView = IGraph.class$("lt.monarch.graph.view.NodeView")) : class$lt$monarch$graph$view$NodeView;
    public Class nodeType = class$java$lang$Object == null ? (class$java$lang$Object = IGraph.class$("java.lang.Object")) : class$java$lang$Object;
    public String name;
    public LListCollector nodes = new LListCollector();
    static /* synthetic */ Class class$lt$monarch$graph$view$NodeView;
    static /* synthetic */ Class class$java$lang$Object;

    public IGraph(String string, GraphView graphView) {
        this.name = string;
        this.refreshGraph(graphView);
    }

    public void refreshGraph(GraphView graphView) {
        Iterator iterator = graphView.nodeLayer.getViews();
        this.nodes.clear();
        NodeView nodeView = null;
        Object object = null;
        while (iterator.hasNext()) {
            nodeView = (NodeView)iterator.next();
            Point point = nodeView.getPosition();
            object = (NodeSpec)nodeView.getModelNode();
            this.nodes.add(new GraphNodeComponent(point, (NodeSpec)object));
        }
        if (nodeView != null) {
            this.nodeViewType = nodeView.getClass();
        }
        if (object != null) {
            this.nodeType = object.getClass();
        }
    }

    public Point getPosition(Object object) {
        GraphNodeComponent graphNodeComponent = this.findNode(object);
        if (graphNodeComponent == null) {
            Debug.noteln("IGraph: getPosition cannot find node " + object.toString());
            return null;
        }
        return graphNodeComponent.position;
    }

    protected GraphNodeComponent findNode(Object object) {
        Enumeration enumeration = this.nodes.elements();
        while (enumeration.hasMoreElements()) {
            GraphNodeComponent graphNodeComponent = (GraphNodeComponent)enumeration.nextElement();
            if (!UIRefinement.isRef(graphNodeComponent.baseNode, object)) continue;
            return graphNodeComponent;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class GraphNodeComponent {
        public Point position;
        public double width;
        public double height;
        public NodeSpec baseNode;

        public GraphNodeComponent(Point point, NodeSpec nodeSpec) {
            this.position = point;
            this.baseNode = nodeSpec;
        }

        public GraphNodeComponent(Point point, double d, double d2, NodeSpec nodeSpec) {
            this(point, nodeSpec);
            this.width = d;
            this.height = d2;
        }
    }
}

