/*
 * Decompiled with CFR 0.152.
 */
package ix.iview.igraph;

import ix.icore.domain.End;
import ix.icore.domain.NodeEndRef;
import ix.icore.domain.NodeSpec;
import ix.icore.domain.Ordering;
import ix.iface.ui.util.UIUtil;
import ix.iview.ActionEditorPanel;
import ix.iview.domain.UIDomain;
import ix.iview.domain.UINodeSpec;
import ix.iview.domain.UIRefinement;
import ix.util.Debug;
import ix.util.Name;
import ix.util.lisp.Cons;
import ix.util.lisp.LList;
import ix.util.lisp.Lisp;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;
import lt.monarch.graph.AbstractGraphModel;
import lt.monarch.graph.plugins.AbstractLinkDragStrategy;
import lt.monarch.graph.plugins.LinkDragStrategy;

public class ExpansionModel
extends AbstractGraphModel {
    private LList components;
    public UIRefinement currentAction;
    private int count = 0;
    public ActionEditorPanel editor;

    public ExpansionModel(UIRefinement uIRefinement) {
        this.setAction(uIRefinement);
    }

    public ExpansionModel() {
        this.components = Lisp.NIL;
    }

    public void setPanel(ActionEditorPanel actionEditorPanel) {
        this.editor = actionEditorPanel;
    }

    public void setAction(UIRefinement uIRefinement) {
        this.currentAction = uIRefinement;
        this.deleteAllNodeViews();
        this.count = 0;
        if (uIRefinement == null) {
            return;
        }
        List list = this.currentAction.getNodes();
        this.loadNodes(list);
        List list2 = this.currentAction.getOrderings();
        this.loadLinks(list2);
        this.updateCounter();
    }

    public void updateAction() {
        this.updateAction(this.currentAction);
    }

    public void updateAction(UIRefinement uIRefinement) {
        this.updateNodesAndLinks(uIRefinement);
    }

    private void loadNodes(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.addNode((UINodeSpec)iterator.next());
        }
    }

    private void loadLinks(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.loadLink(iterator.next());
        }
    }

    private void updateNodesAndLinks(UIRefinement uIRefinement) {
        try {
            uIRefinement.clearNodes();
            uIRefinement.clearOrderings();
            Iterator iterator = this.getNodes();
            while (iterator.hasNext()) {
                NodeComponent nodeComponent = (NodeComponent)iterator.next();
                uIRefinement.addNode(nodeComponent);
                Pin[] pinArray = nodeComponent.inputPins;
                int n = 0;
                while (n < pinArray.length) {
                    this.addLinks(uIRefinement, pinArray[n]);
                    ++n;
                }
                pinArray = nodeComponent.outputPins;
                int n2 = 0;
                while (n2 < pinArray.length) {
                    this.addLinks(uIRefinement, pinArray[n2]);
                    ++n2;
                }
            }
        }
        catch (Exception exception) {
            Debug.noteException(exception);
        }
    }

    private void addLinks(UIRefinement uIRefinement, Pin pin) {
        Iterator iterator = this.getLinksFrom(pin);
        Name name = pin.component.getId();
        End end = pin.isInputPin() ? End.BEGIN : End.END;
        while (iterator.hasNext()) {
            Pin pin2 = (Pin)iterator.next();
            End end2 = pin2.isInputPin() ? End.BEGIN : End.END;
            Name name2 = pin2.component.getId();
            if (null == this.findNode(name2)) continue;
            Ordering ordering = new Ordering(new NodeEndRef(end, name), new NodeEndRef(end2, name2));
            uIRefinement.addOrdering(ordering);
        }
        Collections.reverse(uIRefinement.getOrderings());
    }

    public void expandNode(NodeComponent nodeComponent) {
        String string = JOptionPane.showInputDialog("Please enter the name of the expansion.");
        if (string == null) {
            return;
        }
        UIDomain uIDomain = this.editor.getUIDomain();
        Object object = uIDomain.getNamedRefinement(string);
        if (object == null) {
            UIRefinement uIRefinement = new UIRefinement(this.editor.getUIDomain());
            uIRefinement.setName(string);
            uIRefinement.setPattern(nodeComponent.getPattern());
            uIDomain.addConstruct(uIRefinement);
            this.editor.setUIConstruct(uIRefinement);
        } else {
            String string2 = "There already is an expansion with this name. Please enter a new name.";
            JOptionPane.showMessageDialog(this.editor, string2);
            this.expandNode(nodeComponent);
        }
    }

    private void updateCounter() {
        Integer n = new Integer(this.currentAction.getHighestNodeId().toString());
        this.count = n;
    }

    protected void loadLink(Object object) {
        Class<?> clazz = object.getClass();
        if (!(object instanceof Ordering)) {
            Debug.error("cannot make an ordering from class " + object.getClass());
            return;
        }
        Ordering ordering = (Ordering)object;
        NodeEndRef nodeEndRef = ordering.getFrom();
        NodeComponent nodeComponent = this.findNode(nodeEndRef);
        End end = nodeEndRef.getEnd();
        nodeEndRef = ordering.getTo();
        NodeComponent nodeComponent2 = this.findNode(nodeEndRef);
        End end2 = nodeEndRef.getEnd();
        if (nodeComponent == null || nodeComponent2 == null) {
            Debug.error("Cannot recognise node in " + ordering.toString());
            return;
        }
        Pin pin = end == End.BEGIN ? nodeComponent.inputPins[0] : nodeComponent.outputPins[0];
        Pin pin2 = end2 == End.END ? nodeComponent2.outputPins[0] : nodeComponent2.inputPins[0];
        this.addLink(pin, pin2);
    }

    protected NodeComponent findNode(Object object) {
        Iterator iterator = this.getNodes();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            NodeComponent nodeComponent = (NodeComponent)e;
            if (!UIRefinement.isRef(nodeComponent, object)) continue;
            return nodeComponent;
        }
        return null;
    }

    public Iterator getNodes() {
        return this.components.iterator();
    }

    public Iterator getLinksFrom(Object object) {
        if (!(object instanceof Pin)) {
            return Collections.EMPTY_LIST.iterator();
        }
        Pin pin = (Pin)object;
        return pin.getConnections();
    }

    protected void fireLinkRemoved(Object object, Object object2) {
        super.fireLinkRemoved(object, object2);
    }

    protected void fireLinkAdded(Object object, Object object2) {
        super.fireLinkAdded(object, object2);
    }

    public void addLink(Object object, Object object2) {
        Pin pin = (Pin)object;
        Pin pin2 = (Pin)object2;
        pin.connections.add(pin2);
        this.fireLinkAdded(object, object2);
    }

    public LinkDragStrategy getLinkStrategy() {
        return new AbstractLinkDragStrategy(){

            public boolean isValidOriginPin(Object object) {
                return true;
            }

            public boolean isValidTargetPin(Object object, Object object2) {
                Pin pin = (Pin)object;
                Pin pin2 = (Pin)object2;
                return pin.component != pin2.component;
            }

            public void addLink(Object object, Object object2) {
                ExpansionModel.this.addLink(object, object2);
            }

            public void removeLink(Object object, Object object2) {
                Pin pin = (Pin)object;
                Pin pin2 = (Pin)object2;
                ((AbstractCollection)pin.connections).remove(pin2);
                ((AbstractCollection)pin2.connections).remove(pin);
                ExpansionModel.this.fireLinkRemoved(object, object2);
            }
        };
    }

    public Object addNewNode() {
        String string = JOptionPane.showInputDialog("Please enter the sub-node's pattern.");
        if (string == null) {
            return null;
        }
        ++this.count;
        NodeComponent nodeComponent = new NodeComponent(this.editor.getUIDomain(), Name.valueOf("" + this.count), string);
        this.currentAction.addNode(nodeComponent);
        this.components = new Cons(nodeComponent, this.components);
        this.fireNodeAdded(nodeComponent);
        return nodeComponent;
    }

    public Object addNode(UINodeSpec uINodeSpec) {
        LList lList = uINodeSpec.getPattern();
        Name name = uINodeSpec.getId();
        NodeComponent nodeComponent = new NodeComponent(this.editor.getUIDomain(), name, lList);
        this.components = new Cons(nodeComponent, this.components);
        this.fireNodeAdded(nodeComponent);
        return nodeComponent;
    }

    public void deleteNode(NodeSpec nodeSpec) {
        this.currentAction.deleteNode(nodeSpec);
        try {
            this.deleteNodeView((NodeComponent)nodeSpec);
        }
        catch (Exception exception) {
            Debug.noteException(exception);
        }
    }

    public void deleteNodeView(NodeComponent nodeComponent) {
        this.components = this.components.without(nodeComponent);
        this.fireNodeRemoved(nodeComponent);
    }

    public void deleteAllNodeViews() {
        if (this.components.isEmpty()) {
            return;
        }
        Iterator iterator = this.getNodes();
        while (iterator.hasNext()) {
            NodeComponent nodeComponent = (NodeComponent)iterator.next();
            this.fireNodeRemoved(nodeComponent);
        }
        this.components = Lisp.NIL;
    }

    static class NodeComponent
    extends UINodeSpec {
        String label = UIUtil.listToDisplay(this.getPattern());
        Name id = this.getId();
        Pin[] inputPins = new Pin[]{new Pin(this, "B")};
        Pin[] outputPins = new Pin[]{new Pin(this, "E")};

        public NodeComponent(UIDomain uIDomain, Name name) {
            this(uIDomain, name, (LList)Lisp.NIL);
        }

        public NodeComponent(UIDomain uIDomain, Name name, LList lList) {
            super(uIDomain, name, lList);
        }

        public NodeComponent(UIDomain uIDomain, Name name, String string) {
            super(uIDomain, name, Lisp.elementsFromString(string));
        }

        public NodeComponent(UIDomain uIDomain, String string, LList lList) {
            super(uIDomain, string, lList);
        }
    }

    static class Pin {
        String label;
        NodeComponent component;
        ArrayList connections;

        Pin(NodeComponent nodeComponent, String string) {
            this.component = nodeComponent;
            this.label = string;
            this.connections = new ArrayList();
        }

        boolean isInputPin() {
            return Arrays.asList(this.component.inputPins).contains(this);
        }

        boolean isOutputPin() {
            return Arrays.asList(this.component.outputPins).contains(this);
        }

        Iterator getConnections() {
            return ((AbstractList)this.connections).iterator();
        }
    }
}

