/*
 * Decompiled with CFR 0.152.
 */
package ix.iview.domain;

import ix.icore.IXObject;
import ix.icore.Issue;
import ix.icore.TaskItem;
import ix.icore.domain.Constraint;
import ix.icore.domain.Domain;
import ix.icore.domain.End;
import ix.icore.domain.Named;
import ix.icore.domain.NodeEndRef;
import ix.icore.domain.NodeSpec;
import ix.icore.domain.Ordering;
import ix.icore.domain.Refinement;
import ix.icore.domain.SchemaTerms;
import ix.iface.ui.util.UIUtil;
import ix.iview.domain.UIDomain;
import ix.iview.domain.UINodeSpec;
import ix.iview.domain.UIObject;
import ix.iview.igraph.IGraph;
import ix.iview.util.IVUtil;
import ix.util.Debug;
import ix.util.Name;
import ix.util.lisp.LList;
import ix.util.lisp.LListCollector;
import ix.util.lisp.Lisp;
import ix.util.match.SimpleMatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.swing.tree.TreeNode;

public class UIRefinement
implements UIObject,
Named,
SchemaTerms,
TreeNode {
    public String name;
    public LList pattern = Lisp.NIL;
    public List nodes = new ArrayList();
    public List orderings = new ArrayList();
    public List constraints = new ArrayList();
    public List issues = new ArrayList();
    public String comments = "";
    public List variableDeclarations;
    protected UIDomain uiDomain;
    protected Refinement baseObject;
    protected String baseReference = "";
    protected IGraph graph;
    private static final int NOFIND = -1;
    static /* synthetic */ Class class$ix$icore$domain$Refinement;

    public UIRefinement(UIDomain uIDomain) {
        this.uiDomain = uIDomain;
    }

    public UIRefinement(UIDomain uIDomain, Refinement refinement) {
        this.uiDomain = uIDomain;
        try {
            this.baseObject = (Refinement)refinement.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            this.baseObject = (Refinement)this.makeBaseObject();
        }
        this.baseReference = refinement.getName();
        this.loadFromDomain();
        uIDomain.addedObject(this, refinement);
    }

    public UIRefinement cloneThis() {
        UIRefinement uIRefinement;
        try {
            uIRefinement = (UIRefinement)this.clone();
            uIRefinement.baseObject = null;
            uIRefinement.baseReference = "";
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            uIRefinement = new UIRefinement(this.uiDomain);
            uIRefinement.pattern = this.pattern;
            uIRefinement.nodes = this.nodes;
            uIRefinement.orderings = this.orderings;
            uIRefinement.constraints = this.constraints;
            uIRefinement.issues = this.issues;
            uIRefinement.comments = this.comments;
            uIRefinement.variableDeclarations = this.variableDeclarations;
            uIRefinement.graph = this.graph;
        }
        return uIRefinement;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public LList getPattern() {
        return this.pattern;
    }

    public void setPattern(LList lList) {
        this.pattern = lList;
    }

    public void clearPattern() {
        this.pattern = Lisp.NIL;
    }

    public List getNodes() {
        return this.nodes;
    }

    public void setNodes(List list) {
        this.nodes = IVUtil.sortNodeCollection(list);
    }

    public void clearNodes() {
        this.nodes = new ArrayList();
    }

    public List getOrderings() {
        return this.orderings;
    }

    public void setOrderings(List list) {
        this.orderings = new ArrayList(list);
    }

    public void clearOrderings() {
        this.orderings = new ArrayList();
    }

    public List getConstraints() {
        return this.constraints;
    }

    public void setConstraints(List list) {
        this.constraints = IVUtil.sortConstraintCollection(new ArrayList(list));
    }

    public void clearConstraints() {
        this.constraints = new ArrayList();
    }

    public List getConditions() {
        List list = this.getConstraints();
        return IVUtil.filterForConditions(list);
    }

    public void setConditions(List list) {
        List list2 = this.getConstraints();
        List list3 = IVUtil.filterOutConditions(list2);
        list3.addAll(list);
        this.setConstraints(list3);
    }

    public List getOtherConstraints() {
        List list = this.getConstraints();
        return IVUtil.filterOutConditions(list);
    }

    public void setOtherConstraints(List list) {
        List list2 = this.getConstraints();
        List list3 = IVUtil.filterForConditions(list2);
        list3.addAll(list);
        this.setConstraints(list3);
    }

    public boolean hasOrderings() {
        return this.orderings != null && this.orderings.size() != 0;
    }

    public boolean hasConditions() {
        List list = this.getConditions();
        return list != null && list.size() != 0;
    }

    public boolean hasAnonConstraints() {
        List list = this.getOtherConstraints();
        return list != null && list.size() != 0;
    }

    public List getIssues() {
        return this.issues;
    }

    public void setIssues(List list) {
        this.issues = IVUtil.sortTICollection(list);
    }

    public void deleteIssue(Issue issue) {
        this.issues.remove(issue);
    }

    public void clearIssues() {
        this.issues = new ArrayList();
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String string) {
        this.comments = string;
    }

    public String toString() {
        return "Refinement[" + this.name + " expands " + this.pattern + "]";
    }

    public Domain getDomain() {
        return this.uiDomain.getDomain();
    }

    public UIDomain getUIDomain() {
        return this.uiDomain;
    }

    public void moveToUIDomain(UIDomain uIDomain) {
        if (this.uiDomain == null) {
            this.uiDomain = uIDomain;
        } else {
            this.uiDomain = uIDomain;
            uIDomain.addedObject(this, this.getBaseObject());
        }
    }

    public Object getBaseReference() {
        return this.baseReference;
    }

    public void setBaseReference(Object object) {
        this.baseReference = (String)object;
    }

    public IXObject getBaseObject() {
        return this.baseObject;
    }

    public IXObject makeBaseObject() {
        return new Refinement();
    }

    public void setBaseObject(IXObject iXObject) {
        this.baseObject = (Refinement)iXObject;
    }

    public Class getBaseClass() {
        return class$ix$icore$domain$Refinement == null ? (class$ix$icore$domain$Refinement = UIRefinement.class$("ix.icore.domain.Refinement")) : class$ix$icore$domain$Refinement;
    }

    public boolean hasOriginal() {
        return this.getBaseReference() != null && !this.getBaseReference().equals("");
    }

    public void saveToDomain() {
        if (this.baseObject == null) {
            this.baseObject = (Refinement)this.makeBaseObject();
        }
        this.saveToDomain(this.baseObject);
    }

    public void saveToDomain(Object object) {
        Refinement refinement = (Refinement)object;
        refinement.setName(this.name);
        refinement.setPattern(this.pattern);
        this.writeNodes(refinement);
        refinement.setOrderings(this.orderings);
        refinement.setConstraints(this.constraints);
        refinement.setIssues(this.issues);
        refinement.setComments(this.comments);
        refinement.setVariableDeclarations(this.variableDeclarations);
    }

    public void loadFromDomain() {
        if (this.baseObject == null) {
            this.baseObject = new Refinement();
        }
        this.name = this.baseObject.getName();
        this.pattern = this.baseObject.getPattern() == null ? Lisp.NIL : this.baseObject.getPattern();
        this.makeNodes(this.baseObject.getNodes());
        this.orderings = this.baseObject.getOrderings() == null ? new ArrayList() : new ArrayList(this.baseObject.getOrderings());
        this.constraints = this.baseObject.getConstraints() == null ? new ArrayList() : new ArrayList(this.baseObject.getConstraints());
        if (this.baseObject.getIssues() == null) {
            this.issues = new ArrayList();
        } else {
            this.setIssues(this.baseObject.getIssues());
        }
        this.comments = this.baseObject.getComments();
        this.variableDeclarations = this.baseObject.getVariableDeclarations();
    }

    public void loadFromDomain(Object object) {
        this.baseObject = (Refinement)object;
        this.loadFromDomain();
    }

    public void loadFromOriginal() {
        if (this.hasOriginal()) {
            Object object = this.getBaseReference();
            Refinement refinement = this.getDomain().getNamedRefinement((String)object);
            try {
                this.setBaseObject((Refinement)refinement.clone());
                this.loadFromDomain();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                Debug.noteException(cloneNotSupportedException);
            }
        } else {
            this.setBaseObject(this.makeBaseObject());
            this.loadFromDomain();
        }
    }

    private void makeNodes(List list) {
        this.nodes = new ArrayList();
        if (list == null) {
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.nodes.add(new UINodeSpec(this.uiDomain, (NodeSpec)iterator.next()));
        }
    }

    private void writeNodes(Refinement refinement) {
        if (this.nodes == null) {
            refinement.setNodes(null);
        } else {
            LListCollector lListCollector = new LListCollector();
            Iterator iterator = this.nodes.iterator();
            while (iterator.hasNext()) {
                NodeSpec nodeSpec = (NodeSpec)iterator.next();
                lListCollector.add(new NodeSpec(nodeSpec.getId(), nodeSpec.getPattern()));
            }
            refinement.setNodes(lListCollector);
        }
    }

    private boolean sameNodes(List list, List list2) {
        Object object;
        if (list == null) {
            return list2 == null || list2.size() == 0;
        }
        if (list2 == null) {
            return list == null || list.size() == 0;
        }
        if (list.size() != list2.size()) {
            return false;
        }
        Hashtable<Name, LList> hashtable = new Hashtable<Name, LList>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object = (NodeSpec)iterator.next();
            hashtable.put(((NodeSpec)object).getId(), ((NodeSpec)object).getPattern());
        }
        object = list2.iterator();
        while (object.hasNext()) {
            NodeSpec nodeSpec = (NodeSpec)object.next();
            LList lList = (LList)hashtable.get(nodeSpec.getId());
            LList lList2 = nodeSpec.getPattern();
            if (!(lList2 == null ? lList != null : !lList2.equal(lList))) continue;
            return false;
        }
        return true;
    }

    private boolean sameIssues(List list, List list2) {
        Object object;
        if (this.bothEmpty(list, list2)) {
            return true;
        }
        if (list == null || list2 == null) {
            return false;
        }
        if (list.size() != list2.size()) {
            return false;
        }
        HashSet<LList> hashSet = new HashSet<LList>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object = (Issue)iterator.next();
            hashSet.add(((TaskItem)object).getPattern());
        }
        object = list2.iterator();
        while (object.hasNext()) {
            Issue issue = (Issue)object.next();
            if (hashSet.contains(issue.getPattern())) continue;
            return false;
        }
        return true;
    }

    private boolean sameList(List list, List list2) {
        if (this.bothEmpty(list, list2)) {
            return true;
        }
        return list != null && list.equals(list2);
    }

    private boolean sameSet(Collection collection, Collection collection2) {
        if (this.bothEmpty(collection, collection2)) {
            return true;
        }
        if (collection == null || collection2 == null) {
            return false;
        }
        HashSet hashSet = new HashSet(collection);
        HashSet hashSet2 = new HashSet(collection2);
        return hashSet != null && hashSet.equals(hashSet2);
    }

    private boolean sameString(String string, String string2) {
        if ((string == null || string.equals("")) && (string2 == null || string2.equals(""))) {
            return true;
        }
        return string.equals(string2);
    }

    private boolean bothEmpty(Collection collection, Collection collection2) {
        return !(collection2 != null && collection2.size() != 0 || collection != null && collection.size() != 0);
    }

    public void addToDomain() {
        this.addToDomain(this.getDomain());
    }

    public void addToDomain(Domain domain) {
        if (this.baseObject == null) {
            this.baseObject = (Refinement)this.makeBaseObject();
        }
        this.saveToDomain();
        String string = this.baseObject.getName();
        Refinement refinement = domain.getNamedRefinement(string);
        if (refinement != null) {
            if (this.baseObject.equals(refinement)) {
                return;
            }
            Debug.noteln("UIR: Trying to add refinement that is already there");
            this.saveToDomain(refinement);
            return;
        }
        domain.addRefinement(this.baseObject);
    }

    public void updateInDomain() {
        this.updateInDomain(this.getDomain());
    }

    public void updateInDomain(Domain domain) {
        String string = (String)this.getBaseReference();
        Refinement refinement = this.getReferredObject(domain, string, this.name);
        if (refinement == null) {
            Debug.noteln("Update refinement: cannot find base object called", string);
            return;
        }
        Debug.noteln("UIR: Update refinement base is ", string);
        this.saveToDomain();
        domain.replaceNamedRefinement(string, this.baseObject);
    }

    public void removeFromDomain() {
        this.removeFromDomain(this.getDomain());
    }

    public void removeFromDomain(Domain domain) {
        String string = (String)this.getBaseReference();
        Refinement refinement = this.getReferredObject(domain, string, this.name);
        if (refinement == null) {
            Debug.noteln("Remove refinement: Cannot find a base object called ", string);
            return;
        }
        domain.deleteNamedRefinement(string);
    }

    private Refinement getReferredObject(Domain domain, String string, String string2) {
        String string3 = string == null || string.equals("") ? string2 : string;
        return domain.getNamedRefinement(string3);
    }

    public void noteChange() {
        if (this.isEmpty() && !this.hasOriginal()) {
            this.uiDomain.removeConstruct(this);
        } else if (this.hasChanged()) {
            this.saveToDomain();
            this.uiDomain.updateConstruct(this);
        }
    }

    public boolean isEmpty() {
        return !(this.name != null && !this.name.equals("") || this.pattern != null && !this.pattern.isEmpty() || this.nodes != null && !this.nodes.isEmpty() || this.orderings != null && !this.orderings.isEmpty() || this.issues != null && !this.issues.isEmpty() || this.comments != null && !this.comments.equals(""));
    }

    public boolean isEmpty(Refinement refinement) {
        if (refinement == null) {
            return true;
        }
        return !(refinement.getName() != null && !refinement.getName().equals("") || refinement.getPattern() != null && !refinement.getPattern().isEmpty() || refinement.getNodes() != null && !refinement.getNodes().isEmpty() || refinement.getOrderings() != null && !refinement.getOrderings().isEmpty() || refinement.getIssues() != null && !refinement.getIssues().isEmpty() || refinement.getComments() != null && !refinement.getComments().equals(""));
    }

    public boolean hasChanged() {
        return this.hasChangedNoDebug((Refinement)this.getBaseObject());
    }

    public boolean hasChangedNoDebug(Refinement refinement) {
        if (!(!this.isEmpty(refinement) || this.name == null || !this.name.equals("Undefined") && !this.name.equals("undefined") || this.nodes != null && !this.nodes.isEmpty() || this.orderings != null && !this.orderings.isEmpty() || this.constraints != null && !this.constraints.isEmpty() || this.issues != null && !this.issues.isEmpty() || this.comments != null && !this.comments.equals(""))) {
            return false;
        }
        if (refinement == null) {
            return !this.isEmpty();
        }
        return this.nameHasChanged(refinement.getName()) || !this.sameList(this.pattern, refinement.getPattern()) || !this.sameNodes(this.nodes, refinement.getNodes()) || !this.sameSet(this.orderings, refinement.getOrderings()) || !this.sameList(this.constraints, refinement.getConstraints()) || !this.sameIssues(this.issues, refinement.getIssues()) || !this.sameString(this.comments, refinement.getComments());
    }

    public boolean hasChanged(Refinement refinement) {
        Debug.noteln("UIR: Checking hasChanged for ", this.print());
        Debug.noteln(" against", refinement.toString());
        if (!(!this.isEmpty(refinement) || this.name == null || !this.name.equals("Undefined") && !this.name.equals("undefined") || this.nodes != null && !this.nodes.isEmpty() || this.orderings != null && !this.orderings.isEmpty() || this.constraints != null && !this.constraints.isEmpty() || this.issues != null && !this.issues.isEmpty() || this.comments != null && !this.comments.equals(""))) {
            Debug.noteln("Empty sub-node editing");
            return false;
        }
        if (refinement == null) {
            return !this.isEmpty();
        }
        if (!this.nameHasChanged(refinement.getName())) {
            if (this.sameList(this.pattern, refinement.getPattern())) {
                if (this.sameNodes(this.nodes, refinement.getNodes())) {
                    if (this.sameSet(this.orderings, refinement.getOrderings())) {
                        if (this.sameList(this.constraints, refinement.getConstraints())) {
                            if (this.sameIssues(this.issues, refinement.getIssues())) {
                                if (this.sameString(this.comments, refinement.getComments())) {
                                    return false;
                                }
                                Debug.noteln("UIR hasChanged comments");
                            } else {
                                Debug.noteln("UIR hasChanged issues");
                            }
                        } else {
                            Debug.noteln("UIR hasChanged constraints");
                        }
                    } else {
                        Debug.noteln("UIR hasChanged orderings");
                    }
                } else {
                    Debug.noteln("UIR hasChanged nodes");
                }
            } else {
                Debug.noteln("UIR hasChanged pattern");
            }
        } else {
            Debug.noteln("UIR hasChanged name from", refinement.getName());
        }
        return true;
    }

    public boolean hasChangedFromOriginal() {
        if (!this.hasOriginal()) {
            return true;
        }
        Refinement refinement = this.getDomain().getNamedRefinement(this.baseReference);
        return this.hasChangedNoDebug(refinement);
    }

    public boolean nameHasChanged(Object object) {
        String string = (String)object;
        return (this.name != null && !this.name.equals("") || string != null && !string.equals("")) && (this.name == null || !this.name.equals(string));
    }

    public static List parseNodes(UIDomain uIDomain, String string) {
        ArrayList<UINodeSpec> arrayList = new ArrayList<UINodeSpec>();
        long l = 1L;
        while (!string.equals("")) {
            String[] stringArray = UIUtil.breakStringAtFirst(string, "\n");
            Long l2 = new Long(l);
            LList lList = Lisp.elementsFromString(stringArray[0]);
            if (!lList.isNull()) {
                arrayList.add(new UINodeSpec(uIDomain, l2, lList));
                ++l;
            }
            string = stringArray[1];
        }
        return arrayList;
    }

    public static List parseIssues(UIDomain uIDomain, String string) {
        ArrayList<Issue> arrayList = new ArrayList<Issue>();
        long l = 1L;
        while (!string.equals("")) {
            String[] stringArray = UIUtil.breakStringAtFirst(string, "\n");
            LList lList = Lisp.elementsFromString(stringArray[0]);
            if (!lList.isNull()) {
                Issue issue = new Issue(lList);
                arrayList.add(issue);
            }
            string = stringArray[1];
        }
        return arrayList;
    }

    public void deleteNode(NodeSpec nodeSpec) {
        this.deleteNodeConstraints(nodeSpec);
        this.nodes.remove(nodeSpec);
    }

    protected void deleteNodeConstraints(NodeSpec nodeSpec) {
        Name name = nodeSpec.getId();
        ArrayList<Ordering> arrayList = new ArrayList<Ordering>();
        Iterator iterator = this.orderings.iterator();
        while (iterator.hasNext()) {
            Ordering ordering = (Ordering)iterator.next();
            if (UIRefinement.constraintMentionsNode(ordering, name)) continue;
            arrayList.add(ordering);
        }
        this.setOrderings(arrayList);
    }

    public boolean matchesPattern(LList lList) {
        if (lList == null && this.getPattern() == null || lList.equal(this.getPattern()) || lList.equals(this.getPattern())) {
            return true;
        }
        return null != SimpleMatcher.match(lList, this.getPattern());
    }

    public NodeSpec findNode(Name name) {
        Iterator iterator = this.nodes.iterator();
        while (iterator.hasNext()) {
            NodeSpec nodeSpec = (NodeSpec)iterator.next();
            if (!name.equals(nodeSpec.getId())) continue;
            return nodeSpec;
        }
        return null;
    }

    public static boolean constraintMentionsNode(Constraint constraint, Name name) {
        Debug.noteln("*****UIRef: cannot see whether constraint mentions node");
        return false;
    }

    public static boolean constraintMentionsNode(Ordering ordering, Name name) {
        NodeEndRef nodeEndRef = ordering.getFrom();
        if (nodeEndRef != null && name.equals(nodeEndRef.getNode())) {
            return true;
        }
        nodeEndRef = ordering.getTo();
        return nodeEndRef != null && name.equals(nodeEndRef.getNode());
    }

    public Name getNewNodeId() {
        Name name = this.getHighestNodeId();
        Integer n = new Integer(name.toString());
        int n2 = n;
        return Name.valueOf("" + ++n2);
    }

    public Name getHighestNodeId() {
        return UIRefinement.getHighestNodeId(this.getNodes());
    }

    public static Name getHighestNodeId(List list) {
        Integer n = new Integer(0);
        Name name = Name.valueOf(n.toString());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Name name2 = ((NodeSpec)iterator.next()).getId();
            Integer n2 = new Integer(name2.toString());
            int n3 = n.compareTo(n2);
            if (n3 > 0) continue;
            name = name2;
            n = n2;
        }
        return name;
    }

    public void addNode(NodeSpec nodeSpec) {
        this.nodes.add(nodeSpec);
        this.setNodes(this.nodes);
    }

    public void addIssue(Issue issue) {
        this.issues.add(issue);
        this.setIssues(this.issues);
    }

    public void addConstraint(Object object) throws ConstraintTypeException {
        Object var2_2 = null;
        if (object instanceof Constraint) {
            this.getConstraints().add((Constraint)object);
            this.setConstraints(this.getConstraints());
        } else if (object instanceof Ordering) {
            this.addOrdering((Constraint)object);
        } else {
            String string = "Cannot recognise this as a constraint: \n" + object.toString();
            throw new ConstraintTypeException(string);
        }
    }

    public void addOrdering(Constraint constraint) {
        this.orderings.add(constraint);
    }

    public void addOrdering(Ordering ordering) {
        this.orderings.add(ordering);
    }

    public String getOrderingType() {
        if (this.nodes == null || this.nodes.size() < 2) {
            return "none";
        }
        if (this.orderings == null || this.orderings.isEmpty()) {
            return "parallel";
        }
        if (this.orderingsAreSequential()) {
            return "sequential";
        }
        return "other";
    }

    public boolean orderingsAreSequential() {
        HashSet hashSet = new HashSet(this.makeSequence());
        return new HashSet(this.orderings).equals(hashSet);
    }

    public List makeSequence() {
        List list = this.getNodes();
        Iterator iterator = list.iterator();
        NodeSpec nodeSpec = null;
        NodeSpec nodeSpec2 = null;
        ArrayList<Ordering> arrayList = new ArrayList<Ordering>();
        while (iterator.hasNext()) {
            nodeSpec2 = (NodeSpec)iterator.next();
            if (nodeSpec != null) {
                Ordering ordering = new Ordering(new NodeEndRef(End.END, nodeSpec.getId()), new NodeEndRef(End.BEGIN, nodeSpec2.getId()));
                arrayList.add(ordering);
            }
            nodeSpec = nodeSpec2;
        }
        return arrayList;
    }

    public static boolean isRef(NodeSpec nodeSpec, Object object) {
        if (nodeSpec.equals(object) || nodeSpec.getId().toString().equals(object.toString()) || nodeSpec.getPattern().toString().equals(object.toString())) {
            return true;
        }
        if (object instanceof NodeSpec && nodeSpec.getId().equals(((NodeSpec)object).getId()) && nodeSpec.getPattern().equals(((NodeSpec)object).getPattern())) {
            return true;
        }
        return object instanceof NodeEndRef && UIRefinement.isRef(nodeSpec, ((NodeEndRef)object).getNode());
    }

    public String print() {
        String string = this.name + " " + this.pattern.toString();
        String string2 = IVUtil.printNodes(this.nodes);
        String string3 = IVUtil.printOrderings(this.orderings);
        return "Refinement: " + string + "\n" + "  Nodes: " + string2 + "\n" + "  Orderings: " + string3;
    }

    public void setGraph(IGraph iGraph) {
        this.graph = iGraph;
    }

    public IGraph getGraph() {
        return this.graph;
    }

    public void removeGraph(IGraph iGraph) {
        this.graph = null;
    }

    public Enumeration children() {
        return new Enumeration(){
            int i;
            {
                this.i = UIRefinement.this.nodes.size() - 1;
            }

            public boolean hasMoreElements() {
                return this.i >= 0;
            }

            public Object nextElement() {
                return UIRefinement.this.nodes.get(this.i--);
            }
        };
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public TreeNode getChildAt(int n) {
        return null;
    }

    public int getChildCount() {
        return this.getNodes().size();
    }

    public int getIndex(TreeNode treeNode) {
        return -1;
    }

    public TreeNode getParent() {
        return null;
    }

    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class ConstraintTypeException
    extends Exception {
        public ConstraintTypeException() {
        }

        public ConstraintTypeException(String string) {
            super(string);
        }
    }

    public class NodeTypeException
    extends Exception {
        public NodeTypeException() {
        }

        public NodeTypeException(String string) {
            super(string);
        }
    }
}

