/*
 * Decompiled with CFR 0.152.
 */
package ix.iview.domain;

import ix.icore.Annotations;
import ix.icore.IXObject;
import ix.icore.domain.Domain;
import ix.icore.domain.Named;
import ix.icore.domain.Refinement;
import ix.icore.domain.event.DomainListener;
import ix.icore.domain.event.RefinementEvent;
import ix.iface.domain.DomainParser;
import ix.iface.domain.DomainWriter;
import ix.iface.ui.util.UIUtil;
import ix.iview.DomainEditor;
import ix.iview.domain.UIObject;
import ix.iview.domain.UIRefinement;
import ix.iview.domain.event.UIDomainEvent;
import ix.iview.domain.event.UIDomainListener;
import ix.util.Debug;
import ix.util.lisp.LList;
import ix.util.lisp.LListCollector;
import ix.util.match.SimpleMatcher;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JOptionPane;

public class UIDomain
implements UIObject,
Named,
DomainListener {
    private Domain currentDomain;
    private Domain draftDomain;
    private File domainFile;
    public boolean loading = false;
    private boolean overwrite = false;
    private Domain saving = null;
    public String name = "Unnamed UI Domain";
    protected String baseReference = "";
    public Annotations annotations;
    public HashMap graphs = new HashMap();
    private HashSet added = new HashSet();
    private HashSet edited = new HashSet();
    private HashSet removed = new HashSet();
    private HashMap touched = new HashMap();
    private HashMap classes = new HashMap();
    private HashSet listeners = new HashSet();
    private DomainEditor editor;
    static /* synthetic */ Class class$ix$icore$domain$Refinement;
    static /* synthetic */ Class class$ix$iview$domain$UIRefinement;
    static /* synthetic */ Class class$ix$icore$domain$Domain;
    static /* synthetic */ Class class$ix$iview$domain$UIDomain;
    static /* synthetic */ Class class$ix$icore$IXObject;
    static /* synthetic */ Class class$ix$iview$domain$UIObject;

    public UIDomain(Domain domain, DomainEditor domainEditor) {
        this.editor = domainEditor;
        this.currentDomain = domain;
        this.draftDomain = this.cloneDomain(domain);
        this.loadFromDomain();
        this.classes.put(class$ix$icore$domain$Refinement == null ? (class$ix$icore$domain$Refinement = UIDomain.class$("ix.icore.domain.Refinement")) : class$ix$icore$domain$Refinement, class$ix$iview$domain$UIRefinement == null ? (class$ix$iview$domain$UIRefinement = UIDomain.class$("ix.iview.domain.UIRefinement")) : class$ix$iview$domain$UIRefinement);
        this.classes.put(class$ix$icore$domain$Domain == null ? (class$ix$icore$domain$Domain = UIDomain.class$("ix.icore.domain.Domain")) : class$ix$icore$domain$Domain, class$ix$iview$domain$UIDomain == null ? (class$ix$iview$domain$UIDomain = UIDomain.class$("ix.iview.domain.UIDomain")) : class$ix$iview$domain$UIDomain);
        this.touched.put(domain, this);
        this.setBaseReference(domain.getName());
        this.currentDomain.addDomainListener(this);
    }

    public UIDomain(DomainEditor domainEditor) {
        this(new Domain(), domainEditor);
    }

    public UIDomain(String string, DomainEditor domainEditor) {
        this(new Domain(), domainEditor);
        this.name = string;
    }

    public void addConstruct(UIObject uIObject) {
        if (!uIObject.isEmpty()) {
            if ((class$ix$iview$domain$UIRefinement == null ? (class$ix$iview$domain$UIRefinement = UIDomain.class$("ix.iview.domain.UIRefinement")) : class$ix$iview$domain$UIRefinement).isInstance(uIObject)) {
                boolean bl = this.handleOverwrite(uIObject);
                if (bl) {
                    this.addConstruct(uIObject);
                    return;
                }
                this.fireUIConstructEdited(uIObject);
            }
            if (this.added.add(uIObject)) {
                this.fireUIConstructAdded(uIObject);
            }
        }
    }

    private boolean handleOverwrite(UIObject uIObject) {
        Object object = this.getNamedRefinement(uIObject.getName());
        if (object != null && !object.equals(uIObject) && !this.removed.contains(object)) {
            String[] stringArray;
            int n = 0;
            if (this.loading) {
                if (!this.overwrite) {
                    stringArray = new String[]{"There already is a refinement called " + uIObject.getName() + ". Do you want to ", "Replace the existing refinement? (Yes)", "Change the name of the new refinement? (No)", "Replace ALL duplicate refinements during this open/insert? (Cancel)"};
                    Object[] objectArray = new Object[]{"Replace", "Change Name", "Replace All"};
                    n = JOptionPane.showConfirmDialog(null, stringArray, "WARNING: Name clash", 1);
                }
            } else {
                stringArray = new String[]{"There already is a refinement called " + uIObject.getName() + ". Do you want to ", "Replace the existing refinement? (Yes)", "Change the name of the new refinement? (No)"};
                n = JOptionPane.showConfirmDialog(null, stringArray, "WARNING: Name clash", 0);
            }
            if (n == 2) {
                this.overwrite = true;
                n = 0;
            }
            if (n == 0) {
                if ((class$ix$icore$IXObject == null ? (class$ix$icore$IXObject = UIDomain.class$("ix.icore.IXObject")) : class$ix$icore$IXObject).isInstance(object)) {
                    this.removeConstruct((IXObject)object);
                } else {
                    this.removeConstruct((UIObject)object);
                }
                return true;
            }
            stringArray = JOptionPane.showInputDialog("Please enter the new name");
            uIObject.setName((String)stringArray);
            return true;
        }
        return false;
    }

    public void updateConstruct(UIObject uIObject) {
        boolean bl;
        if (this.equals(uIObject)) {
            this.saveToDomain();
        }
        if (!uIObject.isEmpty() && (class$ix$iview$domain$UIRefinement == null ? (class$ix$iview$domain$UIRefinement = UIDomain.class$("ix.iview.domain.UIRefinement")) : class$ix$iview$domain$UIRefinement).isInstance(uIObject) && (bl = this.handleOverwrite(uIObject))) {
            this.updateConstruct(uIObject);
            return;
        }
        if (uIObject.hasOriginal()) {
            if (!this.added.contains(uIObject)) {
                this.edited.add(uIObject);
            }
            Debug.noteln("UID: Edited construct", uIObject.getName());
            if (!uIObject.hasChangedFromOriginal()) {
                this.edited.remove(uIObject);
            }
            this.fireUIConstructEdited(uIObject);
        } else {
            this.addConstruct(uIObject);
        }
    }

    public void removeConstruct(UIObject uIObject) {
        if (this.added.contains(uIObject)) {
            this.added.remove(uIObject);
        } else {
            if (!uIObject.hasOriginal() && uIObject.isEmpty()) {
                return;
            }
            this.edited.remove(uIObject);
            this.removed.add(uIObject);
        }
        this.fireUIConstructRemoved(uIObject);
    }

    public void removeConstruct(IXObject iXObject) {
        UIObject uIObject = this.findUIObject(iXObject);
        if (uIObject == null) {
            this.removed.add(iXObject);
        } else {
            this.removeConstruct(uIObject);
        }
    }

    public boolean hasChanged(Domain domain) {
        if (!(this.name != "" && this.name != null || this.annotations != null || domain != null && !domain.isEmpty())) {
            return false;
        }
        if (domain == null) {
            Debug.noteln("UID has changed: was empty, not now");
            return true;
        }
        if (!this.nameHasChanged(domain.getName())) {
            if (this.annotations == null && domain.getAnnotations() == null || this.annotations.equals(domain.getAnnotations())) {
                return false;
            }
            Debug.noteln("UID has changed annotations");
            return true;
        }
        Debug.note("UID has changed name from " + domain.getName());
        Debug.noteln(" to", this.name + ".");
        return true;
    }

    public boolean hasChanged() {
        return this.hasChanged(this.draftDomain);
    }

    public boolean hasChangedFromOriginal() {
        return this.hasChanged(this.currentDomain);
    }

    public boolean nameHasChanged(Object object) {
        String string = (String)object;
        return (this.name != null && !this.name.equals("") || string != null && !string.equals("")) && (this.name == null || !this.name.equals(string));
    }

    public boolean hasChangedAll(Domain domain) {
        if (this.hasChanged(domain)) {
            return true;
        }
        return this.hasChangedConstructs(domain);
    }

    public boolean hasChangedConstructs(Domain domain) {
        return !this.added.isEmpty() || !this.removed.isEmpty() || !this.edited.isEmpty();
    }

    public boolean hasChangedAll() {
        return this.hasChangedAll(this.draftDomain);
    }

    public boolean hasChangedAllFromOriginal() {
        return this.hasChangedAll(this.currentDomain);
    }

    public boolean hasChangedConstructsFromOriginal() {
        return this.hasChangedConstructs(this.currentDomain);
    }

    private void setSaving(Domain domain) {
        this.saving = domain;
    }

    private void unsetSaving() {
        this.saving = null;
    }

    private boolean isSaving(Domain domain) {
        return domain.equals(this.saving);
    }

    public void refinementAdded(RefinementEvent refinementEvent) {
        Domain domain = (Domain)refinementEvent.getSource();
        if (!this.isSaving(domain)) {
            this.fireConstructAdded(refinementEvent);
        }
    }

    public List getAllRefinements() {
        LListCollector lListCollector;
        if (this.currentDomain == null) {
            lListCollector = new LListCollector(this.added);
        } else {
            HashSet<Named> hashSet = new HashSet<Named>(this.added);
            HashSet hashSet2 = new HashSet(this.currentDomain.getRefinements());
            Iterator iterator = hashSet2.iterator();
            while (iterator.hasNext()) {
                Refinement refinement = (Refinement)iterator.next();
                UIObject uIObject = this.findUIObject(refinement);
                if (uIObject != null) {
                    if (this.removed.contains(uIObject)) continue;
                    hashSet.add(uIObject);
                    continue;
                }
                if (this.removed.contains(refinement)) continue;
                hashSet.add(refinement);
            }
            lListCollector = new LListCollector(hashSet);
        }
        return lListCollector;
    }

    public List getAllConstructs() {
        return this.getAllRefinements();
    }

    public UIObject newUIObject(IXObject iXObject) {
        if (iXObject == null) {
            return null;
        }
        UIObject uIObject = null;
        if (iXObject instanceof Refinement) {
            uIObject = new UIRefinement(this, (Refinement)iXObject);
        } else if (iXObject instanceof Domain) {
            uIObject = new UIDomain((Domain)iXObject, this.editor);
        } else {
            return null;
        }
        this.addedObject(uIObject, iXObject);
        return uIObject;
    }

    public Object getNamedRefinement(String string) {
        Named named = this.findUIObject(string);
        if (named == null) {
            named = this.currentDomain.getNamedRefinement(string);
        }
        return named;
    }

    public UIObject getUIObject(IXObject iXObject) {
        UIObject uIObject = this.findUIObject(iXObject);
        if (uIObject == null) {
            return this.newUIObject(iXObject);
        }
        return uIObject;
    }

    public UIObject findUIObject(IXObject iXObject) {
        Object v = this.touched.get(iXObject);
        if (v != null) {
            // empty if block
        }
        return (UIObject)v;
    }

    public UIObject findUIObject(String string) {
        UIObject uIObject = UIDomain.findUIObject(string, this.added);
        if (uIObject == null) {
            uIObject = UIDomain.findUIObject(string, this.touched.values());
        }
        return uIObject;
    }

    private static UIObject findUIObject(String string, Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            try {
                Named named = (Named)iterator.next();
                if (!named.getName().equals(string)) continue;
                return (UIObject)named;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public void addedObject(UIObject uIObject, IXObject iXObject) {
        if (iXObject == null) {
            this.addConstruct(uIObject);
        } else {
            this.touched.put(iXObject, uIObject);
        }
    }

    public Set getMatchingRefinements(LList lList) {
        List list = this.currentDomain.getRefinements();
        HashSet hashSet = this.getMatchingUIRefinements(lList, list);
        return hashSet;
    }

    public HashSet getMatchingUIRefinements(LList lList, List list) {
        UIObject uIObject;
        Object object;
        HashSet<Object> hashSet = new HashSet<Object>(list);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object = (Refinement)iterator.next();
            uIObject = this.findUIObject((IXObject)object);
            if (uIObject != null) {
                hashSet.remove(object);
                continue;
            }
            if (!this.isMatchingRefinement(lList, (Refinement)object)) continue;
            hashSet.add(object);
        }
        object = this.touched.values().iterator();
        while (object.hasNext()) {
            uIObject = (UIRefinement)object.next();
            if (!this.isMatchingRefinement(lList, (UIRefinement)uIObject)) continue;
            hashSet.add(uIObject);
        }
        return hashSet;
    }

    protected boolean isMatchingRefinement(LList lList, UIRefinement uIRefinement) {
        if (this.removed.contains(uIRefinement)) {
            return false;
        }
        if (this.edited.contains(uIRefinement) || this.added.contains(uIRefinement)) {
            return uIRefinement.matchesPattern(lList);
        }
        return false;
    }

    protected boolean isMatchingRefinement(LList lList, Refinement refinement) {
        if (lList == null && refinement.getPattern() == null || lList.equal(refinement.getPattern()) || lList.equals(refinement.getPattern())) {
            return true;
        }
        return null != SimpleMatcher.match(lList, refinement.getPattern());
    }

    public void saveToDomain() {
        if (this.currentDomain == null) {
            this.currentDomain = (Domain)this.makeBaseObject();
        }
        if (this.draftDomain == null) {
            this.draftDomain = this.cloneDomain(this.currentDomain);
        }
        this.saveToDomain(this.draftDomain);
    }

    public void fullSaveToDomain() {
        if (this.currentDomain == null) {
            this.currentDomain = (Domain)this.makeBaseObject();
        }
        if (this.draftDomain == null) {
            this.draftDomain = this.cloneDomain(this.currentDomain);
        }
        this.fullSaveToDomain(this.draftDomain);
    }

    public void saveToDomain(Object object) {
        Domain domain = (Domain)object;
        domain.setName(this.name);
        domain.setAnnotations(this.annotations);
    }

    public void fullSaveToDomain(Object object) {
        Object object2;
        Object object3;
        Domain domain = (Domain)object;
        this.setSaving(domain);
        if (domain != this.currentDomain) {
            domain.clear();
            this.copyDomain(this.currentDomain, domain);
        }
        domain.setName(this.name);
        Debug.noteln("UID-Added:", UIUtil.listToDisplay(this.added));
        Debug.noteln("UID-Edited:", UIUtil.listToDisplay(this.edited));
        Debug.noteln("UID-Removed:", UIUtil.listToDisplay(this.removed));
        Debug.noteln("UID: base domain is", this.currentDomain);
        Debug.noteln("UID: saving to domain", domain);
        Iterator iterator = this.added.iterator();
        while (iterator.hasNext()) {
            if (!(class$ix$iview$domain$UIObject == null ? UIDomain.class$("ix.iview.domain.UIObject") : class$ix$iview$domain$UIObject).isInstance(object3 = iterator.next()) || ((UIObject)object3).isEmpty()) continue;
            ((UIObject)object3).addToDomain(domain);
        }
        object3 = this.edited.iterator();
        while (object3.hasNext()) {
            if (!(class$ix$iview$domain$UIObject == null ? UIDomain.class$("ix.iview.domain.UIObject") : class$ix$iview$domain$UIObject).isInstance(object2 = object3.next())) continue;
            ((UIObject)object2).updateInDomain(domain);
        }
        object2 = this.removed.iterator();
        while (object2.hasNext()) {
            Object e;
            if ((class$ix$iview$domain$UIObject == null ? UIDomain.class$("ix.iview.domain.UIObject") : class$ix$iview$domain$UIObject).isInstance(e = object2.next())) {
                ((UIObject)e).removeFromDomain(domain);
                continue;
            }
            this.removeFromDomain(domain, e);
        }
        this.unsetSaving();
    }

    public void publishToDomain() {
        if (this.currentDomain == null) {
            this.currentDomain = new Domain();
        }
        this.fullSaveToDomain(this.currentDomain);
        this.added.clear();
        this.edited.clear();
        this.removed.clear();
        this.draftDomain = this.cloneDomain(this.currentDomain);
    }

    public void loadFromDomain() {
        this.loadFromDomain(this.draftDomain);
    }

    public void loadFromDomain(Object object) {
        this.name = ((Domain)object).getName();
        this.annotations = ((Domain)object).getAnnotations();
        this.fireDomainEdited();
    }

    public void loadFromOriginal() {
        this.loadFromDomain(this.currentDomain);
    }

    public void revertToOriginal() {
        this.added.clear();
        this.edited.clear();
        this.removed.clear();
        this.touched.clear();
        this.graphs.clear();
        this.draftDomain = this.cloneDomain(this.currentDomain);
        this.touched.put(this.currentDomain, this);
        this.loadFromDomain(this.currentDomain);
        this.fireDomainEdited();
    }

    public void removeFromDomain(Domain domain, Object object) {
        if ((class$ix$icore$domain$Refinement == null ? (class$ix$icore$domain$Refinement = UIDomain.class$("ix.icore.domain.Refinement")) : class$ix$icore$domain$Refinement).isInstance(object)) {
            domain.deleteRefinement((Refinement)object);
        }
    }

    public void addUIDomainListener(UIDomainListener uIDomainListener) {
        this.listeners.add(uIDomainListener);
    }

    public void setUIDomainListeners(HashSet hashSet) {
        this.listeners = hashSet;
    }

    public void removeUIDomainListener(UIDomainListener uIDomainListener) {
        this.listeners.remove(uIDomainListener);
    }

    public void fireConstructAdded(RefinementEvent refinementEvent) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            UIDomainListener uIDomainListener = (UIDomainListener)iterator.next();
            uIDomainListener.constructAdded(refinementEvent);
        }
    }

    public void fireUIConstructAdded(UIObject uIObject) {
        UIDomainEvent uIDomainEvent = new UIDomainEvent(this, uIObject);
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            UIDomainListener uIDomainListener = (UIDomainListener)iterator.next();
            uIDomainListener.constructAdded(uIDomainEvent);
        }
    }

    public void fireUIConstructEdited(UIObject uIObject) {
        UIDomainEvent uIDomainEvent = new UIDomainEvent(this, uIObject);
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            UIDomainListener uIDomainListener = (UIDomainListener)iterator.next();
            uIDomainListener.constructEdited(uIDomainEvent);
        }
    }

    public void fireUIConstructRemoved(UIObject uIObject) {
        UIDomainEvent uIDomainEvent = new UIDomainEvent(this, uIObject);
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            UIDomainListener uIDomainListener = (UIDomainListener)iterator.next();
            uIDomainListener.constructRemoved(uIDomainEvent);
        }
    }

    public void fireDomainEdited() {
        UIDomainEvent uIDomainEvent = new UIDomainEvent(this);
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            UIDomainListener uIDomainListener = (UIDomainListener)iterator.next();
            uIDomainListener.domainEdited(uIDomainEvent);
        }
    }

    public void fireDomainCleared() {
        UIDomainEvent uIDomainEvent = new UIDomainEvent(this);
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            UIDomainListener uIDomainListener = (UIDomainListener)iterator.next();
            uIDomainListener.domainCleared(uIDomainEvent);
        }
    }

    public void fireDomainSet(Domain domain) {
        UIDomainEvent uIDomainEvent = new UIDomainEvent(this);
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            UIDomainListener uIDomainListener = (UIDomainListener)iterator.next();
            uIDomainListener.domainSet(uIDomainEvent);
        }
    }

    public Domain getDomain() {
        return this.currentDomain;
    }

    public UIDomain getUIDomain() {
        return this;
    }

    public UIDomain setDomain(Domain domain) {
        if (this.getDomain().equals(domain)) {
            return this;
        }
        return this.setNewDomain(domain);
    }

    public UIDomain setNewDomain(Domain domain) {
        UIDomain uIDomain = new UIDomain(domain, this.editor);
        uIDomain.setUIDomainListeners(this.listeners);
        this.editor.setDomain(domain);
        this.fireDomainSet(domain);
        return uIDomain;
    }

    public boolean hasOriginal() {
        return this.currentDomain != null;
    }

    public IXObject getBaseObject() {
        return this.currentDomain;
    }

    public IXObject makeBaseObject() {
        return new Domain();
    }

    public void setBaseObject(IXObject iXObject) {
        this.currentDomain = (Domain)iXObject;
    }

    public Object getBaseReference() {
        return this.baseReference;
    }

    public void setBaseReference(Object object) {
        this.baseReference = (String)object;
    }

    public Class getBaseClass() {
        return class$ix$icore$domain$Domain == null ? (class$ix$icore$domain$Domain = UIDomain.class$("ix.icore.domain.Domain")) : class$ix$icore$domain$Domain;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean isEmpty() {
        return this.added.isEmpty() && (this.currentDomain == null || this.currentDomain.isEmpty());
    }

    public void clearThis() {
        this.name = "";
        this.annotations = null;
    }

    public void clear() {
        this.clearThis();
        this.added.clear();
        this.edited.clear();
        this.removed.clear();
        this.touched.clear();
        this.graphs.clear();
        this.draftDomain.clear();
        this.removed.addAll(this.currentDomain.getRefinements());
        this.domainFile = null;
        this.saveToDomain(this.draftDomain);
        this.fireDomainCleared();
    }

    public void clearBase() {
        this.currentDomain.clear();
        this.clear();
        this.saveToDomain(this.currentDomain);
    }

    public void clearDraft() {
        this.clear();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public Annotations getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(Annotations annotations) {
        this.annotations = annotations;
    }

    public void setDomainFile(File file) {
        this.domainFile = file;
    }

    public File getDomainFile(File file) {
        return this.domainFile;
    }

    public File saveDomain() {
        return this.saveDomain(this.domainFile);
    }

    public File saveDomainAs() {
        return this.saveDomain(null);
    }

    public File saveDomain(File file) {
        this.fullSaveToDomain(this.draftDomain);
        Debug.noteln("UID: Saving domain:", this.draftDomain);
        Debug.noteln(" published domain:", this.currentDomain);
        if (file != null) {
            file = DomainWriter.saveDomain(this.editor, this.draftDomain, file);
        }
        if (file == null) {
            file = DomainWriter.saveDomain(this.editor, this.draftDomain);
        }
        if (file != null) {
            this.domainFile = file;
        }
        return file;
    }

    public void analyseDomain() {
    }

    private Domain cloneDomain(Domain domain) {
        try {
            Domain domain2 = (Domain)domain.clone();
            domain2.setRefinements(new ArrayList(domain.getRefinements()));
            return domain2;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Debug.error("Cloning of the domain failed");
            return null;
        }
    }

    private void copyDomain(Domain domain, Domain domain2) {
        domain2.setName(domain.getName());
        domain2.setRefinements(new ArrayList(domain.getRefinements()));
    }

    public String toString() {
        return this.name;
    }

    public String print() {
        List list = this.getAllRefinements();
        return "UIDomain[" + this.name + ", " + list.size() + " refinements]";
    }

    public void insertDomain() {
        this.overwrite = false;
        this.loading = true;
        File file = DomainParser.loadDomain(this.editor, this.draftDomain);
        if (file != null) {
            this.domainFile = file;
            this.loadFromDomain();
            List list = this.draftDomain.getRefinements();
            ArrayList arrayList = new ArrayList();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                IXObject iXObject = (IXObject)iterator.next();
                this.addConstruct(this.getUIObject(iXObject));
            }
        }
        this.loading = false;
        this.overwrite = false;
        this.fireDomainEdited();
    }

    public void loadDomain() {
        this.clear();
        this.draftDomain = new Domain();
        this.insertDomain();
        String string = this.draftDomain.getName();
        if (string != null && string.startsWith("+")) {
            string = string.substring(1);
            this.draftDomain.setName(string);
            this.setName(string);
        }
    }

    public void addGraph(Named named) {
        this.graphs.put(named.getName(), named);
        this.fireGraphAdded(named);
    }

    public void fireGraphAdded(Object object) {
    }

    public LList getAllGraphs() {
        LListCollector lListCollector = new LListCollector(this.graphs.values());
        return lListCollector.contents();
    }

    public Named getNamedGraph(String string) {
        return (Named)this.graphs.get(string);
    }

    public void removeNamedGraph(String string) {
        this.graphs.remove(string);
    }

    public void addToDomain(Domain domain) {
    }

    public void updateInDomain(Domain domain) {
    }

    public void removeFromDomain(Domain domain) {
    }

    public void moveToUIDomain(UIDomain uIDomain) {
    }

    public void noteChange() {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

