/*
 * Decompiled with CFR 0.152.
 */
package ix.iview;

import ix.icore.IXAgent;
import ix.icore.domain.Domain;
import ix.icore.domain.End;
import ix.icore.domain.NodeEndRef;
import ix.icore.domain.NodeSpec;
import ix.icore.domain.Ordering;
import ix.icore.domain.Refinement;
import ix.icore.domain.VariableDeclaration;
import ix.iface.domain.DomainParser;
import ix.iface.domain.DomainWriter;
import ix.iface.util.CatchingActionListener;
import ix.iface.util.IconImage;
import ix.iface.util.RadioButtonBox;
import ix.iface.util.ToolFrame;
import ix.iview.InternalDomainEditor;
import ix.util.Collect;
import ix.util.Debug;
import ix.util.Strings;
import ix.util.Util;
import ix.util.lisp.ItemVar;
import ix.util.lisp.LList;
import ix.util.lisp.LListCollector;
import ix.util.lisp.Lisp;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedSet;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class SimpleDomainEditor
implements InternalDomainEditor,
ActionListener {
    JFrame frame;
    Container contentPane;
    JMenu refinementMenu;
    RefinementEditor refinementEditor;
    File domainLibraryDirectory = DomainParser.getLibraryDirectory();
    IXAgent agent;
    Domain dom;

    public SimpleDomainEditor(IXAgent iXAgent, Domain domain) {
        this.agent = iXAgent;
        this.dom = domain;
        this.setUpFrame();
    }

    protected void setUpFrame() {
        this.frame = new ToolFrame(this.agent.getAgentDisplayName() + " Domain Editor");
        ((Frame)this.frame).setIconImage(IconImage.getIconImage(this));
        ((Component)this.frame).setSize(500, 300);
        this.frame.setJMenuBar(this.makeMenuBar());
        this.contentPane = this.frame.getContentPane();
        this.ensureRefinementEditor();
        this.refinementEditor.editNewRefinement();
        ((Component)this.frame).setVisible(true);
    }

    public void setVisible(boolean bl) {
        ((Component)this.frame).setVisible(bl);
    }

    public void setLocation(int n, int n2) {
        ((Component)this.frame).setLocation(n, n2);
    }

    public void saveExpansion(Refinement refinement) {
        this.ensureRefinementEditor();
        this.refinementEditor.editPartialRefinement(refinement);
    }

    protected void ensureRefinementEditor() {
        if (this.refinementEditor == null) {
            this.refinementEditor = new RefinementEditor();
            this.refinementEditor.setBorder(BorderFactory.createTitledBorder("Refinement"));
            this.contentPane.add(this.refinementEditor);
            this.frame.pack();
        }
    }

    protected JMenuBar makeMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenuBar.add(jMenu);
        jMenu.add(this.makeMenuItem("Load Domain"));
        jMenu.add(this.makeMenuItem("Check Domain"));
        jMenu.getMenuComponent(jMenu.getMenuComponentCount() - 1).setEnabled(false);
        jMenu.add(this.makeMenuItem("Clear Domain"));
        jMenu.add(this.makeMenuItem("Save Domain As ..."));
        jMenu.addSeparator();
        jMenu.add(this.makeMenuItem("Close"));
        JMenu jMenu2 = new JMenu("Edit");
        jMenuBar.add(jMenu2);
        this.refinementMenu = new JMenu("Refinement");
        this.populateRefinementMenu();
        jMenu2.add(this.refinementMenu);
        jMenu2.add(this.makeMenuItem("New Refinement"));
        JMenu jMenu3 = new JMenu("View");
        jMenuBar.add(jMenu3);
        jMenu3.add(this.makeMenuItem("Simple"));
        jMenu3.add(this.makeMenuItem("Advanced"));
        jMenu3.getMenuComponent(jMenu3.getMenuComponentCount() - 1).setEnabled(false);
        return jMenuBar;
    }

    protected JMenuItem makeMenuItem(String string) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.addActionListener(CatchingActionListener.listener(this));
        return jMenuItem;
    }

    protected void populateRefinementMenu() {
        this.refinementMenu.setEnabled(false);
        this.refinementMenu.removeAll();
        List list = this.dom.getRefinements();
        ArrayList arrayList = new ArrayList(list);
        Collections.sort(arrayList, new Comparator(){

            public int compare(Object object, Object object2) {
                Refinement refinement = (Refinement)object;
                Refinement refinement2 = (Refinement)object2;
                return refinement.getName().compareTo(refinement2.getName());
            }
        });
        if (!arrayList.isEmpty()) {
            int n = 20;
            int n2 = arrayList.size();
            int n3 = 0;
            Object object = this.refinementMenu;
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                Object object2;
                if (n3 == n && n2 > 5) {
                    object2 = new JMenu("More");
                    ((JMenu)object).add((JMenuItem)object2);
                    object = object2;
                    n3 = 0;
                }
                object2 = (Refinement)iterator.next();
                JMenuItem jMenuItem = this.makeMenuItem(((Refinement)object2).getName());
                jMenuItem.setActionCommand("Edit Refinement");
                ((JMenu)object).add(jMenuItem);
                --n2;
                ++n3;
            }
            this.refinementMenu.setEnabled(true);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        Debug.noteln("DomainEditor action:", string);
        if (string.equals("Close")) {
            ((Component)this.frame).setVisible(false);
        } else if (string.equals("Load Domain")) {
            DomainParser.loadDomain(this.frame, this.dom);
            this.populateRefinementMenu();
        } else if (string.equals("Save Domain As ...")) {
            DomainWriter.saveDomain(this.frame, this.dom);
        } else if (string.equals("Clear Domain")) {
            this.clearDomain();
        } else if (string.equals("Edit Refinement")) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            String string2 = jMenuItem.getText();
            Debug.noteln("Edit refinement", string2);
            this.ensureRefinementEditor();
            this.refinementEditor.editRefinement(this.dom.getNamedRefinement(string2));
        } else if (string.equals("New Refinement")) {
            this.ensureRefinementEditor();
            this.refinementEditor.editNewRefinement();
        } else {
            Debug.noteln("Nothing to do for", string);
        }
    }

    protected void clearDomain() {
        if (this.dom.isEmpty()) {
            JOptionPane.showMessageDialog(this.frame, "The domain is already empty.", "Empty Domain", 1);
            return;
        }
        switch (JOptionPane.showConfirmDialog(this.frame, "Are you sure you want to clear the domain?", "Confirm", 0)) {
            case 0: {
                break;
            }
            case 1: {
                return;
            }
        }
        this.dom.clear();
        this.populateRefinementMenu();
    }

    public static List parseNodes(String string) {
        LListCollector lListCollector = new LListCollector();
        long l = 1L;
        while (!string.equals("")) {
            String[] stringArray = Strings.breakAtFirst("\n", string);
            Long l2 = new Long(l);
            LList lList = Lisp.elementsFromString(stringArray[0]);
            if (!lList.isNull()) {
                lListCollector.addElement(new NodeSpec(l2, lList));
                ++l;
            }
            string = stringArray[1];
        }
        return lListCollector.contents();
    }

    public static List sequentialOrderings(List list) {
        LinkedList<Ordering> linkedList = new LinkedList<Ordering>();
        if (list == null || list.size() < 2) {
            return linkedList;
        }
        Iterator iterator = list.iterator();
        NodeSpec nodeSpec = (NodeSpec)iterator.next();
        NodeSpec nodeSpec2 = (NodeSpec)iterator.next();
        while (true) {
            linkedList.add(new Ordering(new NodeEndRef(End.END, nodeSpec.getId()), new NodeEndRef(End.BEGIN, nodeSpec2.getId())));
            if (!iterator.hasNext()) {
                return linkedList;
            }
            nodeSpec = nodeSpec2;
            nodeSpec2 = (NodeSpec)iterator.next();
        }
    }

    public static boolean orderingsAreSequential(List list, List list2) {
        List list3 = SimpleDomainEditor.sequentialOrderings(list);
        return list2 == null && list3.isEmpty() || list2.size() == list3.size() && list2.containsAll(list3);
    }

    public static class TemporalConstraintPanel
    extends JPanel {
        RadioButtonBox box = RadioButtonBox.createHorizontalBox();
        JRadioButton ordParallel = new JRadioButton("Parallel", false);
        JRadioButton ordSequential = new JRadioButton("Sequential", true);
        JRadioButton ordOther = new JRadioButton("Other", false);

        public TemporalConstraintPanel() {
            this.setLayout(new BoxLayout(this, 1));
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 0));
            jPanel.setBorder(BorderFactory.createTitledBorder("Temporal"));
            this.ordOther.setEnabled(false);
            this.box.add(new JLabel("Activities are", 2));
            this.box.add(Box.createHorizontalStrut(10));
            this.box.add(this.ordParallel);
            this.box.add(this.ordSequential);
            this.box.add(this.ordOther);
            this.box.add(Box.createHorizontalGlue());
            jPanel.add(this.box);
            this.add(jPanel);
        }

        public String getOrderingChoice() {
            String string = this.box.getSelection();
            Debug.noteln("Ordering choice", string);
            Debug.assert(string != null);
            return string;
        }

        public void newOrderings() {
            this.ordParallel.setEnabled(true);
            this.ordSequential.setEnabled(true);
            this.ordOther.setEnabled(false);
            this.ordSequential.setSelected(true);
        }

        public void loadFromOrderings(List list, List list2) {
            if (list2 == null || list2.isEmpty() || SimpleDomainEditor.orderingsAreSequential(list, list2)) {
                this.ordParallel.setEnabled(true);
                this.ordSequential.setEnabled(true);
                this.ordOther.setEnabled(false);
                if ((list2 == null || list2.isEmpty()) && list != null && list.size() >= 2) {
                    this.ordParallel.setSelected(true);
                } else {
                    this.ordSequential.setSelected(true);
                }
            } else {
                this.ordParallel.setEnabled(true);
                this.ordSequential.setEnabled(true);
                this.ordOther.setEnabled(true);
                this.ordOther.setSelected(true);
            }
        }
    }

    protected class RefinementEditor
    extends JPanel
    implements ActionListener {
        String lineSeparator = System.getProperty("line.separator");
        int textCols = 50;
        JTextField nameText;
        JTextField patternText;
        JTextArea expansionText;
        JTextArea commentText;
        TemporalConstraintPanel constraintPanel;
        JButton saveButton;
        JButton deleteButton;
        JButton clearButton;
        Refinement editingRefinement = null;

        RefinementEditor() {
            this.setLayout(new BoxLayout(this, 1));
            this.setUp();
        }

        protected void setUp() {
            this.nameText = new JTextField(this.textCols);
            this.patternText = new JTextField(this.textCols);
            this.expansionText = new JTextArea(7, this.textCols);
            this.commentText = new JTextArea(5, this.textCols);
            this.constraintPanel = new TemporalConstraintPanel();
            this.addLeftLabel("Name");
            this.add(this.nameText);
            this.addLeftLabel("Pattern");
            this.add(this.patternText);
            this.addLeftLabel("Expansion");
            this.add(new JScrollPane(this.expansionText));
            this.addLeftLabel("Constraints");
            this.add(this.constraintPanel);
            this.addLeftLabel("Annotations");
            this.add(new JScrollPane(this.commentText));
            this.saveButton = this.makeButton("Define Refinement");
            this.deleteButton = this.makeButton("Delete Refinement");
            this.clearButton = this.makeButton("Clear");
            this.setButtonsEnabled(false);
            Box box = Box.createHorizontalBox();
            box.add(this.saveButton);
            box.add(this.deleteButton);
            box.add(this.clearButton);
            this.add(box);
        }

        protected void addLeftLabel(String string) {
            Box box = Box.createHorizontalBox();
            box.add(new JLabel(string));
            box.add(Box.createHorizontalGlue());
            this.add(box);
        }

        protected JButton makeButton(String string) {
            JButton jButton = new JButton(string);
            jButton.addActionListener(CatchingActionListener.listener(this));
            return jButton;
        }

        protected void setButtonsEnabled(boolean bl) {
            this.saveButton.setEnabled(bl);
            this.deleteButton.setEnabled(bl);
            this.clearButton.setEnabled(bl);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            Debug.noteln("RefinementEditor action:", string);
            if (string.equals("Define Refinement")) {
                this.saveDefinition();
            } else if (string.equals("Delete Refinement")) {
                this.deleteRefinement();
            } else if (string.equals("Clear")) {
                this.clearEdit();
            } else {
                Debug.noteln("Nothing to do for", string);
            }
        }

        public void editNewRefinement() {
            this.editingRefinement = null;
            this.nameText.setText("");
            this.patternText.setText("");
            this.expansionText.setText("");
            this.commentText.setText("");
            this.constraintPanel.newOrderings();
            this.setButtonsEnabled(true);
            this.deleteButton.setEnabled(false);
        }

        public void editRefinement(Refinement refinement) {
            Debug.noteln("Editing refinement named", refinement.getName());
            this.editingRefinement = refinement;
            this.loadFromRefinement(refinement);
            this.setButtonsEnabled(true);
        }

        public void editPartialRefinement(Refinement refinement) {
            this.loadFromRefinement(refinement);
            this.setButtonsEnabled(true);
            this.deleteButton.setEnabled(false);
        }

        protected void clearEdit() {
            this.editNewRefinement();
        }

        protected void saveDefinition() {
            if (this.editingRefinement == null) {
                this.defineNewRefinement();
            } else {
                String string = this.editingRefinement.getName();
                String string2 = this.nameText.getText();
                if (string2.equals(string)) {
                    switch (JOptionPane.showConfirmDialog(SimpleDomainEditor.this.frame, "Redefine refinement " + Util.quote(string), "Confirm", 0)) {
                        case 0: {
                            this.redefineRefinement(this.editingRefinement);
                            break;
                        }
                    }
                } else {
                    Object[] objectArray = new Object[]{"You have changed the name from " + Util.quote(string) + ".", "Do you want to define a new refinement named " + Util.quote(string2) + "?"};
                    switch (JOptionPane.showConfirmDialog(SimpleDomainEditor.this.frame, objectArray, "Confirm", 0)) {
                        case 0: {
                            this.defineRenamedRefinement();
                            break;
                        }
                    }
                }
            }
        }

        protected void defineRenamedRefinement() {
            LinkedList<String> linkedList = new LinkedList<String>();
            Refinement refinement = this.editingRefinement;
            if (!Collect.isEmpty(refinement.getVariableDeclarations())) {
                linkedList.add("  Variable declarations");
            }
            if (!Collect.isEmpty(refinement.getOrderings()) && !SimpleDomainEditor.orderingsAreSequential(refinement.getNodes(), refinement.getOrderings())) {
                linkedList.add("  Nonsequential orderings");
            }
            if (!Collect.isEmpty(refinement.getConstraints())) {
                linkedList.add("  Constraints");
            }
            if (!Collect.isEmpty(refinement.getIssues())) {
                linkedList.add("  Issues");
            }
            if (!linkedList.isEmpty()) {
                linkedList.addFirst("Some of the original refinement will be lost:");
                linkedList.add("Do you still want to define the new refinement?");
                switch (JOptionPane.showConfirmDialog(SimpleDomainEditor.this.frame, linkedList.toArray(), "Confirm", 0)) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        return;
                    }
                }
            }
            this.editingRefinement = null;
            this.saveDefinition();
        }

        protected void defineNewRefinement() {
            Refinement refinement;
            try {
                String string = this.nameText.getText().trim();
                LList lList = Lisp.elementsFromString(this.patternText.getText());
                if (string.equals("")) {
                    throw new EditException("No name for refinement.");
                }
                if (lList.isNull()) {
                    throw new EditException("No pattern for refinement.");
                }
                if (SimpleDomainEditor.this.dom.getNamedRefinement(string) != null) {
                    throw new EditException("There is already a refinement named " + Util.quote(string));
                }
                refinement = new Refinement(string, lList);
                this.storeIntoRefinement(refinement);
            }
            catch (Exception exception) {
                Debug.noteException(exception);
                JOptionPane.showMessageDialog(SimpleDomainEditor.this.frame, new Object[]{"Cannot define refinement.", exception.toString()}, "Error while defining refinement", 0);
                return;
            }
            this.editingRefinement = refinement;
            SimpleDomainEditor.this.dom.addRefinement(refinement);
            SimpleDomainEditor.this.populateRefinementMenu();
        }

        protected void redefineRefinement(Refinement refinement) {
            Debug.noteln("Redefining refinement", refinement.toString());
            JOptionPane.showMessageDialog(SimpleDomainEditor.this.frame, "Refinement redefinition is not yet supported.", "Redefinition not allowed", 0);
        }

        protected void loadFromRefinement(Refinement refinement) {
            this.nameText.setText(refinement.getName() != null ? refinement.getName() : "");
            this.patternText.setText(Lisp.elementsToString(refinement.getPattern()));
            this.expansionText.setText("");
            if (refinement.getNodes() != null) {
                Iterator iterator = refinement.getNodes().iterator();
                while (iterator.hasNext()) {
                    NodeSpec nodeSpec = (NodeSpec)iterator.next();
                    LList lList = nodeSpec.getPattern();
                    this.expansionText.append(Lisp.elementsToString(lList));
                    this.expansionText.append(this.lineSeparator);
                }
            }
            this.commentText.setText(refinement.getComments());
            this.constraintPanel.loadFromOrderings(refinement.getNodes(), refinement.getOrderings());
        }

        protected void storeIntoRefinement(Refinement refinement) {
            String string;
            List list;
            Debug.noteln("Changing refinement", refinement.toString());
            Debug.assert(refinement.getName().equals(this.nameText.getText().trim()));
            String string2 = this.expansionText.getText().trim();
            List list2 = SimpleDomainEditor.parseNodes(string2);
            refinement.setNodes(list2.isEmpty() ? null : list2);
            String string3 = this.constraintPanel.getOrderingChoice();
            List list3 = list = string3.equals("Sequential") ? SimpleDomainEditor.sequentialOrderings(list2) : null;
            if (!string3.equals("Other")) {
                refinement.setOrderings(list);
            }
            if (!(string = this.commentText.getText()).trim().equals("")) {
                refinement.setComments(string);
            } else {
                refinement.setComments(null);
            }
            refinement.checkConsistency();
            Debug.noteln("Refinement is now", refinement.toString());
        }

        protected List makeVarDcls(SortedSet sortedSet) {
            LinkedList<VariableDeclaration> linkedList = new LinkedList<VariableDeclaration>();
            Iterator iterator = sortedSet.iterator();
            while (iterator.hasNext()) {
                ItemVar itemVar = (ItemVar)iterator.next();
                linkedList.add(new VariableDeclaration(itemVar));
            }
            return linkedList.isEmpty() ? null : linkedList;
        }

        protected void deleteRefinement() {
            Debug.assert(this.editingRefinement != null);
            String string = this.editingRefinement.getName();
            String string2 = this.nameText.getText();
            if (!string2.equals(string)) {
                JOptionPane.showMessageDialog(SimpleDomainEditor.this.frame, "You cannot delete the refinement after changing the name.", "Name changed", 0);
                this.deleteButton.setEnabled(false);
                return;
            }
            if (SimpleDomainEditor.this.dom.getNamedRefinement(string2) == null) {
                JOptionPane.showMessageDialog(SimpleDomainEditor.this.frame, "There is no refinement named " + Util.quote(string2), "No such refinement", 0);
                this.deleteButton.setEnabled(false);
                return;
            }
            switch (JOptionPane.showConfirmDialog(SimpleDomainEditor.this.frame, "Delete refinement " + Util.quote(string2), "Confirm", 0)) {
                case 0: {
                    SimpleDomainEditor.this.dom.deleteNamedRefinement(string2);
                    SimpleDomainEditor.this.populateRefinementMenu();
                    this.clearEdit();
                    break;
                }
            }
        }
    }

    class EditException
    extends RuntimeException {
        EditException(String string) {
            super(string);
        }
    }
}

