/*
 * Decompiled with CFR 0.152.
 */
package ix.iview;

import ix.icore.domain.End;
import ix.icore.domain.NodeEndRef;
import ix.icore.domain.NodeSpec;
import ix.icore.domain.Ordering;
import ix.iface.ui.ListEditorPanel;
import ix.iview.ConstraintEditor;
import ix.iview.NodeNumberRenderer;
import ix.iview.domain.UIRefinement;
import ix.util.Name;
import java.awt.Component;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.ListModel;

public class OrderingEditor
extends ConstraintEditor {
    protected JList actListA;
    protected JList timeListA;
    protected JLabel beforeLabel;
    protected JList timeListB;
    protected JList actListB;

    public OrderingEditor() {
        super("Activity Relation Editor", "Please specify orderings (select 2 activities and 2 time points).");
    }

    public OrderingEditor(UIRefinement uIRefinement) {
        super("Activity Relation Editor", "Please specify orderings (select 2 activities and 2 time points).", uIRefinement);
    }

    protected Component makeRels() {
        Box box = new Box(0);
        this.actListA = new JList();
        ListEditorPanel listEditorPanel = this.makeActPanel(this.actListA);
        this.timeListA = new JList<Object>(End.values().toArray());
        ListEditorPanel listEditorPanel2 = new ListEditorPanel((MouseListener)this, "Time", this.timeListA);
        this.timeListB = new JList<Object>(End.values().toArray());
        ListEditorPanel listEditorPanel3 = new ListEditorPanel((MouseListener)this, "Time", this.timeListB);
        this.timeListA.setAutoscrolls(true);
        this.timeListA.setSelectionMode(0);
        this.timeListA.setSelectedIndex(1);
        this.timeListB.setAutoscrolls(true);
        this.timeListB.setSelectionMode(0);
        this.timeListB.setSelectedIndex(0);
        this.actListB = new JList();
        ListEditorPanel listEditorPanel4 = this.makeActPanel(this.actListB);
        box.add(listEditorPanel);
        box.add(listEditorPanel2);
        box.add(Box.createHorizontalStrut(5));
        box.add(Box.createGlue());
        this.beforeLabel = new JLabel("Before");
        box.add(this.beforeLabel);
        box.add(Box.createGlue());
        box.add(Box.createHorizontalStrut(5));
        box.add(listEditorPanel4);
        box.add(listEditorPanel3);
        return box;
    }

    private ListEditorPanel makeActPanel(JList jList) {
        ListEditorPanel listEditorPanel = new ListEditorPanel((MouseListener)this, "Activity", jList);
        jList.setAutoscrolls(true);
        jList.setSelectionMode(0);
        jList.setCellRenderer(new NodeNumberRenderer(false));
        return listEditorPanel;
    }

    protected void initFromObject() throws NullPointerException {
        UIRefinement uIRefinement = (UIRefinement)this.currentObject;
        if (uIRefinement == null) {
            return;
        }
        List list = uIRefinement.getNodes();
        if (list.isEmpty()) {
            String string = "the refinement " + uIRefinement.getName() + " has no children to relate.";
            throw new NullPointerException(string);
        }
        this.makeActList(this.actListA, list.toArray());
        this.makeActList(this.actListB, list.toArray());
    }

    protected void setFromObject(Object object) {
        this.actListA.clearSelection();
        this.actListB.clearSelection();
        this.timeListA.clearSelection();
        this.timeListB.clearSelection();
        if (object == null) {
            return;
        }
        if (!(object instanceof Ordering)) {
            String string = "Condition/Effect editor can only deal with orderings not objects of class " + object.getClass().getName();
            JOptionPane.showMessageDialog(this, string);
            return;
        }
        Ordering ordering = (Ordering)object;
        NodeEndRef nodeEndRef = ordering.getFrom();
        NodeEndRef nodeEndRef2 = ordering.getTo();
        Name name = nodeEndRef.getNode();
        Name name2 = nodeEndRef2.getNode();
        this.actListA.setSelectedValue(this.findNodeSpec(name, this.actListA), true);
        this.actListB.setSelectedValue(this.findNodeSpec(name2, this.actListB), true);
        this.timeListA.setSelectedValue(nodeEndRef.getEnd(), true);
        this.timeListB.setSelectedValue(nodeEndRef2.getEnd(), true);
    }

    private void makeActList(JList jList, Object[] objectArray) {
        jList.removeAll();
        jList.setListData(objectArray);
    }

    protected Object collectConstraint() {
        Object e = this.actListA.getSelectedValue();
        Object e2 = this.actListB.getSelectedValue();
        End end = (End)this.timeListA.getSelectedValue();
        End end2 = (End)this.timeListB.getSelectedValue();
        if (e == null || e2 == null || end == null || end2 == null) {
            Object[] objectArray = new Object[]{"Please select two activities and two time points.", "Click Cancel to cancel."};
            JOptionPane.showMessageDialog(this, objectArray);
            return null;
        }
        Name name = ((NodeSpec)e).getId();
        Name name2 = ((NodeSpec)e2).getId();
        NodeEndRef nodeEndRef = new NodeEndRef(end, name);
        NodeEndRef nodeEndRef2 = new NodeEndRef(end2, name2);
        if (this.isEditing()) {
            Ordering ordering = (Ordering)this.original;
            ordering.setFrom(nodeEndRef);
            ordering.setTo(nodeEndRef2);
            return ordering;
        }
        return new Ordering(nodeEndRef, nodeEndRef2);
    }

    private NodeSpec findNodeSpec(Name name, JList jList) {
        if (name == null) {
            return null;
        }
        ListModel listModel = jList.getModel();
        int n = 0;
        while (n < listModel.getSize()) {
            NodeSpec nodeSpec;
            Object e = listModel.getElementAt(n);
            if (e instanceof NodeSpec && name.equals((nodeSpec = (NodeSpec)e).getId())) {
                return nodeSpec;
            }
            ++n;
        }
        return null;
    }
}

