/*
 * Decompiled with CFR 0.152.
 */
package ix.iview;

import ix.iface.ui.JPreferencesDialog;
import ix.iview.DomainEditor;
import ix.iview.IDESymbols;
import ix.iview.util.IDEUtil;
import ix.util.Debug;
import ix.util.lisp.Symbol;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class IDEPreferencesDialog
extends JPreferencesDialog
implements IDESymbols,
ChangeListener {
    public IDEPreferencesDialog(DomainEditor domainEditor, Properties properties) {
        super(domainEditor, properties);
    }

    public File getPreferencesFile() {
        String string = ".";
        String string2 = System.getProperty("file.separator");
        String string3 = string + string2 + "ix-ide.prefs";
        return new File(string3);
    }

    public void makeComponents() {
        Box box = new Box(1);
        ArrayList<JCheckBox> arrayList = new ArrayList<JCheckBox>();
        JCheckBox jCheckBox = new JCheckBox("Simple mode");
        jCheckBox.setActionCommand(IDESymbols.MODE_SIMPLE.toString());
        jCheckBox.setToolTipText("Set the mode to simple (tick) or advanced (no tick)");
        jCheckBox.setSelected(this.properties.getProperty("ideMode").equals(jCheckBox.getActionCommand()));
        jCheckBox.addChangeListener(this);
        box.add(jCheckBox);
        arrayList.add(jCheckBox);
        this.keyComponents.put("ideMode", arrayList);
        arrayList = new ArrayList();
        JCheckBox jCheckBox2 = new JCheckBox("Set editable");
        jCheckBox2.setActionCommand("propEditable");
        jCheckBox2.setToolTipText("Switch off to use the editor as a viewer only");
        jCheckBox2.setSelected(this.properties.getProperty("ideEditable").equals("true"));
        jCheckBox2.setEnabled(false);
        box.add(jCheckBox2);
        this.keyComponents.put("ideEditable", arrayList);
        arrayList = new ArrayList();
        jCheckBox2 = new JCheckBox("Show text on toolbar buttons");
        jCheckBox2.setActionCommand("showButtText");
        jCheckBox2.setToolTipText("Toggle text on toolbar buttons on/off");
        jCheckBox2.setSelected(this.properties.getProperty("ideShowButtonTexts").equals("true"));
        box.add(jCheckBox2);
        arrayList.add(jCheckBox2);
        this.keyComponents.put("ideShowButtonTexts", arrayList);
        arrayList = new ArrayList();
        jCheckBox2 = new JCheckBox("Use text fields for lists");
        jCheckBox2.setActionCommand("ListsAsTexts");
        jCheckBox2.setToolTipText("Edit by typing (tick) or dialogue (no tick)");
        jCheckBox2.setSelected(this.properties.getProperty("ideListsAsTexts").equals("true"));
        jCheckBox2.setEnabled(false);
        box.add(jCheckBox2);
        arrayList.add(jCheckBox2);
        this.keyComponents.put("ideListsAsTexts", arrayList);
        this.prefsPanel.add(box);
        this.makeRadioComponent("idePanelStyle", "Preferred Panel Style", ((DomainEditor)this.frame).getPanelStyles(), "is the preferred style");
        this.makeRadioComponent("ideActivityView", "Preferred Activity View", Arrays.asList(IDESymbols.VIEWS), "is the preferred activity view");
        String[] stringArray = new String[]{"orderings", "conditions/effects", "other constraints"};
        this.makeCheckBoxComponent("ideConstraints", "Preferred Constraints View", Arrays.asList(stringArray), "should be shown");
        this.simpleEffect(jCheckBox);
    }

    private void makeRadioComponent(String string, String string2, List list, String string3) {
        String string4 = this.properties.getProperty(string);
        Box box = new Box(1);
        ArrayList<JRadioButton> arrayList = new ArrayList<JRadioButton>();
        box.add(new JLabel(string2));
        Box box2 = new Box(1);
        ButtonGroup buttonGroup = new ButtonGroup();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string5 = iterator.next().toString();
            JRadioButton jRadioButton = new JRadioButton(string5);
            jRadioButton.setActionCommand(string5);
            jRadioButton.setToolTipText(string5 + " " + string3);
            buttonGroup.add(jRadioButton);
            jRadioButton.setSelected(string5.equals(string4));
            box2.add(jRadioButton);
            arrayList.add(jRadioButton);
        }
        box.add(box2);
        this.prefsPanel.add(Box.createHorizontalGlue());
        this.prefsPanel.add(box);
        this.keyComponents.put(string, arrayList);
    }

    private void makeCheckBoxComponent(String string, String string2, List list, String string3) {
        String string4 = this.properties.getProperty(string);
        Box box = new Box(1);
        ArrayList<JCheckBox> arrayList = new ArrayList<JCheckBox>();
        box.add(new JLabel(string2));
        Box box2 = new Box(1);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string5 = iterator.next().toString();
            JCheckBox jCheckBox = new JCheckBox(string5);
            jCheckBox.setActionCommand(string5);
            jCheckBox.setToolTipText(string5 + " " + string3);
            box2.add(jCheckBox);
            arrayList.add(jCheckBox);
        }
        box.add(box2);
        this.prefsPanel.add(Box.createHorizontalGlue());
        this.prefsPanel.add(box);
        this.keyComponents.put(string, arrayList);
        this.setKeyComponent(string, arrayList, string4);
    }

    public void setKeyComponent(String string, List list, String string2) {
        if (list == null) {
            Debug.noteln("no components for", string);
            return;
        }
        if (string.equals("ideConstraints")) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                try {
                    JToggleButton jToggleButton = (JToggleButton)iterator.next();
                    String string3 = jToggleButton.getActionCommand();
                    if (IDEUtil.showConstraints(string3, Symbol.intern(string2))) {
                        jToggleButton.setSelected(true);
                        continue;
                    }
                    jToggleButton.setSelected(false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        } else {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                try {
                    JToggleButton jToggleButton = (JToggleButton)iterator.next();
                    String string4 = jToggleButton.getActionCommand();
                    if (string4.equals(string2)) {
                        jToggleButton.setSelected(true);
                        continue;
                    }
                    jToggleButton.setSelected(false);
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
        }
    }

    public void setEnabledComponents(String string, boolean bl) {
        this.setEnabledComponents(string, (List)this.keyComponents.get(string), bl);
    }

    public void setEnabledComponents(String string, List list, boolean bl) {
        if (list == null) {
            Debug.noteln("no components for", string);
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            try {
                JToggleButton jToggleButton = (JToggleButton)iterator.next();
                jToggleButton.setEnabled(bl);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String getPropertyFromComponent(String string, List list) {
        if (string.equals("ideMode")) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                try {
                    JToggleButton jToggleButton = (JToggleButton)iterator.next();
                    String string2 = jToggleButton.getActionCommand();
                    if (jToggleButton.isSelected()) {
                        return IDESymbols.MODE_SIMPLE.toString();
                    }
                    return IDESymbols.MODE_ADVANCED.toString();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return this.properties.getProperty(string);
        }
        if (string.equals("idePanelStyle")) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                try {
                    JToggleButton jToggleButton = (JToggleButton)iterator.next();
                    String string3 = jToggleButton.getActionCommand();
                    if (!jToggleButton.isSelected()) continue;
                    return jToggleButton.getActionCommand();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return this.properties.getProperty(string);
        }
        if (string.equals("ideActivityView")) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                try {
                    JToggleButton jToggleButton = (JToggleButton)iterator.next();
                    String string4 = jToggleButton.getActionCommand();
                    if (!jToggleButton.isSelected()) continue;
                    return jToggleButton.getActionCommand();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return this.properties.getProperty(string);
        }
        if (string.equals("ideConstraints")) {
            boolean[] blArray = new boolean[]{true, true, true};
            int n = 0;
            try {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    JToggleButton jToggleButton = (JToggleButton)iterator.next();
                    String string5 = jToggleButton.getActionCommand();
                    blArray[n] = jToggleButton.isSelected();
                    ++n;
                }
                return IDEUtil.makeConstPrefSymbol(blArray[0], blArray[1], blArray[2]).toString();
            }
            catch (Exception exception) {
                return this.properties.getProperty(string);
            }
        }
        return this.properties.getProperty(string);
    }

    public void setDefaultPreferences(Properties properties) {
        ((DomainEditor)this.frame).setDefaultProperties(properties);
        this.setKeyComponents(properties);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.simpleEffect((JToggleButton)changeEvent.getSource());
    }

    private void simpleEffect(JToggleButton jToggleButton) {
        if (jToggleButton.isSelected()) {
            List list = (List)this.keyComponents.get("idePanelStyle");
            this.setEnabledComponents("idePanelStyle", list, false);
            list = (List)this.keyComponents.get("ideActivityView");
            this.setEnabledComponents("ideActivityView", list, false);
            this.setEnabledComponents("ideConstraints", false);
        } else {
            this.setEnabledComponents("idePanelStyle", true);
            this.setEnabledComponents("ideActivityView", true);
            this.setEnabledComponents("ideConstraints", true);
        }
    }
}

