/*
 * Decompiled with CFR 0.152.
 */
package ix.iview;

import ix.icore.TaskItem;
import ix.icore.domain.Named;
import ix.icore.domain.NodeSpec;
import ix.icore.domain.Refinement;
import ix.icore.domain.event.RefinementEvent;
import ix.iface.ui.IXLabelRenderer;
import ix.iface.ui.ListEditorPanel;
import ix.iface.ui.util.UIUtil;
import ix.iview.AConstructFramePanel;
import ix.iview.DomainEditor;
import ix.iview.domain.UIObject;
import ix.iview.domain.UIRefinement;
import ix.iview.domain.event.UIDomainEvent;
import ix.iview.domain.event.UIDomainListener;
import ix.util.Debug;
import ix.util.lisp.LListCollector;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseListener;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JList;
import javax.swing.JPanel;

public class GrammarEditorPanel
extends AConstructFramePanel
implements ActionListener,
UIDomainListener {
    private ListEditorPanel issuePatternList;
    private ListEditorPanel nodePatternList;
    private ListEditorPanel constraintPatternList;
    private HashSet issuePatterns = new HashSet();
    private HashSet nodePatterns = new HashSet();
    private HashSet constraintPatterns = new HashSet();
    static /* synthetic */ Class class$ix$icore$domain$Refinement;
    static /* synthetic */ Class class$ix$iview$domain$UIRefinement;

    public GrammarEditorPanel(DomainEditor domainEditor) {
        super(domainEditor);
        this.updatePatterns();
    }

    protected JPanel setupMainPanel() {
        this.mainPanel = new JPanel(new GridLayout(3, 1));
        this.scrollPane.getViewport().add(this.mainPanel);
        MouseAdapter mouseAdapter = new MouseAdapter(){};
        this.issuePatternList = this.makeList(mouseAdapter, "Issue Patterns");
        this.nodePatternList = this.makeList(mouseAdapter, "Node Patterns");
        this.constraintPatternList = this.makeList(mouseAdapter, "Constraint Patterns");
        this.fillConstraintPatternList();
        return this.mainPanel;
    }

    public boolean beforeSwitching() {
        return true;
    }

    private ListEditorPanel makeList(MouseListener mouseListener, String string) {
        String[] stringArray = new String[]{"Add", "Delete", "Clear"};
        JList jList = new JList();
        jList.setVisibleRowCount(5);
        jList.setCellRenderer(new IXLabelRenderer(false){

            public void setInfo(Object object) {
                String string = "";
                string = object instanceof Collection ? UIUtil.listToDisplay((Collection)object) : object.toString();
                this.setText(string);
            }
        });
        ListEditorPanel listEditorPanel = new ListEditorPanel(mouseListener, string, jList, stringArray);
        listEditorPanel.setEnabled(false);
        this.mainPanel.add(listEditorPanel);
        return listEditorPanel;
    }

    private void fillConstraintPatternList() {
        String[] stringArray = new String[]{"temporal  before  <node-end> <node-end>", "world-state  condition  <pattern> = <value>", "world-state  effect  <pattern> = <value>", "<type>  <relation>  <parameters>"};
        this.constraintPatternList.setData(stringArray);
    }

    public void newConstruct() {
        this.setConstruct((UIObject)null);
    }

    public UIObject makeNewConstruct() {
        return null;
    }

    public void saveConstruct() {
        UIUtil.notImplemented(this, "Saving grammars");
    }

    protected UIObject noteConstruct() {
        return null;
    }

    public void setConstruct(UIObject uIObject) {
        if (uIObject == null) {
            this.issuePatternList.removeData();
            this.nodePatternList.removeData();
            this.constraintPatternList.removeData();
        } else {
            UIUtil.notImplemented(this, "Setting grammars");
        }
    }

    public boolean checkConstruct() {
        UIUtil.notImplemented(this, "Checking grammars");
        return true;
    }

    public List getAllConstructs() {
        return new LListCollector();
    }

    public Named getNamedConstruct(String string) {
        return null;
    }

    public void constructAdded(UIDomainEvent uIDomainEvent) {
        this.updatePatterns();
    }

    public void constructAdded(RefinementEvent refinementEvent) {
        this.updatePatterns();
    }

    public void constructEdited(UIDomainEvent uIDomainEvent) {
        this.updatePatterns();
    }

    public void constructRemoved(UIDomainEvent uIDomainEvent) {
        this.updatePatterns();
    }

    public void domainCleared(UIDomainEvent uIDomainEvent) {
        this.updatePatterns();
    }

    public void domainEdited(UIDomainEvent uIDomainEvent) {
    }

    public void domainSet(UIDomainEvent uIDomainEvent) {
        this.updatePatterns();
    }

    private void updatePatterns() {
        this.issuePatterns.clear();
        this.nodePatterns.clear();
        this.constraintPatterns.clear();
        if (this.parent.getUIDomain() != null) {
            List list = this.parent.getUIDomain().getAllRefinements();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                this.addAllPatterns(iterator.next());
            }
        }
        this.updateListPatterns(this.issuePatternList, this.issuePatterns);
        this.updateListPatterns(this.nodePatternList, this.nodePatterns);
        this.fillConstraintPatternList();
    }

    private void addAllPatterns(Object object) {
        if (object == null) {
            return;
        }
        Object var2_2 = null;
        List list = null;
        List list2 = null;
        List list3 = null;
        Object var6_6 = null;
        if ((class$ix$icore$domain$Refinement == null ? (class$ix$icore$domain$Refinement = GrammarEditorPanel.class$("ix.icore.domain.Refinement")) : class$ix$icore$domain$Refinement).isInstance(object)) {
            Refinement refinement = (Refinement)object;
            this.nodePatterns.add(refinement.getPattern());
            list = refinement.getNodes();
            list2 = refinement.getIssues();
            list3 = refinement.getConstraints();
        } else if ((class$ix$iview$domain$UIRefinement == null ? (class$ix$iview$domain$UIRefinement = GrammarEditorPanel.class$("ix.iview.domain.UIRefinement")) : class$ix$iview$domain$UIRefinement).isInstance(object)) {
            UIRefinement uIRefinement = (UIRefinement)object;
            this.nodePatterns.add(uIRefinement.getPattern());
            list = uIRefinement.getNodes();
            list2 = uIRefinement.getIssues();
            list3 = uIRefinement.getConstraints();
        } else {
            Debug.noteln("GEP: Cannot get patterns from class ", object.getClass().getName());
            return;
        }
        if (list != null) {
            this.nodePatterns = this.getNodePatterns(list.iterator(), this.nodePatterns);
        }
        if (list2 != null) {
            this.issuePatterns = this.getIssuePatterns(list2.iterator(), this.issuePatterns);
        }
        if (list3 != null) {
            this.constraintPatterns = this.getConstraintPatterns(list3.iterator(), this.constraintPatterns);
        }
    }

    private void updateListPatterns(ListEditorPanel listEditorPanel, HashSet hashSet) {
        LinkedList linkedList = new LinkedList(hashSet);
        Collections.sort(linkedList, new UIUtil.ToStringComparator());
        listEditorPanel.setData(linkedList.toArray());
    }

    public HashSet getAllPatterns() {
        if (this.parent.getUIDomain() == null) {
            return null;
        }
        List list = this.parent.getUIDomain().getAllRefinements();
        Iterator iterator = list.iterator();
        HashSet hashSet = new HashSet();
        while (iterator.hasNext()) {
            hashSet.addAll(this.getAllPatterns(iterator.next()));
        }
        return hashSet;
    }

    public HashSet getAllPatterns(Object object) {
        HashSet hashSet = new HashSet();
        if (object == null) {
            return hashSet;
        }
        Object var3_3 = null;
        List list = null;
        List list2 = null;
        Object var6_6 = null;
        if ((class$ix$icore$domain$Refinement == null ? (class$ix$icore$domain$Refinement = GrammarEditorPanel.class$("ix.icore.domain.Refinement")) : class$ix$icore$domain$Refinement).isInstance(object)) {
            Refinement refinement = (Refinement)object;
            list = refinement.getNodes();
            if (list != null) {
                hashSet = this.getNodePatterns(list.iterator(), hashSet);
            }
            if ((list2 = refinement.getIssues()) != null) {
                hashSet = this.getIssuePatterns(list2.iterator(), hashSet);
            }
            hashSet.add(refinement.getPattern());
        } else if ((class$ix$iview$domain$UIRefinement == null ? (class$ix$iview$domain$UIRefinement = GrammarEditorPanel.class$("ix.iview.domain.UIRefinement")) : class$ix$iview$domain$UIRefinement).isInstance(object)) {
            UIRefinement uIRefinement = (UIRefinement)object;
            list = uIRefinement.getNodes();
            if (list != null) {
                hashSet = this.getNodePatterns(list.iterator(), hashSet);
            }
            if ((list2 = uIRefinement.getIssues()) != null) {
                hashSet = this.getIssuePatterns(list2.iterator(), hashSet);
            }
            hashSet.add(uIRefinement.getPattern());
        } else {
            Debug.noteln("GEP: Cannot get patterns from class ", object.getClass().getName());
            return null;
        }
        return hashSet;
    }

    public HashSet getNodePatterns(Iterator iterator, HashSet hashSet) {
        if (iterator != null) {
            while (iterator.hasNext()) {
                hashSet.add(((NodeSpec)iterator.next()).getPattern());
            }
        }
        return hashSet;
    }

    public HashSet getIssuePatterns(Iterator iterator, HashSet hashSet) {
        if (iterator != null) {
            while (iterator.hasNext()) {
                hashSet.add(((TaskItem)iterator.next()).getPattern());
            }
        }
        return hashSet;
    }

    public HashSet getConstraintPatterns(Iterator iterator, HashSet hashSet) {
        return hashSet;
    }

    public boolean frameActionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "newConstruct") {
            this.newConstruct();
        } else if (string != "editConstruct") {
            if (string == "modify") {
                this.saveConstruct();
            } else if (string == "check") {
                this.checkConstruct();
            } else {
                return false;
            }
        }
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        Debug.noteln("Grammar editor: Got action command", string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

