/*
 * Decompiled with CFR 0.152.
 */
package ix.iview;

import ix.icore.IXObject;
import ix.icore.domain.Named;
import ix.icore.domain.Refinement;
import ix.iface.ui.IXEditorPanel;
import ix.iface.ui.table.IXTreeTable;
import ix.iface.ui.util.UIUtil;
import ix.iview.AConstructFramePanel;
import ix.iview.DomainEditor;
import ix.iview.DomainFormModel;
import ix.iview.GlobalFormPanel;
import ix.iview.domain.UIDomain;
import ix.iview.domain.UINodeSpec;
import ix.iview.domain.UIObject;
import ix.iview.domain.UIRefinement;
import ix.iview.event.CurrentActionListener;
import ix.iview.table.ActionTreeTableModel;
import ix.util.Debug;
import ix.util.lisp.LListCollector;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class GlobalFramePanel
extends AConstructFramePanel
implements CurrentActionListener {
    protected EdMouseAdapter ml = new EdMouseAdapter();

    public GlobalFramePanel() {
    }

    public GlobalFramePanel(DomainEditor domainEditor) {
        super(domainEditor);
        DomainFormModel domainFormModel = new DomainFormModel();
        String[] stringArray = new String[]{"refinements"};
        domainFormModel.setDisplayFields(stringArray);
        this.formPanel.setModel(domainFormModel);
        UIDomain uIDomain = this.parent.getUIDomain();
        this.setUIConstruct(uIDomain);
        uIDomain.addUIDomainListener((GlobalFormPanel)this.formPanel);
    }

    protected JPanel setupMainPanel() {
        this.formPanel = new GlobalFormPanel(this);
        return this.formPanel;
    }

    public EdMouseAdapter getML() {
        return this.ml;
    }

    protected void setConstructFields() {
    }

    public List getAllConstructs() {
        LListCollector lListCollector = new LListCollector();
        lListCollector.add(this.parent.getUIDomain());
        return lListCollector;
    }

    public void newConstruct() {
        this.notImp("Creating a new domain");
    }

    public UIObject makeNewConstruct() {
        return new UIDomain(this.parent);
    }

    public boolean checkConstruct() {
        this.notImp("Checking domains");
        return true;
    }

    public void saveConstruct() {
        this.noteConstruct();
    }

    public void revertConstruct() {
        UIDomain uIDomain = this.parent.getUIDomain();
        uIDomain.loadFromDomain();
        this.setUIConstruct(uIDomain);
    }

    public void revertOConstruct() {
        UIDomain uIDomain = this.parent.getUIDomain();
        uIDomain.loadFromOriginal();
        this.setUIConstruct(uIDomain);
    }

    protected UIObject noteConstruct() {
        UIDomain uIDomain = this.parent.getUIDomain();
        this.formPanel.saveToObject(uIDomain);
        Debug.noteln(" new name:", uIDomain.getName());
        uIDomain.saveToDomain();
        this.setUIConstruct(uIDomain);
        return uIDomain;
    }

    public Named getNamedConstruct(String string) {
        if (this.parent.uiDomain == null) {
            return null;
        }
        if (this.parent.uiDomain.getName().equals(string)) {
            return this.parent.uiDomain;
        }
        return null;
    }

    public void updatePanel() {
        this.setUIConstruct(this.parent.getUIDomain());
    }

    public void clear() {
        this.parent.getUIDomain().clear();
        this.updatePanel();
    }

    private void editRefinement() {
        List list = this.getClearSelectedRefinements();
        if (list != null && !list.isEmpty()) {
            Object e = list.get(0);
            try {
                this.parent.setConstruct((IXObject)e);
            }
            catch (ClassCastException classCastException) {
                try {
                    this.parent.setUIConstruct((UIObject)e);
                }
                catch (ClassCastException classCastException2) {
                    try {
                        UINodeSpec uINodeSpec = (UINodeSpec)e;
                        UIRefinement uIRefinement = new UIRefinement(this.getUIDomain());
                        uIRefinement.setPattern(uINodeSpec.getPattern());
                        uIRefinement.setName("undefined");
                        this.parent.setUIConstruct(uIRefinement);
                    }
                    catch (ClassCastException classCastException3) {
                        Debug.noteln("Domain Editor: Cannot edit things of class", e.getClass().getName());
                    }
                }
            }
        }
    }

    private void addRefinement() {
        this.parent.setConstruct(new Refinement());
    }

    private void deleteRefinement() {
        List list = this.getClearSelectedRefinements();
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                try {
                    this.parent.getUIDomain().removeConstruct((UIObject)e);
                }
                catch (ClassCastException classCastException) {
                    try {
                        this.parent.getUIDomain().removeConstruct((IXObject)e);
                    }
                    catch (ClassCastException classCastException2) {
                        Debug.noteln("Domain Editor: Cannot delete things of class", e.getClass().getName());
                    }
                }
            }
        }
    }

    private List getClearSelectedRefinements() {
        IXEditorPanel iXEditorPanel = this.formPanel.getFieldBit("refinements");
        IXTreeTable iXTreeTable = (IXTreeTable)iXEditorPanel.getItemComponent();
        int[] nArray = iXTreeTable.getSelectedRows();
        iXTreeTable.clearSelection();
        if (nArray.length == 0) {
            String string = "Please select a refinement first.";
            JOptionPane.showMessageDialog(this, string);
            return null;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ActionTreeTableModel actionTreeTableModel = (ActionTreeTableModel)iXTreeTable.getModel();
        int n = 0;
        while (n < nArray.length) {
            arrayList.add(actionTreeTableModel.getRowObject(nArray[n]));
            ++n;
        }
        return arrayList;
    }

    public void addCurrentActionListener(CurrentActionListener currentActionListener) {
        ((GlobalFormPanel)this.formPanel).addCurrentActionListener(currentActionListener);
    }

    public void actionChanged(Component component, UIRefinement uIRefinement) {
        if (this.equals(component)) {
            return;
        }
        ((GlobalFormPanel)this.formPanel).reactingActionChange(true);
        ((GlobalFormPanel)this.formPanel).setSelectedAction(uIRefinement);
        ((GlobalFormPanel)this.formPanel).reactingActionChange(false);
    }

    public boolean frameActionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        Debug.noteln("DomainFramePanel got frame action command", string);
        if (string == "newConstruct") {
            this.newConstruct();
        } else if (string == "editConstruct") {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            String string2 = jMenuItem.getText().trim();
            this.setUIConstruct((UIObject)this.getNamedConstruct(string2));
        } else if (string == "modify") {
            this.saveConstruct();
        } else if (string == "revert") {
            this.revertConstruct();
        } else if (string == "revertO") {
            this.revertOConstruct();
        } else if (string == "check") {
            this.checkConstruct();
        } else {
            return false;
        }
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        Debug.noteln("Global Domain Panel got action command", string);
    }

    protected void notImp(String string) {
        UIUtil.notImplemented(this, string);
    }

    class EdMouseAdapter
    extends MouseAdapter {
        EdMouseAdapter() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            Component component = mouseEvent.getComponent();
            if (!(component instanceof AbstractButton)) {
                return;
            }
            AbstractButton abstractButton = (AbstractButton)component;
            Debug.noteln("GFrP: Button command " + abstractButton.getText());
            if (abstractButton.getText() == "Add") {
                GlobalFramePanel.this.addRefinement();
            } else if (abstractButton.getText() == "Delete") {
                GlobalFramePanel.this.deleteRefinement();
            } else if (abstractButton.getText() == "Edit") {
                GlobalFramePanel.this.editRefinement();
            }
        }
    }
}

