/*
 * Decompiled with CFR 0.152.
 */
package ix.iview;

import ix.icore.IXAgent;
import ix.icore.IXObject;
import ix.icore.domain.Domain;
import ix.icore.domain.Refinement;
import ix.icore.domain.event.DomainListener;
import ix.icore.domain.event.RefinementEvent;
import ix.iface.domain.DomainParser;
import ix.iface.ui.HelpFrame;
import ix.iface.ui.IXToolItem;
import ix.iface.ui.JFrameMTP;
import ix.iface.ui.JPreferencesDialog;
import ix.iface.ui.util.UIUtil;
import ix.iview.AConstructFramePanel;
import ix.iview.AROEditorPanel;
import ix.iview.ActionEditorPanel;
import ix.iview.GlobalFramePanel;
import ix.iview.GrammarEditorPanel;
import ix.iview.IDEPreferencesDialog;
import ix.iview.IDESymbols;
import ix.iview.InternalDomainEditor;
import ix.iview.OrderingEditor;
import ix.iview.domain.UIDomain;
import ix.iview.domain.UIObject;
import ix.iview.domain.event.UIDomainEvent;
import ix.iview.domain.event.UIDomainListener;
import ix.iview.util.IVUtil;
import ix.util.Debug;
import ix.util.Util;
import ix.util.lisp.Symbol;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToolBar;
import javax.swing.event.ChangeListener;

public class DomainEditor
extends JFrameMTP
implements ChangeListener,
DomainListener,
UIDomainListener,
PropertyChangeListener,
InternalDomainEditor,
IDESymbols {
    protected IXAgent agent;
    public Properties ideProperties;
    protected JPreferencesDialog preferencesDialog;
    protected GlobalFramePanel domainPanel;
    protected ActionEditorPanel actionPanel;
    protected AROEditorPanel aroPanel;
    protected GrammarEditorPanel grammarPanel;
    protected AConstructFramePanel lexiconPanel;
    protected AConstructFramePanel testPanel;
    protected OrderingEditor orderingEditor;
    protected ImageIcon checkIcon = Util.resourceImageIcon("ide-check.gif");
    protected ImageIcon revertOIcon = Util.resourceImageIcon("ide-revert-orig.gif");
    protected ImageIcon modifyIcon = Util.resourceImageIcon("ide-modify-draft.gif");
    protected ImageIcon publishIcon = Util.resourceImageIcon("ide-draft-publish.gif");
    protected ImageIcon minimalIcon = Util.resourceImageIcon("ide-view-minimal.gif");
    protected ImageIcon comprehensiveIcon = Util.resourceImageIcon("ide-view-comprehensive.gif");
    protected ImageIcon graphicalIcon = Util.resourceImageIcon("ide-view-graphical.gif");
    protected ImageIcon preferredIcon = Util.resourceImageIcon("ide-preferences.gif");
    protected ImageIcon simpleIcon = Util.resourceImageIcon("ide-mode-simple.gif");
    protected ImageIcon advancedIcon = Util.resourceImageIcon("ide-mode-advanced.gif");
    protected HelpFrame helpFrame;
    private String helpFile = "ide-help.html";
    private ImageIcon helpFrameIcon = Util.resourceImageIcon("ide-help-icon.gif");
    private JMenu editConstructMenu;
    private JMenu orderMenu;
    private ButtonGroup modeGroup = new ButtonGroup();
    private ButtonGroup viewGroup = new ButtonGroup();
    private JRadioButtonMenuItem simpleMI;
    private JRadioButtonMenuItem advancedMI;
    private JRadioButtonMenuItem minimalMI;
    private JRadioButtonMenuItem comprehensiveMI;
    private JRadioButtonMenuItem graphicalMI;
    private JButton minimalTB;
    private JButton comprehensiveTB;
    private JButton graphicalTB;
    private JCheckBoxMenuItem defSequenceMI;
    public IXToolItem revertItem = new IXToolItem(this.editMenu, this.toolBar, (ActionListener)this, "revert", "Undo", this.revertIcon, 'U', "Undo (revert) to last draft");
    protected IXToolItem publishItem = new IXToolItem(this.fileMenu, this.toolBar, (ActionListener)this, "publish", "Publish Draft", this.publishIcon, 'P', "Publish draft to application");
    protected IXToolItem insertItem = new IXToolItem(this.fileMenu, (ActionListener)this, "insert", "Insert into draft domain...", 'I', "Insert all constructs from an existing domain into the draft");
    protected IXToolItem clearItem = new IXToolItem(this.fileMenu, (ActionListener)this, "clearDom", "Clear draft domain", 'C', "Clear draft domain");
    protected IXToolItem revertDItem = new IXToolItem(this.fileMenu, (ActionListener)this, "revertDom", "Discard domain changes (revert to published)", 'R', "Discard changes to draft domain (revert to published)");
    protected IXToolItem newEditItem = new IXToolItem(this.editMenu, this.toolBar, (ActionListener)this, "newEdit", "New", this.newIcon, 'N', "Create new item");
    protected IXToolItem revertOItem = new IXToolItem(this.editMenu, this.toolBar, this, "revertO", "Revert to Published", this.revertOIcon, "Revert to last published version");
    protected IXToolItem modifyItem = new IXToolItem(this.editMenu, this.toolBar, (ActionListener)this, "modify", "Modify Draft", this.modifyIcon, 'M', "Note changes from panel into draft");
    protected JMenu modeMenu;
    protected IXToolItem simpleItem = new IXToolItem(this.modeMenu, this.toolBar, (ActionListener)this, "simple", "Simple Mode", this.simpleIcon, 'S', "Switch to simple mode");
    protected IXToolItem advancedItem = new IXToolItem(this.modeMenu, this.toolBar, (ActionListener)this, "advanced", "Advanced Mode", this.advancedIcon, 'A', "Switch to advanced mode");
    protected JMenu viewsMenu;
    protected IXToolItem minimalItem = new IXToolItem(this.viewsMenu, this.toolBar, (ActionListener)this, "minimal", "Minimal View", "Minimal", this.minimalIcon, "Switch to minimal view");
    protected IXToolItem comprehensiveItem = new IXToolItem(this.viewsMenu, this.toolBar, (ActionListener)this, "comprehensive", "Comprehensive View", "Comprehensive", this.comprehensiveIcon, "Switch to comprehensive view");
    protected IXToolItem graphicalItem = new IXToolItem(this.viewsMenu, this.toolBar, (ActionListener)this, "graphical", "Graphical View", "Graphical", this.graphicalIcon, "Switch to graphical view");
    protected IXToolItem checkItem = new IXToolItem(this.toolsMenu, this.toolBar, (ActionListener)this, "check", "Check", this.checkIcon, 'C', "Check the current construct");
    protected IXToolItem preferencesItem;
    protected IXToolItem preferredItem = new IXToolItem(this.viewMenu, this.toolBar, (ActionListener)this, "preferred", "Preferred", this.preferredIcon, 'P', "Use current preferences to set mode, style, and view");
    protected IXToolItem sequenceNewItem;
    protected IXToolItem sequenceItem;
    protected IXToolItem parallelItem;
    protected IXToolItem propModeItem;
    protected IXToolItem propButtTextItem;
    protected IXToolItem propEditableItem;
    protected IXToolItem propListTextItem;
    protected IXToolItem propSaveItem;
    public IXToolItem[] allButtons = new IXToolItem[]{this.newItem, this.openItem, this.saveItem, this.saveAsItem, this.revertItem, this.publishItem, this.newEditItem, this.cutItem, this.copyItem, this.pasteItem, this.revertOItem, this.modifyItem, this.minimalItem, this.comprehensiveItem, this.graphicalItem, this.checkItem, this.helpItem};
    private boolean standAlone = false;
    private boolean simpleMode = true;
    private boolean showButtonTexts = true;
    private boolean isEditable = true;
    private boolean listsAsText = true;
    private Symbol preferredView = IDESymbols.VIEW_COMPREHENSIVE;
    private String preferredStyle = "tabbed";
    protected Symbol preferredConstraints = IDESymbols.C_ALL;
    private ImageIcon frameIcon = Util.resourceImageIcon("ide-icon.gif");
    private ImageIcon logo = Util.resourceImageIcon("ide-logo.gif");
    private String title = "I-X Domain Editor";
    protected File modelDirectory = new File("domain-library");
    public UIDomain uiDomain = new UIDomain(new Domain(), this);
    private boolean adjustingDomain = false;
    private boolean adjustingMode = false;
    private boolean adjustingView = false;
    JToolBar.Separator tbs = new JToolBar.Separator();
    static /* synthetic */ Class class$ix$iview$domain$UIRefinement;
    static /* synthetic */ Class class$ix$iview$domain$UIDomain;

    public DomainEditor() {
        this(false, true);
    }

    public DomainEditor(boolean bl, boolean bl2) {
        this(bl2);
        this.setSimpleMode(bl);
    }

    public DomainEditor(boolean bl) {
        IVUtil.printIDEReleaseGreeting();
        ((Component)this).setSize(650, 650);
        this.setVisuals();
        this.standAlone = bl;
        this.loadProperties();
        this.makeDefaultMenu();
        Debug.noteln("I-DE made menus");
        this.makeToolbar();
        Debug.noteln("I-DE made toolbar");
        this.actionPanel = new ActionEditorPanel(this, this.preferredView, this.preferredConstraints);
        this.actionPanel.updateToolbar(this.showButtonTexts);
        this.domainPanel = new GlobalFramePanel(this);
        this.grammarPanel = new GrammarEditorPanel(this);
        this.actionPanel.addCurrentActionListener(this.domainPanel);
        this.domainPanel.addCurrentActionListener(this.actionPanel);
        this.addPanels();
        Debug.noteln("I-DE added panels");
        this.fillWindowsMenu();
        this.setCurrentPanel(this.actionPanel);
        this.advancedMI.setSelected(!this.simpleMode);
        this.simpleMI.setSelected(this.simpleMode);
        this.updateViewMenu(this.preferredView);
        this.orderingEditor = this.actionPanel.orderingEditor;
        this.addWindowListener(new IXWindow());
        this.setUIDomainListeners(this.getUIDomain());
        this.populateEditMenu();
        this.validate();
    }

    public DomainEditor(Domain domain) {
        this(domain, true);
    }

    public DomainEditor(Domain domain, boolean bl) {
        this(bl);
        this.setDomain(domain);
    }

    public DomainEditor(IXAgent iXAgent, Domain domain) {
        this(domain, false);
        this.agent = iXAgent;
        this.title = iXAgent.getAgentSymbolName().toString() + " Domain Editor";
        this.exitItem.hide();
        this.setVisuals();
    }

    public File getPreferencesFile() {
        this.ensurePreferencesDialog();
        return this.preferencesDialog.getPreferencesFile();
    }

    public void loadProperties() {
        Debug.noteln("IDE: loading properties");
        Properties properties = new Properties();
        this.setDefaultProperties(properties);
        this.ideProperties = new Properties(properties);
        this.ensurePreferencesDialog();
        this.preferencesDialog.loadPreferences(this.ideProperties);
        this.updateIDEFromProperties();
    }

    public void setDefaultProperties(Properties properties) {
        properties.setProperty("idePanelStyle", "tabbed");
        properties.setProperty("ideActivityView", IDESymbols.VIEW_COMPREHENSIVE.toString());
        properties.setProperty("ideShowButtonTexts", new Boolean(true).toString());
        properties.setProperty("ideEditable", new Boolean(true).toString());
        properties.setProperty("ideListsAsTexts", new Boolean(true).toString());
        properties.setProperty("ideConstraints", IDESymbols.C_ALL.toString());
        Symbol symbol = IDESymbols.MODE_SIMPLE;
        properties.setProperty("ideMode", symbol.toString());
    }

    public void setCurrentProperties(Properties properties) {
        Symbol symbol = this.simpleMode ? IDESymbols.MODE_SIMPLE : IDESymbols.MODE_ADVANCED;
        properties.setProperty("ideMode", symbol.toString());
        properties.setProperty("idePanelStyle", this.preferredStyle);
        properties.setProperty("ideActivityView", this.preferredView.toString());
        properties.setProperty("ideShowButtonTexts", new Boolean(this.showButtonTexts).toString());
        properties.setProperty("ideEditable", new Boolean(this.isEditable).toString());
        properties.setProperty("ideListsAsTexts", new Boolean(this.listsAsText).toString());
        properties.setProperty("ideConstraints", this.preferredConstraints.toString());
    }

    public void saveProperties() {
        this.updatePropertiesFromIDE();
        this.ensurePreferencesDialog();
        this.preferencesDialog.writePreferences(this.ideProperties);
    }

    public void updateIDEFromProperties() {
        boolean bl = this.simpleMode;
        String string = this.ideProperties.getProperty("ideMode");
        bl = IDESymbols.MODE_SIMPLE.equals(Symbol.intern(string));
        if (bl) {
            this.setPanelStyle("single");
            this.setActivityView(IDESymbols.VIEW_MINIMAL);
        } else {
            string = this.ideProperties.getProperty("idePanelStyle");
            this.applyPanelStyle(string);
            string = this.ideProperties.getProperty("ideActivityView");
            this.applyActivityView(string);
        }
        string = this.ideProperties.getProperty("ideShowButtonTexts");
        this.applyButtonTexts(string);
        string = this.ideProperties.getProperty("ideEditable");
        this.applyEditable(string);
        string = this.ideProperties.getProperty("ideListsAsTexts");
        this.applyListsAsTexts(string);
        string = this.ideProperties.getProperty("ideConstraints");
        this.applyConstraintsView(string);
        string = this.ideProperties.getProperty("ideMode");
        this.applyMode(string);
    }

    private void applyMode(String string) {
        this.setMode(Symbol.intern(string));
    }

    private void applyPanelStyle(String string) {
        this.setPanelStyle(string);
    }

    private void applyActivityView(String string) {
        this.setActivityView(Symbol.intern(string));
    }

    private void applyButtonTexts(String string) {
        boolean bl = new Boolean(string);
        this.updateToolbar(bl);
    }

    private void applyEditable(String string) {
        this.isEditable = new Boolean(string);
    }

    private void applyListsAsTexts(String string) {
        this.showListsAsTexts(new Boolean(string));
    }

    private void applyConstraintsView(String string) {
        this.setConstraintsView(Symbol.intern(string));
    }

    public void updatePropertiesFromIDE() {
        if (this.simpleMode && this.getPanelStyle().equals("single") && this.actionPanel.getActivityView().equals(IDESymbols.VIEW_MINIMAL)) {
            this.ideProperties.setProperty("ideMode", IDESymbols.MODE_SIMPLE.toString());
        } else {
            this.ideProperties.setProperty("ideMode", IDESymbols.MODE_ADVANCED.toString());
        }
        this.ideProperties.setProperty("idePanelStyle", this.preferredStyle);
        this.ideProperties.setProperty("ideActivityView", this.preferredView.toString());
        this.ideProperties.setProperty("ideShowButtonTexts", new Boolean(this.showButtonTexts).toString());
        this.ideProperties.setProperty("ideEditable", new Boolean(this.isEditable).toString());
        this.ideProperties.setProperty("ideListsAsTexts", new Boolean(this.listsAsText).toString());
        this.ideProperties.setProperty("ideConstraints", this.preferredConstraints.toString());
    }

    private void setMode(Symbol symbol) {
        if (IDESymbols.MODE_SIMPLE.equals(symbol)) {
            this.setSimpleMode(true);
        } else if (IDESymbols.MODE_ADVANCED.equals(symbol)) {
            this.setSimpleMode(false);
        } else {
            Debug.noteln("I-DE: Cannot recognise mode ", symbol.toString());
        }
    }

    private void updateToolbar(boolean bl) {
        if (this.showButtonTexts != bl) {
            this.showButtonTexts = bl;
            int n = 0;
            while (n < this.allButtons.length) {
                try {
                    IXToolItem iXToolItem = this.allButtons[n];
                    if (iXToolItem != null) {
                        iXToolItem.showButtonText(bl);
                    }
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
                ++n;
            }
            this.actionPanel.updateToolbar(bl);
        }
    }

    private void showListsAsTexts(boolean bl) {
        if (this.listsAsText != bl) {
            this.listsAsText = bl;
            Debug.noteln("Cannot toggle lists as texts yet");
        }
    }

    private void addPanels() {
        this.addPanel(this.domainPanel, "Domain", "Viewer/editor for global domain constraints and issues");
        this.addPanel(this.actionPanel, "Activity", "Activity viewer/editor");
        this.addPanel(this.grammarPanel, "Grammar", "Grammar viewer/editor");
    }

    private void clearPanels() {
        this.domainPanel.clear();
        this.actionPanel.clear();
        this.grammarPanel.clear();
    }

    private boolean closePanels() {
        Debug.noteln("DE: Closing panels");
        return this.domainPanel.beforeClosing() && this.actionPanel.beforeClosing() && this.grammarPanel.beforeClosing();
    }

    protected boolean currentPanelChanging(JPanel jPanel, JPanel jPanel2) {
        if (jPanel == null) {
            return ((AConstructFramePanel)jPanel2).beforeOpening();
        }
        if (jPanel.equals(jPanel2)) {
            return true;
        }
        AConstructFramePanel aConstructFramePanel = (AConstructFramePanel)jPanel;
        AConstructFramePanel aConstructFramePanel2 = (AConstructFramePanel)jPanel2;
        return aConstructFramePanel.beforeClosing() && aConstructFramePanel2.beforeOpening();
    }

    protected void setVisuals() {
        this.setTitle(this.title);
        ((Frame)this).setIconImage(this.frameIcon.getImage());
    }

    public void ensureHelpFrame() {
        if (this.helpFrame == null) {
            this.helpFrame = new HelpFrame(this.helpFile);
            ((Frame)this.helpFrame).setIconImage(this.helpFrameIcon.getImage());
            ((Component)this.helpFrame).setVisible(false);
        }
    }

    public boolean isSimpleMode() {
        return this.simpleMode;
    }

    public void setActivityView(Symbol symbol) {
        if (this.adjustingView) {
            return;
        }
        this.adjustingView = true;
        this.updateViewMenu(symbol);
        if (!this.preferredView.equals(symbol)) {
            this.enableView(symbol);
        }
        if (this.actionPanel != null) {
            this.actionPanel.setCurrentView(symbol);
        }
        this.adjustingView = false;
    }

    public boolean setPanelStyle(String string) {
        boolean bl = super.setPanelStyle(string);
        if (bl && this.simpleMode && !string.equals("single")) {
            this.setSimpleMode(false);
        }
        return bl;
    }

    public void setConstraintsView(Symbol symbol) {
        if (!this.preferredConstraints.equals(symbol)) {
            this.preferredConstraints = symbol;
            if (this.actionPanel != null) {
                this.actionPanel.setConstraintsView(symbol);
            }
        }
    }

    public void updateViewMenu(Symbol symbol) {
        if (IDESymbols.VIEW_GRAPHICAL.equals(symbol)) {
            if (this.graphicalMI != null && !this.graphicalMI.isSelected()) {
                this.graphicalMI.setSelected(true);
                this.minimalMI.setSelected(false);
                this.comprehensiveMI.setSelected(false);
            }
        } else if (IDESymbols.VIEW_COMPREHENSIVE.equals(symbol)) {
            if (this.comprehensiveMI != null && !this.comprehensiveMI.isSelected()) {
                this.comprehensiveMI.setSelected(true);
                this.minimalMI.setSelected(false);
                this.graphicalMI.setSelected(false);
            }
        } else if (IDESymbols.VIEW_MINIMAL.equals(symbol) && this.minimalMI != null && !this.minimalMI.isSelected()) {
            this.minimalMI.setSelected(true);
            this.comprehensiveMI.setSelected(false);
            this.graphicalMI.setSelected(false);
        }
    }

    public void setSimpleMode(boolean bl) {
        if (this.adjustingMode) {
            return;
        }
        this.adjustingMode = true;
        if (this.simpleMI != null && this.simpleMI.isSelected() != bl) {
            this.simpleMI.setSelected(bl);
            this.advancedMI.setSelected(!bl);
        }
        this.simpleMode = bl;
        if (bl) {
            this.setPanelStyle("single");
            this.setActivityView(IDESymbols.VIEW_MINIMAL);
            if (this.minimalMI != null) {
                this.minimalMI.setSelected(true);
            }
        } else {
            this.applyPanelStyle(this.ideProperties.getProperty("idePanelStyle"));
            this.applyActivityView(this.ideProperties.getProperty("ideActivityView"));
        }
        this.adjustingMode = false;
    }

    public void setGraphical() {
        if (this.graphicalMI != null && !this.graphicalMI.isSelected()) {
            this.graphicalMI.setSelected(true);
            this.minimalMI.setSelected(false);
            this.comprehensiveMI.setSelected(false);
        }
    }

    public void setModelDirectory(File file) {
        this.modelDirectory = file;
    }

    public File getModelDirectory() {
        return this.modelDirectory;
    }

    private void enableView(Symbol symbol) {
        this.preferredView = symbol;
        Dimension dimension = this.getSize();
        if (this.defSequenceMI != null) {
            if (IDESymbols.VIEW_MINIMAL.equals(symbol)) {
                this.defSequenceMI.setEnabled(true);
            } else {
                this.defSequenceMI.setEnabled(false);
            }
        }
        if (this.simpleMode && !IDESymbols.VIEW_MINIMAL.equals(symbol)) {
            this.setSimpleMode(false);
        }
        ((Component)this).setSize(dimension);
        this.validate();
    }

    public void adaptDefaultMenu() {
        this.adaptMenuToAction();
    }

    private void adaptMenuToAction() {
        if (this.orderMenu == null) {
            this.orderMenu = this.makeMenu(this.editMenu, "Set Constraints");
        } else {
            this.orderMenu.setVisible(true);
        }
        if (this.sequenceItem == null) {
            this.sequenceItem = new IXToolItem(this.orderMenu, this, "makeSequence", "Put Sub-Activities in Sequence", "Put Sub-Activities in Sequence");
        }
        if (this.parallelItem == null) {
            this.parallelItem = new IXToolItem(this.orderMenu, this, "makeParallel", "Put Sub-Activities in Parallel", "Put Sub-Activities in Parallel");
        }
        this.sequenceItem.showItem();
        this.parallelItem.showItem();
        this.populateEditMenu();
        this.makeViewsMenu();
    }

    public void makeFileMenu() {
        this.openItem.setItemLabel("Open as draft domain...");
        this.openItem.setToolTip("Open an existing file as a draft domain");
        this.openItem.showItem();
        this.insertItem.showItem();
        this.clearItem.showItem();
        this.revertDItem.showItem();
        this.saveItem.setItemLabel("Save draft to file");
        this.saveItem.showItem();
        this.saveAsItem.showItem();
        this.publishItem.showItem();
        this.makeFileMenuExits();
    }

    public void makeFileMenuExits() {
        this.fileMenu.addSeparator();
        if (this.standAlone) {
            this.exitItem.showItem();
        } else {
            this.closeItem.showItem();
        }
    }

    public void makeOptionsMenu() {
    }

    public void makeEditMenu() {
        this.newEditItem.setLabel("New construct");
        this.newEditItem.setToolTip("New construct");
        this.newEditItem.makeItem();
        this.newEditItem.show();
        this.cutItem.setToolTip("Delete");
        this.cutItem.showItem();
        this.editConstructMenu = this.makeMenu(this.editMenu, "Edit Construct");
        this.editConstructMenu.setEnabled(false);
        this.copyItem.showItem();
        this.modifyItem.showItem();
        this.revertItem.showItem();
        this.revertOItem.showItem();
        this.editMenu.addSeparator();
    }

    public void makeViewMenu() {
        this.makeToolbarItem(this.viewMenu);
        this.viewMenu.addSeparator();
        this.preferredItem.showItem();
        this.makeModeMenu();
        this.makeStyleMenu(this.viewMenu);
        this.makeWindowsMenu(this.viewMenu);
    }

    public void makeModeMenu() {
        this.modeMenu = this.makeMenu(this.viewMenu, "Editor Mode");
        this.modeMenu.setMnemonic('M');
        this.simpleItem.setMenu(this.modeMenu);
        this.advancedItem.setMenu(this.modeMenu);
        if (this.simpleMI == null) {
            this.simpleMI = this.simpleItem.makeRadioItem();
        }
        if (this.advancedMI == null) {
            this.advancedMI = this.advancedItem.makeRadioItem();
        }
        this.modeGroup.add(this.simpleMI);
        this.modeGroup.add(this.advancedMI);
        this.simpleItem.showItem();
        this.advancedItem.showItem();
    }

    public void makeViewsMenu() {
        this.viewsMenu = this.makeMenu(this.viewMenu, "Activity Views");
        this.minimalItem.setMenu(this.viewsMenu);
        this.comprehensiveItem.setMenu(this.viewsMenu);
        this.graphicalItem.setMenu(this.viewsMenu);
        if (this.minimalMI == null) {
            this.minimalMI = this.minimalItem.makeRadioItem();
        }
        if (this.comprehensiveMI == null) {
            this.comprehensiveMI = this.comprehensiveItem.makeRadioItem();
        }
        if (this.graphicalMI == null) {
            this.graphicalMI = this.graphicalItem.makeRadioItem();
        }
        this.viewGroup.add(this.minimalMI);
        this.viewGroup.add(this.comprehensiveMI);
        this.viewGroup.add(this.graphicalMI);
    }

    public void makeToolsMenu() {
        this.checkItem.showItem();
        this.checkItem.setEnabled(false);
        this.toolsMenu.addSeparator();
        this.makePreferences();
    }

    public void makeHelpMenu() {
        super.makeHelpMenu();
        this.manualItem.setEnabled(false);
    }

    protected void makeToolbar() {
        this.toolBar.removeAll();
        LayoutManager layoutManager = this.toolBar.getLayout();
        this.saveItem.setButtonLabel("Save Draft");
        this.saveItem.showButtonText(true);
        this.saveItem.showButton();
        this.publishItem.showButtonText(true);
        this.publishItem.showButton();
        this.toolBar.addSeparator();
        this.newEditItem.showButtonText(true);
        this.newEditItem.showButton();
        this.cutItem.setButtonLabel("Delete");
        this.cutItem.showButtonText(true);
        this.cutItem.showButton();
        this.copyItem.showButtonText(true);
        this.copyItem.showButton();
        this.revertItem.showButtonText(true);
        this.revertItem.showButton();
        this.modifyItem.showButtonText(true);
        this.modifyItem.showButton();
    }

    public void showButtonTexts(boolean bl) {
    }

    protected void adaptMenusToPanel(JPanel jPanel) {
        if (jPanel == null) {
            return;
        }
        String string = jPanel.getName();
        this.editConstructMenu.setText("Edit " + string);
        this.newEditItem.setItemLabel("New " + string);
        this.newEditItem.setEnabled(true);
        this.newEditItem.hideItem();
        this.newEditItem.showItem();
        this.modifyItem.setItemLabel("Note " + string + " into Draft");
        this.modifyItem.setEnabled(true);
        this.modifyItem.hideItem();
        this.modifyItem.showItem();
        this.checkItem.setItemLabel("Check current " + string);
        this.checkItem.setEnabled(false);
        this.checkItem.hideItem();
        this.checkItem.showItem();
        this.populateEditMenu();
        if (jPanel.equals(this.actionPanel)) {
            this.cutItem.setItemLabel("Delete " + string);
            this.cutItem.setEnabled(true);
            this.cutItem.hide();
            this.cutItem.show();
            this.copyItem.setItemLabel("Copy " + string);
            this.copyItem.setEnabled(true);
            this.copyItem.hide();
            this.copyItem.show();
            this.revertItem.hideButton();
            this.revertItem.showButton();
            this.modifyItem.hideButton();
            this.modifyItem.showButton();
            this.toolBar.add(this.tbs);
            Component component = Box.createHorizontalGlue();
            this.toolBar.add(component);
            String string2 = "";
            try {
                string2 = this.viewGroup.getSelection().getActionCommand();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.viewGroup = new ButtonGroup();
            this.minimalMI = (JRadioButtonMenuItem)this.minimalItem.show();
            this.comprehensiveMI = (JRadioButtonMenuItem)this.comprehensiveItem.show();
            this.graphicalMI = (JRadioButtonMenuItem)this.graphicalItem.show();
            this.viewGroup.add(this.minimalMI);
            this.viewGroup.add(this.comprehensiveMI);
            this.viewGroup.add(this.graphicalMI);
            if (string2 != "" && string2 != null) {
                if (string2.equals("comprehensive")) {
                    this.comprehensiveMI.setSelected(true);
                } else if (string2.equals("graphical")) {
                    this.graphicalMI.setSelected(true);
                } else if (string2.equals("minimal")) {
                    this.minimalMI.setSelected(true);
                }
            }
            this.editMenu.add(this.orderMenu);
        } else {
            this.minimalItem.hide();
            this.comprehensiveItem.hide();
            this.graphicalItem.hide();
            this.cutItem.hide();
            this.copyItem.hide();
            this.editMenu.remove(this.orderMenu);
            this.toolBar.remove(this.tbs);
        }
    }

    protected void populateEditMenu() {
        AConstructFramePanel aConstructFramePanel = (AConstructFramePanel)this.getCurrentPanel();
        if (aConstructFramePanel != null) {
            ArrayList arrayList;
            Collection collection = aConstructFramePanel.getAllConstructs();
            if (collection != null) {
                collection = IVUtil.sortNamedCollection(collection);
                arrayList = new ArrayList(collection);
            } else {
                arrayList = new ArrayList();
            }
            UIUtil.populateMenu(this, this.editConstructMenu, "editConstruct", arrayList);
        }
    }

    protected void makePreferences() {
        this.preferencesItem = new IXToolItem(this.toolsMenu, (ActionListener)this, "preferences", "Preferences", 'P', "Edit I-DE preferences");
        this.preferencesItem.showItem();
    }

    protected void makePreferencesMenu() {
        IXToolItem iXToolItem;
        Object object;
        JMenu jMenu = this.makeMenu(this.optionsMenu, "Preferences");
        this.propModeItem = new IXToolItem(jMenu, this, "modeSimple", "Simple mode", "Set the mode to simple (tick) or advanced (no tick)");
        JCheckBoxMenuItem jCheckBoxMenuItem = this.propModeItem.makeCheckItem();
        jCheckBoxMenuItem.setState(this.simpleMode);
        this.propModeItem.showItem();
        JMenu jMenu2 = this.makeMenu(jMenu, "Preferred panel style");
        ButtonGroup buttonGroup = new ButtonGroup();
        Iterator iterator = ((AbstractList)this.getPanelStyles()).iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            iXToolItem = new IXToolItem(jMenu2, this, "prop-style-" + (String)object, (String)object, (String)object + " is the preferred style");
            jCheckBoxMenuItem = iXToolItem.makeCheckItem();
            buttonGroup.add(jCheckBoxMenuItem);
            jCheckBoxMenuItem.setState(this.preferredStyle.equals(object));
            iXToolItem.showItem();
        }
        object = this.makeMenu(jMenu, "Preferred activity view");
        buttonGroup = new ButtonGroup();
        Iterator<Symbol> iterator2 = Arrays.asList(IDESymbols.VIEWS).iterator();
        while (iterator2.hasNext()) {
            Symbol symbol = iterator2.next();
            String string = symbol.toString();
            iXToolItem = new IXToolItem((JMenu)object, this, "prop-" + string, string, string + " is the preferred activity view");
            jCheckBoxMenuItem = iXToolItem.makeCheckItem();
            buttonGroup.add(jCheckBoxMenuItem);
            jCheckBoxMenuItem.setState(this.preferredView.equals(symbol));
            iXToolItem.showItem();
        }
        this.propButtTextItem = new IXToolItem(jMenu, this, "showButtText", "Show text on toolbar buttons", "Toggle text on toolbar buttons on/off");
        jCheckBoxMenuItem = this.propButtTextItem.makeCheckItem();
        jCheckBoxMenuItem.setState(this.showButtonTexts);
        this.propButtTextItem.showItem();
        this.propEditableItem = new IXToolItem(jMenu, this, "propEditable", "Set editable", "Switch off to use the editor as a viewer only");
        jCheckBoxMenuItem = this.propEditableItem.makeCheckItem();
        jCheckBoxMenuItem.setState(this.isEditable);
        this.propEditableItem.showItem();
        this.propListTextItem = new IXToolItem(jMenu, this, "propListText", "Use text fields for lists", "Edit by typing (tick) or dialogue (no tick)");
        jCheckBoxMenuItem = this.propListTextItem.makeCheckItem();
        jCheckBoxMenuItem.setState(this.listsAsText);
        this.propListTextItem.showItem();
        this.propSaveItem = new IXToolItem(jMenu, this, "propSave", "Save the current settings", "Saved settings are used on next startup");
        this.propSaveItem.showItem();
    }

    public void saveExpansion(Refinement refinement) {
        this.setConstruct(refinement);
    }

    public void setConstruct(IXObject iXObject) {
        this.setUIConstruct(this.uiDomain.getUIObject(iXObject));
    }

    public void setUIConstruct(UIObject uIObject) {
        if ((class$ix$iview$domain$UIRefinement == null ? (class$ix$iview$domain$UIRefinement = DomainEditor.class$("ix.iview.domain.UIRefinement")) : class$ix$iview$domain$UIRefinement).isInstance(uIObject)) {
            this.setCurrentPanel(this.actionPanel);
        } else if ((class$ix$iview$domain$UIDomain == null ? (class$ix$iview$domain$UIDomain = DomainEditor.class$("ix.iview.domain.UIDomain")) : class$ix$iview$domain$UIDomain).isInstance(uIObject)) {
            this.setCurrentPanel(this.domainPanel);
        }
        AConstructFramePanel aConstructFramePanel = (AConstructFramePanel)this.getCurrentPanel();
        if (aConstructFramePanel != null) {
            aConstructFramePanel.setUIConstruct(uIObject);
        }
    }

    public void setDomain(File file) {
        try {
            DomainParser domainParser = DomainParser.makeParser(file.getPath());
            this.setDomain(domainParser.readDomain(this.uiDomain.getDomain()));
        }
        catch (FileNotFoundException fileNotFoundException) {
            JOptionPane.showMessageDialog(this, "Can't find file " + Util.quote(file.getPath()), "File not found", 0);
        }
    }

    public void setDomain(Domain domain) {
        if (this.adjustingDomain) {
            return;
        }
        this.adjustingDomain = true;
        if (domain.equals(this.getDomain())) {
            return;
        }
        UIDomain uIDomain = this.uiDomain.setDomain(domain);
        this.setUIDomain(uIDomain);
        this.adjustingDomain = false;
    }

    public void setUIDomain(UIDomain uIDomain) {
        if (this.uiDomain.equals(uIDomain)) {
            return;
        }
        this.uiDomain = uIDomain;
        this.setUIDomainListeners(uIDomain);
    }

    private void setUIDomainListeners(UIDomain uIDomain) {
        uIDomain.addUIDomainListener(this);
        uIDomain.addUIDomainListener(this.grammarPanel);
        uIDomain.addUIDomainListener(this.actionPanel);
        UIDomainEvent uIDomainEvent = new UIDomainEvent(uIDomain);
        uIDomain.fireDomainSet(uIDomain.getDomain());
    }

    public UIDomain getUIDomain() {
        return this.uiDomain;
    }

    public Domain getDomain() {
        return this.uiDomain.getDomain();
    }

    public void updateCurrentPanel(AConstructFramePanel aConstructFramePanel) {
        super.updateCurrentPanel(aConstructFramePanel);
        this.populateEditMenu();
    }

    public void setDefaultSequence(boolean bl) {
        if (this.defSequenceMI != null) {
            this.defSequenceMI.setState(bl);
        }
        this.actionPanel.setDefaultSequence(bl);
    }

    protected void userClearDomain() {
        int n = 0;
        if (!this.uiDomain.isEmpty()) {
            String[] stringArray = new String[]{"This will clear all constructs in the draft.", "Are you sure you want to do this?"};
            n = JOptionPane.showConfirmDialog(this, stringArray, "Confirm", 0);
        }
        if (n == 0) {
            this.uiDomain.clearDraft();
            this.clearPanels();
            this.setUIDomain(this.uiDomain);
        }
    }

    protected void userRevertDomain() {
        int n = 0;
        if (this.uiDomain.hasChangedConstructsFromOriginal()) {
            String[] stringArray = new String[]{"This will clear all changes to the draft (including open/insert)", "since it was last published.", "If the domain has not been published yet, it will revert to the original domain.", "Are you sure you want to do this?"};
            n = JOptionPane.showConfirmDialog(this, stringArray, "Confirm", 0);
        }
        if (n == 0) {
            this.clearPanels();
            this.uiDomain.revertToOriginal();
            this.setUIDomain(this.uiDomain);
        }
    }

    protected void userOpenDomain() {
        int n = 0;
        if (!this.uiDomain.isEmpty()) {
            String[] stringArray = new String[]{"This will clear all current domain constructs.", "Are you sure you want to do this?", "(Use 'Insert domain' to add to the current constructs)"};
            n = JOptionPane.showConfirmDialog(this, stringArray, "Confirm", 0);
        }
        if (n == 0) {
            this.clearPanels();
            this.uiDomain.loadDomain();
            this.setUIDomain(this.uiDomain);
        }
    }

    protected void userInsertDomain() {
        this.uiDomain.insertDomain();
    }

    protected File userSaveDomain() {
        ((AConstructFramePanel)this.getACurrentPanel()).beforeClosing();
        return this.uiDomain.saveDomain();
    }

    protected File userSaveDomainAs() {
        ((AConstructFramePanel)this.getACurrentPanel()).beforeClosing();
        return this.uiDomain.saveDomain(null);
    }

    protected void userPublishDomain() {
        ((AConstructFramePanel)this.getACurrentPanel()).beforeClosing();
        this.uiDomain.publishToDomain();
    }

    private void userPropSimple(boolean bl) {
        this.setSimpleMode(bl);
        if (bl) {
            this.ideProperties.setProperty("ideMode", IDESymbols.MODE_SIMPLE.toString());
        } else {
            this.ideProperties.setProperty("ideMode", IDESymbols.MODE_ADVANCED.toString());
        }
    }

    private void userPropStyle(String string) {
        if (!string.equals(this.preferredStyle)) {
            String string2 = this.preferredStyle;
            this.preferredStyle = string;
            if (!this.setPanelStyle(string)) {
                this.preferredStyle = string2;
            } else {
                this.ideProperties.setProperty("idePanelStyle", this.preferredStyle);
            }
        }
    }

    private void userPropView(Symbol symbol) {
        this.setActivityView(symbol);
        this.ideProperties.setProperty("ideActivityView", symbol.toString());
    }

    private void userPropButtText(boolean bl) {
        this.updateToolbar(bl);
        this.ideProperties.setProperty("ideShowButtonTexts", new Boolean(bl).toString());
    }

    private void userPropEditable(boolean bl) {
        this.isEditable = bl;
        this.ideProperties.setProperty("ideEditable", new Boolean(bl).toString());
    }

    private void userPropListText(boolean bl) {
        this.showListsAsTexts(bl);
        this.ideProperties.setProperty("ideListsAsTexts", new Boolean(bl).toString());
    }

    private void userPropSave() {
        this.saveProperties();
    }

    public void refinementAdded(RefinementEvent refinementEvent) {
        this.populateEditMenu();
    }

    public void constructAdded(RefinementEvent refinementEvent) {
        this.populateEditMenu();
    }

    public void constructAdded(UIDomainEvent uIDomainEvent) {
        this.populateEditMenu();
    }

    public void constructEdited(UIDomainEvent uIDomainEvent) {
        this.populateEditMenu();
    }

    public void constructRemoved(UIDomainEvent uIDomainEvent) {
        this.populateEditMenu();
    }

    public void domainCleared(UIDomainEvent uIDomainEvent) {
        this.populateEditMenu();
    }

    public void domainEdited(UIDomainEvent uIDomainEvent) {
        this.populateEditMenu();
    }

    public void domainSet(UIDomainEvent uIDomainEvent) {
        Debug.noteln("DomainEditor: got domain-set event");
        this.populateEditMenu();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent == null) {
            return;
        }
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("all")) {
            this.updateIDEFromProperties();
            return;
        }
        Object object = propertyChangeEvent.getOldValue();
        String string2 = (String)propertyChangeEvent.getNewValue();
        if (object != null && object.equals(string2)) {
            return;
        }
        Debug.note("IDE: got property change for " + string);
        Debug.noteln(" - old: " + object.toString() + " new:", string2);
        if (string.equals("idePanelStyle")) {
            this.applyPanelStyle(string2);
        } else if (string.equals("ideActivityView")) {
            this.applyActivityView(string2);
        } else if (string.equals("ideShowButtonTexts")) {
            this.applyButtonTexts(string2);
        } else if (string.equals("ideEditable")) {
            this.applyEditable(string2);
        } else if (string.equals("ideListsAsTexts")) {
            this.applyListsAsTexts(string2);
        } else if (string.equals("ideConstraints")) {
            this.applyConstraintsView(string2);
        } else if (string.equals("ideMode")) {
            this.applyMode(string2);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = ((AbstractButton)object).getActionCommand();
        Debug.noteln("Domain Editor: action command is", string);
        if (string.equals("close")) {
            this.userClose();
        } else if (string.equals("clearDom")) {
            this.userClearDomain();
        } else if (string.equals("open")) {
            this.userOpenDomain();
        } else if (string.equals("revertDom")) {
            this.userRevertDomain();
        } else if (string.equals("insert")) {
            this.userInsertDomain();
        } else if (string.equals("save")) {
            this.userSaveDomain();
        } else if (string.equals("saveAs")) {
            this.userSaveDomainAs();
        } else if (string.equals("publish")) {
            this.userPublishDomain();
        } else if (string.equals("preferences")) {
            this.userPreferences();
        } else if (string.equals("modeSimple")) {
            this.userPropSimple(((JCheckBoxMenuItem)object).getState());
        } else if (string.equals("preferred")) {
            this.updateIDEFromProperties();
        } else if (string.equals("simple")) {
            this.setSimpleMode(true);
        } else if (string.equals("advanced")) {
            this.setSimpleMode(false);
        } else if (string.startsWith("prop-style-")) {
            String string2 = string.substring(11);
            Debug.noteln("Got prop style", string2);
            this.userPropStyle(string2);
        } else if (string.equals("prop-view-minimal")) {
            this.userPropView(IDESymbols.VIEW_MINIMAL);
        } else if (string.equals("prop-view-comprehensive")) {
            this.userPropView(IDESymbols.VIEW_COMPREHENSIVE);
        } else if (string.equals("prop-view-graphical")) {
            this.userPropView(IDESymbols.VIEW_GRAPHICAL);
        } else if (string.equals("showButtText")) {
            this.userPropButtText(((JCheckBoxMenuItem)object).getState());
        } else if (string.equals("propEditable")) {
            this.userPropEditable(((JCheckBoxMenuItem)object).getState());
        } else if (string.equals("propListText")) {
            this.userPropListText(((JCheckBoxMenuItem)object).getState());
        } else if (string.equals("propSave")) {
            this.userPropSave();
        } else if (string.equals("manual")) {
            this.userManual();
        } else if (string.equals("help")) {
            this.userHelp();
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    private boolean userCheckConstruct() {
        AConstructFramePanel aConstructFramePanel = (AConstructFramePanel)this.getCurrentPanel();
        if (aConstructFramePanel != null) {
            return aConstructFramePanel.checkConstruct();
        }
        return true;
    }

    private void closeIDE() {
        if (this.standAlone) {
            System.exit(0);
        } else {
            ((Component)this).setVisible(false);
        }
    }

    public void exitApplication() {
        this.userClose();
    }

    public boolean userClose() {
        if (this.helpFrame != null) {
            ((Component)this.helpFrame).setVisible(false);
        }
        if (this.closePanels()) {
            if (this.uiDomain.hasChangedAllFromOriginal()) {
                Object object;
                if (this.standAlone) {
                    String string = "Do you want to save unsaved changes?";
                    int n = JOptionPane.showConfirmDialog(this, string, "", 1, 3);
                    if (n == 2) {
                        return false;
                    }
                    object = n == 1 ? "Exit" : (n == 0 ? "Save" : null);
                } else {
                    String string = "Do you want to save/publish changes?";
                    Object[] objectArray = new Object[]{"Save and Publish", "Save", "Publish", "Close only"};
                    object = JOptionPane.showInputDialog(this, string, "", 3, null, objectArray, objectArray[0]);
                }
                if (object == null) {
                    return false;
                }
                if (object.equals("Save")) {
                    this.uiDomain.saveDomain();
                } else if (object.equals("Publish")) {
                    this.uiDomain.publishToDomain();
                } else if (object.equals("Save and Publish")) {
                    this.uiDomain.saveDomain();
                    this.uiDomain.publishToDomain();
                }
            }
            this.closeIDE();
            return true;
        }
        return false;
    }

    private void userManual() {
        UIUtil.notImplemented(this, "The user manual");
    }

    private void userHelp() {
        this.ensureHelpFrame();
        ((Component)this.helpFrame).setVisible(true);
    }

    public void aboutDialog() {
        String[] stringArray = new String[]{"About " + this.getTitle(), IVUtil.releaseToString(), IVUtil.ideReleaseToString()};
        JOptionPane.showMessageDialog(this, stringArray, "About " + this.getTitle(), 1);
    }

    private void userPreferences() {
        try {
            this.ensurePreferencesDialog();
            this.preferencesDialog.show();
        }
        catch (Exception exception) {
            Debug.noteException(exception);
        }
    }

    private void ensurePreferencesDialog() {
        if (this.preferencesDialog == null) {
            this.preferencesDialog = new IDEPreferencesDialog(this, this.ideProperties);
            this.preferencesDialog.setModal(true);
            this.preferencesDialog.addPropertyChangeListener(this);
        }
    }

    public static void main(String[] stringArray) {
        File file = new File("domain-library");
        DomainEditor domainEditor = new DomainEditor(true);
        domainEditor.setModelDirectory(file);
        ((Component)domainEditor).setVisible(true);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class IXWindow
    extends WindowAdapter {
        IXWindow() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            DomainEditor.this.userClose();
        }
    }
}

