/*
 * Decompiled with CFR 0.152.
 */
package ix.iview;

import ix.iview.ConstraintListener;
import ix.util.Debug;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.AbstractCollection;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public abstract class ConstraintEditor
extends JFrame
implements MouseListener {
    protected JPanel mainPanel = new JPanel();
    protected Component relsBox;
    protected Component butBox;
    protected JButton okBut = new JButton("Ok");
    protected JButton cancelBut = new JButton("Cancel");
    protected JButton moreBut = new JButton("Add More");
    protected JLabel label;
    protected ArrayList constraintListeners = new ArrayList();
    public Object currentObject;
    protected Object original;

    public ConstraintEditor(String string, String string2) {
        super(string);
        GridBagConstraints gridBagConstraints;
        Debug.noteln("CE: making constraint editor");
        ((Component)this).setSize(405, 175);
        this.mainPanel.setLayout(new GridBagLayout());
        this.getContentPane().add(this.mainPanel);
        this.mainPanel.setBounds(0, 0, 500, 300);
        this.relsBox = this.makeRels();
        this.butBox = this.makeButs();
        if (string2 != "") {
            this.label = new JLabel(string2);
            gridBagConstraints = new GridBagConstraints(0, 0, 0, 1, 0.0, 0.0, 18, 0, new Insets(0, 4, 0, 0), 0, 0);
            this.mainPanel.add((Component)this.label, gridBagConstraints);
        }
        gridBagConstraints = new GridBagConstraints(0, 1, 0, 1, 1.0, 1.0, 18, 1, new Insets(0, 4, 0, 0), 0, 0);
        this.mainPanel.add(this.relsBox, gridBagConstraints);
        this.mainPanel.add(new JSeparator());
        gridBagConstraints = new GridBagConstraints(0, 2, 0, 1, 0.0, 0.0, 16, 2, new Insets(0, 4, 0, 0), 0, 0);
        this.mainPanel.add(this.butBox, gridBagConstraints);
        this.invalidate();
        this.pack();
        ((Component)this).setVisible(false);
    }

    public ConstraintEditor(String string) {
        this("Constraint Editor", string);
    }

    public ConstraintEditor(String string, String string2, Object object) {
        this(string, string2);
        try {
            this.setObject(object);
        }
        catch (NullPointerException nullPointerException) {
            JOptionPane.showMessageDialog(this, ((Throwable)nullPointerException).getMessage());
            return;
        }
        this.pack();
        ((Component)this).setVisible(true);
    }

    private Component makeButs() {
        this.okBut.addMouseListener(this);
        this.cancelBut.addMouseListener(this);
        this.moreBut.addMouseListener(this);
        Box box = new Box(0);
        box.add(Box.createGlue());
        box.add(this.okBut);
        box.add(this.cancelBut);
        box.add(this.moreBut);
        box.add(Box.createGlue());
        return box;
    }

    public boolean isEditing() {
        return this.original != null;
    }

    public void setMessage(String string) {
        if (this.label != null) {
            this.label.setText(string);
        }
    }

    public void setObject(Object object) throws NullPointerException {
        if (object == null) {
            return;
        }
        this.currentObject = object;
        this.initFromObject();
    }

    public void setOriginal(Object object) {
        this.original = object;
    }

    public void start(Point point) {
        ((Component)this).setLocation(point);
        this.start();
    }

    public void start() {
        ((Component)this).setVisible(true);
    }

    public void start(Object object, Point point) {
        ((Component)this).setLocation(point);
        this.start(object);
    }

    public boolean start(Object object) {
        try {
            this.original = null;
            this.setObject(object);
            this.start();
            return true;
        }
        catch (NullPointerException nullPointerException) {
            JOptionPane.showMessageDialog(this, ((Throwable)nullPointerException).getMessage());
            return false;
        }
    }

    public void start(Object object, Object object2, Point point) {
        ((Component)this).setLocation(point);
        this.start(object, object2);
    }

    public void start(Object object, Object object2) {
        if (this.start(object)) {
            this.setOriginal(object2);
            this.setFromObject(object2);
            this.moreBut.setEnabled(false);
        }
    }

    public void addConstraintListener(ConstraintListener constraintListener) {
        this.constraintListeners.add(constraintListener);
    }

    public void removeConstraintListener(ConstraintListener constraintListener) {
        while (this.constraintListeners.contains(constraintListener)) {
            ((AbstractCollection)this.constraintListeners).remove(constraintListener);
        }
    }

    private boolean processConstraint() {
        Object object = this.collectConstraint();
        if (object == null) {
            return false;
        }
        if (object == this.original) {
            object = null;
        }
        if (this.constraintListeners == null) {
            return true;
        }
        int n = 0;
        while (n < this.constraintListeners.size()) {
            ConstraintListener constraintListener = (ConstraintListener)this.constraintListeners.get(n);
            constraintListener.gotConstraint(this.currentObject, object);
            ++n;
        }
        return true;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.cancelBut) {
            this.closeEditor();
            return;
        }
        if (mouseEvent.getSource() == this.okBut) {
            if (this.processConstraint()) {
                this.closeEditor();
            }
            return;
        }
        if (mouseEvent.getSource() == this.moreBut) {
            this.processConstraint();
            this.moreInitFromObject();
            return;
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void closeEditor() {
        ((Component)this).setVisible(false);
        this.original = null;
        this.currentObject = null;
        this.moreBut.setEnabled(true);
    }

    public void moreInitFromObject() {
        this.initFromObject();
    }

    protected abstract Component makeRels();

    protected abstract void initFromObject();

    protected abstract void setFromObject(Object var1);

    protected abstract Object collectConstraint();
}

