/*
 * Decompiled with CFR 0.152.
 */
package ix.iview;

import ix.icore.domain.Constraint;
import ix.icore.domain.Refinement;
import ix.iface.domain.LTF_Parser;
import ix.iface.domain.SyntaxException;
import ix.iface.ui.IXButPanel;
import ix.iface.ui.ListEditorPanel;
import ix.iview.ConstraintEditor;
import ix.iview.NodeNumberRenderer;
import ix.iview.domain.UIRefinement;
import ix.iview.util.IVUtil;
import ix.util.Strings;
import ix.util.lisp.LList;
import ix.util.lisp.Lisp;
import ix.util.lisp.Symbol;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class ConditionEffectEditor
extends ConstraintEditor {
    protected JList actList;
    protected JRadioButton condBut;
    protected JRadioButton effBut;
    private ButtonGroup group;
    protected JTextField statement;
    LTF_Parser constraintParser = new LTF_Parser();

    public ConditionEffectEditor() {
        super("Condition/Effect Editor", "Please specify a condition or an effect");
    }

    public ConditionEffectEditor(UIRefinement uIRefinement) {
        this();
        this.setObject(uIRefinement);
    }

    protected Component makeRels() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.actList = new JList();
        ListEditorPanel listEditorPanel = this.makeActPanel(this.actList);
        JLabel jLabel = new JLabel("Statement (pattern = value)");
        this.statement = new JTextField();
        this.condBut = new JRadioButton("Condition", true);
        this.effBut = new JRadioButton("Effect", false);
        this.condBut.setActionCommand("Condition");
        this.effBut.setActionCommand("Effect");
        Object[] objectArray = new Object[]{this.condBut, this.effBut};
        IXButPanel iXButPanel = new IXButPanel(this, 0, objectArray);
        iXButPanel.setButtonGroup(true);
        this.group = iXButPanel.group;
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 2, 0, 2), 0, 0);
        jPanel.add((Component)iXButPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 2), 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 2, 0, 2), 0, 0);
        jPanel.add((Component)this.statement, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 3, 1, 2, 1.0, 1.0, 17, 1, new Insets(0, 2, 0, 2), 0, 0);
        jPanel.add((Component)listEditorPanel, gridBagConstraints);
        return jPanel;
    }

    private ListEditorPanel makeActPanel(JList jList) {
        ListEditorPanel listEditorPanel = new ListEditorPanel((MouseListener)this, "Activity", jList);
        jList.setAutoscrolls(true);
        jList.setSelectionMode(0);
        jList.setCellRenderer(new NodeNumberRenderer(false));
        return listEditorPanel;
    }

    public void moreInitFromObject() throws NullPointerException {
        boolean bl = this.effBut.isSelected();
        this.initFromObject();
        if (bl) {
            this.effBut.setSelected(true);
        }
    }

    protected void initFromObject() throws NullPointerException {
        this.statement.setText("");
        this.condBut.setSelected(true);
        UIRefinement uIRefinement = (UIRefinement)this.currentObject;
        if (uIRefinement == null) {
            return;
        }
        List list = uIRefinement.getNodes();
        list.add(0, uIRefinement);
        this.makeActList(this.actList, list.toArray());
        this.actList.clearSelection();
        this.actList.setSelectedIndex(0);
        list.remove(0);
        this.statement.requestFocus();
    }

    protected void setFromObject(Object object) {
        this.actList.clearSelection();
        this.statement.setText("");
        if (object == null) {
            return;
        }
        if (!(object instanceof Constraint)) {
            String string = "Condition/Effect editor can only deal with constraints not objects of class " + object.getClass().getName();
            JOptionPane.showMessageDialog(this, string);
            return;
        }
        Constraint constraint = (Constraint)object;
        if (constraint.getType() != Refinement.S_WORLD_STATE) {
            String string = "Condition/Effect editor cannot deal with constraints Of type " + constraint.getType().toString();
            JOptionPane.showMessageDialog(this, string);
            return;
        }
        this.actList.clearSelection();
        this.actList.setSelectedIndex(0);
        this.condBut.setSelected(constraint.getRelation() != Refinement.S_EFFECT);
        this.effBut.setSelected(constraint.getRelation() == Refinement.S_EFFECT);
        this.statement.setText(IVUtil.printConstraintParameters(constraint));
        this.statement.requestFocus();
    }

    private void makeActList(JList jList, Object[] objectArray) {
        jList.removeAll();
        jList.setListData(objectArray);
    }

    protected Object collectConstraint() {
        Object e = this.actList.getSelectedValue();
        ButtonModel buttonModel = this.group.getSelection();
        String string = buttonModel.getActionCommand();
        Symbol symbol = string.equals("Effect") ? Refinement.S_EFFECT : Refinement.S_CONDITION;
        String string2 = this.statement.getText().trim();
        Constraint constraint = this.readCondition(symbol, string2);
        if (this.isEditing()) {
            Constraint constraint2 = (Constraint)this.original;
            constraint2.setRelation(symbol);
            constraint2.setParameters(constraint.getParameters());
            return constraint2;
        }
        return constraint;
    }

    protected String ensureParenthesized(String string) {
        if (string.startsWith("(") && string.endsWith(")")) {
            return string;
        }
        return "(" + string + ")";
    }

    protected Constraint readCondition(Symbol symbol, String string) throws SyntaxException {
        String string2;
        LList lList;
        Constraint constraint;
        String[] stringArray = Strings.breakAtFirst("=", string);
        String string3 = this.ensureParenthesized(stringArray[0].trim());
        String string4 = stringArray[1].trim();
        if (string4.equals("")) {
            string4 = "true";
        }
        if ((constraint = this.constraintParser.parseConstraint(lList = (LList)Lisp.readFromString(string2 = "(world-state " + symbol.toString() + " " + string3 + " = " + string4 + ")"))) == null) {
            throw new SyntaxException("Invalid constraint: " + Strings.quote(string));
        }
        return constraint;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.actList) {
            int n = this.actList.getSelectedIndex();
            if (n != 0) {
                String string = "Sofar, conditions and effects can only be attached to refinements (i.e. self)";
                JOptionPane.showMessageDialog(this, string);
                this.actList.setSelectedIndex(0);
            }
        } else {
            super.mouseClicked(mouseEvent);
        }
    }
}

