/*
 * Decompiled with CFR 0.152.
 */
package ix.iview;

import ix.icore.IXObject;
import ix.icore.Issue;
import ix.icore.domain.Constraint;
import ix.icore.domain.End;
import ix.icore.domain.Named;
import ix.icore.domain.NodeEndRef;
import ix.icore.domain.NodeSpec;
import ix.icore.domain.Ordering;
import ix.icore.domain.SchemaTerms;
import ix.icore.domain.event.RefinementEvent;
import ix.iface.ui.IFormModel;
import ix.iface.ui.IXEditorPanel;
import ix.iface.ui.IXRenderer;
import ix.iface.ui.table.IXTreeTable;
import ix.iface.ui.util.UIUtil;
import ix.iview.AConstructFramePanel;
import ix.iview.ActionFormModel;
import ix.iview.ActionFormPanel;
import ix.iview.ConditionEffectEditor;
import ix.iview.ConstraintListener;
import ix.iview.ConstructEditing;
import ix.iview.ConstructFraming;
import ix.iview.DefaultConstraintEditor;
import ix.iview.DomainEditor;
import ix.iview.FullNodeRenderer;
import ix.iview.IDESymbols;
import ix.iview.IssueRenderer;
import ix.iview.MiniConstraintPanel;
import ix.iview.NodeNameRenderer;
import ix.iview.OrderingEditor;
import ix.iview.SpecEditor;
import ix.iview.domain.UINodeSpec;
import ix.iview.domain.UIObject;
import ix.iview.domain.UIRefinement;
import ix.iview.domain.UISpec;
import ix.iview.domain.event.UIDomainEvent;
import ix.iview.domain.event.UIDomainListener;
import ix.iview.event.CurrentActionListener;
import ix.iview.igraph.GExpansionEditor;
import ix.iview.table.ActionTreeTableModel;
import ix.iview.table.ShortActionTreeTableModel;
import ix.iview.util.IDEUtil;
import ix.util.Debug;
import ix.util.Name;
import ix.util.lisp.LList;
import ix.util.lisp.LListCollector;
import ix.util.lisp.Lisp;
import ix.util.lisp.Symbol;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class ActionEditorPanel
extends AConstructFramePanel
implements ConstructFraming,
ConstraintListener,
ActionListener,
UIDomainListener,
CurrentActionListener,
IDESymbols {
    private IXEditorPanel miniConstraintsPanel;
    private IXEditorPanel nodesTextPanel;
    private boolean minimalView = false;
    private IXRenderer fullNodeRenderer = new FullNodeRenderer(false);
    private IXRenderer miniNodeRenderer = new NodeNameRenderer(false);
    private IXRenderer fullIssueRenderer = new IssueRenderer(false);
    private IXRenderer miniIssueRenderer = new IssueRenderer(false);
    private boolean sequence = true;
    public OrderingEditor orderingEditor;
    public ConditionEffectEditor conditionEditor;
    public DefaultConstraintEditor constraintEditor;
    public SpecEditor specEditor;
    private JSplitPane actionSplit = new JSplitPane(1);
    private JScrollPane scrollTree = new JScrollPane();
    private IXTreeTable actionTree;
    private ActionTreeTableModel treeModel;
    IFormModel formModel;
    ConstructEditing currentPanel;
    private Point mousePoint = new Point(100, 100);
    private Symbol currentView = IDESymbols.VIEW_MINIMAL;
    private Symbol formView = IDESymbols.VIEW_MINIMAL;
    private boolean graphMode = false;
    GExpansionEditor graphPanel;
    int comprehensiveConstrIndex = 3;
    List comprehensiveFields = new ArrayList();
    List minimalFields = new ArrayList();
    private boolean updatingView = false;
    String lineSeparator = System.getProperty("line.separator");
    private UIRefinement uiConstruct;
    HashSet actionListeners = new HashSet();
    static /* synthetic */ Class class$ix$iview$domain$UIObject;

    public ActionEditorPanel(DomainEditor domainEditor, Symbol symbol, Symbol symbol2) {
        super(domainEditor);
        this.currentPanel = (ActionFormPanel)this.formPanel;
        this.setupActionTree();
        this.formModel = new ActionFormModel(domainEditor);
        String[] stringArray = new String[]{"pattern", "issues", "nodes", "orderings", "conditions", "constraints", "comments"};
        this.comprehensiveFields.addAll(Arrays.asList(stringArray));
        String[] stringArray2 = new String[]{"pattern", "issues", "nodes", "miniConstraints", "comments"};
        this.minimalFields.addAll(Arrays.asList(stringArray2));
        this.setConstraintsView(symbol2);
        this.enableComprehensive();
        String[] stringArray3 = new String[]{"name"};
        this.formModel.setNameFields(stringArray3);
        this.formPanel.setModel(this.formModel);
        EdMouseAdapter edMouseAdapter = new EdMouseAdapter();
        this.formPanel.addFormMouseListener(edMouseAdapter);
        this.setCurrentView(symbol);
        this.newConstruct();
    }

    protected JPanel setupMainPanel() {
        this.formPanel = new ActionFormPanel(this);
        this.graphPanel = new GExpansionEditor(this);
        return this.formPanel;
    }

    protected void setupActionTree() {
        this.actionSplit.setRightComponent(this.scrollPane);
        this.actionSplit.setLeftComponent(this.scrollTree);
        this.add((Component)this.actionSplit, "Center");
        JPanel jPanel = new JPanel();
        this.scrollTree.add(jPanel);
        this.treeModel = new ShortActionTreeTableModel(this.getUIDomain());
        this.actionTree = new IXTreeTable(this.treeModel);
        this.actionTree.addMouseListener(new ActionTableMouser());
        this.actionTree.setPreferredScrollableViewportSize(new Dimension(50, 500));
        this.scrollTree.getViewport().add(this.actionTree);
        this.actionSplit.setOneTouchExpandable(true);
        this.actionSplit.setDividerLocation(170);
    }

    protected void setPanel(ConstructEditing constructEditing) {
        Dimension dimension = this.parent.getSize();
        if (this.currentPanel != null) {
            ((JPanel)((Object)this.currentPanel)).setVisible(false);
            this.scrollPane.getViewport().remove((JPanel)((Object)this.currentPanel));
        }
        this.scrollPane.getViewport().add((JPanel)((Object)constructEditing));
        this.currentPanel = constructEditing;
        this.mainPanel = (JPanel)((Object)constructEditing);
        ((JPanel)((Object)constructEditing)).setVisible(true);
        this.scrollPane.invalidate();
        ((Component)this.parent).setSize(dimension);
        this.parent.validate();
    }

    public void updateToolbar(boolean bl) {
        if (this.graphPanel != null) {
            this.graphPanel.newGNodeItem.showButtonText(bl);
            this.graphPanel.deleteGNodesItem.showButtonText(bl);
            this.graphPanel.layoutItem.showButtonText(bl);
        }
    }

    public boolean isComprehensive() {
        return this.formView.equals(IDESymbols.VIEW_COMPREHENSIVE);
    }

    public Symbol getActivityView() {
        return this.currentView;
    }

    public void setCurrentView(Symbol symbol) {
        if (symbol.equals(this.currentView)) {
            return;
        }
        if (!this.beforeSwitching()) {
            return;
        }
        if (symbol.equals(IDESymbols.VIEW_GRAPHICAL)) {
            this.updatingView = true;
            if (!this.graphMode) {
                this.setPanel(this.graphPanel);
                this.graphMode = true;
                this.currentView = symbol;
                this.parent.setActivityView(symbol);
                this.setUIConstructPanel(this.uiConstruct);
            }
            this.updatingView = false;
        } else if (this.graphMode) {
            this.updatingView = true;
            this.setPanel((ActionFormPanel)this.formPanel);
            this.graphMode = false;
            this.currentView = symbol;
            if (!this.formView.equals(symbol)) {
                this.formView = symbol;
                this.enableComprehensive();
            } else {
                this.setUIConstructPanel(this.uiConstruct);
                this.invalidate();
                this.validate();
            }
            this.parent.setActivityView(symbol);
            this.updatingView = false;
        } else if (!this.formView.equals(symbol)) {
            this.updatingView = true;
            this.formView = symbol;
            this.currentView = symbol;
            this.enableComprehensive();
            this.parent.setActivityView(symbol);
            this.updatingView = false;
        }
    }

    public void setConstraintsView(Symbol symbol) {
        int n = this.comprehensiveFields.indexOf("constraints");
        if (n != -1) {
            this.comprehensiveFields.remove(n);
        }
        if ((n = this.comprehensiveFields.indexOf("conditions")) != -1) {
            this.comprehensiveFields.remove(n);
        }
        if ((n = this.comprehensiveFields.indexOf("orderings")) != -1) {
            this.comprehensiveFields.remove(n);
        }
        if (IDEUtil.showOther(symbol)) {
            this.comprehensiveFields.add(this.comprehensiveConstrIndex, "constraints");
        }
        if (IDEUtil.showConditions(symbol)) {
            this.comprehensiveFields.add(this.comprehensiveConstrIndex, "conditions");
        }
        if (IDEUtil.showOrder(symbol)) {
            this.comprehensiveFields.add(this.comprehensiveConstrIndex, "orderings");
        }
        this.setComprehensiveFields(this.isComprehensive(), this.uiConstruct);
    }

    public boolean isSequenceSet() {
        return ((ActionFormPanel)this.formPanel).isSequenceSet();
    }

    public void setDefaultSequence(boolean bl) {
        if (bl == this.sequence) {
            return;
        }
        this.sequence = bl;
    }

    public static boolean orderingsAreSequential(LList lList, LList lList2) {
        HashSet hashSet = new HashSet(ActionEditorPanel.makeSequence(lList));
        return new HashSet(lList2).equals(hashSet);
    }

    public void setOrdering(boolean bl) {
        if (bl) {
            this.makeSequence();
        } else {
            this.makeParallel();
        }
    }

    public void makeSequence() {
        try {
            this.uiConstruct.setOrderings(ActionEditorPanel.makeSequence(this.uiConstruct.getNodes()));
            this.setOrderings();
        }
        catch (Exception exception) {
            Debug.noteException(exception);
        }
    }

    public static List makeSequence(List list) {
        NodeSpec nodeSpec = null;
        End end = End.END;
        End end2 = End.BEGIN;
        LListCollector lListCollector = new LListCollector();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            NodeSpec nodeSpec2 = (NodeSpec)iterator.next();
            if (nodeSpec != null) {
                Ordering ordering = new Ordering(new NodeEndRef(end, nodeSpec.getId()), new NodeEndRef(end2, nodeSpec2.getId()));
                lListCollector.add(ordering);
            }
            nodeSpec = nodeSpec2;
        }
        return lListCollector;
    }

    public void makeParallel() {
        this.clearOrderings();
    }

    private void enableComprehensive() {
        this.setComprehensiveFields(this.isComprehensive(), this.uiConstruct);
    }

    private void setComprehensiveFields(boolean bl, UIRefinement uIRefinement) {
        if (bl) {
            this.formPanel.unsetSimpleField("nodes");
            this.formPanel.unsetSimpleField("issues");
            this.formPanel.setRenderer("nodes", this.fullNodeRenderer);
            this.formPanel.setRenderer("issues", this.fullIssueRenderer);
            this.formModel.setDisplayFields(this.comprehensiveFields);
        } else {
            this.formPanel.setSimpleField("nodes");
            this.formPanel.setSimpleField("issues");
            this.formPanel.setRenderer("nodes", this.miniNodeRenderer);
            this.formPanel.setRenderer("issues", this.miniIssueRenderer);
            this.formModel.setDisplayFields(this.minimalFields);
        }
        if (uIRefinement != null) {
            this.setUIConstructPanel(uIRefinement);
        }
        this.uiConstruct = uIRefinement;
        this.invalidate();
        this.validate();
    }

    public void ensureRelationEditor() {
        if (this.orderingEditor == null) {
            this.orderingEditor = new OrderingEditor();
            this.orderingEditor.addConstraintListener(this);
            ((Component)this.orderingEditor).setVisible(false);
        }
    }

    public void ensureConditionEditor() {
        if (this.conditionEditor == null) {
            this.conditionEditor = new ConditionEffectEditor();
            this.conditionEditor.addConstraintListener(this);
            ((Component)this.conditionEditor).setVisible(false);
        }
    }

    public void ensureConstraintEditor() {
        if (this.constraintEditor == null) {
            this.constraintEditor = new DefaultConstraintEditor();
            this.constraintEditor.addConstraintListener(this);
            ((Component)this.constraintEditor).setVisible(false);
        }
    }

    public void ensureSpecEditor(String string) {
        if (this.specEditor == null) {
            this.specEditor = new SpecEditor(string);
            this.specEditor.addConstraintListener(this);
            ((Component)this.specEditor).setVisible(false);
        }
        this.specEditor.setType(string);
    }

    public void ensureSpecEditor(String string, String string2) {
        this.ensureSpecEditor(string);
        this.specEditor.setMessage(string2);
    }

    private Point getEditorLocation() {
        Point point = this.getLocation();
        Point point2 = this.parent.getLocation();
        point.translate((int)point2.getX(), (int)point2.getY());
        Point point3 = new Point(point);
        point3.translate((int)this.mousePoint.getX(), (int)this.mousePoint.getY());
        return point3;
    }

    public boolean beforeClosing() {
        if (this.specEditor != null) {
            ((Component)this.specEditor).setVisible(false);
        }
        if (this.orderingEditor != null) {
            ((Component)this.orderingEditor).setVisible(false);
        }
        if (this.conditionEditor != null) {
            ((Component)this.conditionEditor).setVisible(false);
        }
        if (this.constraintEditor != null) {
            ((Component)this.constraintEditor).setVisible(false);
        }
        return this.beforeSwitching();
    }

    public void setUIConstruct(UIObject uIObject) {
        if (this.beforeSwitching()) {
            this.setUIConstructPanel(uIObject);
        }
    }

    public void setUIConstructPanel(UIObject uIObject) {
        UIRefinement uIRefinement = this.uiConstruct;
        this.uiConstruct = (UIRefinement)uIObject;
        this.currentPanel.setUIConstruct(this.uiConstruct);
        this.updateTreeSelection();
        this.fireCurrentActionChanged(uIRefinement, this.uiConstruct);
    }

    public void setUIConstructOnly(UIObject uIObject) {
        this.uiConstruct = (UIRefinement)uIObject;
        this.updateTreeSelection();
    }

    public void clearUIConstruct() {
        this.uiConstruct = new UIRefinement(this.parent.uiDomain);
        this.setUIConstructPanel(this.uiConstruct);
        this.graphPanel.setUIConstruct(this.uiConstruct);
        ((ConstructEditing)((Object)this.formPanel)).setUIConstruct(this.uiConstruct);
    }

    public UIRefinement makeNewRefinement(String string, LList lList) {
        UIRefinement uIRefinement = new UIRefinement(this.parent.getUIDomain());
        uIRefinement.setName(string);
        uIRefinement.setPattern(lList);
        return uIRefinement;
    }

    public ArrayList getAllExpansions(NodeSpec nodeSpec) {
        if (this.parent.uiDomain == null) {
            return null;
        }
        LList lList = nodeSpec.getPattern();
        Set set = this.parent.uiDomain.getMatchingRefinements(lList);
        return new ArrayList(set);
    }

    protected UIObject noteConstruct() {
        if (this.uiConstruct == null) {
            this.uiConstruct = new UIRefinement(this.parent.uiDomain);
        }
        this.currentPanel.saveToObject(this.uiConstruct);
        this.uiConstruct.noteChange();
        if (!this.parent.getUIDomain().equals(this.uiConstruct.getUIDomain())) {
            this.uiConstruct.moveToUIDomain(this.parent.getUIDomain());
        }
        this.parent.getUIDomain().updateConstruct(this.uiConstruct);
        return this.uiConstruct;
    }

    private void setChildren() {
        this.formPanel.displayFieldData("nodes");
    }

    private void setIssues() {
        this.formPanel.displayFieldData("issues");
    }

    private void setOrderings() {
        if (this.isComprehensive()) {
            this.formPanel.displayFieldData("orderings");
        } else if (this.graphMode) {
            this.graphPanel.displayFieldData("orderings");
        } else {
            this.formPanel.displayFieldData("miniConstraints");
        }
    }

    private void setConditions() {
        this.formPanel.displayFieldData("conditions");
    }

    private void setConstraints() {
        this.formPanel.displayFieldData("constraints");
    }

    protected void resetUIConstruct(UIObject uIObject) {
        if (this.currentView.equals(IDESymbols.VIEW_MINIMAL)) {
            MiniConstraintPanel miniConstraintPanel = (MiniConstraintPanel)this.formPanel.getFieldBit("miniConstraints");
            AbstractButton abstractButton = miniConstraintPanel.getLast();
            this.setUIConstruct(uIObject);
            this.formPanel.setFieldData("miniConstraints", abstractButton.getText());
        } else {
            this.setUIConstruct(uIObject);
        }
    }

    public boolean checkConstruct() {
        ActionEditorPanel.notImp("Checking activities");
        return true;
    }

    public void newConstruct() {
        this.setUIConstruct(new UIRefinement(this.parent.uiDomain));
    }

    public void deleteConstruct() {
        this.parent.getUIDomain().removeConstruct(this.uiConstruct);
        this.setUIConstruct(new UIRefinement(this.parent.uiDomain));
    }

    public void copyConstruct() {
        if (!this.uiConstruct.isEmpty() && this.beforeSwitching()) {
            UIRefinement uIRefinement = this.uiConstruct.cloneThis();
            String string = JOptionPane.showInputDialog("Please enter the new name");
            uIRefinement.setName(string);
            uIRefinement.saveToDomain();
            this.parent.uiDomain.addConstruct(uIRefinement);
            this.setUIConstructPanel(uIRefinement);
        }
    }

    public UIObject makeNewConstruct() {
        return new UIRefinement(this.parent.uiDomain);
    }

    public void saveConstruct() {
        this.noteConstruct();
        this.setUIConstructPanel(this.uiConstruct);
    }

    public void revertConstruct() {
        this.uiConstruct.loadFromDomain();
        this.setUIConstructPanel(this.uiConstruct);
    }

    public void revertOConstruct() {
        this.uiConstruct.loadFromOriginal();
        this.setUIConstructPanel(this.uiConstruct);
    }

    public List getAllConstructs() {
        if (this.parent.uiDomain == null) {
            return null;
        }
        List list = this.parent.uiDomain.getAllRefinements();
        return new ArrayList(list);
    }

    public Named getNamedConstruct(String string) {
        if (this.parent.getUIDomain() == null) {
            return null;
        }
        Object object = this.parent.getUIDomain().getNamedRefinement(string);
        if (object != null && (class$ix$iview$domain$UIObject == null ? (class$ix$iview$domain$UIObject = ActionEditorPanel.class$("ix.iview.domain.UIObject")) : class$ix$iview$domain$UIObject).isInstance(object)) {
            return (Named)object;
        }
        return this.parent.getUIDomain().newUIObject((IXObject)object);
    }

    public void userMakeSequence() {
        this.makeSequence();
    }

    public void userMakeParallel() {
        this.makeParallel();
    }

    private void userAddChild() {
        this.ensureSpecEditor("sub-activity", "Please enter the pattern of the sub-activity.");
        this.specEditor.start(this.getEditorLocation());
    }

    private void userAddIssue() {
        this.ensureSpecEditor("issue", "Please enter the pattern of the issue.");
        this.specEditor.start(this.getEditorLocation());
    }

    public void noteTextNodes() {
        JTextArea jTextArea = (JTextArea)this.nodesTextPanel.getItemComponent();
        List list = UIRefinement.parseNodes(this.getUIDomain(), jTextArea.getText());
        this.uiConstruct.setNodes(list);
        if (this.isSequenceSet()) {
            this.makeSequence();
        }
    }

    private void userDeleteChild() {
        IXEditorPanel iXEditorPanel = this.formPanel.getFieldBit("nodes");
        JList jList = (JList)iXEditorPanel.getItemComponent();
        if (jList.isSelectionEmpty()) {
            String string = "Please select a sub-activity to delete first.";
            JOptionPane.showMessageDialog(this, string);
        } else {
            Object[] objectArray = jList.getSelectedValues();
            int n = 0;
            while (n < objectArray.length) {
                Object object = objectArray[n];
                this.uiConstruct.deleteNode((NodeSpec)object);
                ++n;
            }
            jList.clearSelection();
            this.setChildren();
            this.setOrderings();
        }
    }

    private void userDeleteIssue() {
        IXEditorPanel iXEditorPanel = this.formPanel.getFieldBit("issues");
        JList jList = (JList)iXEditorPanel.getItemComponent();
        if (jList.isSelectionEmpty()) {
            String string = "Please select an issue to delete first.";
            JOptionPane.showMessageDialog(this, string);
        } else {
            Object[] objectArray = jList.getSelectedValues();
            int n = 0;
            while (n < objectArray.length) {
                Object object = objectArray[n];
                this.uiConstruct.deleteIssue((Issue)object);
                ++n;
            }
            jList.clearSelection();
            this.setIssues();
        }
    }

    private void userEditChild() {
        IXEditorPanel iXEditorPanel = this.formPanel.getFieldBit("nodes");
        JList jList = (JList)iXEditorPanel.getItemComponent();
        if (jList.isSelectionEmpty()) {
            String string = "Please select a sub-activity to edit first.";
            JOptionPane.showMessageDialog(this, string);
        } else {
            Object[] objectArray = jList.getSelectedValues();
            this.ensureSpecEditor("sub-activity", "Please enter the new pattern of the sub-activity.");
            this.specEditor.start(this.uiConstruct, objectArray[0], this.getEditorLocation());
        }
    }

    private void userEditIssue() {
        IXEditorPanel iXEditorPanel = this.formPanel.getFieldBit("issues");
        JList jList = (JList)iXEditorPanel.getItemComponent();
        if (jList.isSelectionEmpty()) {
            String string = "Please select an issue to edit first.";
            JOptionPane.showMessageDialog(this, string);
        } else {
            Object[] objectArray = jList.getSelectedValues();
            this.ensureSpecEditor("issue", "Please enter the new pattern of the issue.");
            this.specEditor.start(this.uiConstruct, objectArray[0], this.getEditorLocation());
        }
    }

    private void userEditOrdering() {
        IXEditorPanel iXEditorPanel = this.formPanel.getFieldBit("orderings");
        JList jList = (JList)iXEditorPanel.getItemComponent();
        if (jList.isSelectionEmpty()) {
            String string = "Please select a constraint to edit first.";
            JOptionPane.showMessageDialog(this, string);
        } else {
            Object[] objectArray = jList.getSelectedValues();
            this.ensureRelationEditor();
            this.orderingEditor.start(this.uiConstruct, objectArray[0], this.getEditorLocation());
        }
    }

    private void userEditCondition() {
        IXEditorPanel iXEditorPanel = this.formPanel.getFieldBit("conditions");
        JList jList = (JList)iXEditorPanel.getItemComponent();
        if (jList.isSelectionEmpty()) {
            String string = "Please select a condition to edit first.";
            JOptionPane.showMessageDialog(this, string);
        } else {
            Object[] objectArray = jList.getSelectedValues();
            this.ensureConditionEditor();
            this.conditionEditor.start(this.uiConstruct, objectArray[0], this.getEditorLocation());
        }
    }

    private void userEditConstraint() {
        IXEditorPanel iXEditorPanel = this.formPanel.getFieldBit("constraints");
        JList jList = (JList)iXEditorPanel.getItemComponent();
        if (jList.isSelectionEmpty()) {
            String string = "Please select a constraint to edit first.";
            JOptionPane.showMessageDialog(this, string);
        } else {
            Object[] objectArray = jList.getSelectedValues();
            this.ensureConstraintEditor();
            this.constraintEditor.start(this.uiConstruct, objectArray[0], this.getEditorLocation());
        }
    }

    private void userClearChildren() {
        List list = this.uiConstruct.getNodes();
        if (list == null || list.isEmpty()) {
            this.setChildren();
            return;
        }
        String[] stringArray = new String[]{"This will clear all sub-activities.", " Are you sure you want to do this?"};
        int n = JOptionPane.showConfirmDialog(this, stringArray, "Warning", 2, 2);
        if (n == 0) {
            this.uiConstruct.setNodes(Lisp.NIL);
            this.uiConstruct.setOrderings(Lisp.NIL);
            this.setChildren();
            this.setOrderings();
        }
    }

    private void userAddOrdering() {
        this.ensureRelationEditor();
        this.orderingEditor.start((Object)this.uiConstruct, this.getEditorLocation());
    }

    private void userAddCondition() {
        Debug.noteln("Adding condition or effect for refinement", this.uiConstruct);
        this.ensureConditionEditor();
        this.conditionEditor.start((Object)this.uiConstruct, this.getEditorLocation());
    }

    private void userAddConstraint() {
        Debug.noteln("Adding constraint for refinement", this.uiConstruct);
        this.ensureConstraintEditor();
        this.constraintEditor.start((Object)this.uiConstruct, this.getEditorLocation());
    }

    private void userDeleteOrdering() {
        IXEditorPanel iXEditorPanel = this.formPanel.getFieldBit("orderings");
        JList jList = (JList)iXEditorPanel.getItemComponent();
        if (jList.isSelectionEmpty()) {
            String string = "Please select a constraint to delete first.";
            JOptionPane.showMessageDialog(this, string);
        } else {
            Object[] objectArray = jList.getSelectedValues();
            int n = 0;
            while (n < objectArray.length) {
                Object object = objectArray[n];
                List list = this.uiConstruct.getOrderings();
                list.remove(object);
                this.uiConstruct.setOrderings(list);
                ++n;
            }
            jList.clearSelection();
            this.setOrderings();
        }
    }

    private void userDeleteCondition() {
        IXEditorPanel iXEditorPanel = this.formPanel.getFieldBit("conditions");
        JList jList = (JList)iXEditorPanel.getItemComponent();
        if (jList.isSelectionEmpty()) {
            String string = "Please select a condition to delete first.";
            JOptionPane.showMessageDialog(this, string);
        } else {
            Object[] objectArray = jList.getSelectedValues();
            int n = 0;
            while (n < objectArray.length) {
                Object object = objectArray[n];
                List list = this.uiConstruct.getConditions();
                list.remove(object);
                this.uiConstruct.setConditions(list);
                ++n;
            }
            jList.clearSelection();
            this.setConditions();
        }
    }

    private void userDeleteConstraint() {
        IXEditorPanel iXEditorPanel = this.formPanel.getFieldBit("constraints");
        JList jList = (JList)iXEditorPanel.getItemComponent();
        if (jList.isSelectionEmpty()) {
            String string = "Please select a constraint to delete first.";
            JOptionPane.showMessageDialog(this, string);
        } else {
            Object[] objectArray = jList.getSelectedValues();
            int n = 0;
            while (n < objectArray.length) {
                Object object = objectArray[n];
                List list = this.uiConstruct.getConstraints();
                list.remove(object);
                this.uiConstruct.setConstraints(list);
                ++n;
            }
            jList.clearSelection();
            this.setConstraints();
        }
    }

    protected boolean clearOrderings() {
        List list = this.uiConstruct.getOrderings();
        if (list == null || list.isEmpty()) {
            this.setOrderings();
            return true;
        }
        String[] stringArray = new String[]{"This will clear all orderings between sub-activities.", " Are you sure you want to do this?"};
        int n = JOptionPane.showConfirmDialog(this, stringArray, "Warning", 2, 2);
        if (n == 0) {
            this.uiConstruct.setOrderings(Lisp.NIL);
            this.setOrderings();
            return true;
        }
        return false;
    }

    public void constructAdded(UIDomainEvent uIDomainEvent) {
    }

    public void constructAdded(RefinementEvent refinementEvent) {
    }

    public void constructEdited(UIDomainEvent uIDomainEvent) {
    }

    public void constructRemoved(UIDomainEvent uIDomainEvent) {
        if (uIDomainEvent.getObject().equals(this.uiConstruct)) {
            this.clearUIConstruct();
        }
    }

    public void domainCleared(UIDomainEvent uIDomainEvent) {
        this.clearUIConstruct();
    }

    public void domainEdited(UIDomainEvent uIDomainEvent) {
    }

    public void domainSet(UIDomainEvent uIDomainEvent) {
        this.clearUIConstruct();
    }

    public void updateTree() {
        this.treeModel.reloadData();
        this.updateTreeSelection();
    }

    public void updateTreeSelection() {
        this.actionTree.setSelectedObject(this.uiConstruct);
    }

    public void addCurrentActionListener(CurrentActionListener currentActionListener) {
        this.actionListeners.add(currentActionListener);
    }

    private void fireCurrentActionChanged(UIRefinement uIRefinement, UIRefinement uIRefinement2) {
        if (uIRefinement == null && uIRefinement2 == null) {
            return;
        }
        Iterator iterator = this.actionListeners.iterator();
        while (iterator.hasNext()) {
            CurrentActionListener currentActionListener = (CurrentActionListener)iterator.next();
            currentActionListener.actionChanged(this, uIRefinement2);
        }
        if (uIRefinement2 == null || uIRefinement2.isEmpty()) {
            this.actionTree.clearSelection();
        }
    }

    public void actionChanged(Component component, UIRefinement uIRefinement) {
        if (!this.equals(component) || uIRefinement == null || uIRefinement.isEmpty()) {
            this.actionTree.clearSelection();
        }
        this.actionTree.setSelectedObject(uIRefinement);
        if (!this.equals(component)) {
            this.setUIConstruct(uIRefinement);
        }
    }

    public void gotConstraint(Object object, Object object2) {
        UIRefinement uIRefinement = (UIRefinement)object;
        if (uIRefinement != null && !uIRefinement.equals(this.uiConstruct)) {
            String string = "Trying to edit constraints of refinement " + this.uiConstruct.getName() + " with constraints of refinement " + uIRefinement.getName();
            JOptionPane.showMessageDialog(this, string);
            return;
        }
        if (object2 == null) {
            uIRefinement.setConstraints(uIRefinement.getConstraints());
            this.setConstraints();
            this.setConditions();
            this.setOrderings();
            this.setChildren();
            this.setIssues();
            this.validate();
            return;
        }
        if (object2 instanceof Ordering) {
            this.uiConstruct.getOrderings().add(object2);
            this.setOrderings();
        } else if (object2 instanceof Constraint) {
            try {
                this.uiConstruct.addConstraint(object2);
                this.setConditions();
                this.setConstraints();
            }
            catch (Exception exception) {}
        } else if (object2 instanceof UISpec) {
            UISpec uISpec = (UISpec)object2;
            LList lList = uISpec.getSpec();
            if (lList.isEmpty()) {
                return;
            }
            String string = uISpec.getType();
            if (string.equals("sub-activity")) {
                Name name = this.uiConstruct.getNewNodeId();
                this.uiConstruct.addNode(new UINodeSpec(this.getUIDomain(), name, lList));
                this.setChildren();
                if (this.isSequenceSet() && !this.isComprehensive()) {
                    this.makeSequence();
                }
            } else if (string.equals("issue")) {
                this.uiConstruct.addIssue(new Issue(lList));
                this.setIssues();
            }
        } else {
            Debug.noteln("AcEP: ***Got a class", object2.getClass().getName());
        }
    }

    public boolean frameActionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "newEdit") {
            this.newConstruct();
        } else if (string == "editConstruct") {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            String string2 = jMenuItem.getText().trim();
            this.setUIConstruct((UIObject)this.getNamedConstruct(string2));
        } else if (string == "cut") {
            this.deleteConstruct();
        } else if (string == "copy") {
            this.copyConstruct();
        } else if (string == "modify") {
            this.saveConstruct();
        } else if (string == "revert") {
            this.revertConstruct();
        } else if (string == "revertO") {
            this.revertOConstruct();
        } else if (string == "check") {
            this.checkConstruct();
        } else if (string == "makeSequence") {
            this.userMakeSequence();
        } else if (string == "makeParallel") {
            this.userMakeParallel();
        } else if (string == "defSequence") {
            Object object = actionEvent.getSource();
            this.parent.setDefaultSequence(((JCheckBoxMenuItem)object).getState());
        } else if (string == "graphical" && !this.updatingView) {
            this.updatingView = true;
            this.parent.setActivityView(IDESymbols.VIEW_GRAPHICAL);
            this.updatingView = false;
        } else if (string == "minimal" && !this.updatingView) {
            this.updatingView = true;
            this.parent.setActivityView(IDESymbols.VIEW_MINIMAL);
            this.updatingView = false;
        } else if (string == "comprehensive" && !this.updatingView) {
            this.updatingView = true;
            this.parent.setActivityView(IDESymbols.VIEW_COMPREHENSIVE);
            this.updatingView = false;
        } else {
            return false;
        }
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.frameActionPerformed(actionEvent)) {
            return;
        }
        String string = actionEvent.getActionCommand();
        Debug.noteln("ActionEditorPanel: Got action command", string);
        if (string.equals("add node")) {
            this.userAddChild();
        } else if (string.equals("delete node")) {
            this.userDeleteChild();
        } else if (string.equals("add ordering")) {
            this.userAddOrdering();
        } else if (string.equals("delete ordering")) {
            this.userDeleteOrdering();
        } else {
            Debug.noteln("ActionEditorPanel cannot recognise command", string);
        }
    }

    protected static void notImp(String string) {
        UIUtil.notImplemented(null, string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ActionTableMouser
    extends MouseAdapter {
        static /* synthetic */ Class class$ix$iview$domain$UIObject;
        static /* synthetic */ Class class$ix$icore$IXObject;
        static /* synthetic */ Class class$ix$iview$domain$UINodeSpec;

        private ActionTableMouser() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            ActionTreeTableModel actionTreeTableModel;
            Object object;
            int n = ActionEditorPanel.this.actionTree.columnAtPoint(mouseEvent.getPoint());
            if (n == 0 || !SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return;
            }
            int n2 = ActionEditorPanel.this.actionTree.rowAtPoint(mouseEvent.getPoint());
            if (n2 >= 0 && n2 < ActionEditorPanel.this.actionTree.getRowCount() && (object = (actionTreeTableModel = (ActionTreeTableModel)ActionEditorPanel.this.actionTree.getModel()).getRowObject(n2)) != null) {
                if ((class$ix$iview$domain$UIObject == null ? (class$ix$iview$domain$UIObject = ActionTableMouser.class$("ix.iview.domain.UIObject")) : class$ix$iview$domain$UIObject).isInstance(object)) {
                    ActionEditorPanel.this.setUIConstruct((UIObject)object);
                } else if ((class$ix$icore$IXObject == null ? (class$ix$icore$IXObject = ActionTableMouser.class$("ix.icore.IXObject")) : class$ix$icore$IXObject).isInstance(object)) {
                    ActionEditorPanel.this.setConstruct((IXObject)object);
                } else if ((class$ix$iview$domain$UINodeSpec == null ? (class$ix$iview$domain$UINodeSpec = ActionTableMouser.class$("ix.iview.domain.UINodeSpec")) : class$ix$iview$domain$UINodeSpec).isInstance(object)) {
                    UIRefinement uIRefinement = new UIRefinement(ActionEditorPanel.this.getUIDomain());
                    uIRefinement.setPattern(((UINodeSpec)object).getPattern());
                    uIRefinement.setName("undefined");
                    ActionEditorPanel.this.setUIConstruct(uIRefinement);
                }
            }
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    class EdMouseAdapter
    extends MouseAdapter
    implements SchemaTerms {
        static /* synthetic */ Class class$javax$swing$AbstractButton;

        EdMouseAdapter() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            Component component = mouseEvent.getComponent();
            ActionEditorPanel.this.mousePoint = mouseEvent.getPoint();
            component.requestFocus();
            if (!(class$javax$swing$AbstractButton == null ? (class$javax$swing$AbstractButton = EdMouseAdapter.class$("javax.swing.AbstractButton")) : class$javax$swing$AbstractButton).isInstance(component)) {
                return;
            }
            AbstractButton abstractButton = (AbstractButton)component;
            IXEditorPanel iXEditorPanel = (IXEditorPanel)((Object)abstractButton.getParent().getParent());
            if (iXEditorPanel.getName().equals("Nodes")) {
                if (abstractButton.getText() == "Add") {
                    ActionEditorPanel.this.userAddChild();
                } else if (abstractButton.getText() == "Delete") {
                    ActionEditorPanel.this.userDeleteChild();
                } else if (abstractButton.getText() == "Edit") {
                    ActionEditorPanel.this.userEditChild();
                } else {
                    ActionEditorPanel.notImp(abstractButton.getText() + " for nodes");
                }
                return;
            }
            if (iXEditorPanel.getName().equals("Issues")) {
                if (abstractButton.getText() == "Add") {
                    ActionEditorPanel.this.userAddIssue();
                } else if (abstractButton.getText() == "Delete") {
                    ActionEditorPanel.this.userDeleteIssue();
                } else if (abstractButton.getText() == "Edit") {
                    ActionEditorPanel.this.userEditIssue();
                } else {
                    ActionEditorPanel.notImp(abstractButton.getText() + " for issues");
                }
                return;
            }
            if (iXEditorPanel.getName().equals("Ordering") || iXEditorPanel.getName().equals("Orderings")) {
                if (abstractButton.getText() == "Add") {
                    ActionEditorPanel.this.userAddOrdering();
                } else if (abstractButton.getText() == "Delete") {
                    ActionEditorPanel.this.userDeleteOrdering();
                } else if (abstractButton.getText() == "Edit") {
                    ActionEditorPanel.this.userEditOrdering();
                } else if (abstractButton.getText().equals("parallel")) {
                    ((MiniConstraintPanel)iXEditorPanel).setLast(abstractButton);
                    ActionEditorPanel.this.setOrdering(false);
                } else if (abstractButton.getText().equals("sequential")) {
                    ((MiniConstraintPanel)iXEditorPanel).setLast(abstractButton);
                    ActionEditorPanel.this.setOrdering(true);
                } else if (abstractButton.getText() != "other") {
                    if (abstractButton.getText() == "Comprehensive") {
                        ActionEditorPanel.this.parent.setActivityView(IDESymbols.VIEW_COMPREHENSIVE);
                    } else {
                        ActionEditorPanel.notImp(abstractButton.getText() + " for orderings");
                    }
                }
                return;
            }
            if (iXEditorPanel.getName().equals("Conditions/Effects")) {
                if (abstractButton.getText() == "Add") {
                    ActionEditorPanel.this.userAddCondition();
                } else if (abstractButton.getText() == "Delete") {
                    ActionEditorPanel.this.userDeleteCondition();
                } else if (abstractButton.getText() == "Edit") {
                    ActionEditorPanel.this.userEditCondition();
                }
                return;
            }
            if (iXEditorPanel.getName().equals("Constraints") || iXEditorPanel.getName().equals("Other Constraints") || iXEditorPanel.getName().equals("Constraints (Other)")) {
                if (abstractButton.getText() == "Add") {
                    ActionEditorPanel.this.userAddConstraint();
                } else if (abstractButton.getText() == "Delete") {
                    ActionEditorPanel.this.userDeleteConstraint();
                } else if (abstractButton.getText() == "Edit") {
                    ActionEditorPanel.this.userEditConstraint();
                }
                return;
            }
            ActionEditorPanel.notImp("Command " + abstractButton.getText());
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

