/*
 * Decompiled with CFR 0.152.
 */
package ix.itest;

import ix.ichat.ChatMessage;
import ix.icore.Activity;
import ix.icore.IXAgent;
import ix.icore.Issue;
import ix.icore.Priority;
import ix.icore.Report;
import ix.icore.ReportType;
import ix.icore.Sendable;
import ix.icore.Status;
import ix.icore.TaskItem;
import ix.icore.Variable;
import ix.icore.YesNo;
import ix.icore.domain.Constraint;
import ix.icore.domain.PatternAssignment;
import ix.iface.domain.LTF_Parser;
import ix.iface.domain.SyntaxException;
import ix.iface.util.CatchingActionListener;
import ix.iface.util.ComboChoice;
import ix.iface.util.GridColumn;
import ix.iface.util.RadioButtonBox;
import ix.ispace.AgentData;
import ix.ispace.GroupSender;
import ix.ispace.event.ContactEvent;
import ix.ispace.event.ContactListener;
import ix.util.Debug;
import ix.util.IPC;
import ix.util.Name;
import ix.util.Strings;
import ix.util.Util;
import ix.util.lisp.LList;
import ix.util.lisp.Lisp;
import ix.util.xml.XML;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class SendPanel
extends JPanel
implements ActionListener,
ContactListener {
    IXAgent agent;
    ActionListener actionListener = CatchingActionListener.listener(this);
    SendTextArea contentText = new SendTextArea(5, 40);
    RadioButtonBox typeSelector = this.makeTypeControl();
    RadioButtonBox prioritySelector = this.makePriorityControl();
    ComboChoice destinationChoice;
    JComboBox reportTypeChoice = new JComboBox<Object>(ReportType.values().toArray());
    JCheckBox reportCheck;
    ComboChoice refChoice;
    LTF_Parser constraintParser;

    public SendPanel(IXAgent iXAgent) {
        this.reportTypeChoice.setSelectedItem(ReportType.INFORMATION);
        this.reportCheck = new JCheckBox("Report Back - Ref =");
        this.refChoice = new ComboChoice();
        this.constraintParser = new LTF_Parser();
        this.agent = iXAgent;
        iXAgent.getContactManager().addContactListener(this);
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(BorderFactory.createTitledBorder("Compose Message"));
        this.add(new JScrollPane(this.contentText));
        this.add(this.makeControlPanel());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        Debug.noteln("I-TEST send action:", string);
        if (string.equals("Send")) {
            this.sendTo(this.destinationChoice.getSelectedString());
        } else {
            Debug.noteln("Nothing to do for", string);
        }
    }

    public void initIssue(Issue issue) {
        this.typeSelector.setSelection("Issue");
        this.initItem(issue);
    }

    public void initActivity(Activity activity) {
        this.typeSelector.setSelection("Activity");
        this.initItem(activity);
    }

    protected void initItem(TaskItem taskItem) {
        LList lList = (LList)Variable.removeVars(taskItem.getPattern());
        this.contentText.setText(Lisp.elementsToString(lList));
        this.prioritySelector.setSelection(Strings.capitalize(taskItem.getPriority().toString()) + " Priority");
    }

    public void initConstraint(PatternAssignment patternAssignment) {
        this.typeSelector.setSelection("Constraint");
        this.contentText.setText(Lisp.elementsToString(patternAssignment.getPattern()) + " = " + Lisp.printToString(patternAssignment.getValue()));
    }

    public void initConstraintForMe(PatternAssignment patternAssignment) {
        this.initConstraint(patternAssignment);
        this.destinationChoice.setSelectedItem("me");
    }

    public void initReport(TaskItem taskItem) {
        Name name = taskItem.getRef();
        Name name2 = taskItem.getSenderId();
        Status status = taskItem.getStatus();
        if (!this.contentText.getText().equals("")) {
            Object[] objectArray = new Object[]{"You have asked to send a report when there", "is unsent text in the display.  Do you want", "to clear the text and set up to send the report?"};
            switch (JOptionPane.showConfirmDialog(null, objectArray, "Confirm", 0)) {
                case 0: {
                    break;
                }
                case 1: {
                    return;
                }
            }
        }
        this.typeSelector.setSelection("Report");
        this.contentText.setText("");
        this.reportTypeChoice.setSelectedItem(ReportType.PROGRESS);
        if (name2 != null) {
            this.destinationChoice.setSelectedItem(name2.toString());
        }
        if (name != null) {
            this.refChoice.setSelectedItem(name.toString());
        }
    }

    public void contactChange(ContactEvent contactEvent) {
        if (contactEvent.isDeletion()) {
            AgentData agentData = contactEvent.getOldData();
            this.destinationChoice.removeItem(agentData.getName());
        } else {
            AgentData agentData = contactEvent.getNewData();
            String string = agentData.getName();
            if (!this.destinationChoice.hasItem(string)) {
                Debug.noteln("New contact", string);
                this.destinationChoice.addItem(string);
            }
        }
    }

    protected void sendTo(String string) {
        Sendable sendable = (Sendable)this.objectFromControls();
        this.send(string, sendable);
        this.contentText.showSent();
    }

    protected void send(String string, Sendable sendable) {
        if (sendable.getSenderId() == null) {
            sendable.setSenderId(Name.valueOf((String)this.agent.getAgentIPCName()));
        }
        Debug.noteln("Sending to", string);
        Debug.noteln("Contents as XML:", XML.objectToXMLString(sendable));
        if (string.equalsIgnoreCase("me")) {
            this.agent.handleInput(new IPC.BasicInputMessage(sendable));
        } else if (string.equals("a group ...")) {
            this.sendToGroup(sendable);
        } else {
            IPC.sendObject(string, sendable);
        }
    }

    public void sendCopy(String string, Sendable sendable) {
        Sendable sendable2 = (Sendable)Util.clone(sendable);
        this.send(string, sendable2);
    }

    protected void sendToGroup(Sendable sendable) {
        new GroupSender(this.agent, sendable);
    }

    protected Object objectFromControls() {
        String string = this.contentText.getText().trim();
        if (string.equals("")) {
            throw new IllegalArgumentException("Contents are empty");
        }
        String string2 = this.typeSelector.getSelection();
        if (string2.equals("Issue")) {
            return this.issueFromControls();
        }
        if (string2.equals("Activity")) {
            return this.activityFromControls();
        }
        if (string2.equals("Constraint")) {
            return this.constraintFromControls();
        }
        if (string2.equals("Report")) {
            return this.reportFromControls();
        }
        if (string2.equals("Message")) {
            return this.messageFromControls();
        }
        throw new Error("Unexpected message type " + string2);
    }

    protected Issue issueFromControls() {
        return (Issue)this.fillTaskItemFromControls(new Issue());
    }

    protected Activity activityFromControls() {
        return (Activity)this.fillTaskItemFromControls(new Activity());
    }

    protected TaskItem fillTaskItemFromControls(TaskItem taskItem) {
        String string = this.contentText.getText().trim();
        String string2 = this.refChoice.getSelectedString();
        boolean bl = this.reportCheck.isSelected();
        taskItem.setPattern(Lisp.elementsFromString(string));
        taskItem.setSenderId(Name.valueOf((String)this.agent.getAgentIPCName()));
        taskItem.setPriority(this.priorityFromControls());
        if (!string2.equals("")) {
            taskItem.setRef(Name.valueOf(string2));
        }
        if (bl) {
            taskItem.setReportBack(YesNo.YES);
        }
        return taskItem;
    }

    protected Constraint constraintFromControls() {
        String string;
        LList lList;
        Constraint constraint;
        String string2 = this.contentText.getText().trim();
        String[] stringArray = Strings.breakAtFirst("=", string2);
        String string3 = stringArray[0].trim();
        String string4 = stringArray[1].trim();
        if (string4.equals("")) {
            string4 = "true";
        }
        if ((constraint = this.constraintParser.parseConstraint(lList = (LList)Lisp.readFromString(string = "(world-state effect (" + string3 + ") = " + string4 + ")"))) == null) {
            throw new SyntaxException("Invalid constraint: " + Strings.quote(string2));
        }
        constraint.setSenderId(Name.valueOf((String)this.agent.getAgentIPCName()));
        return constraint;
    }

    protected Report reportFromControls() {
        String string = this.contentText.getText().trim();
        String string2 = this.refChoice.getSelectedString();
        ReportType reportType = (ReportType)this.reportTypeChoice.getSelectedItem();
        Report report = new Report(string);
        report.setSenderId(Name.valueOf((String)this.agent.getAgentIPCName()));
        report.setPriority(this.priorityFromControls());
        if (!string2.equals("")) {
            report.setRef(Name.valueOf(string2));
        }
        if (!reportType.equals("")) {
            report.setReportType(reportType);
        }
        return report;
    }

    protected ChatMessage messageFromControls() {
        String string = this.contentText.getText();
        String string2 = (String)this.agent.getAgentIPCName();
        return new ChatMessage(string, string2);
    }

    protected Priority priorityFromControls() {
        String string = this.prioritySelector.getSelection();
        Debug.assert(string.endsWith(" Priority"));
        String string2 = Strings.beforeFirst(" ", string);
        return Priority.valueOf(string2.toLowerCase());
    }

    protected JPanel makeControlPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(this.typeSelector);
        jPanel.add(this.prioritySelector);
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(this.makeSendControls());
        return jPanel;
    }

    protected RadioButtonBox makeTypeControl() {
        RadioButtonBox radioButtonBox = RadioButtonBox.createVerticalBox();
        JRadioButton jRadioButton = new JRadioButton("Issue");
        JRadioButton jRadioButton2 = new JRadioButton("Activity");
        JRadioButton jRadioButton3 = new JRadioButton("Constraint");
        JRadioButton jRadioButton4 = new JRadioButton("Report");
        JRadioButton jRadioButton5 = new JRadioButton("Message");
        jRadioButton4.setSelected(true);
        radioButtonBox.add(jRadioButton);
        radioButtonBox.add(jRadioButton2);
        radioButtonBox.add(jRadioButton3);
        radioButtonBox.add(jRadioButton4);
        radioButtonBox.add(jRadioButton5);
        radioButtonBox.add(Box.createVerticalGlue());
        return radioButtonBox;
    }

    protected RadioButtonBox makePriorityControl() {
        RadioButtonBox radioButtonBox = RadioButtonBox.createVerticalBox();
        radioButtonBox.add(new JRadioButton("Highest Priority"));
        radioButtonBox.add(new JRadioButton("High Priority"));
        radioButtonBox.add(new JRadioButton("Normal Priority", true));
        radioButtonBox.add(new JRadioButton("Low Priority"));
        radioButtonBox.add(new JRadioButton("Lowest Priority"));
        radioButtonBox.add(Box.createVerticalGlue());
        return radioButtonBox;
    }

    protected JPanel makeSendControls() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        GridColumn gridColumn = new GridColumn();
        GridColumn gridColumn2 = new GridColumn();
        jPanel.add(gridColumn);
        jPanel.add(gridColumn2);
        List list = this.agent.getContactManager().getSortedNameList();
        list.add(0, "me");
        list.add(1, "a group ...");
        this.destinationChoice = new ComboChoice(list.toArray());
        this.reportCheck.setHorizontalAlignment(11);
        gridColumn.add(this.reportCheck);
        gridColumn2.add(this.refChoice);
        JLabel jLabel = new JLabel("Report Type =");
        jLabel.setForeground(Color.black);
        jLabel.setHorizontalAlignment(11);
        gridColumn.add(jLabel);
        gridColumn2.add(this.reportTypeChoice);
        JLabel jLabel2 = new JLabel("Recipient =");
        jLabel2.setForeground(Color.black);
        jLabel2.setHorizontalAlignment(11);
        gridColumn.add(jLabel2);
        gridColumn2.add(this.destinationChoice);
        JButton jButton = new JButton("Send", Util.resourceImageIcon("ip2-send.gif"));
        jButton.setHorizontalTextPosition(2);
        jButton.addActionListener(this.actionListener);
        gridColumn.add(new JLabel(""));
        gridColumn2.add(jButton);
        return SendPanel.makeFlowPanel(jPanel);
    }

    public static JPanel makeFlowPanel(Component component) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(2, 0, 5));
        jPanel.add(component);
        return jPanel;
    }

    class SendTextArea
    extends JTextArea {
        boolean inSentState = false;

        SendTextArea(int n, int n2) {
            super(n, n2);
            this.addKeyListener(new KeyAdapter(this){
                private final /* synthetic */ SendTextArea this$1;
                {
                    this.this$1 = sendTextArea;
                }

                public void keyPressed(KeyEvent keyEvent) {
                    if (this.this$1.inSentState) {
                        this.this$1.clearSent();
                    }
                }
            });
            this.addMouseListener(new MouseAdapter(this){
                private final /* synthetic */ SendTextArea this$1;
                {
                    this.this$1 = sendTextArea;
                }

                public void mousePressed(MouseEvent mouseEvent) {
                    if (this.this$1.inSentState) {
                        this.this$1.clearSent();
                        this.this$1.setSelectionStart(0);
                        this.this$1.setSelectionEnd(this.this$1.getText().length());
                    }
                }
            });
        }

        public void setText(String string) {
            if (this.inSentState) {
                this.clearSent();
            }
            super.setText(string);
        }

        void showSent() {
            this.setForeground(MetalLookAndFeel.getControlDisabled());
            this.inSentState = true;
        }

        void clearSent() {
            this.setForeground(MetalLookAndFeel.getBlack());
            this.inSentState = false;
        }
    }
}

