/*
 * Decompiled with CFR 0.152.
 */
package ix.itest;

import ix.icore.IXAgent;
import ix.iface.util.LogoPanel;
import ix.itest.ItestFrame;
import ix.itest.ReceivePanel;
import ix.itest.SendPanel;
import ix.util.Debug;
import ix.util.IPC;
import ix.util.Parameters;
import ix.util.Util;
import java.awt.Component;
import java.awt.Container;
import javax.swing.BoxLayout;
import javax.swing.JPanel;

public class Itest
extends IXAgent {
    protected ItestFrame frame;
    protected SendPanel sendPanel;
    protected ReceivePanel receivePanel;

    public Object getAgentIPCName() {
        return this.ipcName;
    }

    public Itest() {
        this("I-Test");
    }

    public Itest(String string) {
        this.displayName = string;
    }

    public static void main(String[] stringArray) {
        Util.printGreeting("I-Test");
        new Itest().mainStartup(stringArray);
    }

    protected void processCommandLineArguments() {
        super.processCommandLineArguments();
        if (Parameters.haveParameter("test-menu")) {
            Debug.noteln("Test menu file", Parameters.getParameter("test-menu"));
        }
    }

    public void startup() {
        super.startup();
        this.frame = new ItestFrame(this);
        this.sendPanel = new SendPanel(this);
        this.receivePanel = new ReceivePanel(this);
        this.setupFrame();
        this.addTests();
        this.frame.pack();
        ((Component)this.frame).setVisible(true);
    }

    public void setupFrame() {
        Container container = this.frame.getContentPane();
        container.setLayout(new BoxLayout(container, 1));
        container.add(this.sendPanel);
        container.add(this.receivePanel);
        container.add(this.makeLogoPanel());
    }

    public JPanel makeLogoPanel() {
        return new LogoPanel("I-Test", "I-X Test Agent", Util.resourceImageIcon("ip2-itest-logo.gif"));
    }

    public void handleInput(IPC.InputMessage inputMessage) {
        this.receivePanel.handleInput(inputMessage);
    }

    protected void addTests() {
        if (Parameters.haveParameter("test-menu")) {
            this.frame.addTests(Parameters.getParameter("test-menu"));
        }
    }
}

