/*
 * Decompiled with CFR 0.152.
 */
package ix.ispace.event;

import ix.ispace.AgentData;
import ix.ispace.Capability;
import ix.ispace.ContactManager;
import java.util.EventObject;

public class ContactEvent
extends EventObject {
    protected AgentData oldData;
    protected AgentData newData;

    public ContactEvent(ContactManager contactManager, AgentData agentData, AgentData agentData2) {
        super(contactManager);
        this.oldData = agentData;
        this.newData = agentData2;
    }

    public AgentData getOldData() {
        return this.oldData;
    }

    public AgentData getNewData() {
        return this.newData;
    }

    public boolean isNewContact() {
        return this.oldData == null;
    }

    public boolean isDeletion() {
        return this.newData == null;
    }

    public boolean isRelationshipChange() {
        return this.oldData != null && this.newData != null && this.oldData.getRelationship() != this.newData.getRelationship();
    }

    public boolean isCapabilityChange() {
        return this.oldData != null && this.newData != null && !this.oldData.getCapabilities().equals(this.newData.getCapabilities());
    }

    public boolean isNewCapability(Capability capability) {
        return this.newData != null && this.newData.hasCapability(capability) && (this.oldData == null || !this.oldData.hasCapability(capability));
    }

    public String toString() {
        return "ContactEvent[" + this.oldData + " --> " + this.newData + "]";
    }
}

