/*
 * Decompiled with CFR 0.152.
 */
package ix.ispace;

import ix.icore.IXAgent;
import ix.iface.util.CatchingActionListener;
import ix.iface.util.GridColumn;
import ix.iface.util.IconImage;
import ix.iface.util.ToolFrame;
import ix.ispace.AgentData;
import ix.ispace.AgentRelationship;
import ix.ispace.ContactManager;
import ix.ispace.event.ContactEvent;
import ix.ispace.event.ContactListener;
import ix.util.Debug;
import ix.util.Strings;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class IspaceTool
implements ActionListener {
    IXAgent agent;
    ContactManager contactManager;
    JFrame frame;
    Container contentPane;
    RelationPanel relationPanel;

    public IspaceTool(IXAgent iXAgent) {
        this.agent = iXAgent;
        this.contactManager = iXAgent.getContactManager();
        this.setUpFrame();
    }

    void setUpFrame() {
        this.frame = new ToolFrame(this.agent.getAgentDisplayName() + " I-Space");
        this.contentPane = this.frame.getContentPane();
        ((Frame)this.frame).setIconImage(IconImage.getIconImage(this));
        this.frame.setJMenuBar(this.makeMenuBar());
        this.relationPanel = new RelationPanel();
        this.contentPane.add((Component)new JScrollPane(this.relationPanel), "Center");
        this.contentPane.add((Component)new ButtonPanel(), "South");
        this.contactManager.addContactListener(this.relationPanel);
        this.frame.pack();
        ((Component)this.frame).setVisible(true);
    }

    public void setVisible(boolean bl) {
        ((Component)this.frame).setVisible(bl);
    }

    protected JMenuBar makeMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenuBar.add(jMenu);
        jMenu.add(this.makeMenuItem("Close"));
        return jMenuBar;
    }

    protected JMenuItem makeMenuItem(String string) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.addActionListener(CatchingActionListener.listener(this));
        return jMenuItem;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        Debug.noteln("I-Space Tool action:", string);
        if (string.equals("Close")) {
            ((Component)this.frame).setVisible(false);
        } else if (string.equals("Commit")) {
            this.relationPanel.commitChanges();
        } else if (string.equals("Undo Uncommitted Changes")) {
            this.relationPanel.resetChanges();
        } else {
            Debug.noteln("Nothing to do for", string);
        }
    }

    class ButtonPanel
    extends JPanel {
        ButtonPanel() {
            this.add(this.makeButton("Commit"));
            this.add(this.makeButton("Undo Uncommitted Changes"));
        }

        protected JButton makeButton(String string) {
            JButton jButton = new JButton(string);
            jButton.addActionListener(CatchingActionListener.listener(IspaceTool.this));
            return jButton;
        }
    }

    class RelationComboBox
    extends JComboBox {
        public RelationComboBox() {
            Iterator iterator = AgentRelationship.values().iterator();
            while (iterator.hasNext()) {
                AgentRelationship agentRelationship = (AgentRelationship)iterator.next();
                this.addItem(Strings.capitalize(agentRelationship.toString()));
            }
            this.addItem("Delete");
            this.setSelectedItem(Strings.capitalize(AgentRelationship.CONTACT.toString()));
        }

        public AgentRelationship getSelectedRelation() {
            String string = (String)this.getSelectedItem();
            return string == "Delete" ? null : AgentRelationship.valueOf(string.toLowerCase());
        }

        public void setRelation(AgentRelationship agentRelationship) {
            this.setSelectedItem(Strings.capitalize(agentRelationship.toString()));
        }
    }

    class Row {
        String name;
        AgentRelationship rel;
        JTextField nameText;
        RelationComboBox relChoice;

        Row(String string) {
            AgentData agentData = IspaceTool.this.contactManager.getAgentData(string);
            this.name = string;
            this.rel = agentData.getRelationship();
            this.nameText = new JTextField(string);
            this.relChoice = new RelationComboBox();
            this.nameText.setEditable(false);
            this.relChoice.setRelation(agentData.getRelationship());
        }

        Row(JTextField jTextField, RelationComboBox relationComboBox) {
            this.name = "";
            this.rel = relationComboBox.getSelectedRelation();
            this.nameText = jTextField;
            this.relChoice = relationComboBox;
        }

        void reset() {
            if (this.nameText.isEditable()) {
                this.nameText.setText(this.name);
            }
            this.relChoice.setRelation(this.rel);
        }

        void addToTable(RelationPanel relationPanel) {
            relationPanel.rows.add(this);
            relationPanel.nameCol.add(this.nameText);
            relationPanel.relationCol.add(this.relChoice);
        }

        void insertInTable(RelationPanel relationPanel) {
            ListIterator listIterator = relationPanel.rows.listIterator();
            while (listIterator.hasNext()) {
                Row row = (Row)listIterator.next();
                if (row.nameText.isEditable() || row.name.compareTo(this.name) > 0) break;
            }
            int n = listIterator.nextIndex() - 1 + 1;
            relationPanel.rows.add(n, this);
            relationPanel.nameCol.add((Component)this.nameText, n);
            relationPanel.relationCol.add((Component)this.relChoice, n);
            relationPanel.invalidate();
            IspaceTool.this.frame.validate();
            IspaceTool.this.frame.pack();
        }
    }

    class RelationPanel
    extends JPanel
    implements ContactListener {
        List rows = new LinkedList();
        GridColumn nameCol = new GridColumn("Agent");
        GridColumn relationCol = new GridColumn("Relation");
        Row newEntryRow;

        RelationPanel() {
            this.setLayout(new BoxLayout(this, 0));
            this.setBorder(BorderFactory.createTitledBorder("Relations"));
            this.add(this.nameCol);
            this.add(Box.createHorizontalStrut(5));
            this.add(this.relationCol);
            this.loadTable();
        }

        void loadTable() {
            List list = IspaceTool.this.contactManager.getSortedNameList();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Row row = new Row(string);
                row.addToTable(this);
            }
            this.newEntryRow = new Row(new JTextField(40), new RelationComboBox());
            this.newEntryRow.addToTable(this);
        }

        void reloadTable() {
            this.nameCol.reset();
            this.relationCol.reset();
            this.rows.clear();
            this.loadTable();
            this.invalidate();
            IspaceTool.this.frame.validate();
            IspaceTool.this.frame.pack();
        }

        void resetChanges() {
            Iterator iterator = this.rows.iterator();
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                row.reset();
            }
        }

        void commitChanges() {
            AgentRelationship agentRelationship;
            Object object;
            Iterator iterator = ((AbstractList)new ArrayList(this.rows)).iterator();
            while (iterator.hasNext()) {
                object = (Row)iterator.next();
                if (object == this.newEntryRow) continue;
                agentRelationship = ((Row)object).relChoice.getSelectedRelation();
                if (agentRelationship == null) {
                    IspaceTool.this.contactManager.deleteAgent(((Row)object).name);
                    continue;
                }
                if (agentRelationship == ((Row)object).rel) continue;
                IspaceTool.this.contactManager.changeRelationship(((Row)object).name, agentRelationship);
            }
            object = this.newEntryRow.nameText.getText().trim();
            if (!((String)object).equals("") && (agentRelationship = this.newEntryRow.relChoice.getSelectedRelation()) != null) {
                this.addNewEntry((String)object, agentRelationship);
            }
            this.reloadTable();
        }

        void addNewEntry(String string, AgentRelationship agentRelationship) {
            Debug.noteln("Adding agent " + string + " as " + agentRelationship);
            if (IspaceTool.this.contactManager.getAgentData(string) != null) {
                JOptionPane.showMessageDialog(IspaceTool.this.frame, "Agent " + string + " already exists", "Error", 0);
                return;
            }
            IspaceTool.this.contactManager.addAgent(string, agentRelationship);
        }

        public void contactChange(ContactEvent contactEvent) {
            if (contactEvent.isNewContact()) {
                new Row(contactEvent.getNewData().getName()).insertInTable(this);
            }
            this.reloadTable();
        }
    }
}

