/*
 * Decompiled with CFR 0.152.
 */
package ix.ispace;

import ix.ispace.AbstractAgentGroup;
import ix.ispace.AgentData;
import ix.ispace.AgentGroup;
import ix.ispace.AgentRelationship;
import ix.ispace.Capability;
import ix.ispace.RelationshipGroup;
import ix.ispace.VerbCapability;
import ix.ispace.event.ContactEvent;
import ix.ispace.event.ContactListener;
import ix.util.Collect;
import ix.util.Debug;
import ix.util.Fn;
import ix.util.MultiHashMap;
import ix.util.MultiMap;
import ix.util.Parameters;
import ix.util.Strings;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ContactManager {
    protected List listeners = new LinkedList();
    protected List agentData = new LinkedList();
    protected MultiMap relMap = new MultiHashMap();
    protected List groups = new LinkedList();
    protected Map nameToGroup = new HashMap();
    static /* synthetic */ Class class$ix$ispace$AgentData;

    public ContactManager() {
        this.addStandardAgentGroups();
    }

    public void addAgent(String string) {
        this.addAgent(string, AgentRelationship.CONTACT);
    }

    public void addAgent(String string, AgentRelationship agentRelationship) {
        Debug.assert(this.getAgentData(string) == null, "adding agent twice", string);
        AgentData agentData = new AgentData(string, agentRelationship);
        this.agentData.add(agentData);
        this.relMap.addValue(agentRelationship, agentData);
        this.fireNewContact(agentData);
    }

    public void addAgents(List list, AgentRelationship agentRelationship) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.addAgent((String)iterator.next(), agentRelationship);
        }
    }

    public void noteAgent(String string) {
        this.noteAgent(string, AgentRelationship.CONTACT);
    }

    public void noteAgent(String string, AgentRelationship agentRelationship) {
        AgentData agentData = this.getAgentData(string);
        if (agentData == null) {
            this.addAgent(string, agentRelationship);
        }
    }

    public List getAgentData() {
        return this.agentData;
    }

    public AgentData getAgentData(String string) {
        Iterator iterator = this.agentData.iterator();
        while (iterator.hasNext()) {
            AgentData agentData = (AgentData)iterator.next();
            if (!agentData.getName().equals(string)) continue;
            return agentData;
        }
        return null;
    }

    public List getAgentData(AgentRelationship agentRelationship) {
        return (List)this.relMap.get(agentRelationship);
    }

    public List getAgentData(Capability capability) {
        return this.getAgentData(capability, false);
    }

    public List getAgentData(Capability capability, boolean bl) {
        LinkedList<AgentData> linkedList = new LinkedList<AgentData>();
        Iterator iterator = this.agentData.iterator();
        while (iterator.hasNext()) {
            AgentData agentData = (AgentData)iterator.next();
            if (!agentData.hasCapability(capability, bl)) continue;
            linkedList.add(agentData);
        }
        return linkedList;
    }

    public List getSortedNameList() {
        List list = (List)Collect.map(this.agentData, Fn.accessor(class$ix$ispace$AgentData == null ? (class$ix$ispace$AgentData = ContactManager.class$("ix.ispace.AgentData")) : class$ix$ispace$AgentData, "getName"));
        Collections.sort(list);
        return list;
    }

    protected void replaceAgentData(AgentData agentData, AgentData agentData2) {
        Collect.replaceFirst(agentData, agentData2, this.agentData);
        this.relMap.removeValue(agentData.getRelationship(), agentData);
        this.relMap.addValue(agentData2.getRelationship(), agentData2);
    }

    public void changeRelationship(String string, AgentRelationship agentRelationship) {
        AgentData agentData = this.getAgentData(string);
        AgentRelationship agentRelationship2 = agentData.getRelationship();
        Debug.noteln("Changing " + string + " from " + agentRelationship2 + " to " + agentRelationship);
        AgentData agentData2 = new AgentData(agentData);
        agentData2.setRelationship(agentRelationship);
        this.replaceAgentData(agentData, agentData2);
        this.checkAgentData(string, agentData2);
        this.fireContactChange(agentData, agentData2);
    }

    public void deleteAgent(String string) {
        AgentData agentData = this.getAgentData(string);
        AgentRelationship agentRelationship = agentData.getRelationship();
        this.agentData.remove(agentData);
        this.relMap.removeValue(agentRelationship, agentData);
        this.fireContactDeleted(agentData);
    }

    public void setCapabilities(String string, List list) {
        AgentData agentData = this.getAgentData(string);
        List list2 = agentData.getCapabilities();
        Debug.noteln("Changing " + string + " capabilities from " + list2 + " to " + list);
        if (!Collect.equalAsSets(list2, list)) {
            AgentData agentData2 = new AgentData(agentData);
            agentData2.setCapabilities(list);
            this.replaceAgentData(agentData, agentData2);
            this.checkAgentData(string, agentData2);
            this.fireContactChange(agentData, agentData2);
        }
    }

    private void checkAgentData(String string, AgentData agentData) {
        Debug.assert(this.getAgentData(string) == agentData, "Don't get new agent data for", string);
        List list = agentData.getCapabilities();
        Debug.noteln("Checking that " + string + " has capabilities " + list);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Capability capability = (Capability)iterator.next();
            Debug.assert(this.getAgentData(capability).contains(agentData), "Agent lacks capability", capability);
        }
        Debug.assert(this.getAgentData(agentData.getRelationship()).contains(agentData), "Relationship doesn't give new data");
    }

    public Collection getAgentGroups() {
        return this.groups;
    }

    public AgentGroup getAgentGroup(String string) {
        return (AgentGroup)this.nameToGroup.get(string);
    }

    public void addAgentGroup(AgentGroup agentGroup) {
        this.groups.add(agentGroup);
        this.nameToGroup.put(agentGroup.getName(), agentGroup);
    }

    protected void addStandardAgentGroups() {
        this.addAgentGroup(new AbstractAgentGroup("all", this){});
        Iterator iterator = AgentRelationship.values().iterator();
        while (iterator.hasNext()) {
            AgentRelationship agentRelationship = (AgentRelationship)iterator.next();
            if (agentRelationship == AgentRelationship.NONE) continue;
            this.addAgentGroup(new RelationshipGroup(agentRelationship, this));
        }
    }

    public void processCommandLineArguments() {
        Object object;
        Object object2;
        Iterator iterator = AgentRelationship.values().iterator();
        while (iterator.hasNext()) {
            object2 = (AgentRelationship)iterator.next();
            object = Parameters.getList(object2 + "s");
            this.addAgents((List)object, (AgentRelationship)object2);
        }
        object2 = Parameters.getParameter("external-capabilities", "");
        object = Strings.breakAt(",", (String)object2).iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            String[] stringArray = Strings.breakAtFirst(":", string);
            String string2 = stringArray[0];
            String string3 = stringArray[1];
            this.noteAgent(string2, AgentRelationship.SERVICE);
            AgentData agentData = this.getAgentData(string2);
            agentData.addCapability(new VerbCapability(string3));
        }
    }

    public void addContactListener(ContactListener contactListener) {
        this.listeners.add(contactListener);
    }

    public void fireNewContact(AgentData agentData) {
        this.fireContactEvent(new ContactEvent(this, null, agentData));
    }

    public void fireContactDeleted(AgentData agentData) {
        this.fireContactEvent(new ContactEvent(this, agentData, null));
    }

    public void fireContactChange(AgentData agentData, AgentData agentData2) {
        this.fireContactEvent(new ContactEvent(this, agentData, agentData2));
    }

    public void fireContactEvent(ContactEvent contactEvent) {
        Debug.noteln("fireContactEvent", contactEvent);
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ContactListener contactListener = (ContactListener)iterator.next();
            contactListener.contactChange(contactEvent);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

